/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once
#include "property.h"

typedef typed_mf_value < t_generic, mf1_additional_name > additional_name_at1;
typedef typed_mf_value < t_generic, mf1_adr > adr_at1;
typedef typed_mf_value < t_generic, mf1_affliation > affliation_at1;
typedef typed_mf_value < t_generic, mf1_agent > agent_at1;
typedef typed_mf_value < t_generic, mf1_album > album_at1;
typedef typed_mf_value < t_generic, mf1_amount > amount_at1;
typedef typed_mf_value < t_generic, mf1_announce > announce_at1;
typedef typed_mf_value < t_generic, mf1_attach > attach_at1;
typedef typed_mf_value < t_generic, mf1_attendee > attendee_at1;
typedef typed_mf_value < t_expected, mf1_author > author_at1;
typedef typed_mf_value < t_generic, mf1_average > average_at1;
typedef typed_mf_value < t_generic, mf1_bday > bday_at1;
typedef typed_mf_value < t_generic, mf1_best > best_at1;
typedef typed_mf_value < t_rel, r_bookmark > bookmark_at1;
typedef typed_mf_value < t_generic, mf1_brand > brand_at1;
typedef typed_mf_value < t_generic, mf1_business > business_at1;
typedef typed_mf_value < t_generic, mf1_category > category_at1;
typedef typed_mf_value < t_generic, mf1_class > class_at1;
typedef typed_mf_value < t_generic, mf1_contact > contact_at1;
typedef typed_mf_value < t_generic, mf1_contributor > contributor_at1;
typedef typed_mf_value < t_generic, mf1_count > count_at1;
typedef typed_mf_value < t_generic, mf1_country_name > country_name_at1;
typedef typed_mf_value < t_generic, mf1_currency > currency_at1;
typedef typed_mf_value < t_generic, mf1_dateline > dateline_at1;
typedef typed_mf_value < t_datetime_absolute, mf1_dtend > dtend_at1;
typedef typed_mf_value < t_datetime_absolute, mf1_dtexpired > dtexpired_at1;
typedef typed_mf_value < t_datetime_absolute, mf1_dtlisted > dtlisted_at1;
typedef typed_mf_value < t_datetime_absolute, mf1_dtreviewed > dtreviewed_at1;
typedef typed_mf_value < t_datetime_absolute, mf1_dtstart > dtstart_at1;
typedef typed_mf_value < t_generic, mf1_description > description_at1;
typedef typed_mf_value < t_generic, mf1_duration > duration_at1;
typedef typed_mf_value < t_generic, mf1_education > education_at1;
typedef typed_mf_value < t_url, mf1_email > email_at1;
typedef typed_mf_value < t_rel, r_enclosure > enclosure_at1;
typedef typed_mf_value < t_rel, r_entry_category > entry_category_at1;
typedef typed_mf_value < t_expected, mf1_entry_content > entry_content_at1;
typedef typed_mf_value < t_expected, mf1_entry_title > entry_title_at1;
typedef typed_mf_value < t_generic, mf1_entry_summary > entry_summary_at1;
typedef typed_mf_value < t_generic, mf1_event > event_at1;
typedef typed_mf_value < t_generic, mf1_experience > experience_at1;
typedef typed_mf_value < t_generic, mf1_extended_address > extended_address_at1;
typedef typed_mf_value < t_generic, mf1_family_name > family_name_at1;
typedef typed_mf_value < t_rel, r_feed > feed_at1;
typedef typed_mf_value < t_expected, mf1_fn > fn_at1;
typedef typed_mf_value < t_generic, mf1_given_name > given_name_at1;
typedef typed_mf_value < t_generic, mf1_geo > geo_at1;
typedef typed_mf_value < t_generic, mf1_hentry > hentry_at1;
typedef typed_mf_value < t_generic, mf1_honorific_prefix > honorific_prefix_at1;
typedef typed_mf_value < t_generic, mf1_honorific_suffix > honorific_suffix_at1;
typedef typed_mf_value < t_generic, mf1_housing > housing_at1;
typedef typed_mf_value < t_generic, mf1_identifier > identifier_at1;
typedef typed_mf_value < t_generic, mf1_ingredient > ingredient_at1;
typedef typed_mf_value < t_generic, mf1_instructions > instructions_at1;
typedef typed_mf_value < t_generic, mf1_item > item_at1;
typedef typed_mf_value < t_generic, mf1_item_info > item_info_at1;
typedef typed_mf_value < t_generic, mf1_item_licence > item_licence_at1;
typedef typed_mf_value < t_generic, mf1_item_tags > item_tags_at1;
typedef typed_mf_value < t_generic, mf1_item_type > item_type_at1;
typedef typed_mf_value < t_generic, mf1_key > key_at1;
typedef typed_mf_value < t_generic, mf1_label > label_at1;
typedef typed_mf_value < t_generic, mf1_latitude > latitude_at1;
typedef typed_mf_value < t_generic, mf1_licence > licence_at1;
typedef typed_mf_value < t_expected, mf1_lister > lister_at1;
typedef typed_mf_value < t_generic, mf1_listing > listing_at1;
typedef typed_mf_value < t_generic, mf1_locality > locality_at1;
typedef typed_mf_value < t_generic, mf1_location > location_at1;
typedef typed_mf_value < t_generic, mf1_logo > logo_at1;
typedef typed_mf_value < t_generic, mf1_longitude > longitude_at1;
typedef typed_mf_value < t_generic, mf1_mailer > mailer_at1;
typedef typed_mf_value < t_generic, mf1_meet > meet_at1;
typedef typed_mf_value < t_generic, mf1_n > n_at1;
typedef typed_mf_value < t_generic, mf1_nickname > nickname_at1;
typedef typed_mf_value < t_generic, mf1_note > note_at1;
typedef typed_mf_value < t_generic, mf1_nutrition > nutrition_at1;
typedef typed_mf_value < t_generic, mf1_offer > offer_at1;
typedef typed_mf_value < t_generic, mf1_opening > opening_at1;
typedef typed_mf_value < t_generic, mf1_org > org_at1;
typedef typed_mf_value < t_generic, mf1_organisation_name > organisation_name_at1;
typedef typed_mf_value < t_generic, mf1_organisation_unit > organisation_unit_at1;
typedef typed_mf_value < t_generic, mf1_organiser > organiser_at1;
typedef typed_mf_value < t_generic, mf1_partstat > partstat_at1;
typedef typed_mf_value < t_generic, mf1_payment > payment_at1;
typedef typed_mf_value < t_url, mf1_permalink > permalink_at1;
typedef typed_mf_value < t_generic, mf1_person > person_at1;
typedef typed_mf_value < t_url, mf1_photo > photo_at1;
typedef typed_mf_value < t_generic, mf1_place > place_at1;
typedef typed_mf_value < t_generic, mf1_player > player_at1;
typedef typed_mf_value < t_generic, mf1_postal_code > postal_code_at1;
typedef typed_mf_value < t_generic, mf1_post_office_box > post_office_box_at1;
typedef typed_mf_value < t_dosh, mf1_price > price_at1;
typedef typed_mf_value < t_generic, mf1_principles > principles_at1;
typedef typed_mf_value < t_generic, mf1_product > product_at1;
typedef typed_mf_value < t_url, mf1_profile > profile_at1;
typedef typed_mf_value < t_generic, mf1_position > position_at1;
typedef typed_mf_value < t_generic, mf1_publications > publications_at1;
typedef typed_mf_value < t_generic, mf1_published > published_at1;
typedef typed_mf_value < t_generic, mf1_rating > rating_at1;
typedef typed_mf_value < t_generic, mf1_rdate > rdate_at1;
typedef typed_mf_value < t_generic, mf1_region > region_at1;
typedef typed_mf_value < t_generic, mf1_rent > rent_at1;
typedef typed_mf_value < t_generic, mf1_rev > rev_at1;
typedef typed_mf_value < t_generic, mf1_review > review_at1;
typedef typed_mf_value < t_generic, mf1_reviewer > reviewer_at1;
typedef typed_mf_value < t_generic, mf1_role > role_at1;
typedef typed_mf_value < t_generic, mf1_rrule > rrule_at1;
typedef typed_mf_value < t_generic, mf1_sample > sample_at1;
typedef typed_mf_value < t_generic, mf1_sell > sell_at1;
typedef typed_mf_value < t_generic, mf1_service > service_at1;
typedef typed_mf_value < t_generic, mf1_skill > skill_at1;
typedef typed_mf_value < t_generic, mf1_sort_string > sort_string_at1;
typedef typed_mf_value < t_generic, mf1_sound > sound_at1;
typedef typed_mf_value < t_generic, mf1_source_org > source_org_at1;
typedef typed_mf_value < t_generic, mf1_status > status_at1;
typedef typed_mf_value < t_generic, mf1_street_address > street_address_at1;
typedef typed_mf_value < t_generic, mf1_summary > summary_at1;
typedef typed_mf_value < t_rel, r_tag > tag_at1;
typedef typed_mf_value < t_tel, mf1_tel > tel_at1;
typedef typed_mf_value < t_generic, mf1_title > title_at1;
typedef typed_mf_value < t_generic, mf1_trade > trade_at1;
typedef typed_mf_value < t_generic, mf1_type > type_at1;
typedef typed_mf_value < t_generic, mf1_tz > tz_at1;
typedef typed_mf_value < t_generic, mf1_uid > uid_at1;
typedef typed_mf_value < t_expected, mf1_updated > updated_at1;
typedef typed_mf_value < t_generic, mf1_url > url_at1;
typedef typed_mf_value < t_generic, mf1_value > value_at1;
typedef typed_mf_value < t_generic, mf1_version > version_at1;
typedef typed_mf_value < t_generic, mf1_votes > votes_at1;
typedef typed_mf_value < t_generic, mf1_wanted > wanted_at1;
typedef typed_mf_value < t_generic, mf1_website > website_at1;
typedef typed_mf_value < t_generic, mf1_worst > worst_at1;
typedef typed_mf_value < t_generic, mf1_yield > yield_at1;

// remove non-MF rels
typedef typed_mf_value < t_illegal, c_error > unknown_at;
typedef typed_mf_value < t_datetime, dt_accessed > accessed_at;
typedef typed_mf_value < t_rel_a, r_acquaintance > acquaintance_rt;
typedef typed_mf_value < t_action, p_action > action_at;
typedef typed_mf_value < t_generic, p_additional_name > additional_name_at;
typedef typed_mf_value < t_generic, p_adr > adr_at;
typedef typed_mf_value < t_generic, p_affiliation > affiliation_at;
typedef typed_mf_value < t_real, p_altitude > altitude_at;
typedef typed_mf_value < t_rel, r_alternative > alternative_rt;
typedef typed_mf_value < t_datetime, dt_anniversary > anniversary_at;
typedef typed_mf_value < t_rel, r_appendix > appendix_rt;
typedef typed_mf_value < t_generic, p_attendee > attendee_at;
typedef typed_mf_value < t_url, u_audio > audio_at;
typedef typed_mf_value < t_generic, p_author > author_at;
typedef typed_mf_value < t_rel, r_author > author_rt;
typedef typed_mf_value < t_real, p_average > average_at;
typedef typed_mf_value < t_datetime, dt_bday > bday_at;
typedef typed_mf_value < t_rating, p_best > best_at;
typedef typed_mf_value < t_rel_a, r_bookmark > bookmark_rt;
typedef typed_mf_value < t_url, u_bookmark_of > bookmark_of_at;
typedef typed_mf_value < t_generic, p_brand > brand_at;
typedef typed_mf_value < t_generic, p_category > category_at;
typedef typed_mf_value < t_rel, r_chapter > chapter_rt;
typedef typed_mf_value < t_rel_obsolete, r_child > child_rt;
typedef typed_mf_value < t_rel_a, r_colleague > colleague_rt;
typedef typed_mf_value < t_generic, p_comment > comment_at;
typedef typed_mf_value < t_generic, p_contact > contact_at;
typedef typed_mf_value < t_rel_a, p_contact > contact_rt;
typedef typed_mf_value < t_generic, p_content > content_at;
typedef typed_mf_value < t_generic, e_content > content_et;
typedef typed_mf_value < t_marked_up, p_content > content_ht;
typedef typed_mf_value < t_rel, r_contents > contents_rt;
typedef typed_mf_value < t_unsigned, p_count > count_at;
typedef typed_mf_value < t_generic, p_country_name > country_name_at;
typedef typed_mf_value < t_rel, r_copyright > copyright_rt;
typedef typed_mf_value < t_rel_a, r_coresident > coresident_rt;
typedef typed_mf_value < t_rel_a, r_coworker > coworker_rt;
typedef typed_mf_value < t_rel_a, r_crush > crush_rt;
typedef typed_mf_value < t_rel_a, r_date > date_rt;
typedef typed_mf_value < t_marked_up, e_description > description_ht;
typedef typed_mf_value < t_generic, e_description > description_at;
typedef typed_mf_value < t_rel, r_directory > directory_rt;
typedef typed_mf_value < t_duration, dt_duration > duration_at;
typedef typed_mf_value < t_generic, p_education > education_at;
typedef typed_mf_value < t_url, u_email > email_at;
typedef typed_mf_value < t_rel, r_enclosure > enclosure_rt;
typedef typed_mf_value < t_datetime, dt_end > end_at;
typedef typed_mf_value < t_generic, p_entry > entry_at;
typedef typed_mf_value < t_generic, p_experience > experience_at;
typedef typed_mf_value < t_datetime, dt_expired > expired_at;
typedef typed_mf_value < t_generic, p_extended_address > extended_address_at;
typedef typed_mf_value < t_generic, p_family_name > family_name_at;
typedef typed_mf_value < t_url, u_featured > featured_at;
typedef typed_mf_value < t_rel_a, r_friend > friend_rt;
typedef typed_mf_value < t_sex, p_gender_identity > gender_identity_at;
typedef typed_mf_value < t_generic, p_geo > geo_at;
typedef typed_mf_value < t_marked_up, p_geo > geo_ht;
typedef typed_mf_value < t_ugeo, u_geo > ugeo_at;
typedef typed_mf_value < t_generic, p_given_name > given_name_at;
typedef typed_mf_value < t_rel, r_glossary > glossary_rt;
typedef typed_mf_value < t_rel, r_help > help_rt;
typedef typed_mf_value < t_rel, r_home > home_rt;
typedef typed_mf_value < t_generic, p_honorific_prefix > honorific_prefix_at;
typedef typed_mf_value < t_generic, p_honorific_suffix > honorific_suffix_at;
typedef typed_mf_value < t_identifier_url, u_identifier > identifier_at;
typedef typed_mf_value < t_url, u_impp > impp_at;
typedef typed_mf_value < t_url, u_in_reply_to > in_reply_to_at;
typedef typed_mf_value < t_rel, r_index > index_rt;
typedef typed_mf_value < t_generic, p_ingredient > ingredient_at;
typedef typed_mf_value < t_marked_up, e_instructions > instructions_at;
typedef typed_mf_value < t_generic, p_item > item_at;
typedef typed_mf_value < t_rel_link, r_its_rules > its_rules_rt;
typedef typed_mf_value < t_generic, p_job_title > job_title_at;
typedef typed_mf_value < t_url, u_key > key_at;
typedef typed_mf_value < t_rel_a, r_kin > kin_rt;
typedef typed_mf_value < t_generic, p_label > label_at;
typedef typed_mf_value < t_real, p_latitude > latitude_at;
typedef typed_mf_value < t_rel, r_licence > licence_rt;
typedef typed_mf_value < t_url, u_like > like_at;
typedef typed_mf_value < t_url, u_like_of > like_of_at;
typedef typed_mf_value < t_datetime, dt_listed > listed_at;
typedef typed_mf_value < t_generic, p_lister > lister_at;
typedef typed_mf_value < t_generic, p_locality > locality_at;
typedef typed_mf_value < t_generic, p_location > location_at;
typedef typed_mf_value < t_url, u_logo > logo_at;
typedef typed_mf_value < t_real, p_longitude > longitude_at;
typedef typed_mf_value < t_rel, r_me > me_rt;
typedef typed_mf_value < t_rel_a, r_met > met_rt;
typedef typed_mf_value < t_rel_a, r_muse > muse_rt;
typedef typed_mf_value < t_generic, p_name > name_at;
typedef typed_mf_value < t_rel_a, r_neighbour > neighbour_rt;
typedef typed_mf_value < t_rel, r_next > next_rt;
typedef typed_mf_value < t_generic, p_nickname > nickname_at;
typedef typed_mf_value < t_rel_a, r_nofollow > nofollow_rt;
typedef typed_mf_value < t_generic, p_note > note_at;
typedef typed_mf_value < t_generic, p_nutrition > nutrition_at;
typedef typed_mf_value < t_generic, p_org > org_at;
typedef typed_mf_value < t_generic, p_organisation_name > organisation_name_at;
typedef typed_mf_value < t_generic, p_organisation_unit > organisation_unit_at;
typedef typed_mf_value < t_rel_obsolete, r_parent > parent_rt;
typedef typed_mf_value < t_rel, r_payment > payment_rt;
typedef typed_mf_value < t_rel, r_prev > prev_rt;
typedef typed_mf_value < t_unsigned_dosh, p_price > price_at;
typedef typed_mf_value < t_url, u_photo > photo_at;
typedef typed_mf_value < t_generic, p_post_office_box > post_office_box_at;
typedef typed_mf_value < t_generic, p_postal_code > postal_code_at;
typedef typed_mf_value < t_generic, p_publication > publication_at;
typedef typed_mf_value < t_rel, r_pronunciation > pronunciation_rt;
typedef typed_mf_value < t_datetime, dt_published > published_at;
typedef typed_mf_value < t_rating, p_rating > rating_at;
typedef typed_mf_value < t_generic, p_region > region_at;
typedef typed_mf_value < t_url, u_repost > repost_at;
typedef typed_mf_value < t_url, u_repost_of > repost_of_at;
typedef typed_mf_value < t_datetime, dt_rev > rev_at;
typedef typed_mf_value < t_generic, p_review > review_at;
typedef typed_mf_value < t_datetime, dt_reviewed > reviewed_at;
typedef typed_mf_value < t_generic, p_reviewer > reviewer_at;
typedef typed_mf_value < t_generic, p_role > role_at;
typedef typed_mf_value < t_rsvp, p_rsvp > rsvp_at;
typedef typed_mf_value < t_rel, r_section > section_rt;
typedef typed_mf_value < t_sex, p_sex > sex_at;
typedef typed_mf_value < t_rel_obsolete, r_sibling > sibling_rt;
typedef typed_mf_value < t_rel, r_sidebar > sidebar_rt;
typedef typed_mf_value < t_generic, p_skill > skill_at;
typedef typed_mf_value < t_generic, p_sort_string > sort_string_at;
typedef typed_mf_value < t_url, u_sound > sound_at;
typedef typed_mf_value < t_rel_obsolete, r_supercedes > supercedes_rt;
typedef typed_mf_value < t_rel_a, r_spouse > spouse_rt;
typedef typed_mf_value < t_datetime, dt_start > start_at;
typedef typed_mf_value < t_rel, r_start > start_rt;
typedef typed_mf_value < t_generic, p_street_address > street_address_at;
typedef typed_mf_value < t_rel_css, r_stylesheet > stylesheet_rt;
typedef typed_mf_value < t_rel, r_subsection > subsection_rt;
typedef typed_mf_value < t_generic, p_summary > summary_at;
typedef typed_mf_value < t_rel_a, r_sweetheart > sweetheart_rt;
typedef typed_mf_value < t_url, u_syndication > syndication_at;
typedef typed_mf_value < t_rel_a, r_tag > tag_rt;
typedef typed_mf_value < t_tel, p_tel > tel_at;
typedef typed_mf_value < t_rel, r_toc > toc_rt;
typedef typed_mf_value < t_rel_obsolete, r_top > top_rt;
typedef typed_mf_value < t_rel, r_transformation > transformation_rt;
typedef typed_mf_value < t_generic, p_tz > tz_at;
typedef typed_mf_value < t_url, u_uid > uid_at;
typedef typed_mf_value < t_url, u_url > url_at;
typedef typed_mf_value < t_datetime, dt_updated > updated_at;
typedef typed_mf_value < t_rel, r_vcs_git > vcs_git_rt;
typedef typed_mf_value < t_rel, r_vcs_svn > vcs_svn_rt;
typedef typed_mf_value < t_url, u_video > video_at;
typedef typed_mf_value < t_unsigned, p_votes > votes_at;
typedef typed_mf_value < t_rating, p_worst > worst_at;
typedef typed_mf_value < t_generic, p_yield > yield_at;

typedef typed_mf_value < t_rel_link, r_micropub > micropub_rt;
typedef typed_mf_value < t_rel_link, r_pingback > pingback_rt;
typedef typed_mf_value < t_rel, r_webmention > webmention_rt;

typedef typed_mf_value < t_rel, r_canonical > canonical_rt;
typedef typed_mf_value < t_rel, r_cite > cite_rt;
typedef typed_mf_value < t_rel, r_code_licence > code_licence_rt;
typedef typed_mf_value < t_rel, r_content_licence > content_licence_rt;
typedef typed_mf_value < t_rel, r_discussion > discussion_rt;
typedef typed_mf_value < t_rel, r_group > group_rt;
typedef typed_mf_value < t_rel, r_in_reply_to > in_reply_to_rt;
typedef typed_mf_value < t_rel, r_issues > issues_rt;
typedef typed_mf_value < t_rel, r_map > map_rt;
typedef typed_mf_value < t_rel, r_member > member_rt;

typedef typed_mf_value < t_rel_link, u_dnsprefetch > dnsprefetch_rt;
typedef typed_mf_value < t_rel_link, u_external > external_rt;
typedef typed_mf_value < t_rel, u_icon > icon_rt;
typedef typed_mf_value < t_rel_a, u_noopener > noopener_rt;
typedef typed_mf_value < t_rel, u_noreferrer > noreferrer_rt;
typedef typed_mf_value < t_rel_link, u_preconnect > preconnect_rt;
typedef typed_mf_value < t_rel, u_prefetch > prefetch_rt;
typedef typed_mf_value < t_rel, u_preload > preload_rt;
typedef typed_mf_value < t_rel, u_prerender > prerender_rt;
typedef typed_mf_value < t_rel, u_search > search_rt;

typedef typed_mf_value < t_rel_obsolete, r_banner > banner_rt;
typedef typed_mf_value < t_rel_obsolete, r_begin > begin_rt;
typedef typed_mf_value < t_rel_obsolete, r_biblioentry > biblioentry_rt;
typedef typed_mf_value < t_rel_obsolete, r_bibliography > bibliography_rt;
typedef typed_mf_value < t_rel_obsolete, r_citation > citation_rt;
typedef typed_mf_value < t_rel_obsolete, r_definition > definition_rt;
typedef typed_mf_value < t_rel_obsolete, r_disclaimer > disclaimer_rt;
typedef typed_mf_value < t_rel_obsolete, r_editor > editor_rt;
typedef typed_mf_value < t_rel_obsolete, r_end > end_rt;
typedef typed_mf_value < t_rel_obsolete, r_navigate > navigate_rt;
typedef typed_mf_value < t_rel_obsolete, r_origin > origin_rt;
typedef typed_mf_value < t_rel_obsolete, r_pointer > pointer_rt;
typedef typed_mf_value < t_rel_obsolete, r_trademark > trademark_rt;
typedef typed_mf_value < t_rel_obsolete, r_translation > translation_rt;
typedef typed_mf_value < t_rel_obsolete, r_urc > urc_rt;

typedef typed_mf_value < t_rel, r_about > about_rt;
typedef typed_mf_value < t_rel, r_archives > archives_rt;
typedef typed_mf_value < t_rel, r_blocked_by > blocked_by_rt;
typedef typed_mf_value < t_rel, r_cite_as > cite_as_rt;
typedef typed_mf_value < t_rel_obsolete, r_collection > collection_rt;
typedef typed_mf_value < t_rel, r_convertedfrom > convertedfrom_rt;
typedef typed_mf_value < t_rel, r_create_form > create_form_rt;
typedef typed_mf_value < t_rel, r_current > current_rt;
typedef typed_mf_value < t_rel, r_describedby > describedby_rt;
typedef typed_mf_value < t_rel, r_describes > describes_rt;
typedef typed_mf_value < t_rel, r_duplicate > duplicate_rt;
typedef typed_mf_value < t_rel_link, r_edit > edit_rt;
typedef typed_mf_value < t_rel, r_edit_form > edit_form_rt;
typedef typed_mf_value < t_rel, r_edit_media > edit_media_rt;
typedef typed_mf_value < t_rel_avoid, r_first > first_rt;
typedef typed_mf_value < t_rel, r_hosts > hosts_rt;
typedef typed_mf_value < t_rel, r_hub > hub_rt;
typedef typed_mf_value < t_rel, r_intervalafter > intervalafter_rt;
typedef typed_mf_value < t_rel, r_intervalbefore > intervalbefore_rt;
typedef typed_mf_value < t_rel, r_intervalcontains > intervalcontains_rt;
typedef typed_mf_value < t_rel, r_intervaldisjoint > intervaldisjoint_rt;
typedef typed_mf_value < t_rel, r_intervalduring > intervalduring_rt;
typedef typed_mf_value < t_rel, r_intervalequals > intervalequals_rt;
typedef typed_mf_value < t_rel, r_intervalfinishedby > intervalfinishedby_rt;
typedef typed_mf_value < t_rel, r_intervalfinishes > intervalfinishes_rt;
typedef typed_mf_value < t_rel, r_intervalin > intervalin_rt;
typedef typed_mf_value < t_rel, r_intervalmeets > intervalmeets_rt;
typedef typed_mf_value < t_rel, r_intervalmetby > intervalmetby_rt;
typedef typed_mf_value < t_rel, r_intervaloverlappedby > intervaloverlappedby_rt;
typedef typed_mf_value < t_rel, r_intervaloverlaps > intervaloverlaps_rt;
typedef typed_mf_value < t_rel, r_intervalstartedby > intervalstartedby_rt;
typedef typed_mf_value < t_rel, r_intervalstarts > intervalstarts_rt;
typedef typed_mf_value < t_rel, r_item > item_rt;
typedef typed_mf_value < t_rel, r_item_licence > item_licence_rt;
typedef typed_mf_value < t_rel_avoid, r_last > last_rt;
typedef typed_mf_value < t_rel, r_latest_version > latest_version_rt;
typedef typed_mf_value < t_rel, r_lrdd > lrdd_rt;
typedef typed_mf_value < t_rel, r_memento > memento_rt;
typedef typed_mf_value < t_rel, r_monitor > monitor_rt;
typedef typed_mf_value < t_rel, r_monitor_group > monitor_group_rt;
typedef typed_mf_value < t_rel, r_next_archive > next_archive_rt;
typedef typed_mf_value < t_rel, r_original > original_rt;
typedef typed_mf_value < t_rel, r_predecessor_version > predecessor_version_rt;
typedef typed_mf_value < t_rel, r_preview > preview_rt;
typedef typed_mf_value < t_rel, r_principles > principles_rt;
typedef typed_mf_value < t_rel, r_prev_archive > prev_archive_rt;
typedef typed_mf_value < t_rel, r_privacy_policy > privacy_policy_rt;
typedef typed_mf_value < t_rel, r_profile > profile_rt;
typedef typed_mf_value < t_rel, r_related > related_rt;
typedef typed_mf_value < t_rel, r_restconf > restconf_rt;
typedef typed_mf_value < t_rel, r_replies > replies_rt;
typedef typed_mf_value < t_rel, r_self > self_rt;
typedef typed_mf_value < t_rel_link, r_service > service_rt;
typedef typed_mf_value < t_rel, r_service_desc > service_desc_rt;
typedef typed_mf_value < t_rel, r_service_doc > service_doc_rt;
typedef typed_mf_value < t_rel, r_service_meta > service_meta_rt;
typedef typed_mf_value < t_rel, r_status > status_rt;
typedef typed_mf_value < t_rel, r_successor_version > successor_version_rt;
typedef typed_mf_value < t_rel, r_sunset > sunset_rt;
typedef typed_mf_value < t_rel, r_terms_of_service > terms_of_service_rt;
typedef typed_mf_value < t_rel, r_timegate > timegate_rt;
typedef typed_mf_value < t_rel, r_timemap > timemap_rt;
typedef typed_mf_value < t_rel, r_type > type_rt;
typedef typed_mf_value < t_rel_avoid, r_up > up_rt;
typedef typed_mf_value < t_rel, r_version_history > version_history_rt;
typedef typed_mf_value < t_rel, r_via > via_rt;
typedef typed_mf_value < t_rel, r_working_copy > working_copy_rt;
typedef typed_mf_value < t_rel, r_working_copy_of > working_copy_of_rt;

typedef typed_mf_value < t_rel, r_amphtml > amphtml_rt;
typedef typed_mf_value < t_rel_link, r_apple_touch_icon > apple_touch_icon_rt;
typedef typed_mf_value < t_rel_link, r_apple_touch_icon_precomposed > apple_touch_icon_precomposed_rt;
typedef typed_mf_value < t_rel_link, r_apple_touch_startup_image > apple_touch_startup_image_rt;
typedef typed_mf_value < t_rel, r_archived > archived_rt;
typedef typed_mf_value < t_rel, r_attachment > attachment_rt;
typedef typed_mf_value < t_rel_link, r_authorisation_endpoint > authorisation_endpoint_rt;
typedef typed_mf_value < t_rel, r_category > category_rt;
typedef typed_mf_value < t_rel, r_code_repository > code_repository_rt;
typedef typed_mf_value < t_rel_link, r_component > component_rt;
typedef typed_mf_value < t_rel_link, r_chrome_webstore_item > chrome_webstore_item_rt;
typedef typed_mf_value < t_rel, r_content_repository > content_repository_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_conformsto > dcterms_conformsto_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_contributor > dcterms_contributor_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_creator > dcterms_creator_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_description > dcterms_description_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_hasformat > dcterms_hasformat_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_haspart > dcterms_haspart_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_hasversion > dcterms_hasversion_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_isformatof > dcterms_isformatof_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_ispartof > dcterms_ispartof_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_isreferencedby > dcterms_isreferencedby_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_isreplacedby > dcterms_isreplacedby_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_isrequiredby > dcterms_isrequiredby_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_isversionof > dcterms_isversionof_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_licence > dcterms_licence_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_mediator > dcterms_mediator_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_publisher > dcterms_publisher_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_references > dcterms_references_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_relation > dcterms_relation_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_replaces > dcterms_replaces_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_requires > dcterms_requires_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_rightsholder > dcterms_rightsholder_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_source > dcterms_source_rt;
typedef typed_mf_value < t_rel_link, r_dcterms_subject > dcterms_subject_rt;
typedef typed_mf_value < t_rel_a, r_disclosure > disclosure_rt;
typedef typed_mf_value < t_rel_link, r_edituri > edituri_rt;
typedef typed_mf_value < t_rel_a, r_entry_content > entry_content_rt;
typedef typed_mf_value < t_rel_link, r_gbfs > gbfs_rt;
typedef typed_mf_value < t_rel_link, r_gtfs_static > gtfs_static_rt;
typedef typed_mf_value < t_rel_link, r_gtfs_realtime > gtfs_realtime_rt;
typedef typed_mf_value < t_rel_link, r_image_src > image_src_rt;
typedef typed_mf_value < t_rel_link, r_import > import_rt;
typedef typed_mf_value < t_rel, r_jslicence > jslicence_rt;
typedef typed_mf_value < t_rel_a, r_lightbox > lightbox_rt;
typedef typed_mf_value < t_rel, r_lightvideo > lightvideo_rt;
typedef typed_mf_value < t_rel_link, r_manifest > manifest_rt;
typedef typed_mf_value < t_rel_link, r_maskicon > maskicon_rt;
typedef typed_mf_value < t_rel_link, r_meta > meta_rt;
typedef typed_mf_value < t_rel_link, r_openid_delegate > openid_delegate_rt;
typedef typed_mf_value < t_rel_link, r_openid_server > openid_server_rt;
typedef typed_mf_value < t_rel_link, r_openid2_local_id > openid2_local_id_rt;
typedef typed_mf_value < t_rel_link, r_openid2_provider > openid2_provider_rt;
typedef typed_mf_value < t_rel_link, r_p3pv1 > p3pv1_rt;
typedef typed_mf_value < t_rel_link, r_pgpkey > pgpkey_rt;
typedef typed_mf_value < t_rel_obsolete, r_publisher > publisher_rt;
typedef typed_mf_value < t_rel, r_radioepg > radioepg_rt;
typedef typed_mf_value < t_rel, r_rendition > rendition_rt;
typedef typed_mf_value < t_rel, r_root > root_rt;
typedef typed_mf_value < t_rel, r_reply_to > reply_to_rt;
typedef typed_mf_value < t_rel_link, r_schema_dcterms > schema_dcterms_rt;
typedef typed_mf_value < t_rel_link, r_shortlink > shortlink_rt;
typedef typed_mf_value < t_rel_link, r_sitemap > sitemap_rt;
typedef typed_mf_value < t_rel_link, r_stylesheetless > stylesheetless_rt;
typedef typed_mf_value < t_rel_link, r_subresource > subresource_rt;
typedef typed_mf_value < t_rel_link, r_sword > sword_rt;
typedef typed_mf_value < t_rel_link, r_syndication > syndication_rt;
typedef typed_mf_value < t_rel_link, r_timesheet > timesheet_rt;
typedef typed_mf_value < t_rel, r_token_endpoint > token_endpoint_rt;
typedef typed_mf_value < t_rel, r_widget > widget_rt;
typedef typed_mf_value < t_rel_link, r_wlwmanifest > wlwmanifest_rt;
typedef typed_mf_value < t_rel_link, r_yandex_tableau_widget > yandex_tableau_widget_rt;
typedef typed_mf_value < t_rel, r_docs_oasis_open_org_ns_cmis_link_200908_acl > docs_oasis_open_org_ns_cmis_link_200908_acl_rt;

typedef typed_mf_value < t_rel, r_accessibility > accessibility_rt;
typedef typed_mf_value < t_rel, r_longdesc > longdesc_rt;
typedef typed_mf_value < t_rel, r_m_pagescroll2id > m_pagescroll2id_rt;
typedef typed_mf_value < t_rel, r_source > source_rt;
typedef typed_mf_value < t_rel, r_vcalendar_parent > vcalendar_parent_rt;
typedef typed_mf_value < t_rel, r_vcalendar_child > vcalendar_child_rt;
typedef typed_mf_value < t_rel, r_vcalendar_sibling > vcalendar_sibling_rt;
typedef typed_mf_value < t_rel, r_w_api_org > w_api_org_rt;

typedef typed_mf_value < t_rel, r_comment > comment_rt;
typedef typed_mf_value < t_rel, r_contribution > contribution_rt;
typedef typed_mf_value < t_rel, r_endorsed > endorsed_rt;
typedef typed_mf_value < t_rel, r_fan > fan_rt;
typedef typed_mf_value < t_rel, r_feed > feed_rt;
typedef typed_mf_value < t_rel_obsolete, r_footnote > footnote_rt;
typedef typed_mf_value < t_rel, r_kinetic_stylesheet > kinetic_stylesheet_rt;
typedef typed_mf_value < t_rel, r_made > made_rt;
typedef typed_mf_value < t_rel_avoid, r_microsummary > microsummary_rt;
typedef typed_mf_value < t_rel, r_permalink > permalink_rt;
typedef typed_mf_value < t_rel, r_popover > popover_rt;
typedef typed_mf_value < t_rel, r_privacy > privacy_rt;
typedef typed_mf_value < t_rel, r_publickey > publickey_rt;
typedef typed_mf_value < t_rel, r_referral > referral_rt;
typedef typed_mf_value < t_rel, r_respond_proxy > respond_proxy_rt;
typedef typed_mf_value < t_rel, r_respond_redirect > respond_redirect_rt;
typedef typed_mf_value < t_rel, r_resource > resource_rt;
typedef typed_mf_value < t_rel, r_sponsor > sponsor_rt;
typedef typed_mf_value < t_rel, r_tooltip > tooltip_rt;
typedef typed_mf_value < t_rel, r_trackback > trackback_rt;
typedef typed_mf_value < t_rel, r_unendorsed > unendorsed_rt;
typedef typed_mf_value < t_rel, r_user > user_rt;

typedef typed_mf_value < t_rel_link, r_schema_dc > schema_dc_rt;

typedef typed_mf_value < t_rel_illegal, r_logo > logo_rt;
typedef typed_mf_value < t_rel_illegal, r_pavatar > pavatar_rt;

typedef typed_mf_value < t_rel, r_cc_permits > cc_permits_rt;
typedef typed_mf_value < t_rel, r_cc_requires > cc_requires_rt;
typedef typed_mf_value < t_rel, r_cc_prohibits > cc_prohibits_rt;
typedef typed_mf_value < t_rel, r_cc_jurisdiction > cc_jurisdiction_rt;
typedef typed_mf_value < t_rel, r_cc_legalcode > cc_legalcode_rt;
typedef typed_mf_value < t_rel, r_cc_deprecatedon > cc_deprecatedon_rt;
typedef typed_mf_value < t_rel, r_cc_licence > cc_licence_rt;
typedef typed_mf_value < t_rel, r_cc_morepermissions > cc_morepermissions_rt;
typedef typed_mf_value < t_rel, r_cc_attributionname > cc_attributionname_rt;    // illustrates ssc mf design issue; mf needs reworking
typedef typed_mf_value < t_rel, r_cc_attributionurl > cc_attributionurl_rt;
typedef typed_mf_value < t_rel, r_cc_useguidelines > cc_useguidelines_rt;
