/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "schema_hierarchy.h"

struct microdata_hierachy
{   schema_version from_;
    schema_version to_;
    e_schema general_;
    e_schema specific_; };

microdata_hierachy schema_hierarchy [] =
{   {   { 3, 1 }, { 0, 0 }, sch_accommodation, sch_apartment },
    {   { 3, 1 }, { 0, 0 }, sch_accommodation, sch_campingpitch },
    {   { 3, 1 }, { 0, 0 }, sch_accommodation, sch_house },
    {   { 3, 1 }, { 0, 0 }, sch_accommodation, sch_room },
    {   { 3, 1 }, { 0, 0 }, sch_accommodation, sch_suite },
    {   { 2, 0 }, { 0, 0 }, sch_achieveaction, sch_loseaction },
    {   { 2, 0 }, { 0, 0 }, sch_achieveaction, sch_tieaction },
    {   { 2, 0 }, { 0, 0 }, sch_achieveaction, sch_winaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_achieveaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_assessaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_consumeaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_controlaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_createaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_findaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_interactaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_moveaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_organiseaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_playaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_searchaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_tradeaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_transferaction },
    {   { 2, 0 }, { 0, 0 }, sch_action, sch_updateaction },
    {   { 3, 5 }, { 0, 0 }, sch_actionstatustype, sch_activeactionstatus },
    {   { 3, 5 }, { 0, 0 }, sch_actionstatustype, sch_completedactionstatus },
    {   { 3, 5 }, { 0, 0 }, sch_actionstatustype, sch_failedactionstatus },
    {   { 3, 5 }, { 0, 0 }, sch_actionstatustype, sch_potentialactionstatus },
    {   { 2, 0 }, { 0, 0 }, sch_addaction, sch_insertaction },
    {   { 2, 0 }, { 0, 0 }, sch_administrativearea, sch_city },
    {   { 2, 0 }, { 0, 0 }, sch_administrativearea, sch_country },
    {   { 7, 1 }, { 0, 0 }, sch_administrativearea, sch_schooldistrict },
    {   { 2, 0 }, { 0, 0 }, sch_administrativearea, sch_state },
    {   { 2, 0 }, { 0, 0 }, sch_aggregaterating, sch_employeraggregaterating },
    {   { 2, 0 }, { 0, 0 }, sch_allocateaction, sch_acceptaction },
    {   { 2, 0 }, { 0, 0 }, sch_allocateaction, sch_assignaction },
    {   { 2, 0 }, { 0, 0 }, sch_allocateaction, sch_authoriseaction },
    {   { 2, 0 }, { 0, 0 }, sch_allocateaction, sch_rejectaction },
    {   { 2, 0 }, { 0, 0 }, sch_anatomicalstructure, sch_bone },
    {   { 2, 0 }, { 0, 0 }, sch_anatomicalstructure, sch_brainstructure },
    {   { 2, 0 }, { 0, 0 }, sch_anatomicalstructure, sch_joint },
    {   { 2, 0 }, { 0, 0 }, sch_anatomicalstructure, sch_ligament },
    {   { 2, 0 }, { 0, 0 }, sch_anatomicalstructure, sch_muscle },
    {   { 2, 0 }, { 0, 0 }, sch_anatomicalstructure, sch_nerve },
    {   { 2, 0 }, { 0, 0 }, sch_anatomicalstructure, sch_vessel },
    {   { 3, 5 }, { 0, 0 }, sch_article, sch_advertisercontentarticle },
    {   { 2, 0 }, { 2, 0 }, sch_article, sch_blogposting },
    {   { 3, 0 }, { 3, 0 }, sch_article, sch_blogposting },
    {   { 2, 0 }, { 0, 0 }, sch_article, sch_newsarticle },
    {   { 2, 1 }, { 0, 0 }, sch_article, sch_report },
    {   { 3, 5 }, { 0, 0 }, sch_article, sch_satiricalarticle },
    {   { 2, 0 }, { 0, 0 }, sch_article, sch_scholarlyarticle },
    {   { 2, 1 }, { 0, 0 }, sch_article, sch_socialmediaposting },
    {   { 2, 0 }, { 0, 0 }, sch_article, sch_techarticle },
    {   { 2, 0 }, { 0, 0 }, sch_assessaction, sch_chooseaction },
    {   { 2, 0 }, { 0, 0 }, sch_assessaction, sch_ignoreaction },
    {   { 2, 0 }, { 0, 0 }, sch_assessaction, sch_reactaction },
    {   { 2, 0 }, { 0, 0 }, sch_assessaction, sch_reviewaction },
    {   { 2, 0 }, { 0, 0 }, sch_audience, sch_businessaudience },
    {   { 2, 0 }, { 0, 0 }, sch_audience, sch_educationalaudience },
    {   { 2, 0 }, { 2, 1 }, sch_audience, sch_medicalaudience },
    {   { 3, 5 }, { 0, 0 }, sch_audience, sch_medicalaudience },
    {   { 2, 0 }, { 0, 0 }, sch_audience, sch_peopleaudience },
    {   { 3, 5 }, { 0, 0 }, sch_audioobject, sch_audiobook },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_autobodyshop },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_autodealer },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_autopartsstore },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_autorental },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_autorepair },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_autowash },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_gasstation },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_motorcycledealer },
    {   { 2, 0 }, { 0, 0 }, sch_automotivebusiness, sch_motorcyclerepair },
    {   { 3, 0 }, { 0, 0 }, sch_bankaccount, sch_depositaccount },
    {   { 2, 1 }, { 0, 0 }, sch_blogposting, sch_liveblogposting },
    {   { 3, 5 }, { 0, 0 }, sch_boardingpolicytype, sch_groupboardingpolicy },
    {   { 3, 5 }, { 0, 0 }, sch_boardingpolicytype, sch_zoneboardingpolicy },
    {   { 2, 0 }, { 0, 0 }, sch_bodyofwater, sch_canal },
    {   { 2, 0 }, { 0, 0 }, sch_bodyofwater, sch_lakebodyofwater },
    {   { 2, 0 }, { 0, 0 }, sch_bodyofwater, sch_oceanbodyofwater },
    {   { 2, 0 }, { 0, 0 }, sch_bodyofwater, sch_pond },
    {   { 2, 0 }, { 0, 0 }, sch_bodyofwater, sch_reservoir },
    {   { 2, 0 }, { 0, 0 }, sch_bodyofwater, sch_riverbodyofwater },
    {   { 2, 0 }, { 0, 0 }, sch_bodyofwater, sch_seabodyofwater },
    {   { 2, 0 }, { 0, 0 }, sch_bodyofwater, sch_waterfall },
    {   { 2, 0 }, { 0, 0 }, sch_boolean, sch_false },
    {   { 2, 0 }, { 0, 0 }, sch_boolean, sch_true },
    {   { 3, 5 }, { 0, 0 }, sch_book, sch_audiobook },
    {   { 3, 5 }, { 0, 0 }, sch_bookformattype, sch_audiobookformat },
    {   { 3, 5 }, { 0, 0 }, sch_bookformattype, sch_ebook },
    {   { 3, 5 }, { 0, 0 }, sch_bookformattype, sch_graphicnovel },
    {   { 3, 5 }, { 0, 0 }, sch_bookformattype, sch_hardcover },
    {   { 3, 5 }, { 0, 0 }, sch_bookformattype, sch_paperback },
    {   { 2, 0 }, { 0, 0 }, sch_broadcastchannel, sch_radiochannel },
    {   { 2, 0 }, { 0, 0 }, sch_broadcastchannel, sch_televisionchannel },
    {   { 3, 5 }, { 0, 0 }, sch_broadcastservice, sch_radiobroadcastservice },
    {   { 3, 6 }, { 5, 0 }, sch_carusagetype, sch_drivingschoolvehicleusage },
    {   { 3, 6 }, { 5, 0 }, sch_carusagetype, sch_rentalvehicleusage },
    {   { 3, 6 }, { 5, 0 }, sch_carusagetype, sch_taxivehicleusage },
    {   { 3, 5 }, { 0, 0 }, sch_categorycode, sch_medicalcode },
    {   { 2, 0 }, { 0, 0 }, sch_chooseaction, sch_voteaction },
    {   { 3, 6 }, { 0, 0 }, sch_church, sch_catholicchurch },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_airport },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_aquarium },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_beach },
    {   { 9, 0 }, { 0, 0 }, sch_civicstructure, sch_boatterminal },
    {   { 2, 1 }, { 0, 0 }, sch_civicstructure, sch_bridge },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_busstation },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_busstop },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_campground },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_cemetery },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_crematorium },
    {   { 7, 4 }, { 0, 0 }, sch_civicstructure, sch_educationalorganisation },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_eventvenue },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_firestation },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_governmentbuilding },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_hospital },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_movietheatre },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_museum },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_musicvenue },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_park },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_parkingfacility },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_performingartstheatre },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_placeofworship },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_playground },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_policestation },
    {   { 3, 5 }, { 0, 0 }, sch_civicstructure, sch_publictoilet },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_rvpark },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_stadiumorarena },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_subwaystation },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_taxistand },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_trainstation },
    {   { 2, 0 }, { 0, 0 }, sch_civicstructure, sch_zoo },
    {   { 2, 0 }, { 0, 0 }, sch_clip, sch_movieclip },
    {   { 2, 0 }, { 0, 0 }, sch_clip, sch_radioclip },
    {   { 2, 0 }, { 0, 0 }, sch_clip, sch_tvclip },
    {   { 2, 0 }, { 0, 0 }, sch_clip, sch_videogameclip },
    {   { 2, 0 }, { 5, 0 }, sch_collectionpage, sch_imagegallery },
    {   { 6, 0 }, { 0, 0 }, sch_collectionpage, sch_mediagallery },
    {   { 2, 0 }, { 5, 0 }, sch_collectionpage, sch_videogallery },
    {   { 3, 5 }, { 0, 0 }, sch_comicstory, sch_comiccoverart },
    {   { 2, 0 }, { 0, 0 }, sch_comment, sch_answer },
    {   { 3, 5 }, { 0, 0 }, sch_comment, sch_correctioncomment },
    {   { 10, 0 }, { 0, 0 }, sch_comment, sch_question },
    {   { 2, 0 }, { 0, 0 }, sch_communicateaction, sch_askaction },
    {   { 2, 0 }, { 0, 0 }, sch_communicateaction, sch_checkinaction },
    {   { 2, 0 }, { 0, 0 }, sch_communicateaction, sch_checkoutaction },
    {   { 2, 0 }, { 0, 0 }, sch_communicateaction, sch_commentaction },
    {   { 2, 0 }, { 0, 0 }, sch_communicateaction, sch_informaction },
    {   { 2, 0 }, { 0, 0 }, sch_communicateaction, sch_inviteaction },
    {   { 2, 0 }, { 0, 0 }, sch_communicateaction, sch_replyaction },
    {   { 2, 0 }, { 0, 0 }, sch_communicateaction, sch_shareaction },
    {   { 2, 0 }, { 0, 0 }, sch_consumeaction, sch_drinkaction },
    {   { 2, 0 }, { 0, 0 }, sch_consumeaction, sch_eataction },
    {   { 2, 0 }, { 0, 0 }, sch_consumeaction, sch_installaction },
    {   { 2, 0 }, { 0, 0 }, sch_consumeaction, sch_listenaction },
    {   { 2, 0 }, { 0, 0 }, sch_consumeaction, sch_readaction },
    {   { 2, 0 }, { 0, 0 }, sch_consumeaction, sch_useaction },
    {   { 2, 0 }, { 0, 0 }, sch_consumeaction, sch_viewaction },
    {   { 2, 0 }, { 0, 0 }, sch_consumeaction, sch_watchaction },
    {   { 2, 0 }, { 0, 0 }, sch_contactpoint, sch_postaladdress },
    {   { 3, 5 }, { 0, 0 }, sch_contactpointoption, sch_hearingimpairedsupported },
    {   { 3, 5 }, { 0, 0 }, sch_contactpointoption, sch_tollfree },
    {   { 2, 0 }, { 0, 0 }, sch_controlaction, sch_activateaction },
    {   { 2, 0 }, { 0, 0 }, sch_controlaction, sch_deactivateaction },
    {   { 2, 0 }, { 0, 0 }, sch_controlaction, sch_resumeaction },
    {   { 2, 0 }, { 0, 0 }, sch_controlaction, sch_suspendaction },
    {   { 3, 5 }, { 0, 0 }, sch_coverart, sch_comiccoverart },
    {   { 2, 0 }, { 0, 0 }, sch_createaction, sch_cookaction },
    {   { 2, 0 }, { 0, 0 }, sch_createaction, sch_drawaction },
    {   { 2, 0 }, { 0, 0 }, sch_createaction, sch_filmaction },
    {   { 2, 0 }, { 0, 0 }, sch_createaction, sch_paintaction },
    {   { 2, 0 }, { 0, 0 }, sch_createaction, sch_photographaction },
    {   { 2, 0 }, { 0, 0 }, sch_createaction, sch_writeaction },
    {   { 3, 5 }, { 7, 2 }, sch_creativework, sch_3dmodel },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_archivecomponent },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_article },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_atlas },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_blog },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_book },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_chapter },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_claim },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_clip },
    {   { 2, 0 }, { 2, 1 }, sch_creativework, sch_code },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_collection },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_comicstory },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_comment },
    {   { 3, 0 }, { 0, 0 }, sch_creativework, sch_conversation },
    {   { 3, 2 }, { 0, 0 }, sch_creativework, sch_course },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_creativeworkseason },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_creativeworkseries },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_datacatalogue },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_dataset },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_definedtermset },
    {   { 2, 0 }, { 2, 1 }, sch_creativework, sch_diet },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_diet },
    {   { 3, 0 }, { 0, 0 }, sch_creativework, sch_digitaldocument },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_drawing },
    {   { 2, 0 }, { 2, 1 }, sch_creativework, sch_emailmessage },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_educationaloccupationalcredential },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_episode },
    {   { 2, 0 }, { 2, 1 }, sch_creativework, sch_exerciseplan },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_exerciseplan },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_game },
    {   { 6, 0 }, { 0, 0 }, sch_creativework, sch_guide },
    {   { 3, 3 }, { 0, 0 }, sch_creativework, sch_howto },
    {   { 3, 4 }, { 0, 0 }, sch_creativework, sch_howtodirection },
    {   { 3, 4 }, { 0, 0 }, sch_creativework, sch_howtosection },
    {   { 3, 4 }, { 0, 0 }, sch_creativework, sch_howtostep },
    {   { 3, 4 }, { 0, 0 }, sch_creativework, sch_howtotip },
    {   { 9, 0 }, { 0, 0 }, sch_creativework, sch_learningresource },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_legislation },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_manuscript },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_map },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_mediaobject },
    {   { 3, 2 }, { 0, 0 }, sch_creativework, sch_menu },
    {   { 3, 2 }, { 0, 0 }, sch_creativework, sch_menusection },
    {   { 3, 0 }, { 0, 0 }, sch_creativework, sch_message },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_movie },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_musiccomposition },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_musicplaylist },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_musicrecording },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_painting },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_photograph },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_play },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_poster },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_publicationissue },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_publicationvolume },
    {   { 2, 0 }, { 9, 0 }, sch_creativework, sch_question },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_quotation },
    {   { 2, 0 }, { 3, 2 }, sch_creativework, sch_recipe },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_review },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_sculpture },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_sheetmusic },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_shortstory },
    {   { 2, 0 }, { 2, 1 }, sch_creativework, sch_season },
    {   { 2, 0 }, { 3, 3 }, sch_creativework, sch_series },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_softwareapplication },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_softwaresourcecode },
    {   { 7, 0 }, { 0, 0 }, sch_creativework, sch_specialannouncement },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_tvseries },
    {   { 3, 5 }, { 0, 0 }, sch_creativework, sch_thesis },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_visualartwork },
    {   { 5, 0 }, { 0, 0 }, sch_creativework, sch_webcontent },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_webpage },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_webpageelement },
    {   { 2, 0 }, { 0, 0 }, sch_creativework, sch_website },
    {   { 4, 0 }, { 0, 0 }, sch_creativeworkseason, sch_podcastseason },
    {   { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sch_radioseason },
    {   { 2, 0 }, { 0, 0 }, sch_creativeworkseason, sch_tvseason },
    {   { 2, 0 }, { 0, 0 }, sch_creativeworkseries, sch_bookseries },
    {   { 2, 0 }, { 0, 0 }, sch_creativeworkseries, sch_movieseries },
    {   { 2, 0 }, { 0, 0 }, sch_creativeworkseries, sch_periodical },
    {   { 4, 0 }, { 0, 0 }, sch_creativeworkseries, sch_podcastseries },
    {   { 2, 0 }, { 0, 0 }, sch_creativeworkseries, sch_radioseries },
    {   { 2, 0 }, { 0, 0 }, sch_creativeworkseries, sch_tvseries },
    {   { 2, 0 }, { 0, 0 }, sch_creativeworkseries, sch_videogameseries },
    {   { 3, 5 }, { 0, 0 }, sch_criticreview, sch_reviewnewsarticle },
    {   { 3, 5 }, { 0, 0 }, sch_datafeed, sch_completedatafeed },
    {   { 2, 2 }, { 0, 0 }, sch_dataset, sch_datafeed },
    {   { 2, 0 }, { 0, 0 }, sch_datatype, sch_boolean },
    {   { 2, 0 }, { 0, 0 }, sch_datatype, sch_date },
    {   { 2, 0 }, { 0, 0 }, sch_datatype, sch_datetime },
    {   { 2, 0 }, { 0, 0 }, sch_datatype, sch_number },
    {   { 2, 0 }, { 0, 0 }, sch_datatype, sch_text },
    {   { 2, 0 }, { 0, 0 }, sch_datatype, sch_time },
    {   { 3, 5 }, { 0, 0 }, sch_dayofweek, sch_friday },
    {   { 3, 5 }, { 0, 0 }, sch_dayofweek, sch_monday },
    {   { 3, 5 }, { 0, 0 }, sch_dayofweek, sch_publicholidays },
    {   { 3, 5 }, { 0, 0 }, sch_dayofweek, sch_saturday },
    {   { 3, 5 }, { 0, 0 }, sch_dayofweek, sch_sunday },
    {   { 3, 5 }, { 0, 0 }, sch_dayofweek, sch_thursday },
    {   { 3, 5 }, { 0, 0 }, sch_dayofweek, sch_tuesday },
    {   { 3, 5 }, { 0, 0 }, sch_dayofweek, sch_wednesday },
    {   { 3, 5 }, { 0, 0 }, sch_definedterm, sch_categorycode },
    {   { 3, 5 }, { 0, 0 }, sch_definedtermset, sch_categorycodeset },
    {   { 2, 0 }, { 0, 0 }, sch_deliverymethod, sch_lockerdelivery },
    {   { 3, 5 }, { 0, 0 }, sch_deliverymethod, sch_onsitepickup },
    {   { 2, 0 }, { 0, 0 }, sch_deliverymethod, sch_parcelservice },
    {   { 3, 0 }, { 0, 0 }, sch_digitaldocument, sch_notedigitaldocument },
    {   { 3, 0 }, { 0, 0 }, sch_digitaldocument, sch_presentationdigitaldocument },
    {   { 3, 0 }, { 0, 0 }, sch_digitaldocument, sch_spreadsheetdigitaldocument },
    {   { 3, 0 }, { 0, 0 }, sch_digitaldocument, sch_textdigitaldocument },
    {   { 3, 5 }, { 0, 0 }, sch_digitaldocumentpermissiontype, sch_commentpermission },
    {   { 3, 5 }, { 0, 0 }, sch_digitaldocumentpermissiontype, sch_readpermission },
    {   { 3, 5 }, { 0, 0 }, sch_digitaldocumentpermissiontype, sch_writepermission },
    {   { 3, 6 }, { 5, 0 }, sch_drivewheelconfigurationvalue, sch_allwheeldriveconfiguration },
    {   { 3, 6 }, { 5, 0 }, sch_drivewheelconfigurationvalue, sch_fourwheeldriveconfiguration },
    {   { 3, 6 }, { 5, 0 }, sch_drivewheelconfigurationvalue, sch_frontwheeldriveconfiguration },
    {   { 3, 6 }, { 5, 0 }, sch_drivewheelconfigurationvalue, sch_rearwheeldriveconfiguration },
    {   { 9, 0 }, { 0, 0 }, sch_drivewheelconfigurationvalue, sch_allwheeldriveconfiguration },
    {   { 9, 0 }, { 0, 0 }, sch_drivewheelconfigurationvalue, sch_fourwheeldriveconfiguration },
    {   { 9, 0 }, { 0, 0 }, sch_drivewheelconfigurationvalue, sch_frontwheeldriveconfiguration },
    {   { 9, 0 }, { 0, 0 }, sch_drivewheelconfigurationvalue, sch_rearwheeldriveconfiguration },
    {   { 3, 6 }, { 5, 0 }, sch_drugcostcategory, sch_reimbursementcap },
    {   { 3, 6 }, { 5, 0 }, sch_drugcostcategory, sch_retail },
    {   { 3, 6 }, { 5, 0 }, sch_drugcostcategory, sch_wholesale },
    {   { 9, 0 }, { 0, 0 }, sch_drugcostcategory, sch_reimbursementcap },
    {   { 9, 0 }, { 0, 0 }, sch_drugcostcategory, sch_retail },
    {   { 9, 0 }, { 0, 0 }, sch_drugcostcategory, sch_wholesale },
    {   { 3, 6 }, { 5, 0 }, sch_drugpregnancycategory, sch_fdacategorya },
    {   { 3, 6 }, { 5, 0 }, sch_drugpregnancycategory, sch_fdacategoryb },
    {   { 3, 6 }, { 5, 0 }, sch_drugpregnancycategory, sch_fdacategoryc },
    {   { 3, 6 }, { 5, 0 }, sch_drugpregnancycategory, sch_fdacategoryd },
    {   { 3, 6 }, { 5, 0 }, sch_drugpregnancycategory, sch_fdacategoryx },
    {   { 3, 6 }, { 5, 0 }, sch_drugpregnancycategory, sch_fdanotevaluated },
    {   { 9, 0 }, { 0, 0 }, sch_drugpregnancycategory, sch_fdacategorya },
    {   { 9, 0 }, { 0, 0 }, sch_drugpregnancycategory, sch_fdacategoryb },
    {   { 9, 0 }, { 0, 0 }, sch_drugpregnancycategory, sch_fdacategoryc },
    {   { 9, 0 }, { 0, 0 }, sch_drugpregnancycategory, sch_fdacategoryd },
    {   { 9, 0 }, { 0, 0 }, sch_drugpregnancycategory, sch_fdacategoryx },
    {   { 9, 0 }, { 0, 0 }, sch_drugpregnancycategory, sch_fdanotevaluated },
    {   { 3, 6 }, { 5, 0 }, sch_drugprescriptionstatus, sch_otc },
    {   { 3, 6 }, { 5, 0 }, sch_drugprescriptionstatus, sch_prescriptiononly },
    {   { 9, 0 }, { 0, 0 }, sch_drugprescriptionstatus, sch_otc },
    {   { 9, 0 }, { 0, 0 }, sch_drugprescriptionstatus, sch_prescriptiononly },
    {   { 3, 9 }, { 0, 0 }, sch_educationaloccupationalprogramme, sch_workbasedprogramme },
    {   { 2, 0 }, { 0, 0 }, sch_educationalorganisation, sch_collegeoruniversity },
    {   { 2, 0 }, { 0, 0 }, sch_educationalorganisation, sch_elementaryschool },
    {   { 2, 0 }, { 0, 0 }, sch_educationalorganisation, sch_highschool },
    {   { 2, 0 }, { 0, 0 }, sch_educationalorganisation, sch_middleschool },
    {   { 2, 0 }, { 0, 0 }, sch_educationalorganisation, sch_preschool },
    {   { 2, 0 }, { 0, 0 }, sch_educationalorganisation, sch_school },
    {   { 2, 0 }, { 0, 0 }, sch_emergencyservice, sch_firestation },
    {   { 2, 0 }, { 0, 0 }, sch_emergencyservice, sch_hospital },
    {   { 2, 0 }, { 0, 0 }, sch_emergencyservice, sch_policestation },
    {   { 10, 0 }, { 0, 0 }, sch_energyefficiencyenumeration, sch_energystarcertified },
    {   { 10, 0 }, { 0, 0 }, sch_energyefficiencyenumeration, sch_euenergyefficiencyenumeration },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategorya },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategorya1plus },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategorya2plus },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategorya3plus },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategoryb },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategoryc },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategoryd },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategorye },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategoryf },
    {   { 10, 0 }, { 0, 0 }, sch_euenergyefficiencyenumeration, sch_euenergyefficiencycategoryg },
    {   { 2, 0 }, { 0, 0 }, sch_entertainmentbusiness, sch_adultentertainment },
    {   { 2, 0 }, { 0, 0 }, sch_entertainmentbusiness, sch_amusementpark },
    {   { 2, 0 }, { 0, 0 }, sch_entertainmentbusiness, sch_artgallery },
    {   { 2, 0 }, { 0, 0 }, sch_entertainmentbusiness, sch_casino },
    {   { 2, 0 }, { 0, 0 }, sch_entertainmentbusiness, sch_comedyclub },
    {   { 2, 0 }, { 0, 0 }, sch_entertainmentbusiness, sch_movietheatre },
    {   { 2, 0 }, { 0, 0 }, sch_entertainmentbusiness, sch_nightclub },
    {   { 2, 0 }, { 8, 0 }, sch_enumeration, sch_actionstatustype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_boardingpolicytype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_bookformattype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_businessentitytype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_businessfunction },
    {   { 9, 0 }, { 0, 0 }, sch_enumeration, sch_carusagetype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_contactpointoption },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_dayofweek },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_deliverymethod },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_drugcostcategory },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_drugpregnancycategory },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_drugprescriptionstatus },
    {   { 3, 0 }, { 0, 0 }, sch_enumeration, sch_digitaldocumentpermissiontype },
    {   { 10, 0 }, { 0, 0 }, sch_enumeration, sch_energyefficiencyenumeration },
    {   { 7, 0 }, { 0, 0 }, sch_enumeration, sch_eventattendancemodeenumeration },
    {   { 2, 0 }, { 8, 0 }, sch_enumeration, sch_eventstatustype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_gameplaymode },
    {   { 2, 0 }, { 8, 0 }, sch_enumeration, sch_gameserverstatus },
    {   { 3, 0 }, { 0, 0 }, sch_enumeration, sch_gendertype },
    {   { 9, 0 }, { 0, 0 }, sch_enumeration, sch_governmentbenefitstype },
    {   { 5, 0 }, { 0, 0 }, sch_enumeration, sch_healthaspectenumeration },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_infectiousagentclass },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_itemavailability },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_itemlistordertype },
    {   { 3, 5 }, { 8, 0 }, sch_enumeration, sch_legalforcestatus },
    {   { 3, 5 }, { 0, 0 }, sch_enumeration, sch_legalvaluelevel },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_mapcategorytype },
    {   { 7, 0 }, { 0, 0 }, sch_enumeration, sch_mediamanipulationratingenumeration },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicalaudience },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicaldevicepurpose },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicalenumeration },
    {   { 3, 5 }, { 0, 0 }, sch_enumeration, sch_medicalenumeration },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicalevidencelevel },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicalobservationalstudydesign },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicalproceduretype },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicalspeciality },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicalstudystatus },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicaltrialdesign },
    {   { 3, 5 }, { 0, 0 }, sch_enumeration, sch_medicaltrialdesign },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_medicinesystem },
    {   { 6, 0 }, { 0, 0 }, sch_enumeration, sch_merchantreturnenumeration },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_musicalbumproductiontype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_musicalbumreleasetype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_musicreleaseformattype },
    {   { 8, 0 }, { 0, 0 }, sch_enumeration, sch_nonprofittype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_offeritemcondition },
    {   { 2, 0 }, { 8, 0 }, sch_enumeration, sch_orderstatus },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_paymentmethod },
    {   { 2, 1 }, { 8, 0 }, sch_enumeration, sch_paymentstatustype },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_physicalactivitycategory },
    {   { 3, 5 }, { 0, 0 }, sch_enumeration, sch_physicalactivitycategory },
    {   { 2, 0 }, { 2, 1 }, sch_enumeration, sch_physicalexam },
    {   { 3, 8 }, { 5, 0 }, sch_enumeration, sch_productreturnenumeration },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_qualitativevalue },
    {   { 3, 8 }, { 0, 0 }, sch_enumeration, sch_refundtypeenumeration },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_reservationstatustype },
    {   { 3, 0 }, { 0, 0 }, sch_enumeration, sch_restricteddiet },
    {   { 3, 8 }, { 0, 0 }, sch_enumeration, sch_returnfeesenumeration },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_rsvpresponsetype },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_speciality },
    {   { 9, 0 }, { 0, 0 }, sch_enumeration, sch_statusenumeration },
    {   { 2, 0 }, { 0, 0 }, sch_enumeration, sch_warrantyscope },
    {   { 4, 0 }, { 0, 0 }, sch_episode, sch_podcastepisode },
    {   { 2, 0 }, { 0, 0 }, sch_episode, sch_radioepisode },
    {   { 2, 0 }, { 0, 0 }, sch_episode, sch_tvepisode },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_businessevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_childrensevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_comedyevent },
    {   { 3, 1 }, { 0, 0 }, sch_event, sch_courseinstance },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_danceevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_deliveryevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_educationevent },
    {   { 3, 5 }, { 0, 0 }, sch_event, sch_eventseries },
    {   { 2, 2 }, { 0, 0 }, sch_event, sch_exhibitionevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_festival },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_foodevent },
    {   { 8, 0 }, { 0, 0 }, sch_event, sch_hackathon },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_literaryevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_musicevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_publicationevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_saleevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_screeningevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_socialevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_sportsevent },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_theatreevent },
    {   { 2, 0 }, { 2, 1 }, sch_event, sch_userinteraction },
    {   { 2, 0 }, { 0, 0 }, sch_event, sch_visualartsevent },
    {   { 7, 0 }, { 0, 0 }, sch_eventattendancemodeenumeration, sch_mixedeventattendancemode },
    {   { 7, 0 }, { 0, 0 }, sch_eventattendancemodeenumeration, sch_offlineeventattendancemode },
    {   { 7, 0 }, { 0, 0 }, sch_eventattendancemodeenumeration, sch_onlineeventattendancemode },
    {   { 3, 5 }, { 0, 0 }, sch_eventstatustype, sch_eventcancelled },
    {   { 7, 0 }, { 0, 0 }, sch_eventstatustype, sch_eventmovedonline },
    {   { 3, 5 }, { 0, 0 }, sch_eventstatustype, sch_eventpostponed },
    {   { 3, 5 }, { 0, 0 }, sch_eventstatustype, sch_eventrescheduled },
    {   { 3, 5 }, { 0, 0 }, sch_eventstatustype, sch_eventscheduled },
    {   { 3, 0 }, { 0, 0 }, sch_financialproduct, sch_bankaccount },
    {   { 3, 1 }, { 0, 0 }, sch_financialproduct, sch_currencyconversionservice },
    {   { 3, 1 }, { 0, 0 }, sch_financialproduct, sch_investmentordeposit },
    {   { 3, 0 }, { 0, 0 }, sch_financialproduct, sch_loanorcredit },
    {   { 3, 0 }, { 0, 0 }, sch_financialproduct, sch_paymentcard },
    {   { 3, 1 }, { 0, 0 }, sch_financialproduct, sch_paymentservice },
    {   { 2, 0 }, { 0, 0 }, sch_financialservice, sch_accountingservice },
    {   { 2, 0 }, { 0, 0 }, sch_financialservice, sch_automatedteller },
    {   { 2, 0 }, { 0, 0 }, sch_financialservice, sch_bankorcreditunion },
    {   { 2, 0 }, { 0, 0 }, sch_financialservice, sch_insuranceagency },
    {   { 2, 0 }, { 0, 0 }, sch_findaction, sch_checkaction },
    {   { 2, 0 }, { 0, 0 }, sch_findaction, sch_discoveraction },
    {   { 2, 0 }, { 0, 0 }, sch_findaction, sch_trackaction },
    {   { 2, 0 }, { 0, 0 }, sch_foodestablishment, sch_bakery },
    {   { 2, 0 }, { 0, 0 }, sch_foodestablishment, sch_barorpub },
    {   { 2, 0 }, { 0, 0 }, sch_foodestablishment, sch_brewery },
    {   { 2, 0 }, { 0, 0 }, sch_foodestablishment, sch_cafeorcoffeeshop },
    {   { 2, 0 }, { 0, 0 }, sch_foodestablishment, sch_fastfoodrestaurant },
    {   { 2, 0 }, { 0, 0 }, sch_foodestablishment, sch_icecreamshop },
    {   { 2, 0 }, { 0, 0 }, sch_foodestablishment, sch_restaurant },
    {   { 2, 0 }, { 0, 0 }, sch_foodestablishment, sch_winery },
    {   { 2, 0 }, { 0, 0 }, sch_game, sch_videogame },
    {   { 3, 5 }, { 0, 0 }, sch_gameplaymode, sch_coop },
    {   { 3, 5 }, { 0, 0 }, sch_gameplaymode, sch_multiplayer },
    {   { 3, 5 }, { 0, 0 }, sch_gameplaymode, sch_singleplayer },
    {   { 3, 5 }, { 0, 0 }, sch_gameserverstatus, sch_offlinepermanently },
    {   { 3, 5 }, { 0, 0 }, sch_gameserverstatus, sch_offlinetemporarily },
    {   { 3, 5 }, { 0, 0 }, sch_gameserverstatus, sch_online },
    {   { 3, 5 }, { 0, 0 }, sch_gameserverstatus, sch_onlinefull },
    {   { 3, 5 }, { 0, 0 }, sch_gendertype, sch_female },
    {   { 3, 5 }, { 0, 0 }, sch_gendertype, sch_male },
    {   { 2, 2 }, { 0, 0 }, sch_geoshape, sch_geocircle },
    {   { 9, 0 }, { 0, 0 }, sch_governmentbenefitstype, sch_basicincome },
    {   { 9, 0 }, { 0, 0 }, sch_governmentbenefitstype, sch_businesssupport },
    {   { 9, 0 }, { 0, 0 }, sch_governmentbenefitstype, sch_disabilitysupport },
    {   { 9, 0 }, { 0, 0 }, sch_governmentbenefitstype, sch_healthcare },
    {   { 9, 0 }, { 0, 0 }, sch_governmentbenefitstype, sch_onetimepayments },
    {   { 9, 0 }, { 0, 0 }, sch_governmentbenefitstype, sch_paidleave },
    {   { 9, 0 }, { 0, 0 }, sch_governmentbenefitstype, sch_parentalsupport },
    {   { 9, 0 }, { 0, 0 }, sch_governmentbenefitstype, sch_unemploymentsupport },
    {   { 2, 0 }, { 0, 0 }, sch_governmentbuilding, sch_cityhall },
    {   { 2, 0 }, { 0, 0 }, sch_governmentbuilding, sch_courthouse },
    {   { 2, 0 }, { 0, 0 }, sch_governmentbuilding, sch_defenceestablishment },
    {   { 2, 0 }, { 0, 0 }, sch_governmentbuilding, sch_embassy },
    {   { 2, 0 }, { 0, 0 }, sch_governmentbuilding, sch_legislativebuilding },
    {   { 3, 5 }, { 0, 0 }, sch_grant, sch_monetarygrant },
    {   { 2, 0 }, { 0, 0 }, sch_healthandbeautybusiness, sch_beautysalon },
    {   { 2, 0 }, { 0, 0 }, sch_healthandbeautybusiness, sch_dayspa },
    {   { 2, 0 }, { 0, 0 }, sch_healthandbeautybusiness, sch_hairsalon },
    {   { 2, 0 }, { 0, 0 }, sch_healthandbeautybusiness, sch_healthclub },
    {   { 2, 0 }, { 0, 0 }, sch_healthandbeautybusiness, sch_nailsalon },
    {   { 2, 0 }, { 0, 0 }, sch_healthandbeautybusiness, sch_tattooparlour },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_benefitshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_causeshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_contagiousnesshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_howorwherehealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_livingwithhealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_maytreathealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_misconceptionshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_overviewhealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_patientexperiencehealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_preventionhealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_prognosishealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_relatedtopicshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_risksorcomplicationshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_screeninghealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_seedoctorhealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_selfcarehealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_sideeffectshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_stageshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_symptomshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_treatmentshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_typeshealthaspect },
    {   { 5, 0 }, { 0, 0 }, sch_healthaspectenumeration, sch_usageorschedulehealthaspect },
    {   { 2, 0 }, { 0, 0 }, sch_homeandconstructionbusiness, sch_electrician },
    {   { 2, 0 }, { 0, 0 }, sch_homeandconstructionbusiness, sch_generalcontractor },
    {   { 2, 0 }, { 0, 0 }, sch_homeandconstructionbusiness, sch_hvacbusiness },
    {   { 2, 0 }, { 0, 0 }, sch_homeandconstructionbusiness, sch_housepainter },
    {   { 2, 0 }, { 0, 0 }, sch_homeandconstructionbusiness, sch_locksmith },
    {   { 2, 0 }, { 0, 0 }, sch_homeandconstructionbusiness, sch_movingcompany },
    {   { 2, 0 }, { 0, 0 }, sch_homeandconstructionbusiness, sch_plumber },
    {   { 2, 0 }, { 0, 0 }, sch_homeandconstructionbusiness, sch_roofingcontractor },
    {   { 3, 3 }, { 0, 0 }, sch_howto, sch_recipe },
    {   { 3, 3 }, { 0, 0 }, sch_howtoitem, sch_howtosupply },
    {   { 3, 3 }, { 0, 0 }, sch_howtoitem, sch_howtotool },
    {   { 3, 1 }, { 0, 0 }, sch_house, sch_singlefamilyresidence },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_postoffice },
    {   { 2, 2 }, { 0, 0 }, sch_imageobject, sch_barcode },
    {   { 3, 6 }, { 5, 0 }, sch_infectiousagentclass, sch_bacteria },
    {   { 3, 6 }, { 5, 0 }, sch_infectiousagentclass, sch_fungus },
    {   { 3, 6 }, { 5, 0 }, sch_infectiousagentclass, sch_multicellularparasite },
    {   { 3, 6 }, { 5, 0 }, sch_infectiousagentclass, sch_prion },
    {   { 3, 6 }, { 5, 0 }, sch_infectiousagentclass, sch_protozoa },
    {   { 3, 6 }, { 5, 0 }, sch_infectiousagentclass, sch_virus },
    {   { 9, 0 }, { 0, 0 }, sch_infectiousagentclass, sch_bacteria },
    {   { 9, 0 }, { 0, 0 }, sch_infectiousagentclass, sch_fungus },
    {   { 9, 0 }, { 0, 0 }, sch_infectiousagentclass, sch_multicellularparasite },
    {   { 9, 0 }, { 0, 0 }, sch_infectiousagentclass, sch_prion },
    {   { 9, 0 }, { 0, 0 }, sch_infectiousagentclass, sch_protozoa },
    {   { 9, 0 }, { 0, 0 }, sch_infectiousagentclass, sch_virus },
    {   { 2, 0 }, { 0, 0 }, sch_informaction, sch_confirmaction },
    {   { 2, 0 }, { 0, 0 }, sch_informaction, sch_rsvpaction },
    {   { 2, 0 }, { 0, 0 }, sch_insertaction, sch_appendaction },
    {   { 2, 0 }, { 0, 0 }, sch_insertaction, sch_prependaction },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_actionaccessspecification },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_alignmentobject },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_audience },
    {   { 3, 1 }, { 0, 0 }, sch_intangible, sch_beddetails },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_brand },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_broadcastchannel },
    {   { 2, 0 }, { 3, 4 }, sch_intangible, sch_bustrip },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_broadcastfrequencyspecification },
    {   { 2, 0 }, { 2, 1 }, sch_intangible, sch_class },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_class },
    {   { 3, 0 }, { 0, 0 }, sch_intangible, sch_computerlanguage },
    {   { 2, 2 }, { 0, 0 }, sch_intangible, sch_datafeeditem },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_definedterm },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_demand },
    {   { 3, 0 }, { 0, 0 }, sch_intangible, sch_digitaldocumentpermission },
    {   { 10, 0 }, { 0, 0 }, sch_intangible, sch_energyconsumptiondetails },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_entrypoint },
    {   { 3, 9 }, { 0, 0 }, sch_intangible, sch_educationaloccupationalprogramme },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_enumeration },
    {   { 2, 0 }, { 3, 3 }, sch_intangible, sch_flight },
    {   { 6, 0 }, { 0, 0 }, sch_intangible, sch_floorplan },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_gameserver },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_geospatialgeometry },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_grant },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_dystopianhealthinsuranceplan },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_dystopianhealthplancostsharingspecification },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_dystopianhealthplanformulary },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_dystopianhealthplannetwork },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_invoice },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_itemlist },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_jobposting },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_language },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_listitem },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_mediasubscription },
    {   { 3, 2 }, { 0, 0 }, sch_intangible, sch_menuitem },
    {   { 6, 0 }, { 0, 0 }, sch_intangible, sch_merchantreturnpolicy },
    {   { 3, 9 }, { 0, 0 }, sch_intangible, sch_observation },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_occupation },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_offer },
    {   { 7, 2 }, { 7, 3 }, sch_intangible, sch_offershippingdetails },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_order },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_orderitem },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_parceldelivery },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_permit },
    {   { 3, 8 }, { 5, 0 }, sch_intangible, sch_productreturnpolicy },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_programmemembership },
    {   { 2, 0 }, { 2, 1 }, sch_intangible, sch_property },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_property },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_propertyvaluespecification },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_quantity },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_rating },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_reservation },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_role },
    {   { 3, 6 }, { 0, 0 }, sch_intangible, sch_schedule },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_seat },
    {   { 3, 4 }, { 0, 0 }, sch_intangible, sch_series },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_service },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_servicechannel },
    {   { 3, 5 }, { 0, 0 }, sch_intangible, sch_speakablespecification },
    {   { 3, 9 }, { 0, 0 }, sch_intangible, sch_statisticalpopulation },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_structuredvalue },
    {   { 2, 0 }, { 0, 0 }, sch_intangible, sch_ticket },
    {   { 2, 0 }, { 3, 3 }, sch_intangible, sch_traintrip },
    {   { 3, 4 }, { 0, 0 }, sch_intangible, sch_trip },
    {   { 3, 7 }, { 0, 0 }, sch_intangible, sch_virtuallocation },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_befriendaction },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_communicateaction },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_followaction },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_joinaction },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_leaveaction },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_marryaction },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_registeraction },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_subscribeaction },
    {   { 2, 0 }, { 0, 0 }, sch_interactaction, sch_unregisteraction },
    {   { 3, 5 }, { 0, 0 }, sch_investmentordeposit, sch_brokerageaccount },
    {   { 3, 1 }, { 0, 0 }, sch_investmentordeposit, sch_depositaccount },
    {   { 3, 5 }, { 0, 0 }, sch_investmentordeposit, sch_investmentfund },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_discontinued },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_instock },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_instoreonly },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_limitedavailability },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_onlineonly },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_outofstock },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_preorder },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_presale },
    {   { 3, 5 }, { 0, 0 }, sch_itemavailability, sch_soldout },
    {   { 2, 0 }, { 0, 0 }, sch_itemlist, sch_breadcrumblist },
    {   { 3, 3 }, { 0, 0 }, sch_itemlist, sch_howtosection },
    {   { 3, 3 }, { 0, 0 }, sch_itemlist, sch_howtostep },
    {   { 2, 2 }, { 0, 0 }, sch_itemlist, sch_offercatalogue },
    {   { 3, 5 }, { 0, 0 }, sch_itemlistordertype, sch_itemlistorderascending },
    {   { 3, 5 }, { 0, 0 }, sch_itemlistordertype, sch_itemlistorderdescending },
    {   { 3, 5 }, { 0, 0 }, sch_itemlistordertype, sch_itemlistunordered },
    {   { 2, 0 }, { 0, 0 }, sch_landform, sch_bodyofwater },
    {   { 2, 0 }, { 0, 0 }, sch_landform, sch_continent },
    {   { 2, 0 }, { 0, 0 }, sch_landform, sch_mountain },
    {   { 2, 0 }, { 0, 0 }, sch_landform, sch_volcano },
    {   { 9, 0 }, { 0, 0 }, sch_learningresource, sch_course },
    {   { 9, 0 }, { 0, 0 }, sch_learningresource, sch_quiz },
    {   { 3, 5 }, { 0, 0 }, sch_legalforcestatus, sch_inforce },
    {   { 3, 5 }, { 0, 0 }, sch_legalforcestatus, sch_notinforce },
    {   { 3, 5 }, { 0, 0 }, sch_legalforcestatus, sch_partiallyinforce },
    {   { 2, 2 }, { 0, 0 }, sch_localbusiness, sch_attorney },
    {   { 3, 0 }, { 0, 0 }, sch_localbusiness, sch_notary },
    {   { 3, 5 }, { 0, 0 }, sch_legalvaluelevel, sch_authoritativelegalvalue },
    {   { 3, 5 }, { 0, 0 }, sch_legalvaluelevel, sch_definitivelegalvalue },
    {   { 3, 5 }, { 0, 0 }, sch_legalvaluelevel, sch_officiallegalvalue },
    {   { 3, 5 }, { 0, 0 }, sch_legalvaluelevel, sch_unofficiallegalvalue },
    {   { 3, 5 }, { 0, 0 }, sch_legislation, sch_legislationobject },
    {   { 2, 0 }, { 0, 0 }, sch_lifestylemodification, sch_diet },
    {   { 2, 0 }, { 0, 0 }, sch_lifestylemodification, sch_physicalactivity },
    {   { 3, 3 }, { 0, 0 }, sch_listitem, sch_howtodirection },
    {   { 3, 3 }, { 0, 0 }, sch_listitem, sch_howtoitem },
    {   { 3, 4 }, { 0, 0 }, sch_listitem, sch_howtosection },
    {   { 3, 4 }, { 0, 0 }, sch_listitem, sch_howtostep },
    {   { 3, 3 }, { 0, 0 }, sch_listitem, sch_howtotip },
    {   { 3, 0 }, { 0, 0 }, sch_loanorcredit, sch_creditcard },
    {   { 3, 5 }, { 0, 0 }, sch_loanorcredit, sch_mortgageloan },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_animalshelter },
    {   { 3, 5 }, { 0, 0 }, sch_localbusiness, sch_archiveorganisation },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_automotivebusiness },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_childcare },
    {   { 3, 1 }, { 0, 0 }, sch_localbusiness, sch_dentist },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_drycleaningorlaundry },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_emergencyservice },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_employmentagency },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_entertainmentbusiness },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_financialservice },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_foodestablishment },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_governmentoffice },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_healthandbeautybusiness },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_homeandconstructionbusiness },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_internetcafe },
    {   { 2, 2 }, { 0, 0 }, sch_localbusiness, sch_legalservice },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_library },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_lodgingbusiness },
    {   { 2, 0 }, { 2, 1 }, sch_localbusiness, sch_medicalorganisation },
    {   { 3, 0 }, { 3, 1 }, sch_localbusiness, sch_medicalbusiness },
    {   { 3, 5 }, { 0, 0 }, sch_localbusiness, sch_medicalbusiness },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_professionalservice },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_radiostation },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_realestateagent },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_recyclingcentre },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_selfstorage },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_shoppingcentre },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_sportsactivitylocation },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_store },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_televisionstation },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_touristinformationcentre },
    {   { 2, 0 }, { 0, 0 }, sch_localbusiness, sch_wholesalestore },
    {   { 2, 0 }, { 0, 0 }, sch_lodgingbusiness, sch_bedandbreakfast },
    {   { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sch_campground },
    {   { 2, 0 }, { 0, 0 }, sch_lodgingbusiness, sch_hostel },
    {   { 2, 0 }, { 0, 0 }, sch_lodgingbusiness, sch_hotel },
    {   { 2, 0 }, { 0, 0 }, sch_lodgingbusiness, sch_motel },
    {   { 3, 1 }, { 0, 0 }, sch_lodgingbusiness, sch_resort },
    {   { 3, 5 }, { 0, 0 }, sch_mapcategorytype, sch_parkingmap },
    {   { 3, 5 }, { 0, 0 }, sch_mapcategorytype, sch_seatingmap },
    {   { 3, 5 }, { 0, 0 }, sch_mapcategorytype, sch_transitmap },
    {   { 3, 5 }, { 0, 0 }, sch_mapcategorytype, sch_venuemap },
    {   { 6, 0 }, { 0, 0 }, sch_mediagallery, sch_imagegallery },
    {   { 6, 0 }, { 0, 0 }, sch_mediagallery, sch_videogallery },
    {   { 7, 0 }, { 0, 0 }, sch_mediamanipulationratingenumeration, sch_authenticcontent },
    {   { 7, 0 }, { 0, 0 }, sch_mediamanipulationratingenumeration, sch_missingcontext },
    {   { 7, 3 }, { 0, 0 }, sch_mediaobject, sch_3dmodel },
    {   { 2, 0 }, { 0, 0 }, sch_mediaobject, sch_audioobject },
    {   { 2, 0 }, { 0, 0 }, sch_mediaobject, sch_datadownload },
    {   { 2, 0 }, { 0, 0 }, sch_mediaobject, sch_imageobject },
    {   { 3, 5 }, { 0, 0 }, sch_mediaobject, sch_legislationobject },
    {   { 2, 0 }, { 0, 0 }, sch_mediaobject, sch_musicvideoobject },
    {   { 2, 0 }, { 0, 0 }, sch_mediaobject, sch_videoobject },
    {   { 3, 6 }, { 5, 0 }, sch_medicalaudience, sch_clinician },
    {   { 3, 6 }, { 5, 0 }, sch_medicalaudience, sch_medicalresearcher },
    {   { 3, 5 }, { 5, 0 }, sch_medicalaudience, sch_patient },
    {   { 9, 0 }, { 0, 0 }, sch_medicalaudiencetype, sch_clinician },
    {   { 9, 0 }, { 0, 0 }, sch_medicalaudiencetype, sch_medicalresearcher },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_communityhealth },
    {   { 3, 0 }, { 0, 0 }, sch_medicalbusiness, sch_dentist },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_dermatology },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_dietnutrition },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_emergency },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_geriatric },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_gynaecologic },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_medicalclinic },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_midwifery },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_nursing },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_obstetric },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_oncologic },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_optician },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_optometric },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_otolaryngologic },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_paediatric },
    {   { 3, 0 }, { 0, 0 }, sch_medicalbusiness, sch_pharmacy },
    {   { 3, 0 }, { 0, 0 }, sch_medicalbusiness, sch_physician },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_physiotherapy },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_plasticsurgery },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_podiatric },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_primarycare },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_psychiatric },
    {   { 3, 5 }, { 0, 0 }, sch_medicalbusiness, sch_publichealth },
    {   { 7, 0 }, { 0, 0 }, sch_medicalclinic, sch_covidtestingfacility },
    {   { 2, 0 }, { 0, 0 }, sch_medicalcondition, sch_infectiousdisease },
    {   { 3, 5 }, { 0, 0 }, sch_medicalcondition, sch_medicalsignorsymptom },
    {   { 3, 6 }, { 5, 0 }, sch_medicaldevicepurpose, sch_diagnostic },
    {   { 3, 6 }, { 5, 0 }, sch_medicaldevicepurpose, sch_therapeutic },
    {   { 9, 0 }, { 0, 0 }, sch_medicaldevicepurpose, sch_diagnostic },
    {   { 9, 0 }, { 0, 0 }, sch_medicaldevicepurpose, sch_therapeutic },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_anatomicalstructure },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_anatomicalsystem },
    {   { 9, 0 }, { 0, 0 }, sch_medicalentity, sch_drugclass },
    {   { 9, 0 }, { 0, 0 }, sch_medicalentity, sch_drugcost },
    {   { 3, 5 }, { 0, 0 }, sch_medicalentity, sch_lifestylemodification },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalcause },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalcondition },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalcontraindication },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicaldevice },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalguideline },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalindication },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalintangible },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalprocedure },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalriskestimator },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalriskfactor },
    {   { 2, 0 }, { 2, 1 }, sch_medicalentity, sch_medicalsignorsymptom },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicalstudy },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_medicaltest },
    {   { 2, 0 }, { 2, 1 }, sch_medicalentity, sch_medicaltherapy },
    {   { 3, 5 }, { 0, 0 }, sch_medicalentity, sch_substance },
    {   { 2, 0 }, { 0, 0 }, sch_medicalentity, sch_superficialanatomy },
    {   { 3, 5 }, { 0, 0 }, sch_medicalenumeration, sch_drugclass },
    {   { 3, 5 }, { 0, 0 }, sch_medicalenumeration, sch_drugcost },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_drugcostcategory },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_drugpregnancycategory },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_drugprescriptionstatus },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_infectiousagentclass },
    {   { 2, 0 }, { 8, 0 }, sch_medicalenumeration, sch_medicalaudience },
    {   { 9, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicalaudiencetype },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicaldevicepurpose },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicalevidencelevel },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicalimagingtechnique },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicalobservationalstudydesign },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicalproceduretype },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicalspeciality },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicalstudystatus },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicaltrialdesign },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_medicinesystem },
    {   { 2, 0 }, { 2, 1 }, sch_medicalenumeration, sch_physicalactivitycategory },
    {   { 2, 0 }, { 0, 0 }, sch_medicalenumeration, sch_physicalexam },
    {   { 3, 6 }, { 5, 0 }, sch_medicalevidencelevel, sch_evidencelevela },
    {   { 3, 6 }, { 5, 0 }, sch_medicalevidencelevel, sch_evidencelevelb },
    {   { 3, 6 }, { 5, 0 }, sch_medicalevidencelevel, sch_evidencelevelc },
    {   { 9, 0 }, { 0, 0 }, sch_medicalevidencelevel, sch_evidencelevela },
    {   { 9, 0 }, { 0, 0 }, sch_medicalevidencelevel, sch_evidencelevelb },
    {   { 9, 0 }, { 0, 0 }, sch_medicalevidencelevel, sch_evidencelevelc },
    {   { 2, 0 }, { 0, 0 }, sch_medicalguideline, sch_medicalguidelinecontraindication },
    {   { 2, 0 }, { 0, 0 }, sch_medicalguideline, sch_medicalguidelinerecommendation },
    {   { 3, 6 }, { 5, 0 }, sch_medicalimagingtechnique, sch_ct },
    {   { 3, 6 }, { 5, 0 }, sch_medicalimagingtechnique, sch_mri },
    {   { 3, 6 }, { 5, 0 }, sch_medicalimagingtechnique, sch_pet },
    {   { 3, 6 }, { 5, 0 }, sch_medicalimagingtechnique, sch_radiography },
    {   { 3, 6 }, { 5, 0 }, sch_medicalimagingtechnique, sch_ultrasound },
    {   { 3, 6 }, { 5, 0 }, sch_medicalimagingtechnique, sch_xray },
    {   { 9, 0 }, { 0, 0 }, sch_medicalimagingtechnique, sch_ct },
    {   { 9, 0 }, { 0, 0 }, sch_medicalimagingtechnique, sch_mri },
    {   { 9, 0 }, { 0, 0 }, sch_medicalimagingtechnique, sch_pet },
    {   { 9, 0 }, { 0, 0 }, sch_medicalimagingtechnique, sch_radiography },
    {   { 9, 0 }, { 0, 0 }, sch_medicalimagingtechnique, sch_ultrasound },
    {   { 9, 0 }, { 0, 0 }, sch_medicalimagingtechnique, sch_xray },
    {   { 2, 0 }, { 0, 0 }, sch_medicalindication, sch_approvedindication },
    {   { 2, 0 }, { 0, 0 }, sch_medicalindication, sch_preventionindication },
    {   { 2, 0 }, { 0, 0 }, sch_medicalindication, sch_treatmentindication },
    {   { 2, 0 }, { 0, 0 }, sch_medicalintangible, sch_ddxelement },
    {   { 2, 0 }, { 0, 0 }, sch_medicalintangible, sch_doseschedule },
    {   { 2, 0 }, { 2, 1 }, sch_medicalintangible, sch_drugcost },
    {   { 2, 0 }, { 0, 0 }, sch_medicalintangible, sch_druglegalstatus },
    {   { 2, 0 }, { 0, 0 }, sch_medicalintangible, sch_drugstrength },
    {   { 2, 0 }, { 0, 0 }, sch_medicalintangible, sch_medicalcode },
    {   { 2, 0 }, { 0, 0 }, sch_medicalintangible, sch_medicalconditionstage },
    {   { 2, 0 }, { 2, 1 }, sch_medicalintangible, sch_medicalenumeration },
    {   { 3, 6 }, { 5, 0 }, sch_medicalobservationalstudydesign, sch_caseseries },
    {   { 3, 6 }, { 5, 0 }, sch_medicalobservationalstudydesign, sch_cohortstudy },
    {   { 3, 6 }, { 5, 0 }, sch_medicalobservationalstudydesign, sch_crosssectional },
    {   { 3, 6 }, { 5, 0 }, sch_medicalobservationalstudydesign, sch_longitudinal },
    {   { 3, 6 }, { 5, 0 }, sch_medicalobservationalstudydesign, sch_observational },
    {   { 3, 6 }, { 5, 0 }, sch_medicalobservationalstudydesign, sch_registry },
    {   { 9, 0 }, { 0, 0 }, sch_medicalobservationalstudydesign, sch_caseseries },
    {   { 9, 0 }, { 0, 0 }, sch_medicalobservationalstudydesign, sch_cohortstudy },
    {   { 9, 0 }, { 0, 0 }, sch_medicalobservationalstudydesign, sch_crosssectional },
    {   { 9, 0 }, { 0, 0 }, sch_medicalobservationalstudydesign, sch_longitudinal },
    {   { 9, 0 }, { 0, 0 }, sch_medicalobservationalstudydesign, sch_observational },
    {   { 9, 0 }, { 0, 0 }, sch_medicalobservationalstudydesign, sch_registry },
    {   { 2, 0 }, { 0, 0 }, sch_medicalorganisation, sch_dentist },
    {   { 2, 0 }, { 2, 1 }, sch_medicalorganisation, sch_diagnosticlab },
    {   { 3, 5 }, { 0, 0 }, sch_medicalorganisation, sch_diagnosticlab },
    {   { 2, 0 }, { 0, 0 }, sch_medicalorganisation, sch_hospital },
    {   { 2, 0 }, { 2, 1 }, sch_medicalorganisation, sch_medicalclinic },
    {   { 2, 0 }, { 2, 1 }, sch_medicalorganisation, sch_optician },
    {   { 2, 0 }, { 0, 0 }, sch_medicalorganisation, sch_pharmacy },
    {   { 2, 0 }, { 0, 0 }, sch_medicalorganisation, sch_physician },
    {   { 2, 0 }, { 2, 1 }, sch_medicalorganisation, sch_veterinarycare },
    {   { 3, 5 }, { 0, 0 }, sch_medicalorganisation, sch_veterinarycare },
    {   { 2, 0 }, { 0, 0 }, sch_medicalprocedure, sch_diagnosticprocedure },
    {   { 2, 0 }, { 0, 0 }, sch_medicalprocedure, sch_palliativeprocedure },
    {   { 3, 5 }, { 0, 0 }, sch_medicalprocedure, sch_physicalexam },
    {   { 3, 5 }, { 0, 0 }, sch_medicalprocedure, sch_surgicalprocedure },
    {   { 2, 0 }, { 0, 0 }, sch_medicalprocedure, sch_therapeuticprocedure },
    {   { 3, 6 }, { 5, 0 }, sch_medicalproceduretype, sch_noninvasiveprocedure },
    {   { 3, 6 }, { 5, 0 }, sch_medicalproceduretype, sch_percutaneousprocedure },
    {   { 9, 0 }, { 0, 0 }, sch_medicalproceduretype, sch_noninvasiveprocedure },
    {   { 9, 0 }, { 0, 0 }, sch_medicalproceduretype, sch_percutaneousprocedure },
    {   { 2, 0 }, { 0, 0 }, sch_medicalriskestimator, sch_medicalriskcalculator },
    {   { 2, 0 }, { 0, 0 }, sch_medicalriskestimator, sch_medicalriskscore },
    {   { 3, 5 }, { 0, 0 }, sch_medicalsign, sch_vitalsign },
    {   { 2, 0 }, { 0, 0 }, sch_medicalsignorsymptom, sch_medicalsign },
    {   { 2, 0 }, { 0, 0 }, sch_medicalsignorsymptom, sch_medicalsymptom },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_anaesthesia },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_cardiovascular },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_communityhealth },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_dentistry },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_dermatology },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_dietnutrition },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_emergency },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_endocrine },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_gastroenterologic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_genetic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_geriatric },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_gynaecologic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_haematologic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_infectious },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_laboratoryscience },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_midwifery },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_musculoskeletal },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_neurologic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_nursing },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_obstetric },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_oncologic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_optometric },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_otolaryngologic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_pathology },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_paediatric },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_pharmacyspeciality },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_physiotherapy },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_plasticsurgery },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_podiatric },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_primarycare },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_psychiatric },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_publichealth },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_pulmonary },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_radiography },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_renal },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_respiratorytherapy },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_rheumatologic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_speechpathology },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_surgical },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_toxicologic },
    {   { 3, 6 }, { 5, 0 }, sch_medicalspeciality, sch_urologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_anaesthesia },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_cardiovascular },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_communityhealth },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_dentistry },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_dermatology },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_dietnutrition },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_emergency },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_endocrine },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_gastroenterologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_genetic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_geriatric },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_gynaecologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_haematologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_infectious },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_laboratoryscience },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_midwifery },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_musculoskeletal },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_neurologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_nursing },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_obstetric },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_oncologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_optometric },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_otolaryngologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_pathology },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_paediatric },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_pharmacyspeciality },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_physiotherapy },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_plasticsurgery },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_podiatric },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_primarycare },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_psychiatric },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_publichealth },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_pulmonary },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_radiography },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_renal },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_respiratorytherapy },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_rheumatologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_speechpathology },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_surgical },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_toxicologic },
    {   { 9, 0 }, { 0, 0 }, sch_medicalspeciality, sch_urologic },
    {   { 2, 0 }, { 0, 0 }, sch_medicalstudy, sch_medicalobservationalstudy },
    {   { 2, 0 }, { 0, 0 }, sch_medicalstudy, sch_medicaltrial },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_activenotrecruiting },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_completed },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_enrollingbyinvitation },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_notyetrecruiting },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_recruiting },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_resultsavailable },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_resultsnotavailable },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_suspended },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_terminated },
    {   { 3, 6 }, { 5, 0 }, sch_medicalstudystatus, sch_withdrawn },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_activenotrecruiting },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_completed },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_enrollingbyinvitation },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_notyetrecruiting },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_recruiting },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_resultsavailable },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_resultsnotavailable },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_suspended },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_terminated },
    {   { 9, 0 }, { 0, 0 }, sch_medicalstudystatus, sch_withdrawn },
    {   { 2, 0 }, { 0, 0 }, sch_medicaltest, sch_bloodtest },
    {   { 2, 0 }, { 2, 1 }, sch_medicaltest, sch_diagnosticprocedure },
    {   { 2, 0 }, { 0, 0 }, sch_medicaltest, sch_imagingtest },
    {   { 2, 0 }, { 0, 0 }, sch_medicaltest, sch_medicaltestpanel },
    {   { 2, 0 }, { 0, 0 }, sch_medicaltest, sch_pathologytest },
    {   { 2, 0 }, { 2, 1 }, sch_medicaltherapy, sch_dietarysupplement },
    {   { 2, 0 }, { 2, 1 }, sch_medicaltherapy, sch_drug },
    {   { 2, 0 }, { 2, 1 }, sch_medicaltherapy, sch_drugclass },
    {   { 2, 0 }, { 2, 1 }, sch_medicaltherapy, sch_lifestylemodification },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltherapy, sch_occupationaltherapy },
    {   { 2, 0 }, { 0, 0 }, sch_medicaltherapy, sch_palliativeprocedure },
    {   { 2, 0 }, { 0, 0 }, sch_medicaltherapy, sch_physicaltherapy },
    {   { 2, 0 }, { 2, 1 }, sch_medicaltherapy, sch_psychologicaltreatment },
    {   { 2, 0 }, { 0, 0 }, sch_medicaltherapy, sch_radiationtherapy },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltherapy, sch_respiratorytherapy },
    {   { 2, 0 }, { 2, 1 }, sch_medicaltherapy, sch_therapeuticprocedure },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_doubleblindedtrial },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_internationaltrial },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_multicentretrial },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_opentrial },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_placebocontrolledtrial },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_randomisedtrial },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_singleblindedtrial },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_singlecentretrial },
    {   { 3, 5 }, { 0, 0 }, sch_medicaltrialdesign, sch_tripleblindedtrial },
    {   { 3, 6 }, { 5, 0 }, sch_medicinesystem, sch_pixiegiven }, // magic
    {   { 3, 6 }, { 5, 0 }, sch_medicinesystem, sch_harmful }, // magic
    {   { 3, 6 }, { 5, 0 }, sch_medicinesystem, sch_magic }, // magic
    {   { 3, 6 }, { 5, 0 }, sch_medicinesystem, sch_osteopathic }, // well...
    {   { 3, 6 }, { 5, 0 }, sch_medicinesystem, sch_environmentharm }, // magic and environmental harm
    {   { 3, 6 }, { 5, 0 }, sch_medicinesystem, sch_realitybased },  // empirical (reality based)
    {   { 6, 0 }, { 0, 0 }, sch_merchantreturnenumeration, sch_merchantreturnfinitereturnwindow  },
    {   { 6, 0 }, { 0, 0 }, sch_merchantreturnenumeration, sch_merchantreturnnotpermitted  },
    {   { 6, 0 }, { 0, 0 }, sch_merchantreturnenumeration, sch_merchantreturnunlimitedwindow  },
    {   { 6, 0 }, { 0, 0 }, sch_merchantreturnenumeration, sch_merchantreturnunspecified  },
    {   { 3, 0 }, { 0, 0 }, sch_message, sch_emailmessage },
    {   { 2, 0 }, { 0, 0 }, sch_moveaction, sch_arriveaction },
    {   { 2, 0 }, { 0, 0 }, sch_moveaction, sch_departaction },
    {   { 2, 0 }, { 0, 0 }, sch_moveaction, sch_travelaction },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_compilationalbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_djmixalbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_demoalbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_livealbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_mixtapealbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_remixalbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_soundtrackalbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_spokenwordalbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumproductiontype, sch_studioalbum },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumreleasetype, sch_albumrelease },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumreleasetype, sch_broadcastrelease },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumreleasetype, sch_eprelease },
    {   { 3, 5 }, { 0, 0 }, sch_musicalbumreleasetype, sch_singlerelease },
    {   { 2, 0 }, { 0, 0 }, sch_musicplaylist, sch_musicalbum },
    {   { 2, 0 }, { 0, 0 }, sch_musicplaylist, sch_musicrelease },
    {   { 3, 5 }, { 0, 0 }, sch_musicreleaseformattype, sch_cdformat },
    {   { 3, 5 }, { 0, 0 }, sch_musicreleaseformattype, sch_cassetteformat },
    {   { 3, 5 }, { 0, 0 }, sch_musicreleaseformattype, sch_dvdformat },
    {   { 3, 5 }, { 0, 0 }, sch_musicreleaseformattype, sch_digitalaudiotapeformat },
    {   { 3, 5 }, { 0, 0 }, sch_musicreleaseformattype, sch_digitalformat },
    {   { 3, 5 }, { 0, 0 }, sch_musicreleaseformattype, sch_laserdiscformat },
    {   { 3, 5 }, { 0, 0 }, sch_musicreleaseformattype, sch_vinylformat },
    {   { 3, 5 }, { 0, 0 }, sch_newsarticle, sch_analysisnewsarticle },
    {   { 3, 5 }, { 0, 0 }, sch_newsarticle, sch_askpublicnewsarticle },
    {   { 3, 5 }, { 0, 0 }, sch_newsarticle, sch_backgroundnewsarticle },
    {   { 3, 5 }, { 0, 0 }, sch_newsarticle, sch_opinionnewsarticle },
    {   { 3, 5 }, { 0, 0 }, sch_newsarticle, sch_reportagenewsarticle },
    {   { 3, 5 }, { 0, 0 }, sch_newsarticle, sch_reviewnewsarticle },
    {   { 9, 0 }, { 0, 0 }, sch_nlnonprofittype, sch_nonprofitanbi },
    {   { 9, 0 }, { 0, 0 }, sch_nlnonprofittype, sch_nonprofitsbbi },
    {   { 8, 0 }, { 0, 0 }, sch_nonprofittype, sch_nlnonprofittype },
    {   { 8, 0 }, { 0, 0 }, sch_nonprofittype, sch_uknonprofittype },
    {   { 8, 0 }, { 0, 0 }, sch_nonprofittype, sch_usnonprofittype },
    {   { 2, 0 }, { 0, 0 }, sch_number, sch_float },
    {   { 2, 0 }, { 0, 0 }, sch_number, sch_integer },
    {   { 2, 0 }, { 0, 0 }, sch_offer, sch_aggregateoffer },
    {   { 4, 0 }, { 0, 0 }, sch_offer, sch_offerforlease },
    {   { 4, 0 }, { 0, 0 }, sch_offer, sch_offerforpurchase },
    {   { 3, 5 }, { 0, 0 }, sch_offeritemcondition, sch_damagedcondition },
    {   { 3, 5 }, { 0, 0 }, sch_offeritemcondition, sch_newcondition },
    {   { 3, 5 }, { 0, 0 }, sch_offeritemcondition, sch_refurbishedcondition },
    {   { 3, 5 }, { 0, 0 }, sch_offeritemcondition, sch_usedcondition },
    {   { 3, 5 }, { 0, 0 }, sch_orderstatus, sch_ordercancelled },
    {   { 3, 5 }, { 0, 0 }, sch_orderstatus, sch_orderdelivered },
    {   { 3, 5 }, { 0, 0 }, sch_orderstatus, sch_orderintransit },
    {   { 3, 5 }, { 0, 0 }, sch_orderstatus, sch_orderpaymentdue },
    {   { 3, 5 }, { 0, 0 }, sch_orderstatus, sch_orderpickupavailable },
    {   { 3, 5 }, { 0, 0 }, sch_orderstatus, sch_orderproblem },
    {   { 3, 5 }, { 0, 0 }, sch_orderstatus, sch_orderprocessing },
    {   { 3, 5 }, { 0, 0 }, sch_orderstatus, sch_orderreturned },
    {   { 2, 0 }, { 0, 0 }, sch_organisation, sch_airline },
    {   { 3, 5 }, { 0, 0 }, sch_organisation, sch_consortium },
    {   { 2, 0 }, { 2, 1 }, sch_organisation, sch_corporation },
    {   { 3, 1 }, { 0, 0 }, sch_organisation, sch_corporation },
    {   { 2, 0 }, { 0, 0 }, sch_organisation, sch_educationalorganisation },
    {   { 3, 5 }, { 0, 0 }, sch_organisation, sch_fundingscheme },
    {   { 2, 0 }, { 2, 1 }, sch_organisation, sch_governmentorganisation },
    {   { 3, 1 }, { 0, 0 }, sch_organisation, sch_governmentorganisation },
    {   { 3, 5 }, { 0, 0 }, sch_organisation, sch_librarysystem },
    {   { 2, 0 }, { 0, 0 }, sch_organisation, sch_localbusiness },
    {   { 3, 0 }, { 0, 0 }, sch_organisation, sch_medicalorganisation },
    {   { 2, 0 }, { 2, 1 }, sch_organisation, sch_ngo },
    {   { 3, 1 }, { 0, 0 }, sch_organisation, sch_ngo },
    {   { 3, 5 }, { 0, 0 }, sch_organisation, sch_newsmediaorganisation },
    {   { 2, 0 }, { 0, 0 }, sch_organisation, sch_performinggroup },
    {   { 3, 5 }, { 0, 0 }, sch_organisation, sch_project },
    {   { 2, 0 }, { 0, 0 }, sch_organisation, sch_sportsorganisation },
    {   { 3, 5 }, { 0, 0 }, sch_organisation, sch_workersunion },
    {   { 2, 0 }, { 0, 0 }, sch_organiseaction, sch_allocateaction },
    {   { 2, 0 }, { 0, 0 }, sch_organiseaction, sch_applyaction },
    {   { 2, 0 }, { 0, 0 }, sch_organiseaction, sch_bookmarkaction },
    {   { 2, 0 }, { 0, 0 }, sch_organiseaction, sch_planaction },
    {   { 2, 0 }, { 0, 0 }, sch_organisationrole, sch_employeerole },
    {   { 3, 0 }, { 0, 0 }, sch_paymentcard, sch_creditcard },
    {   { 2, 0 }, { 2, 1 }, sch_paymentmethod, sch_creditcard },
    {   { 3, 0 }, { 0, 0 }, sch_paymentmethod, sch_paymentcard },
    {   { 3, 5 }, { 0, 0 }, sch_paymentstatustype, sch_paymentautomaticallyapplied },
    {   { 3, 5 }, { 0, 0 }, sch_paymentstatustype, sch_paymentcomplete },
    {   { 3, 5 }, { 0, 0 }, sch_paymentstatustype, sch_paymentdeclined },
    {   { 3, 5 }, { 0, 0 }, sch_paymentstatustype, sch_paymentdue },
    {   { 3, 5 }, { 0, 0 }, sch_paymentstatustype, sch_paymentpastdue },
    {   { 2, 0 }, { 2, 1 }, sch_peopleaudience, sch_medicalaudience },
    {   { 3, 5 }, { 0, 0 }, sch_peopleaudience, sch_medicalaudience },
    {   { 2, 0 }, { 0, 0 }, sch_peopleaudience, sch_parentaudience },
    {   { 2, 0 }, { 0, 0 }, sch_performinggroup, sch_dancegroup },
    {   { 2, 0 }, { 0, 0 }, sch_performinggroup, sch_musicgroup },
    {   { 2, 0 }, { 0, 0 }, sch_performinggroup, sch_theatregroup },
    {   { 3, 5 }, { 0, 0 }, sch_periodical, sch_comicseries },
    {   { 3, 5 }, { 0, 0 }, sch_periodical, sch_newspaper },
    {   { 2, 0 }, { 2, 1 }, sch_permit, sch_governmentpermit },
    {   { 3, 1 }, { 0, 0 }, sch_permit, sch_governmentpermit },
    {   { 3, 5 }, { 0, 0 }, sch_person, sch_patient },
    {   { 2, 0 }, { 0, 0 }, sch_physicalactivity, sch_exerciseplan },
    {   { 3, 5 }, { 0, 0 }, sch_physicalactivitycategory, sch_aerobicactivity },
    {   { 3, 5 }, { 0, 0 }, sch_physicalactivitycategory, sch_anaerobicactivity },
    {   { 3, 5 }, { 0, 0 }, sch_physicalactivitycategory, sch_balance },
    {   { 3, 5 }, { 0, 0 }, sch_physicalactivitycategory, sch_flexibility },
    {   { 3, 5 }, { 0, 0 }, sch_physicalactivitycategory, sch_leisuretimeactivity },
    {   { 3, 5 }, { 0, 0 }, sch_physicalactivitycategory, sch_occupationalactivity },
    {   { 3, 5 }, { 0, 0 }, sch_physicalactivitycategory, sch_strengthtraining },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_abdomen },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_appearance },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_cardiovascularexam },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_ear },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_eye },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_genitourinary },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_head },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_lung },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_musculoskeletalexam },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_neck },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_neuro },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_nose },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_skin },
    {   { 3, 6 }, { 5, 0 }, sch_physicalexam, sch_throat },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_abdomen },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_appearance },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_cardiovascularexam },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_ear },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_eye },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_genitourinary },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_head },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_lung },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_musculoskeletalexam },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_neck },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_neuro },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_nose },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_skin },
    {   { 9, 0 }, { 0, 0 }, sch_physicalexam, sch_throat },
    {   { 3, 1 }, { 0, 0 }, sch_place, sch_accommodation },
    {   { 2, 0 }, { 0, 0 }, sch_place, sch_administrativearea },
    {   { 2, 0 }, { 0, 0 }, sch_place, sch_civicstructure },
    {   { 2, 0 }, { 0, 0 }, sch_place, sch_landform },
    {   { 2, 0 }, { 0, 0 }, sch_place, sch_landmarksorhistoricalbuildings },
    {   { 2, 0 }, { 0, 0 }, sch_place, sch_localbusiness },
    {   { 2, 0 }, { 0, 0 }, sch_place, sch_residence },
    {   { 2, 0 }, { 0, 0 }, sch_place, sch_touristattraction },
    {   { 3, 5 }, { 0, 0 }, sch_place, sch_touristdestination },
    {   { 2, 0 }, { 0, 0 }, sch_placeofworship, sch_buddhisttemple },
    {   { 2, 0 }, { 3, 5 }, sch_placeofworship, sch_catholicchurch },
    {   { 2, 0 }, { 0, 0 }, sch_placeofworship, sch_church },
    {   { 2, 0 }, { 0, 0 }, sch_placeofworship, sch_hindutemple },
    {   { 2, 0 }, { 0, 0 }, sch_placeofworship, sch_mosque },
    {   { 2, 0 }, { 0, 0 }, sch_placeofworship, sch_synagogue },
    {   { 2, 0 }, { 0, 0 }, sch_planaction, sch_cancelaction },
    {   { 2, 0 }, { 0, 0 }, sch_planaction, sch_reserveaction },
    {   { 2, 0 }, { 0, 0 }, sch_planaction, sch_scheduleaction },
    {   { 2, 0 }, { 0, 0 }, sch_playaction, sch_exerciseaction },
    {   { 2, 0 }, { 0, 0 }, sch_playaction, sch_performaction },
    {   { 3, 0 }, { 0, 0 }, sch_pricespecification, sch_compoundpricespecification },
    {   { 2, 0 }, { 0, 0 }, sch_pricespecification, sch_deliverychargespecification },
    {   { 2, 0 }, { 0, 0 }, sch_pricespecification, sch_paymentchargespecification },
    {   { 2, 0 }, { 0, 0 }, sch_pricespecification, sch_unitpricespecification },
    {   { 2, 0 }, { 0, 0 }, sch_product, sch_individualproduct },
    {   { 9, 0 }, { 0, 0 }, sch_product, sch_productcollection },
    {   { 9, 0 }, { 0, 0 }, sch_product, sch_productgroup },
    {   { 2, 0 }, { 0, 0 }, sch_product, sch_productmodel },
    {   { 2, 0 }, { 0, 0 }, sch_product, sch_someproducts },
    {   { 2, 0 }, { 0, 0 }, sch_product, sch_vehicle },
    {   { 3, 8 }, { 0, 0 }, sch_productreturnenumeration, sch_productreturnfinitereturnwindow },
    {   { 3, 8 }, { 0, 0 }, sch_productreturnenumeration, sch_productreturnnotpermitted },
    {   { 3, 8 }, { 0, 0 }, sch_productreturnenumeration, sch_productreturnunlimitedwindow },
    {   { 3, 8 }, { 0, 0 }, sch_productreturnenumeration, sch_productreturnunspecified },
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_accountingservice },
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_attorney },
    {   { 2, 0 }, { 3, 0 }, sch_professionalservice, sch_dentist },
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_electrician },
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_generalcontractor },
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_housepainter },
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_locksmith},
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_notary },
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_plumber },
    {   { 2, 0 }, { 2, 1 }, sch_professionalservice, sch_roofingcontractor },
    {   { 3, 5 }, { 0, 0 }, sch_project, sch_fundingagency },
    {   { 3, 5 }, { 0, 0 }, sch_project, sch_researchproject },
    {   { 2, 0 }, { 0, 0 }, sch_publicationevent, sch_broadcastevent },
    {   { 2, 0 }, { 0, 0 }, sch_publicationevent, sch_ondemandevent },
    {   { 2, 0 }, { 0, 0 }, sch_publicationissue, sch_comicissue },
    {   { 3, 5 }, { 0, 0 }, sch_qualitativevalue, sch_bedtype },
    {   { 2, 0 }, { 2, 1 }, sch_qualitativevalue, sch_carusagetype },
    {   { 3, 5 }, { 8, 0 }, sch_qualitativevalue, sch_carusagetype },
    {   { 2, 0 }, { 0, 0 }, sch_qualitativevalue, sch_drivewheelconfigurationvalue },
    {   { 2, 1 }, { 0, 0 }, sch_qualitativevalue, sch_steeringpositionvalue },
    {   { 2, 0 }, { 0, 0 }, sch_quantity, sch_distance },
    {   { 2, 0 }, { 0, 0 }, sch_quantity, sch_duration },
    {   { 2, 0 }, { 0, 0 }, sch_quantity, sch_energy },
    {   { 2, 0 }, { 0, 0 }, sch_quantity, sch_mass },
    {   { 3, 5 }, { 0, 0 }, sch_quantitativevaluedistribution, sch_monetaryamountdistribution },
    {   { 3, 5 }, { 0, 0 }, sch_radiochannel, sch_amradiochannel },
    {   { 3, 5 }, { 0, 0 }, sch_radiochannel, sch_fmradiochannel },
    {   { 2, 0 }, { 0, 0 }, sch_rating, sch_aggregaterating },
    {   { 3, 5 }, { 0, 0 }, sch_rating, sch_endorsementrating },
    {   { 2, 0 }, { 0, 0 }, sch_reactaction, sch_agreeaction },
    {   { 2, 0 }, { 0, 0 }, sch_reactaction, sch_disagreeaction },
    {   { 2, 0 }, { 0, 0 }, sch_reactaction, sch_dislikeaction },
    {   { 2, 0 }, { 0, 0 }, sch_reactaction, sch_endorseaction },
    {   { 2, 0 }, { 0, 0 }, sch_reactaction, sch_likeaction },
    {   { 2, 0 }, { 0, 0 }, sch_reactaction, sch_wantaction },
    {   { 3, 8 }, { 0, 0 }, sch_refundtypeenumeration, sch_exchangerefund },
    {   { 3, 8 }, { 0, 0 }, sch_refundtypeenumeration, sch_fullrefund },
    {   { 3, 8 }, { 0, 0 }, sch_refundtypeenumeration, sch_storecreditrefund },
    {   { 9, 0 }, { 0, 0 }, sch_reservation, sch_boatreservation },
    {   { 2, 0 }, { 2, 1 }, sch_reservation, sch_busreservation },
    {   { 3, 1 }, { 0, 0 }, sch_reservation, sch_busreservation },
    {   { 2, 0 }, { 2, 1 }, sch_reservation, sch_eventreservation },
    {   { 3, 1 }, { 0, 0 }, sch_reservation, sch_eventreservation },
    {   { 2, 0 }, { 0, 0 }, sch_reservation, sch_flightreservation },
    {   { 2, 0 }, { 0, 0 }, sch_reservation, sch_foodestablishmentreservation },
    {   { 2, 0 }, { 0, 0 }, sch_reservation, sch_lodgingreservation },
    {   { 2, 0 }, { 0, 0 }, sch_reservation, sch_rentalcarreservation },
    {   { 2, 0 }, { 2, 1 }, sch_reservation, sch_reservationpackage },
    {   { 3, 1 }, { 0, 0 }, sch_reservation, sch_reservationpackage },
    {   { 2, 0 }, { 2, 1 }, sch_reservation, sch_taxireservation },
    {   { 3, 1 }, { 0, 0 }, sch_reservation, sch_taxireservation },
    {   { 2, 0 }, { 0, 0 }, sch_reservation, sch_trainreservation },
    {   { 3, 5 }, { 0, 0 }, sch_reservationstatustype, sch_reservationcancelled },
    {   { 3, 5 }, { 0, 0 }, sch_reservationstatustype, sch_reservationconfirmed },
    {   { 3, 5 }, { 0, 0 }, sch_reservationstatustype, sch_reservationhold },
    {   { 3, 5 }, { 0, 0 }, sch_reservationstatustype, sch_reservationpending },
    {   { 2, 0 }, { 0, 0 }, sch_residence, sch_apartmentcomplex },
    {   { 2, 0 }, { 0, 0 }, sch_residence, sch_gatedresidencecommunity },
    {   { 2, 0 }, { 3, 0 }, sch_residence, sch_singlefamilyresidence },
    {   { 10, 0 }, { 0, 0 }, sch_resort, sch_skiresort },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_diabeticdiet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_glutenfreediet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_halaldiet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_hindudiet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_kosherdiet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_lowcaloriediet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_lowfatdiet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_lowlactosediet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_lowsaltdiet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_vegandiet },
    {   { 3, 5 }, { 0, 0 }, sch_restricteddiet, sch_vegetariandiet },
    {   { 3, 8 }, { 0, 0 }, sch_returnfeesenumeration, sch_originalshippingfees },
    {   { 3, 8 }, { 0, 0 }, sch_returnfeesenumeration, sch_restockingfees },
    {   { 3, 8 }, { 0, 0 }, sch_returnfeesenumeration, sch_returnshippingfees },
    {   { 3, 2 }, { 0, 0 }, sch_review, sch_claimreview },
    {   { 3, 5 }, { 0, 0 }, sch_review, sch_criticreview },
    {   { 3, 5 }, { 0, 0 }, sch_review, sch_employerreview },
    {   { 7, 0 }, { 0, 0 }, sch_review, sch_mediareview },
    {   { 6, 0 }, { 0, 0 }, sch_review, sch_recommendation },
    {   { 3, 5 }, { 0, 0 }, sch_review, sch_userreview },
    {   { 3, 5 }, { 0, 0 }, sch_role, sch_linkrole },
    {   { 2, 0 }, { 0, 0 }, sch_role, sch_organisationrole },
    {   { 2, 0 }, { 0, 0 }, sch_role, sch_performancerole },
    {   { 3, 1 }, { 0, 0 }, sch_room, sch_hotelroom },
    {   { 3, 1 }, { 0, 0 }, sch_room, sch_meetingroom },
    {   { 3, 5 }, { 0, 0 }, sch_rsvpresponsetype, sch_rsvpresponsemaybe },
    {   { 3, 5 }, { 0, 0 }, sch_rsvpresponsetype, sch_rsvpresponseno },
    {   { 3, 5 }, { 0, 0 }, sch_rsvpresponsetype, sch_rsvpresponseyes },
    {   { 3, 4 }, { 0, 0 }, sch_series, sch_creativeworkseries },
    {   { 3, 5 }, { 0, 0 }, sch_series, sch_eventseries },
    {   { 2, 1 }, { 0, 0 }, sch_service, sch_broadcastservice },
    {   { 2, 0 }, { 0, 0 }, sch_service, sch_cableorsatelliteservice },
    {   { 3, 0 }, { 0, 0 }, sch_service, sch_financialproduct },
    {   { 3, 1 }, { 0, 0 }, sch_service, sch_foodservice },
    {   { 2, 0 }, { 0, 0 }, sch_service, sch_governmentservice },
    {   { 2, 0 }, { 2, 1 }, sch_service, sch_taxi },
    {   { 2, 0 }, { 0, 0 }, sch_service, sch_taxiservice },
    {   { 3, 5 }, { 0, 0 }, sch_service, sch_webapi },
    {   { 2, 1 }, { 2, 1 }, sch_socialmediaposting, sch_blogposting },
    {   { 3, 1 }, { 0, 0 }, sch_socialmediaposting, sch_blogposting },
    {   { 2, 1 }, { 0, 0 }, sch_socialmediaposting, sch_discussionforumposting },
    {   { 2, 0 }, { 0, 0 }, sch_softwareapplication, sch_mobileapplication },
    {   { 2, 0 }, { 0, 0 }, sch_softwareapplication, sch_videogame },
    {   { 2, 0 }, { 0, 0 }, sch_softwareapplication, sch_webapplication },
    {   { 2, 0 }, { 2, 1 }, sch_speciality, sch_medicalspeciality },
    {   { 3, 5 }, { 0, 0 }, sch_speciality, sch_medicalspeciality },
    {   { 2, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_bowlingalley },
    {   { 2, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_exercisegym },
    {   { 2, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_golfcourse },
    {   { 2, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_healthclub },
    {   { 2, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_publicswimmingpool },
    {   { 2, 0 }, { 9, 0 }, sch_sportsactivitylocation, sch_skiresort },
    {   { 10, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_resort },
    {   { 2, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_sportsclub },
    {   { 2, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_stadiumorarena },
    {   { 2, 0 }, { 0, 0 }, sch_sportsactivitylocation, sch_tenniscomplex },
    {   { 2, 0 }, { 0, 0 }, sch_sportsorganisation, sch_sportsteam },
    {   { 9, 0 }, { 0, 0 }, sch_statusenumeration, sch_actionstatustype },
    {   { 9, 0 }, { 0, 0 }, sch_statusenumeration, sch_eventstatustype },
    {   { 9, 0 }, { 0, 0 }, sch_statusenumeration, sch_gameserverstatus },
    {   { 9, 0 }, { 0, 0 }, sch_statusenumeration, sch_legalforcestatus },
    {   { 9, 0 }, { 0, 0 }, sch_statusenumeration, sch_orderstatus },
    {   { 9, 0 }, { 0, 0 }, sch_statusenumeration, sch_paymentstatustype },
    {   { 9, 0 }, { 0, 0 }, sch_statusenumeration, sch_reservationstatustype },
    {   { 3, 6 }, { 5, 0 }, sch_steeringpositionvalue, sch_lefthanddriving },
    {   { 3, 6 }, { 5, 0 }, sch_steeringpositionvalue, sch_righthanddriving },
    {   { 9, 0 }, { 0, 0 }, sch_steeringpositionvalue, sch_lefthanddriving },
    {   { 9, 0 }, { 0, 0 }, sch_steeringpositionvalue, sch_righthanddriving },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_autopartsstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_bikestore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_bookstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_clothingstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_computerstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_conveniencestore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_departmentstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_electronicsstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_florist },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_furniturestore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_gardenstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_grocerystore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_hardwarestore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_hobbyshop },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_homegoodsstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_jewelrystore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_liquorstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_mensclothingstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_mobilephonestore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_movierentalstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_musicstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_officeequipmentstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_outletstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_pawnshop },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_petstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_shoestore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_sportinggoodsstore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_tyreshop },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_toystore },
    {   { 2, 0 }, { 0, 0 }, sch_store, sch_wholesalestore },
    {   { 7, 3 }, { 0, 0 }, sch_structuredvalue, sch_cdcpmdrecord },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_contactpoint },
    {   { 2, 0 }, { 2, 1 }, sch_structuredvalue, sch_datedmoneyspecification },
    {   { 7, 4 }, { 2, 1 }, sch_structuredvalue, sch_definedregion },
    {   { 8, 0 }, { 2, 1 }, sch_structuredvalue, sch_deliverytimesettings },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_enginespecification },
    {   { 3, 5 }, { 0, 0 }, sch_structuredvalue, sch_exchangeratespecification },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_geocoordinates },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_geoshape },
    {   { 2, 1 }, { 0, 0 }, sch_structuredvalue, sch_interactioncounter },
    {   { 3, 0 }, { 0, 0 }, sch_structuredvalue, sch_monetaryamount },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_nutritioninformation },
    {   { 7, 4 }, { 0, 0 }, sch_structuredvalue, sch_offershippingdetails },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_openinghoursspecification },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_ownershipinfo },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_ownershipinfo },
    {   { 8, 0 }, { 0, 0 }, sch_structuredvalue, sch_postalcoderangespecification },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_propertyvalue },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_quantitativevalue },
    {   { 3, 5 }, { 0, 0 }, sch_structuredvalue, sch_quantitativevaluedistribution },
    {   { 3, 5 }, { 0, 0 }, sch_structuredvalue, sch_repaymentspecification },
    {   { 8, 0 }, { 0, 0 }, sch_structuredvalue, sch_shippingdeliverytime },
    {   { 8, 0 }, { 0, 0 }, sch_structuredvalue, sch_shippingratesettings },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_typeandquantitynode },
    {   { 2, 0 }, { 0, 0 }, sch_structuredvalue, sch_warrantypromise },
    {   { 3, 5 }, { 0, 0 }, sch_substance, sch_dietarysupplement },
    {   { 3, 5 }, { 0, 0 }, sch_substance, sch_drug },
    {   { 2, 0 }, { 0, 0 }, sch_techarticle, sch_apireference },
    {   { 2, 0 }, { 0, 0 }, sch_text, sch_cssselectortype },
    {   { 2, 0 }, { 0, 0 }, sch_text, sch_pronounceabletext },
    {   { 2, 0 }, { 0, 0 }, sch_text, sch_url },
    {   { 2, 0 }, { 0, 0 }, sch_text, sch_xpathtype },
    {   { 3, 5 }, { 0, 0 }, sch_therapeuticprocedure, sch_medicaltherapy },
    {   { 3, 5 }, { 0, 0 }, sch_therapeuticprocedure, sch_psychologicaltreatment },
    {   { 2, 0 }, { 0, 0 }, sch_thing, sch_action },
    {   { 2, 0 }, { 2, 0 }, sch_thing, sch_broadcastservice },
    {   { 2, 0 }, { 0, 0 }, sch_thing, sch_creativework },
    {   { 2, 0 }, { 0, 0 }, sch_thing, sch_event },
    {   { 2, 0 }, { 0, 0 }, sch_thing, sch_intangible },
    {   { 2, 0 }, { 2, 1 }, sch_thing, sch_medicalentity },
    {   { 3, 5 }, { 0, 0 }, sch_thing, sch_medicalentity },
    {   { 2, 0 }, { 0, 0 }, sch_thing, sch_organisation },
    {   { 2, 0 }, { 0, 0 }, sch_thing, sch_person },
    {   { 2, 0 }, { 0, 0 }, sch_thing, sch_place },
    {   { 2, 0 }, { 0, 0 }, sch_thing, sch_product },
    {   { 2, 0 }, { 0, 0 }, sch_tradeaction, sch_buyaction },
    {   { 2, 0 }, { 0, 0 }, sch_tradeaction, sch_donateaction },
    {   { 2, 0 }, { 0, 0 }, sch_tradeaction, sch_orderaction },
    {   { 2, 0 }, { 0, 0 }, sch_tradeaction, sch_payaction },
    {   { 3, 5 }, { 0, 0 }, sch_tradeaction, sch_preorderaction },
    {   { 2, 0 }, { 0, 0 }, sch_tradeaction, sch_quoteaction },
    {   { 2, 0 }, { 0, 0 }, sch_tradeaction, sch_rentaction },
    {   { 2, 0 }, { 0, 0 }, sch_tradeaction, sch_sellaction },
    {   { 2, 0 }, { 0, 0 }, sch_tradeaction, sch_tipaction },
    {   { 2, 0 }, { 0, 0 }, sch_transferaction, sch_borrowaction },
    {   { 2, 0 }, { 0, 0 }, sch_transferaction, sch_downloadaction },
    {   { 2, 0 }, { 0, 0 }, sch_transferaction, sch_giveaction },
    {   { 2, 0 }, { 0, 0 }, sch_transferaction, sch_lendaction },
    {   { 4, 0 }, { 0, 0 }, sch_transferaction, sch_moneytransfer },
    {   { 2, 0 }, { 0, 0 }, sch_transferaction, sch_receiveaction },
    {   { 2, 0 }, { 0, 0 }, sch_transferaction, sch_returnaction },
    {   { 2, 0 }, { 0, 0 }, sch_transferaction, sch_sendaction },
    {   { 2, 0 }, { 0, 0 }, sch_transferaction, sch_takeaction },
    {   { 9, 0 }, { 0, 0 }, sch_trip, sch_boattrip },
    {   { 3, 4 }, { 0, 0 }, sch_trip, sch_bustrip },
    {   { 3, 4 }, { 0, 0 }, sch_trip, sch_flight },
    {   { 3, 5 }, { 0, 0 }, sch_trip, sch_touristtrip },
    {   { 3, 4 }, { 0, 0 }, sch_trip, sch_traintrip },
    {   { 2, 0 }, { 0, 0 }, sch_updateaction, sch_addaction },
    {   { 2, 0 }, { 0, 0 }, sch_updateaction, sch_deleteaction },
    {   { 2, 0 }, { 0, 0 }, sch_updateaction, sch_replaceaction },
    {   { 9, 0 }, { 0, 0 }, sch_uknonprofittype, sch_charitableincorporatedorganization },
    {   { 9, 0 }, { 0, 0 }, sch_uknonprofittype, sch_limitedbyguaranteecharity },
    {   { 9, 0 }, { 0, 0 }, sch_uknonprofittype, sch_uktrust },
    {   { 9, 0 }, { 0, 0 }, sch_uknonprofittype, sch_unincorporatedassociationcharity },
    {   { 2, 0 }, { 0, 0 }, sch_useaction, sch_wearaction },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_userblocks },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_usercheckins },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_usercomments },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_userdownloads },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_userlikes },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_userpagevisits },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_userplays },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_userplusones },
    {   { 2, 0 }, { 0, 0 }, sch_userinteraction, sch_usertweets },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501a, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c1, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c10, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c11, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c12, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c13, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c14, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c15, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c16, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c17, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c18, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c19, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c2, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c20, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c21, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c22, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c23, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c24, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c25, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c26, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c27, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c28, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c3, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c4, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c5, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c6, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c7, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c8, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501c9, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501d, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501e, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501f, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501k, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501n, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit501q, },
    {   { 9, 0 }, { 0, 0 }, sch_usnonprofittype, sch_nonprofit527, },
    {   { 3, 5 }, { 0, 0 }, sch_vehicle, sch_busorcoach },
    {   { 2, 0 }, { 0, 0 }, sch_vehicle, sch_car },
    {   { 3, 5 }, { 0, 0 }, sch_vehicle, sch_motorcycle },
    {   { 3, 5 }, { 0, 0 }, sch_vehicle, sch_motorisedbicycle },
    {   { 2, 0 }, { 0, 0 }, sch_vessel, sch_artery },
    {   { 2, 0 }, { 0, 0 }, sch_vessel, sch_lymphaticvessel },
    {   { 2, 0 }, { 0, 0 }, sch_vessel, sch_vein },
    {   { 3, 5 }, { 0, 0 }, sch_visualartwork, sch_coverart },
    {   { 5, 0 }, { 0, 0 }, sch_webcontent, sch_healthtopiccontent },
    {   { 2, 0 }, { 0, 0 }, sch_webpage, sch_aboutpage },
    {   { 2, 0 }, { 0, 0 }, sch_webpage, sch_checkoutpage },
    {   { 2, 0 }, { 0, 0 }, sch_webpage, sch_collectionpage },
    {   { 2, 0 }, { 0, 0 }, sch_webpage, sch_contactpage },
    {   { 3, 5 }, { 0, 0 }, sch_webpage, sch_faqpage },
    {   { 2, 0 }, { 0, 0 }, sch_webpage, sch_itempage },
    {   { 2, 0 }, { 2, 1 }, sch_webpage, sch_medicalwebpage },
    {   { 3, 5 }, { 0, 0 }, sch_webpage, sch_medicalwebpage },
    {   { 2, 0 }, { 0, 0 }, sch_webpage, sch_profilepage },
    {   { 2, 0 }, { 0, 0 }, sch_webpage, sch_qapage },
    {   { 4, 0 }, { 0, 0 }, sch_webpage, sch_realestatelisting },
    {   { 2, 0 }, { 0, 0 }, sch_webpage, sch_searchresultspage },
    {   { 2, 0 }, { 0, 0 }, sch_webpageelement, sch_sitenavigationelement },
    {   { 2, 0 }, { 0, 0 }, sch_webpageelement, sch_table },
    {   { 2, 0 }, { 0, 0 }, sch_webpageelement, sch_wpadblock },
    {   { 2, 0 }, { 0, 0 }, sch_webpageelement, sch_wpfooter },
    {   { 2, 0 }, { 0, 0 }, sch_webpageelement, sch_wpheader },
    {   { 2, 0 }, { 0, 0 }, sch_webpageelement, sch_wpsidebar },
    {   { 0, 0 }, { 0, 0 }, sch_illegal, sch_illegal } };

typedef ssc_mm < e_schema, microdata_hierachy* > vmap_t;
typedef ssc_mm < e_schema, e_schema > vss_t;
vmap_t hierarchy;
vss_t generalisations;

void hierarchy_init (nitpick& nits)
{   assert (hierarchy.empty ());
    for (::std::size_t x = 0; schema_hierarchy [x].general_ != sch_illegal; ++x)
    {   hierarchy.insert (vmap_t::value_type (schema_hierarchy [x].general_, &schema_hierarchy [x]));
        if (generalisations.find (schema_hierarchy [x].specific_) != generalisations.cend ())
            for (vmap_t::const_iterator vi = hierarchy.find (schema_hierarchy [x].general_); (vi != hierarchy.cend ()) && (vi -> first == schema_hierarchy [x].general_); ++vi)
                if (vi -> second != nullptr)
                    if ((vi -> second -> specific_ == schema_hierarchy [x].specific_) && (vi -> second -> general_ != schema_hierarchy [x].general_))
                        if (overlap (schema_hierarchy [x].from_, schema_hierarchy [x].to_, vi -> second -> from_, vi -> second -> to_))
                            nits.pick (nit_schema_hierarchy, es_catastrophic, ec_microdata, "multiple generalisations for ", sch::name (schema_hierarchy [x].specific_), " (", schema_hierarchy [x].specific_, ")");
        generalisations.emplace (vss_t::value_type (schema_hierarchy [x].specific_, schema_hierarchy [x].general_)); } }

void int_generalise  (const schema_version& v, const e_schema s, ssch_t& ssch)
{   ssch.insert (s);
    for (vss_t::const_iterator i = generalisations.find (s); (i != generalisations.cend ()) && (i -> first == s); ++i)
        if (ssch.find (i -> second) == ssch.cend ())
            for (vmap_t::const_iterator vi = hierarchy.find (i -> second); (vi != hierarchy.cend ()) && (vi -> first == i -> second); ++vi)
                if (vi -> second != nullptr)
                    if (vi -> second -> specific_ == s)
                        if (does_apply (v, vi -> second -> from_, vi -> second -> to_))
                            int_generalise (v, i -> second, ssch); }

ssch_t generalise (const schema_version& v, const e_schema s)
{   ssch_t res;
    int_generalise (v, s, res);
    return res; }

bool is_specific_type_of (const schema_version& , const e_schema general, const e_schema specific)
{   for (vss_t::const_iterator x = generalisations.find (specific); x != generalisations.cend (); x = generalisations.find (x -> second))
        if (x -> second == general) return true;
    return false; }

