/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "context.h"
#include "schema_type.h"
#include "quote.h"

bool is_schema_domain (const ::std::string& d)
{   return compare_no_case (d, "Schema.org"); }

#define SF_ENUMERATION          0x10000000
#define SF_EXTERNAL_ENUMERATION 0x20000000
#define SF_SIMPLE_MASK          0x0FFFFFFF
#define SF_NO_SIMPLE_TYPE       0
#define MAKE_SIMPLE_TYPE(T)     static_cast < uint64_t > (T)

struct symbol_entry < e_schema > schema_symbol_table [] =
{   { { 2, 0 }, { 0, 0 }, "APIReference", sch_apireference },
    { { 3, 5 }, { 0, 0 }, "3DModel", sch_3dmodel },
    { { 3, 6 }, { 6, 0 }, "Abdomen", sch_abdomen },
    { { 2, 0 }, { 0, 0 }, "AboutPage", sch_aboutpage },
    { { 2, 0 }, { 0, 0 }, "AcceptAction", sch_acceptaction },
    { { 3, 1 }, { 0, 0 }, "Accommodation", sch_accommodation },
    { { 2, 0 }, { 0, 0 }, "AccountingService", sch_accountingservice },
    { { 2, 0 }, { 0, 0 }, "AchieveAction", sch_achieveaction },
    { { 2, 0 }, { 0, 0 }, "Action", sch_action },
    { { 3, 5 }, { 0, 0 }, "ActionAccessSpecification", sch_actionaccessspecification },
    { { 2, 0 }, { 0, 0 }, "ActionStatusType", sch_actionstatustype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "ActivateAction", sch_activateaction },
    { { 3, 5 }, { 0, 0 }, "ActiveActionStatus", sch_activeactionstatus },
    { { 3, 6 }, { 6, 0 }, "ActiveNotRecruiting", sch_activenotrecruiting },
    { { 2, 0 }, { 0, 0 }, "AddAction", sch_addaction },
    { { 2, 0 }, { 0, 0 }, "AdministrativeArea", sch_administrativearea },
    { { 2, 0 }, { 0, 0 }, "AdultEntertainment", sch_adultentertainment },
    { { 3, 5 }, { 0, 0 }, "AdvertiserContentArticle", sch_advertisercontentarticle },
    { { 3, 5 }, { 0, 0 }, "AerobicActivity", sch_aerobicactivity },
    { { 2, 0 }, { 0, 0 }, "AggregateOffer", sch_aggregateoffer },
    { { 2, 0 }, { 0, 0 }, "AggregateRating", sch_aggregaterating },
    { { 2, 0 }, { 0, 0 }, "AgreeAction", sch_agreeaction },
    { { 2, 0 }, { 0, 0 }, "Airline", sch_airline },
    { { 2, 0 }, { 0, 0 }, "Airport", sch_airport },
    { { 3, 5 }, { 0, 0 }, "AlbumRelease", sch_albumrelease },
    { { 2, 0 }, { 0, 0 }, "AlignmentObject", sch_alignmentobject },
    { { 2, 0 }, { 0, 0 }, "AllocateAction", sch_allocateaction },
    { { 3, 6 }, { 6, 0 }, "AllWheelDriveConfiguration", sch_allwheeldriveconfiguration },
    { { 3, 5 }, { 0, 0 }, "AMRadioChannel", sch_amradiochannel },
    { { 2, 0 }, { 0, 0 }, "AmusementPark", sch_amusementpark },
    { { 3, 5 }, { 0, 0 }, "AnaerobicActivity", sch_anaerobicactivity },
    { { 3, 5 }, { 0, 0 }, "AnalysisNewsArticle", sch_analysisnewsarticle },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "AnatomicalStructure", sch_anatomicalstructure },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "AnatomicalSystem", sch_anatomicalsystem },
    { { 3, 6 }, { 6, 0 }, "Anesthesia", sch_anaesthesia },
    { { 2, 0 }, { 0, 0 }, "Animalshelter", sch_animalshelter },
    { { 2, 0 }, { 0, 0 }, "Answer", sch_answer },
    { { 3, 1 }, { 0, 0 }, "Apartment", sch_apartment },
    { { 2, 0 }, { 0, 0 }, "Apartmentcomplex", sch_apartmentcomplex },
    { { 3, 6 }, { 6, 0 }, "Appearance", sch_appearance },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "AppendAction", sch_appendaction },
    { { 2, 0 }, { 0, 0 }, "ApplyAction", sch_applyaction },
    { { 2, 0 }, { 0, 0 }, "ApprovedIndication", sch_approvedindication },
    { { 2, 0 }, { 0, 0 }, "Aquarium", sch_aquarium },
    { { 3, 5 }, { 0, 0 }, "ArchiveComponent", sch_archivecomponent },
    { { 3, 5 }, { 0, 0 }, "ArchiveOrganization", sch_archiveorganisation },
    { { 2, 0 }, { 0, 0 }, "ArriveAction", sch_arriveaction },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Artery", sch_artery },
    { { 2, 0 }, { 0, 0 }, "ArtGallery", sch_artgallery },
    { { 2, 0 }, { 0, 0 }, "Article", sch_article },
    { { 2, 0 }, { 0, 0 }, "AskAction", sch_askaction },
    { { 3, 5 }, { 0, 0 }, "AskPublicNewsArticle", sch_askpublicnewsarticle },
    { { 2, 0 }, { 0, 0 }, "AssessAction", sch_assessaction },
    { { 2, 0 }, { 0, 0 }, "AssignAction", sch_assignaction },
    { { 3, 5 }, { 0, 0 }, "Atlas", sch_atlas },
    { { 2, 0 }, { 0, 0 }, "Attorney", sch_attorney },
    { { 2, 0 }, { 0, 0 }, "Audience", sch_audience },
    { { 3, 5 }, { 0, 0 }, "Audiobook", sch_audiobook },
    { { 3, 5 }, { 0, 0 }, "AudiobookFormat", sch_audiobookformat },
    { { 2, 0 }, { 0, 0 }, "AudioObject", sch_audioobject },
    { { 7, 0 }, { 0, 0 }, "AuthenticContent", sch_authenticcontent },
    { { 3, 5 }, { 0, 0 }, "AuthoritativeLegalValue", sch_authoritativelegalvalue },
    { { 2, 0 }, { 0, 0 }, "AuthorizeAction", sch_authoriseaction },
    { { 2, 0 }, { 0, 0 }, "AutoBodyShop", sch_autobodyshop },
    { { 2, 0 }, { 0, 0 }, "AutoDealer", sch_autodealer },
    { { 2, 0 }, { 0, 0 }, "AutomatedTeller", sch_automatedteller },
    { { 2, 0 }, { 0, 0 }, "AutomotiveBusiness", sch_automotivebusiness },
    { { 2, 0 }, { 0, 0 }, "AutoPartsStore", sch_autopartsstore },
    { { 2, 0 }, { 0, 0 }, "AutoRental", sch_autorental },
    { { 2, 0 }, { 0, 0 }, "AutoRepair", sch_autorepair },
    { { 2, 0 }, { 0, 0 }, "AutoWash", sch_autowash },
    { { 3, 6 }, { 6, 0 }, "Ayurvedic", sch_pixiegiven },
    { { 3, 5 }, { 0, 0 }, "BackgroundNewsArticle", sch_backgroundnewsarticle },
    { { 3, 6 }, { 6, 0 }, "Bacteria", sch_bacteria },
    { { 2, 0 }, { 0, 0 }, "Bakery", sch_bakery },
    { { 3, 5 }, { 0, 0 }, "Balance", sch_balance },
    { { 3, 0 }, { 0, 0 }, "BankAccount", sch_bankaccount },
    { { 2, 0 }, { 0, 0 }, "BankOrCreditUnion", sch_bankorcreditunion },
    { { 2, 2 }, { 0, 0 }, "BarCode", sch_barcode },
    { { 2, 0 }, { 0, 0 }, "BarOrPub", sch_barorpub },
    { { 7, 4 }, { 0, 0 }, "BasicIncome", sch_basicincome },
    { { 2, 0 }, { 0, 0 }, "Beach", sch_beach },
    { { 2, 0 }, { 0, 0 }, "BeautySalon", sch_beautysalon },
    { { 2, 0 }, { 0, 0 }, "BedAndBreakfast", sch_bedandbreakfast },
    { { 3, 1 }, { 0, 0 }, "BedDetails", sch_beddetails },
    { { 3, 5 }, { 0, 0 }, "BedType", sch_bedtype },
    { { 2, 0 }, { 0, 0 }, "BefriendAction", sch_befriendaction },
    { { 5, 0 }, { 0, 0 }, "BenefitsHealthAspect", sch_benefitshealthaspect },
    { { 2, 0 }, { 0, 0 }, "BikeStore", sch_bikestore },
    { { 2, 0 }, { 0, 0 }, "Blog", sch_blog },
    { { 2, 0 }, { 0, 0 }, "BlogPosting", sch_blogposting },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "BloodTest", sch_bloodtest },
    { { 2, 0 }, { 0, 0 }, "BoardingPolicyType", sch_boardingpolicytype, ns_default, SF_ENUMERATION },
    { { 9, 0 }, { 0, 0 }, "BoatReservation", sch_boatreservation },
    { { 9, 0 }, { 0, 0 }, "BoatTerminal", sch_boatterminal },
    { { 9, 0 }, { 0, 0 }, "BoatTrip", sch_boattrip },
    { { 2, 0 }, { 0, 0 }, "BodyOfWater", sch_bodyofwater },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Bone", sch_bone },
    { { 2, 0 }, { 0, 0 }, "Book", sch_book },
    { { 2, 0 }, { 0, 0 }, "BookFormatType", sch_bookformattype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "BookMarkAction", sch_bookmarkaction },
    { { 2, 0 }, { 0, 0 }, "BookSeries", sch_bookseries },
    { { 2, 0 }, { 0, 0 }, "BookStore", sch_bookstore },
    { { 2, 0 }, { 0, 0 }, "Boolean", sch_boolean, ns_default, SF_ENUMERATION | MAKE_SIMPLE_TYPE (t_bool) },
    { { 2, 0 }, { 0, 0 }, "BorrowAction", sch_borrowaction },
    { { 2, 0 }, { 0, 0 }, "BowlingAlley", sch_bowlingalley },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "BrainStructure", sch_brainstructure },
    { { 2, 0 }, { 0, 0 }, "Brand", sch_brand },
    { { 2, 0 }, { 0, 0 }, "BreadCrumblist", sch_breadcrumblist },
    { { 2, 0 }, { 0, 0 }, "Brewery", sch_brewery },
    { { 2, 1 }, { 0, 0 }, "Bridge", sch_bridge },
    { { 2, 0 }, { 0, 0 }, "BroadcastChannel", sch_broadcastchannel },
    { { 2, 0 }, { 0, 0 }, "BroadcastEvent", sch_broadcastevent },
    { { 3, 5 }, { 0, 0 }, "BroadcastFrequencySpecification", sch_broadcastfrequencyspecification },
    { { 3, 5 }, { 0, 0 }, "BroadcastRelease", sch_broadcastrelease },
    { { 2, 0 }, { 0, 0 }, "BroadcastService", sch_broadcastservice },
    { { 3, 5 }, { 0, 0 }, "BrokerageAccount", sch_brokerageaccount },
    { { 2, 0 }, { 0, 0 }, "BuddhistTemple", sch_buddhisttemple },
    { { 2, 0 }, { 0, 0 }, "BusinessAudience", sch_businessaudience },
    { { 2, 0 }, { 0, 0 }, "BusinessEntityType", sch_businessentitytype, ns_default, SF_EXTERNAL_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "BusinessEvent", sch_businessevent },
    { { 2, 0 }, { 0, 0 }, "BusinessFunction", sch_businessfunction, ns_default, SF_EXTERNAL_ENUMERATION },
    { { 7, 4 }, { 0, 0 }, "BusinessSupport", sch_businesssupport },
    { { 3, 5 }, { 0, 0 }, "BusOrCoach", sch_busorcoach },
    { { 2, 0 }, { 0, 0 }, "BusReservation", sch_busreservation },
    { { 2, 0 }, { 0, 0 }, "BusStation", sch_busstation },
    { { 2, 0 }, { 0, 0 }, "BusStop", sch_busstop },
    { { 2, 0 }, { 0, 0 }, "BusTrip", sch_bustrip },
    { { 2, 0 }, { 0, 0 }, "BuyAction", sch_buyaction },
    { { 2, 0 }, { 0, 0 }, "CableOrSatelliteService", sch_cableorsatelliteservice },
    { { 2, 0 }, { 0, 0 }, "CafeOrCoffeeShop", sch_cafeorcoffeeshop },
    { { 2, 0 }, { 0, 0 }, "Campground", sch_campground },
    { { 3, 1 }, { 0, 0 }, "CampingPitch", sch_campingpitch },
    { { 2, 0 }, { 0, 0 }, "Canal", sch_canal },
    { { 2, 0 }, { 0, 0 }, "CancelAction", sch_cancelaction },
    { { 2, 0 }, { 0, 0 }, "Car", sch_car },
    { { 3, 6 }, { 6, 0 }, "Cardiovascular", sch_cardiovascular },
    { { 3, 6 }, { 6, 0 }, "CardiovascularExam", sch_cardiovascularexam },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "CarUsageType", sch_carusagetype, ns_default, SF_ENUMERATION },
    { { 3, 6 }, { 6, 0 }, "CaseSeries", sch_caseseries },
    { { 2, 0 }, { 0, 0 }, "Casino", sch_casino },
    { { 3, 5 }, { 0, 0 }, "CassetteFormat", sch_cassetteformat },
    { { 3, 5 }, { 0, 0 }, "CategoryCode", sch_categorycode },
    { { 3, 5 }, { 0, 0 }, "CategoryCodeSet", sch_categorycodeset },
    { { 2, 0 }, { 0, 0 }, "CatholicChurch", sch_catholicchurch },
    { { 5, 0 }, { 0, 0 }, "CausesHealthAspect", sch_causeshealthaspect },
    { { 7, 3 }, { 0, 0 }, "CDCPMDRecord", sch_cdcpmdrecord },
    { { 3, 5 }, { 0, 0 }, "CDFormat", sch_cdformat },
    { { 2, 0 }, { 0, 0 }, "Cemetery", sch_cemetery },
    { { 3, 5 }, { 0, 0 }, "Chapter", sch_chapter },
    { { 9, 0 }, { 0, 0 }, "CharitableIncorporatedOrganization", sch_charitableincorporatedorganization },
    { { 2, 0 }, { 0, 0 }, "CheckSction", sch_checkaction },
    { { 2, 0 }, { 0, 0 }, "CheckInAction", sch_checkinaction },
    { { 2, 0 }, { 0, 0 }, "CheckOutAction", sch_checkoutaction },
    { { 2, 0 }, { 0, 0 }, "CheckOutPage", sch_checkoutpage },
    { { 2, 0 }, { 0, 0 }, "ChildCare", sch_childcare },
    { { 2, 0 }, { 0, 0 }, "ChildrensEvent", sch_childrensevent },
    { { 3, 6 }, { 6, 0 }, "Chiropractic", sch_harmful },
    { { 2, 0 }, { 0, 0 }, "ChooseAction", sch_chooseaction },
    { { 2, 0 }, { 0, 0 }, "Church", sch_church },
    { { 2, 0 }, { 0, 0 }, "City", sch_city },
    { { 2, 0 }, { 0, 0 }, "CityHall", sch_cityhall },
    { { 2, 0 }, { 0, 0 }, "CivicStructure", sch_civicstructure },
    { { 3, 5 }, { 0, 0 }, "Claim", sch_claim },
    { { 3, 2 }, { 0, 0 }, "ClaimReview", sch_claimreview },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Class", sch_class },
    { { 3, 6 }, { 6, 0 }, "Clinician", sch_clinician },
    { { 2, 0 }, { 0, 0 }, "Clip", sch_clip },
    { { 2, 0 }, { 0, 0 }, "ClothingStore", sch_clothingstore },
    { { 2, 0 }, { 2, 1 }, "Code", sch_code },
    { { 3, 6 }, { 6, 0 }, "CohortStudy", sch_cohortstudy },
    { { 3, 5 }, { 0, 0 }, "Collection", sch_collection },
    { { 2, 0 }, { 0, 0 }, "CollectionPage", sch_collectionpage },
    { { 2, 0 }, { 0, 0 }, "CollegeOrUniversity", sch_collegeoruniversity },
    { { 2, 0 }, { 0, 0 }, "ComedyClub", sch_comedyclub },
    { { 2, 0 }, { 0, 0 }, "ComedyEvent", sch_comedyevent },
    { { 3, 5 }, { 0, 0 }, "ComicCoverArt", sch_comiccoverart },
    { { 3, 5 }, { 0, 0 }, "ComicIssue", sch_comicissue },
    { { 3, 5 }, { 0, 0 }, "ComicSeries", sch_comicseries },
    { { 3, 5 }, { 0, 0 }, "ComicStory", sch_comicstory },
    { { 2, 0 }, { 0, 0 }, "Comment", sch_comment },
    { { 2, 0 }, { 0, 0 }, "CommentAction", sch_commentaction },
    { { 3, 5 }, { 0, 0 }, "CommentPermission", sch_commentpermission },
    { { 2, 0 }, { 0, 0 }, "CommunicateAction", sch_communicateaction },
    { { 3, 5 }, { 0, 0 }, "CommunityHealth", sch_communityhealth },
    { { 3, 5 }, { 0, 0 }, "CompilationAlbum", sch_compilationalbum },
    { { 3, 6 }, { 6, 0 }, "Completed", sch_completed },
    { { 3, 5 }, { 0, 0 }, "CompletedActionStatus", sch_completedactionstatus },
    { { 3, 5 }, { 0, 0 }, "CompleteDatafeed", sch_completedatafeed },
    { { 3, 0 }, { 0, 0 }, "CompoundPriceSpecification", sch_compoundpricespecification },
    { { 3, 0 }, { 0, 0 }, "ComputerLanguage", sch_computerlanguage },
    { { 2, 0 }, { 0, 0 }, "ComputerStore", sch_computerstore },
    { { 2, 0 }, { 0, 0 }, "ConfirmAction", sch_confirmaction },
    { { 3, 5 }, { 0, 0 }, "Consortium", sch_consortium },
    { { 2, 0 }, { 0, 0 }, "ConsumeAction", sch_consumeaction },
    { { 2, 0 }, { 0, 0 }, "ContactPage", sch_contactpage },
    { { 2, 0 }, { 0, 0 }, "ContactPoint", sch_contactpoint },
    { { 2, 0 }, { 0, 0 }, "ContactPointOption", sch_contactpointoption, ns_default, SF_ENUMERATION },
    { { 5, 0 }, { 0, 0 }, "ContagiousnessHealthAspect", sch_contagiousnesshealthaspect },
    { { 2, 0 }, { 0, 0 }, "Continent", sch_continent },
    { { 2, 0 }, { 0, 0 }, "ControlAction", sch_controlaction },
    { { 2, 0 }, { 0, 0 }, "ConvenienceStore", sch_conveniencestore },
    { { 3, 0 }, { 0, 0 }, "Conversation", sch_conversation },
    { { 2, 0 }, { 0, 0 }, "CookAction", sch_cookaction },
    { { 3, 5 }, { 0, 0 }, "Coop", sch_coop },
    { { 2, 0 }, { 0, 0 }, "Corporation", sch_corporation },
    { { 3, 5 }, { 0, 0 }, "CorrectionComment", sch_correctioncomment },
    { { 2, 0 }, { 0, 0 }, "Country", sch_country },
    { { 3, 2 }, { 0, 0 }, "Course", sch_course },
    { { 3, 2 }, { 0, 0 }, "CourseInstance", sch_courseinstance },
    { { 2, 0 }, { 0, 0 }, "CourtHouse", sch_courthouse },
    { { 3, 5 }, { 0, 0 }, "CoverArt", sch_coverart },
    { { 7, 0 }, { 0, 0 }, "CovidTestingFacility", sch_covidtestingfacility },
    { { 2, 0 }, { 0, 0 }, "Createaction", sch_createaction },
    { { 2, 0 }, { 0, 0 }, "CreativeWork", sch_creativework },
    { { 2, 0 }, { 0, 0 }, "CreativeWorkSeason", sch_creativeworkseason },
    { { 2, 0 }, { 0, 0 }, "CreativeWorkSeries", sch_creativeworkseries },
    { { 2, 0 }, { 0, 0 }, "CreditCard", sch_creditcard },
    { { 2, 0 }, { 0, 0 }, "Crematorium", sch_crematorium },
    { { 3, 5 }, { 0, 0 }, "CriticReview", sch_criticreview },
    { { 3, 6 }, { 6, 0 }, "CrossSectional", sch_crosssectional },
    { { 3, 5 }, { 0, 0 }, "CssSelectorType", sch_cssselectortype },
    { { 3, 6 }, { 6, 0 }, "CT", sch_ct },
    { { 3, 1 }, { 0, 0 }, "CurrencyConversionService", sch_currencyconversionservice },
    { { 3, 5 }, { 0, 0 }, "DamagedCondition", sch_damagedcondition },
    { { 2, 0 }, { 0, 0 }, "DanceEvent", sch_danceevent },
    { { 2, 0 }, { 0, 0 }, "DanceGroup", sch_dancegroup },
    { { 2, 0 }, { 0, 0 }, "DataCatalog", sch_datacatalogue },
    { { 2, 0 }, { 0, 0 }, "DataDownload", sch_datadownload },
    { { 3, 0 }, { 0, 0 }, "DataFeed", sch_datafeed },
    { { 3, 0 }, { 0, 0 }, "DataFeedItem", sch_datafeeditem },
    { { 2, 0 }, { 0, 0 }, "Dataset", sch_dataset },
    { { 2, 0 }, { 0, 0 }, "DataType", sch_datatype },
    { { 2, 0 }, { 0, 0 }, "Date", sch_date, ns_default, MAKE_SIMPLE_TYPE (t_just_date) },
    { { 2, 0 }, { 3, 4 }, "DatedMoneySpecification", sch_datedmoneyspecification },
    { { 2, 0 }, { 0, 0 }, "DateTime", sch_datetime, ns_default, MAKE_SIMPLE_TYPE (t_datetime) },
    { { 2, 0 }, { 0, 0 }, "DayOfWeek", sch_dayofweek, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "DaySpa", sch_dayspa },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DDxElement", sch_ddxelement },
    { { 2, 0 }, { 0, 0 }, "DeactivateAction", sch_deactivateaction },
    { { 2, 0 }, { 0, 0 }, "DefenceEstablishment", sch_defenceestablishment },
    { { 7, 4 }, { 0, 0 }, "DefinedRegion", sch_definedregion },
    { { 3, 5 }, { 0, 0 }, "DefinedTerm", sch_definedterm },
    { { 3, 5 }, { 0, 0 }, "DefinedTermSet", sch_definedtermset },
    { { 3, 5 }, { 0, 0 }, "DefinitiveLegalValue", sch_definitivelegalvalue },
    { { 2, 0 }, { 0, 0 }, "DeleteAction", sch_deleteaction },
    { { 2, 0 }, { 0, 0 }, "DeliveryChargeSpecification", sch_deliverychargespecification },
    { { 2, 0 }, { 0, 0 }, "DeliveryEvent", sch_deliveryevent },
    { { 2, 0 }, { 0, 0 }, "DeliveryMethod", sch_deliverymethod, ns_default, SF_ENUMERATION },
    { { 8, 0 }, { 0, 0 }, "DeliveryTimeSettings", sch_deliverytimesettings },
    { { 2, 0 }, { 0, 0 }, "Demand", sch_demand },
    { { 3, 5 }, { 0, 0 }, "DemoAlbum", sch_demoalbum },
    { { 2, 0 }, { 0, 0 }, "Dentist", sch_dentist },
    { { 3, 6 }, { 6, 0 }, "Dentistry", sch_dentistry },
    { { 2, 0 }, { 0, 0 }, "DepartAction", sch_departaction },
    { { 2, 0 }, { 0, 0 }, "DepartmentStore", sch_departmentstore },
    { { 3, 0 }, { 0, 0 }, "DepositAccount", sch_depositaccount },
    { { 3, 5 }, { 0, 0 }, "Dermatology", sch_dermatology },
    { { 3, 5 }, { 0, 0 }, "DiabeticDiet", sch_diabeticdiet },
    { { 3, 6 }, { 6, 0 }, "Diagnostic", sch_diagnostic },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DiagnosticLab", sch_diagnosticlab },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DiagnosticProcedure", sch_diagnosticprocedure },
    { { 2, 0 }, { 0, 0 }, "Diet", sch_diet },
    { { 2, 0 }, { 0, 0 }, "DietarySupplement", sch_dietarysupplement },
    { { 3, 5 }, { 0, 0 }, "DietNutrition", sch_dietnutrition },
    { { 3, 5 }, { 0, 0 }, "DigitalAudioTapeFormat", sch_digitalaudiotapeformat },
    { { 3, 0 }, { 0, 0 }, "DigitalDocument", sch_digitaldocument },
    { { 3, 0 }, { 0, 0 }, "DigitalDocumentPermission", sch_digitaldocumentpermission },
    { { 3, 0 }, { 0, 0 }, "DigitalDocumentPermissionType", sch_digitaldocumentpermissiontype, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "DigitalFormat", sch_digitalformat },
    { { 7, 4 }, { 0, 0 }, "DisabilitySupport", sch_disabilitysupport },
    { { 2, 0 }, { 0, 0 }, "DisagreeAction", sch_disagreeaction },
    { { 3, 5 }, { 0, 0 }, "Discontinued", sch_discontinued },
    { { 2, 0 }, { 0, 0 }, "DiscoverAction", sch_discoveraction },
    { { 2, 1 }, { 0, 0 }, "DiscussionForumPosting", sch_discussionforumposting },
    { { 2, 0 }, { 0, 0 }, "DislikeAction", sch_dislikeaction },
    { { 2, 0 }, { 0, 0 }, "Distance", sch_distance },
    { { 3, 5 }, { 0, 0 }, "Distillery", sch_distillery },
    { { 3, 5 }, { 0, 0 }, "DJMixAlbum", sch_djmixalbum },
    { { 2, 0 }, { 0, 0 }, "DonateAction", sch_donateaction },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DoseSchedule", sch_doseschedule },
    { { 3, 5 }, { 0, 0 }, "DoubleBlindedTrial", sch_doubleblindedtrial },
    { { 2, 0 }, { 0, 0 }, "DownloadaAtion", sch_downloadaction },
    { { 2, 0 }, { 0, 0 }, "DrawAction", sch_drawaction },
    { { 3, 5 }, { 0, 0 }, "Drawing", sch_drawing },
    { { 2, 0 }, { 0, 0 }, "DrinkAction", sch_drinkaction },
    { { 2, 0 }, { 0, 0 }, "DriveWheelConfigurationValue", sch_drivewheelconfigurationvalue, ns_default, SF_ENUMERATION },
    { { 3, 6 }, { 6, 0 }, "DrivingSchoolVehicleUsage", sch_drivingschoolvehicleusage },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Drug", sch_drug },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DrugClass", sch_drugclass },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DrugCost", sch_drugcost },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DrugCostCategory", sch_drugcostcategory, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DrugLegalStatus", sch_druglegalstatus },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DrugPregnancyCategory", sch_drugpregnancycategory, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DrugPrescriptionStatus", sch_drugprescriptionstatus },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "DrugStrength", sch_drugstrength },
    { { 2, 0 }, { 0, 0 }, "DryCleaningOrLaundry", sch_drycleaningorlaundry },
    { { 2, 0 }, { 0, 0 }, "Duration", sch_duration,  ns_default, MAKE_SIMPLE_TYPE (t_duration) },
    { { 3, 5 }, { 0, 0 }, "DVDFormat", sch_dvdformat },
    { { 3, 6 }, { 6, 0 }, "Ear", sch_ear },
    { { 2, 0 }, { 0, 0 }, "Eataction", sch_eataction },
    { { 3, 5 }, { 0, 0 }, "EBook", sch_ebook },
    { { 2, 0 }, { 0, 0 }, "EducationalAudience", sch_educationalaudience },
    { { 3, 5 }, { 0, 0 }, "EducationalOccupationalCredential", sch_educationaloccupationalcredential },
    { { 3, 9 }, { 0, 0 }, "EducationalOccupationalProgram", sch_educationaloccupationalprogramme },
    { { 2, 0 }, { 0, 0 }, "EducationalOrganization", sch_educationalorganisation },
    { { 2, 0 }, { 0, 0 }, "EducationEvent", sch_educationevent },
    { { 2, 0 }, { 0, 0 }, "Electrician", sch_electrician },
    { { 2, 0 }, { 0, 0 }, "ElectronicsStore", sch_electronicsstore },
    { { 2, 0 }, { 0, 0 }, "ElementarySchool", sch_elementaryschool },
    { { 2, 0 }, { 0, 0 }, "EmailMessage", sch_emailmessage },
    { { 2, 0 }, { 0, 0 }, "Embassy", sch_embassy },
    { { 3, 5 }, { 0, 0 }, "Emergency", sch_emergency },
    { { 2, 0 }, { 0, 0 }, "EmergencyService", sch_emergencyservice },
    { { 2, 0 }, { 0, 0 }, "EmployeeRole", sch_employeerole },
    { { 3, 5 }, { 0, 0 }, "EmployerAggregateRating", sch_employeraggregaterating },
    { { 3, 5 }, { 0, 0 }, "EmployerReview", sch_employerreview },
    { { 2, 0 }, { 0, 0 }, "EmploymentAgency", sch_employmentagency },
    { { 3, 6 }, { 6, 0 }, "Endocrine", sch_endocrine },
    { { 2, 0 }, { 0, 0 }, "EndorseAction", sch_endorseaction },
    { { 3, 5 }, { 0, 0 }, "EndorsementRating", sch_endorsementrating },
    { { 2, 0 }, { 0, 0 }, "Energy", sch_energy },
    { { 10, 0 }, { 0, 0 }, "EnergyConsumptionDetails", sch_energyconsumptiondetails },
    { { 10, 0 }, { 0, 0 }, "EnergyEfficiencyEnumeration", sch_energyefficiencyenumeration, ns_default, SF_ENUMERATION },
    { { 10, 0 }, { 0, 0 }, "EnergyStarCertified", sch_energystarcertified },
    { { 2, 0 }, { 0, 0 }, "EngineSpecification", sch_enginespecification },
    { { 3, 6 }, { 6, 0 }, "EnrollingByInvitation", sch_enrollingbyinvitation },
    { { 2, 0 }, { 0, 0 }, "EntertainmentBusiness", sch_entertainmentbusiness },
    { { 2, 0 }, { 0, 0 }, "EntryPoint", sch_entrypoint },
    { { 2, 0 }, { 0, 0 }, "Enumeration", sch_enumeration },
    { { 2, 0 }, { 0, 0 }, "Episode", sch_episode },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryA", sch_euenergyefficiencycategorya },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryA1Plus", sch_euenergyefficiencycategorya1plus },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryA2Plus", sch_euenergyefficiencycategorya2plus },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryA3Plus", sch_euenergyefficiencycategorya3plus },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryB", sch_euenergyefficiencycategoryb },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryC", sch_euenergyefficiencycategoryc },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryD", sch_euenergyefficiencycategoryd },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryE", sch_euenergyefficiencycategorye },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryF", sch_euenergyefficiencycategoryf },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyCategoryG", sch_euenergyefficiencycategoryg },
    { { 10, 0 }, { 0, 0 }, "EUEnergyEfficiencyEnumeration", sch_euenergyefficiencyenumeration, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "EPRelease", sch_eprelease },
    { { 2, 0 }, { 0, 0 }, "Event", sch_event },
    { { 7, 0 }, { 0, 0 }, "EventAttendanceModeEnumeration", sch_eventattendancemodeenumeration, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "EventCancelled", sch_eventcancelled },
    { { 7, 0 }, { 0, 0 }, "EventMovedOnline", sch_eventmovedonline },
    { { 3, 5 }, { 0, 0 }, "EventPostponed", sch_eventpostponed },
    { { 3, 5 }, { 0, 0 }, "EventRescheduled", sch_eventrescheduled },
    { { 2, 0 }, { 0, 0 }, "EventReservation", sch_eventreservation },
    { { 3, 5 }, { 0, 0 }, "EventScheduled", sch_eventscheduled },
    { { 3, 5 }, { 0, 0 }, "EventSeries", sch_eventseries },
    { { 2, 0 }, { 0, 0 }, "EventStatusType", sch_eventstatustype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "EventVenue", sch_eventvenue },
    { { 3, 6 }, { 6, 0 }, "EvidenceLevelA", sch_evidencelevela },
    { { 3, 6 }, { 6, 0 }, "EvidenceLevelB", sch_evidencelevelb },
    { { 3, 6 }, { 6, 0 }, "EvidenceLevelC", sch_evidencelevelc },
    { { 3, 5 }, { 0, 0 }, "ExchangeRateSpecification", sch_exchangeratespecification },
    { { 3, 8 }, { 0, 0 }, "ExchangeRefund", sch_exchangerefund },
    { { 2, 0 }, { 0, 0 }, "ExerciseAction", sch_exerciseaction },
    { { 2, 0 }, { 0, 0 }, "ExerciseGym", sch_exercisegym },
    { { 2, 0 }, { 0, 0 }, "ExercisePlan", sch_exerciseplan },
    { { 2, 2 }, { 0, 0 }, "ExhibitionEvent", sch_exhibitionevent },
    { { 3, 6 }, { 6, 0 }, "Eye", sch_eye },
    { { 3, 5 }, { 0, 0 }, "FailedActionStatus", sch_failedactionstatus },
    { { 2, 0 }, { 0, 0 }, "False", sch_false },
    { { 3, 5 }, { 0, 0 }, "FAQPage", sch_faqpage },
    { { 2, 0 }, { 0, 0 }, "FastFoodRestaurant", sch_fastfoodrestaurant },
    { { 3, 6 }, { 6, 0 }, "FDACategoryA", sch_fdacategorya },
    { { 3, 6 }, { 6, 0 }, "FDACategoryB", sch_fdacategoryb },
    { { 3, 6 }, { 6, 0 }, "FDACategoryC", sch_fdacategoryc },
    { { 3, 6 }, { 6, 0 }, "FDACategoryD", sch_fdacategoryd },
    { { 3, 6 }, { 6, 0 }, "FDACategoryX", sch_fdacategoryx },
    { { 3, 6 }, { 6, 0 }, "FDANotEvaluated", sch_fdanotevaluated },
    { { 3, 5 }, { 0, 0 }, "Female", sch_female },
    { { 2, 0 }, { 0, 0 }, "Festival", sch_festival },
    { { 2, 0 }, { 0, 0 }, "FilmAction", sch_filmaction },
    { { 3, 0 }, { 0, 0 }, "FinancialProduct", sch_financialproduct },
    { { 2, 0 }, { 0, 0 }, "FinancialService", sch_financialservice },
    { { 2, 0 }, { 0, 0 }, "FindAction", sch_findaction },
    { { 2, 0 }, { 0, 0 }, "FireStation", sch_firestation },
    { { 3, 5 }, { 0, 0 }, "Flexibility", sch_flexibility },
    { { 2, 0 }, { 0, 0 }, "Flight", sch_flight },
    { { 2, 0 }, { 0, 0 }, "FlightReservation", sch_flightreservation },
    { { 2, 0 }, { 0, 0 }, "Float", sch_float, ns_default, MAKE_SIMPLE_TYPE (t_real) },
    { { 6, 0 }, { 0, 0 }, "FloorPlan", sch_floorplan },
    { { 2, 0 }, { 0, 0 }, "Florist", sch_florist },
    { { 3, 5 }, { 0, 0 }, "FMRadioChannel", sch_fmradiochannel },
    { { 2, 0 }, { 0, 0 }, "Followaction", sch_followaction },
    { { 2, 0 }, { 0, 0 }, "FoodEstablishment", sch_foodestablishment },
    { { 2, 0 }, { 0, 0 }, "FoodEstablishmentReservation", sch_foodestablishmentreservation },
    { { 2, 0 }, { 0, 0 }, "FoodEvent", sch_foodevent },
    { { 3, 1 }, { 0, 0 }, "FoodService", sch_foodservice },
    { { 3, 6 }, { 6, 0 }, "FourWheelDriveConfiguration", sch_fourwheeldriveconfiguration },
    { { 3, 5 }, { 0, 0 }, "Friday", sch_friday },
    { { 3, 6 }, { 6, 0 }, "FrontWheelDriveConfiguration", sch_frontwheeldriveconfiguration },
    { { 3, 8 }, { 0, 0 }, "FullRefund", sch_fullrefund },
    { { 3, 5 }, { 0, 0 }, "FundingAgency", sch_fundingagency },
    { { 3, 5 }, { 0, 0 }, "FundingScheme", sch_fundingscheme },
    { { 3, 6 }, { 6, 0 }, "Fungus", sch_fungus },
    { { 2, 0 }, { 0, 0 }, "FurnitureStore", sch_furniturestore },
    { { 2, 0 }, { 0, 0 }, "Game", sch_game },
    { { 2, 0 }, { 0, 0 }, "GamePlayMode", sch_gameplaymode, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "GameServer", sch_gameserver },
    { { 2, 0 }, { 0, 0 }, "GameServerStatus", sch_gameserverstatus, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "GardenStore", sch_gardenstore },
    { { 2, 0 }, { 0, 0 }, "GasStation", sch_gasstation },
    { { 3, 6 }, { 6, 0 }, "Gastroenterologic", sch_gastroenterologic },
    { { 2, 0 }, { 0, 0 }, "GatedResidenceCommunity", sch_gatedresidencecommunity },
    { { 3, 0 }, { 0, 0 }, "GenderType", sch_gendertype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "GeneralContractor", sch_generalcontractor },
    { { 3, 6 }, { 6, 0 }, "Genetic", sch_genetic },
    { { 3, 6 }, { 6, 0 }, "Genitourinary", sch_genitourinary },
    { { 2, 2 }, { 0, 0 }, "GeoCircle", sch_geocircle },
    { { 2, 0 }, { 0, 0 }, "GeoCoordinates", sch_geocoordinates },
    { { 2, 0 }, { 0, 0 }, "GeoShape", sch_geoshape },
    { { 3, 5 }, { 0, 0 }, "GeospatialGeometry", sch_geospatialgeometry },
    { { 3, 5 }, { 0, 0 }, "Geriatric", sch_geriatric },
    { { 2, 0 }, { 0, 0 }, "GiveAction", sch_giveaction },
    { { 3, 5 }, { 0, 0 }, "GlutenFreeDiet", sch_glutenfreediet },
    { { 2, 0 }, { 0, 0 }, "GolfCourse", sch_golfcourse },
    { { 7, 4 }, { 0, 0 }, "GovernmentBenefitsType", sch_governmentbenefitstype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "GovernmentBuilding", sch_governmentbuilding },
    { { 2, 0 }, { 0, 0 }, "GovernmentOffice", sch_governmentoffice },
    { { 2, 0 }, { 0, 0 }, "GovernmentOrganization", sch_governmentorganisation },
    { { 2, 0 }, { 0, 0 }, "GovernmentPermit", sch_governmentpermit },
    { { 2, 0 }, { 0, 0 }, "Governmentservice", sch_governmentservice },
    { { 3, 5 }, { 0, 0 }, "Grant", sch_grant },
    { { 3, 5 }, { 0, 0 }, "GraphicNovel", sch_graphicnovel },
    { { 2, 0 }, { 0, 0 }, "GroceryStore", sch_grocerystore },
    { { 3, 5 }, { 0, 0 }, "GroupBoardingPolicy", sch_groupboardingpolicy },
    { { 6, 0 }, { 0, 0 }, "Guide", sch_guide },
    { { 3, 5 }, { 0, 0 }, "Gynecologic", sch_gynaecologic },
    { { 7, 4 }, { 0, 0 }, "Hackathon", sch_hackathon },
    { { 2, 0 }, { 0, 0 }, "HairSalon", sch_hairsalon },
    { { 3, 5 }, { 0, 0 }, "HalalDiet", sch_halaldiet },
    { { 3, 5 }, { 0, 0 }, "Hardcover", sch_hardcover },
    { { 2, 0 }, { 0, 0 }, "HardwareStore", sch_hardwarestore },
    { { 3, 6 }, { 6, 0 }, "Head", sch_head },
    { { 2, 0 }, { 0, 0 }, "HealthAndBeautyBusiness", sch_healthandbeautybusiness },
    { { 5, 0 }, { 0, 0 }, "HealthAspectEnumeration", sch_healthaspectenumeration, ns_default, SF_ENUMERATION },
    { { 7, 4 }, { 0, 0 }, "HealthCare", sch_healthcare },
    { { 2, 0 }, { 0, 0 }, "HealthClub", sch_healthclub },
    { { 3, 5 }, { 0, 0 }, "HealthInsurancePlan", sch_dystopianhealthinsuranceplan },
    { { 3, 5 }, { 0, 0 }, "HealthPlanCostSharingSpecification", sch_dystopianhealthplancostsharingspecification },
    { { 3, 5 }, { 0, 0 }, "HealthPlanFormulary", sch_dystopianhealthplanformulary },
    { { 3, 5 }, { 0, 0 }, "HealthPlanNetwork", sch_dystopianhealthplannetwork },
    { { 5, 0 }, { 0, 0 }, "HealthTopicContent", sch_healthtopiccontent },
    { { 3, 5 }, { 0, 0 }, "HearingImpairedSupported", sch_hearingimpairedsupported },
    { { 3, 6 }, { 6, 0 }, "Hematologic", sch_haematologic },
    { { 2, 0 }, { 0, 0 }, "HighSchool", sch_highschool },
    { { 3, 5 }, { 0, 0 }, "HinduDiet", sch_hindudiet },
    { { 2, 0 }, { 0, 0 }, "HinduTemple", sch_hindutemple },
    { { 2, 0 }, { 0, 0 }, "HobbyShop", sch_hobbyshop },
    { { 2, 0 }, { 0, 0 }, "HomeAndConstructionBusiness", sch_homeandconstructionbusiness },
    { { 2, 0 }, { 0, 0 }, "HomeGoodsStore", sch_homegoodsstore },
    { { 3, 6 }, { 6, 0 }, "Homeopathic", sch_magic },
    { { 2, 0 }, { 0, 0 }, "Hospital", sch_hospital },
    { { 2, 0 }, { 0, 0 }, "Hostel", sch_hostel },
    { { 2, 0 }, { 0, 0 }, "Hotel", sch_hotel },
    { { 3, 1 }, { 0, 0 }, "HotelRoom", sch_hotelroom },
    { { 3, 1 }, { 0, 0 }, "House", sch_house },
    { { 2, 0 }, { 0, 0 }, "HousePainter", sch_housepainter },
    { { 5, 0 }, { 0, 0 }, "Howorwherehealthaspect", sch_howorwherehealthaspect },
    { { 3, 3 }, { 0, 0 }, "HowTo", sch_howto },
    { { 3, 3 }, { 0, 0 }, "HowToDirection", sch_howtodirection },
    { { 3, 3 }, { 0, 0 }, "HowToItem", sch_howtoitem },
    { { 3, 3 }, { 0, 0 }, "HowToSection", sch_howtosection },
    { { 3, 3 }, { 0, 0 }, "HowToStep", sch_howtostep },
    { { 3, 3 }, { 0, 0 }, "HowToSupply", sch_howtosupply },
    { { 3, 3 }, { 0, 0 }, "HowToTip", sch_howtotip },
    { { 3, 3 }, { 0, 0 }, "HowToTool", sch_howtotool },
    { { 2, 0 }, { 0, 0 }, "HVACBusiness", sch_hvacbusiness },
    { { 2, 0 }, { 0, 0 }, "IceCreamShop", sch_icecreamshop },
    { { 2, 0 }, { 0, 0 }, "IgnoreAction", sch_ignoreaction },
    { { 2, 0 }, { 0, 0 }, "ImageGallery", sch_imagegallery },
    { { 2, 0 }, { 0, 0 }, "ImageObject", sch_imageobject },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "ImagingTest", sch_imagingtest },
    { { 2, 0 }, { 0, 0 }, "IndividualProduct", sch_individualproduct },
    { { 3, 6 }, { 6, 0 }, "Infectious", sch_infectious },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "InfectiousAgentClass", sch_infectiousagentclass, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "InfectiousDisease", sch_infectiousdisease },
    { { 3, 5 }, { 0, 0 }, "InForce", sch_inforce },
    { { 2, 0 }, { 0, 0 }, "InformAction", sch_informaction },
    { { 2, 0 }, { 0, 0 }, "InsertAction", sch_insertaction },
    { { 2, 0 }, { 0, 0 }, "InstallAction", sch_installaction },
    { { 3, 5 }, { 0, 0 }, "InStock", sch_instock },
    { { 3, 5 }, { 0, 0 }, "InStoreOnly", sch_instoreonly },
    { { 2, 0 }, { 0, 0 }, "InsuranceAgency", sch_insuranceagency },
    { { 2, 0 }, { 0, 0 }, "Intangible", sch_intangible },
    { { 2, 0 }, { 0, 0 }, "Integer", sch_integer, ns_default, MAKE_SIMPLE_TYPE (t_integer) },
    { { 2, 0 }, { 0, 0 }, "InteractAction", sch_interactaction },
    { { 2, 1 }, { 0, 0 }, "InteractionCounter", sch_interactioncounter },
    { { 3, 5 }, { 0, 0 }, "InternationalTrial", sch_internationaltrial },
    { { 2, 0 }, { 0, 0 }, "InternetCafe", sch_internetcafe },
    { { 3, 5 }, { 0, 0 }, "InvestmentFund", sch_investmentfund },
    { { 3, 1 }, { 0, 0 }, "InvestmentOrDeposit", sch_investmentordeposit },
    { { 2, 0 }, { 0, 0 }, "InviteAction", sch_inviteaction },
    { { 2, 0 }, { 0, 0 }, "Invoice", sch_invoice },
    { { 2, 0 }, { 0, 0 }, "ItemAvailability", sch_itemavailability, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "ItemList", sch_itemlist },
    { { 3, 5 }, { 0, 0 }, "ItemListOrderAscending", sch_itemlistorderascending },
    { { 3, 5 }, { 0, 0 }, "ItemListOrderDescending", sch_itemlistorderdescending },
    { { 2, 0 }, { 0, 0 }, "ItemListOrderType", sch_itemlistordertype, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "ItemListUnordered", sch_itemlistunordered },
    { { 2, 0 }, { 0, 0 }, "ItemPage", sch_itempage },
    { { 2, 0 }, { 0, 0 }, "JewelryStore", sch_jewelrystore },
    { { 2, 0 }, { 0, 0 }, "JobPosting", sch_jobposting },
    { { 2, 0 }, { 0, 0 }, "JoinAction", sch_joinaction },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Joint", sch_joint },
    { { 3, 5 }, { 0, 0 }, "KosherDiet", sch_kosherdiet },
    { { 3, 6 }, { 6, 0 }, "LaboratoryScience", sch_laboratoryscience },
    { { 2, 0 }, { 0, 0 }, "LakeBodyOfWater", sch_lakebodyofwater },
    { { 2, 0 }, { 0, 0 }, "Landform", sch_landform },
    { { 2, 0 }, { 0, 0 }, "LandmarksOrHistoricalBuildings", sch_landmarksorhistoricalbuildings },
    { { 2, 0 }, { 0, 0 }, "Language", sch_language },
    { { 3, 5 }, { 0, 0 }, "LaserDiscFormat", sch_laserdiscformat },
    { { 9, 0 }, { 0, 0 }, "LearningResource", sch_learningresource },
    { { 2, 0 }, { 0, 0 }, "LeaveAction", sch_leaveaction },
    { { 3, 6 }, { 6, 0 }, "LeftHandDriving", sch_lefthanddriving },
    { { 3, 5 }, { 0, 0 }, "LegalForceStatus", sch_legalforcestatus, ns_default, SF_ENUMERATION },
    { { 2, 2 }, { 0, 0 }, "LegalService", sch_legalservice },
    { { 3, 5 }, { 0, 0 }, "LegalValueLevel", sch_legalvaluelevel, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "Legislation", sch_legislation },
    { { 3, 5 }, { 0, 0 }, "LegislationObject", sch_legislationobject },
    { { 2, 0 }, { 0, 0 }, "LegislativeBuilding", sch_legislativebuilding },
    { { 3, 5 }, { 0, 0 }, "LeisureTimeActivity", sch_leisuretimeactivity },
    { { 2, 0 }, { 0, 0 }, "LendAction", sch_lendaction },
    { { 2, 0 }, { 0, 0 }, "Library", sch_library },
    { { 3, 5 }, { 0, 0 }, "LibrarySystem", sch_librarysystem },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "LifestyleModification", sch_lifestylemodification },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Ligament", sch_ligament },
    { { 2, 0 }, { 0, 0 }, "LikeAction", sch_likeaction },
    { { 3, 5 }, { 0, 0 }, "LimitedAvailability", sch_limitedavailability },
    { { 9, 0 }, { 0, 0 }, "LimitedByGuaranteeCharity", sch_limitedbyguaranteecharity },
    { { 3, 5 }, { 0, 0 }, "LinkRole", sch_linkrole },
    { { 2, 0 }, { 0, 0 }, "LiquorStore", sch_liquorstore },
    { { 2, 0 }, { 0, 0 }, "ListenAction", sch_listenaction },
    { { 2, 0 }, { 0, 0 }, "ListItem", sch_listitem },
    { { 2, 0 }, { 0, 0 }, "LiteraryEvent", sch_literaryevent },
    { { 3, 5 }, { 0, 0 }, "LiveAlbum", sch_livealbum },
    { { 2, 1 }, { 0, 0 }, "LiveBlogPosting", sch_liveblogposting },
    { { 5, 0 }, { 0, 0 }, "LivingWithHealthAspect", sch_livingwithhealthaspect },
    { { 3, 0 }, { 0, 0 }, "LoanOrCredit", sch_loanorcredit },
    { { 2, 0 }, { 0, 0 }, "LocalBusiness", sch_localbusiness },
    { { 3, 1 }, { 0, 0 }, "LocationFeatureSpecification", sch_locationfeaturespecification },
    { { 2, 0 }, { 0, 0 }, "LockerDelivery", sch_lockerdelivery },
    { { 2, 0 }, { 0, 0 }, "Locksmith", sch_locksmith },
    { { 2, 0 }, { 0, 0 }, "LodgingBusiness", sch_lodgingbusiness },
    { { 2, 0 }, { 0, 0 }, "LodgingReservation", sch_lodgingreservation },
    { { 3, 6 }, { 6, 0 }, "Longitudinal", sch_longitudinal },
    { { 2, 0 }, { 0, 0 }, "LoseAction", sch_loseaction },
    { { 3, 5 }, { 0, 0 }, "LowCalorieDiet", sch_lowcaloriediet },
    { { 3, 5 }, { 0, 0 }, "LowFatDiet", sch_lowfatdiet },
    { { 3, 5 }, { 0, 0 }, "LowLactoseDiet", sch_lowlactosediet },
    { { 3, 5 }, { 0, 0 }, "LowSaltDiet", sch_lowsaltdiet },
    { { 3, 6 }, { 6, 0 }, "Lung", sch_lung },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "LymphaticVessel", sch_lymphaticvessel },
    { { 3, 5 }, { 0, 0 }, "Male", sch_male },
    { { 3, 5 }, { 0, 0 }, "Manuscript", sch_manuscript },
    { { 2, 0 }, { 0, 0 }, "Map", sch_map },
    { { 2, 0 }, { 0, 0 }, "MapCategoryType", sch_mapcategorytype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "MarryAction", sch_marryaction },
    { { 2, 0 }, { 0, 0 }, "Mass", sch_mass },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Maximumdoseschedule", sch_maximumdoseschedule },
    { { 5, 0 }, { 0, 0 }, "Maytreathealthaspect", sch_maytreathealthaspect },
    { { 6, 0 }, { 0, 0 }, "Mediagallery", sch_mediagallery },
    { { 7, 0 }, { 0, 0 }, "Mediamanipulationratingenumeration", sch_mediamanipulationratingenumeration, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "Mediaobject", sch_mediaobject },
    { { 7, 0 }, { 0, 0 }, "Mediareview", sch_mediareview },
    { { 3, 5 }, { 0, 0 }, "Mediasubscription", sch_mediasubscription },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Medicalaudience", sch_medicalaudience },
    { { 9, 0 }, { 0, 0 }, "Medicalaudiencetype", sch_medicalaudiencetype, ns_default, SF_ENUMERATION },
    { { 3, 0, SV_NOT_3134 }, { 0, 0 }, "MedicalBusiness", sch_medicalbusiness },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalCause", sch_medicalcause },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalClinic", sch_medicalclinic },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalCode", sch_medicalcode },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalCondition", sch_medicalcondition },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalConditionStage", sch_medicalconditionstage },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalContraindication", sch_medicalcontraindication },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalDevice", sch_medicaldevice },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalDevicePurpose", sch_medicaldevicepurpose, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalEntity", sch_medicalentity },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalEnumeration", sch_medicalenumeration },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalEvidenceLevel", sch_medicalevidencelevel, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalGuideline", sch_medicalguideline },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalGuidelineContraindication", sch_medicalguidelinecontraindication },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalGuidelineRecommendation", sch_medicalguidelinerecommendation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalImagingTechnique", sch_medicalimagingtechnique, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalIndication", sch_medicalindication },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalIntangible", sch_medicalintangible },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalObservationalStudy", sch_medicalobservationalstudy },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalObservationalStudyDesign", sch_medicalobservationalstudydesign, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalOrganization", sch_medicalorganisation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalProcedure", sch_medicalprocedure },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalProcedureType", sch_medicalproceduretype, ns_default, SF_ENUMERATION },
    { { 3, 6 }, { 6, 0 }, "MedicalResearcher", sch_medicalresearcher },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalRiskCalculator", sch_medicalriskcalculator },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalRiskEstimator", sch_medicalriskestimator },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalRiskFactor", sch_medicalriskfactor },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalRiskScore", sch_medicalriskscore },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalScholarlyArticle", sch_medicalscholarlyarticle },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalSign", sch_medicalsign },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalSignOrSymptom", sch_medicalsignorsymptom },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalSpecialty", sch_medicalspeciality, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalStudy", sch_medicalstudy },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalStudyStatus", sch_medicalstudystatus, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalSymptom", sch_medicalsymptom },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalTest", sch_medicaltest },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalTestPanel", sch_medicaltestpanel },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalTherapy", sch_medicaltherapy },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalTrial", sch_medicaltrial },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalTrialDesign", sch_medicaltrialdesign, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicalWebPage", sch_medicalwebpage },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "MedicineSystem", sch_medicinesystem, ns_default, SF_ENUMERATION },
    { { 3, 1 }, { 0, 0 }, "Meetingroom", sch_meetingroom },
    { { 2, 0 }, { 0, 0 }, "Mensclothingstore", sch_mensclothingstore },
    { { 3, 2 }, { 0, 0 }, "Menu", sch_menu },
    { { 3, 2 }, { 0, 0 }, "Menuitem", sch_menuitem },
    { { 3, 2 }, { 0, 0 }, "Menusection", sch_menusection },
    { { 6, 0 }, { 0, 0 }, "Merchantreturnenumeration", sch_merchantreturnenumeration, ns_default, SF_ENUMERATION },
    { { 6, 0 }, { 0, 0 }, "Merchantreturnfinitereturnwindow", sch_merchantreturnfinitereturnwindow },
    { { 6, 0 }, { 0, 0 }, "Merchantreturnnotpermitted", sch_merchantreturnnotpermitted },
    { { 6, 0 }, { 0, 0 }, "Merchantreturnpolicy", sch_merchantreturnpolicy },
    { { 6, 0 }, { 0, 0 }, "Merchantreturnunlimitedwindow", sch_merchantreturnunlimitedwindow },
    { { 6, 0 }, { 0, 0 }, "Merchantreturnunspecified", sch_merchantreturnunspecified },
    { { 3, 0 }, { 0, 0 }, "Message", sch_message },
    { { 2, 0 }, { 0, 0 }, "Middleschool", sch_middleschool },
    { { 3, 5 }, { 0, 0 }, "Midwifery", sch_midwifery },
    { { 5, 0 }, { 0, 0 }, "Misconceptionshealthaspect", sch_misconceptionshealthaspect },
    { { 7, 0 }, { 0, 0 }, "Missingcontext", sch_missingcontext },
    { { 7, 0 }, { 0, 0 }, "Mixedeventattendancemode", sch_mixedeventattendancemode },
    { { 3, 5 }, { 0, 0 }, "Mixtapealbum", sch_mixtapealbum },
    { { 2, 0 }, { 0, 0 }, "Mobileapplication", sch_mobileapplication },
    { { 2, 0 }, { 0, 0 }, "Mobilephonestore", sch_mobilephonestore },
    { { 3, 5 }, { 0, 0 }, "Monday", sch_monday },
    { { 3, 0 }, { 0, 0 }, "Monetaryamount", sch_monetaryamount },
    { { 3, 5 }, { 0, 0 }, "Monetaryamountdistribution", sch_monetaryamountdistribution },
    { { 3, 5 }, { 0, 0 }, "Monetarygrant", sch_monetarygrant },
    { { 3, 5 }, { 0, 0 }, "Moneytransfer", sch_moneytransfer },
    { { 3, 5 }, { 0, 0 }, "Mortgageloan", sch_mortgageloan },
    { { 2, 0 }, { 0, 0 }, "Mosque", sch_mosque },
    { { 2, 0 }, { 0, 0 }, "Motel", sch_motel },
    { { 3, 5 }, { 0, 0 }, "Motorcycle", sch_motorcycle },
    { { 2, 0 }, { 0, 0 }, "Motorcycledealer", sch_motorcycledealer },
    { { 2, 0 }, { 0, 0 }, "Motorcyclerepair", sch_motorcyclerepair },
    { { 3, 5 }, { 0, 0 }, "Motorizedbicycle", sch_motorisedbicycle },
    { { 2, 0 }, { 0, 0 }, "Mountain", sch_mountain },
    { { 2, 0 }, { 0, 0 }, "Moveaction", sch_moveaction },
    { { 2, 0 }, { 0, 0 }, "Movie", sch_movie },
    { { 2, 0 }, { 0, 0 }, "Movieclip", sch_movieclip },
    { { 2, 0 }, { 0, 0 }, "Movierentalstore", sch_movierentalstore },
    { { 2, 0 }, { 0, 0 }, "Movieseries", sch_movieseries },
    { { 2, 0 }, { 0, 0 }, "Movietheater", sch_movietheatre },
    { { 2, 0 }, { 0, 0 }, "Movingcompany", sch_movingcompany },
    { { 3, 6 }, { 6, 0 }, "Mri", sch_mri },
    { { 3, 6 }, { 6, 0 }, "Multicellularparasite", sch_multicellularparasite },
    { { 3, 5 }, { 0, 0 }, "Multicentertrial", sch_multicentretrial },
    { { 3, 5 }, { 0, 0 }, "Multiplayer", sch_multiplayer },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Muscle", sch_muscle },
    { { 3, 6 }, { 6, 0 }, "Musculoskeletal", sch_musculoskeletal },
    { { 3, 6 }, { 6, 0 }, "Musculoskeletalexam", sch_musculoskeletalexam },
    { { 2, 0 }, { 0, 0 }, "Museum", sch_museum },
    { { 2, 0 }, { 0, 0 }, "Musicalbum", sch_musicalbum },
    { { 2, 0 }, { 0, 0 }, "Musicalbumproductiontype", sch_musicalbumproductiontype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "Musicalbumreleasetype", sch_musicalbumreleasetype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "Musiccomposition", sch_musiccomposition },
    { { 2, 0 }, { 0, 0 }, "Musicevent", sch_musicevent },
    { { 2, 0 }, { 0, 0 }, "Musicgroup", sch_musicgroup },
    { { 2, 0 }, { 0, 0 }, "Musicplaylist", sch_musicplaylist },
    { { 2, 0 }, { 0, 0 }, "Musicrecording", sch_musicrecording },
    { { 2, 0 }, { 0, 0 }, "Musicrelease", sch_musicrelease },
    { { 2, 0 }, { 0, 0 }, "Musicreleaseformattype", sch_musicreleaseformattype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "Musicstore", sch_musicstore },
    { { 2, 0 }, { 0, 0 }, "Musicvenue", sch_musicvenue },
    { { 2, 0 }, { 0, 0 }, "Musicvideoobject", sch_musicvideoobject },
    { { 2, 0 }, { 0, 0 }, "Nailsalon", sch_nailsalon },
    { { 3, 6 }, { 6, 0 }, "Neck", sch_neck },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Nerve", sch_nerve },
    { { 3, 6 }, { 6, 0 }, "Neuro", sch_neuro },
    { { 3, 6 }, { 6, 0 }, "Neurologic", sch_neurologic },
    { { 3, 5 }, { 0, 0 }, "Newcondition", sch_newcondition },
    { { 2, 0 }, { 0, 0 }, "Newsarticle", sch_newsarticle },
    { { 3, 5 }, { 0, 0 }, "NewsmediaOrganization", sch_newsmediaorganisation },
    { { 3, 5 }, { 0, 0 }, "Newspaper", sch_newspaper },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Ngo", sch_ngo },
    { { 2, 0 }, { 0, 0 }, "Nightclub", sch_nightclub },
    { { 8, 0 }, { 0, 0 }, "Nlnonprofittype", sch_nlnonprofittype, ns_default, SF_ENUMERATION },
    { { 3, 6 }, { 6, 0 }, "Noninvasiveprocedure", sch_noninvasiveprocedure },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501a", sch_nonprofit501a },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c1", sch_nonprofit501c1 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c10", sch_nonprofit501c10 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c11", sch_nonprofit501c11 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c12", sch_nonprofit501c12 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c13", sch_nonprofit501c13 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c14", sch_nonprofit501c14 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c15", sch_nonprofit501c15 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c16", sch_nonprofit501c16 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c17", sch_nonprofit501c17 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c18", sch_nonprofit501c18 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c19", sch_nonprofit501c19 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c2", sch_nonprofit501c2 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c20", sch_nonprofit501c20 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c21", sch_nonprofit501c21 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c22", sch_nonprofit501c22 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c23", sch_nonprofit501c23 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c24", sch_nonprofit501c24 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c25", sch_nonprofit501c25 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c26", sch_nonprofit501c26 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c27", sch_nonprofit501c27 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c28", sch_nonprofit501c28 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c3", sch_nonprofit501c3 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c4", sch_nonprofit501c4 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c5", sch_nonprofit501c5 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c6", sch_nonprofit501c6 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c7", sch_nonprofit501c7 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c8", sch_nonprofit501c8 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501c9", sch_nonprofit501c9 },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501d", sch_nonprofit501d },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501e", sch_nonprofit501e },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501f", sch_nonprofit501f },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501k", sch_nonprofit501k },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501n", sch_nonprofit501n },
    { { 9, 0 }, { 0, 0 }, "Nonprofit501q", sch_nonprofit501q },
    { { 9, 0 }, { 0, 0 }, "Nonprofit527", sch_nonprofit527 },
    { { 9, 0 }, { 0, 0 }, "Nonprofitanbi", sch_nonprofitanbi },
    { { 9, 0 }, { 0, 0 }, "Nonprofitsbbi", sch_nonprofitsbbi },
    { { 8, 0 }, { 0, 0 }, "Nonprofittype", sch_nonprofittype },
    { { 3, 6 }, { 6, 0 }, "Nose", sch_nose },
    { { 2, 0 }, { 0, 0 }, "Notary", sch_notary },
    { { 3, 0 }, { 0, 0 }, "Notedigitaldocument", sch_notedigitaldocument },
    { { 3, 5 }, { 0, 0 }, "Notinforce", sch_notinforce },
    { { 3, 6 }, { 6, 0 }, "Notyetrecruiting", sch_notyetrecruiting },
    { { 2, 0 }, { 0, 0 }, "Number", sch_number, ns_default, MAKE_SIMPLE_TYPE (t_fixedpoint) },
    { { 3, 5 }, { 0, 0 }, "Nursing", sch_nursing },
    { { 2, 0 }, { 0, 0 }, "Nutritioninformation", sch_nutritioninformation },
    { { 3, 9 }, { 0, 0 }, "Observation", sch_observation },
    { { 3, 6 }, { 6, 0 }, "Observational", sch_observational },
    { { 3, 5 }, { 0, 0 }, "Obstetric", sch_obstetric },
    { { 3, 5 }, { 0, 0 }, "Occupation", sch_occupation },
    { { 3, 5 }, { 0, 0 }, "Occupationalactivity", sch_occupationalactivity },
    { { 3, 5 }, { 0, 0 }, "Occupationaltherapy", sch_occupationaltherapy },
    { { 2, 0 }, { 0, 0 }, "Oceanbodyofwater", sch_oceanbodyofwater },
    { { 2, 0 }, { 0, 0 }, "Offer", sch_offer },
    { { 2, 2 }, { 0, 0 }, "Offercatalog", sch_offercatalogue },
    { { 4, 0 }, { 0, 0 }, "Offerforlease", sch_offerforlease },
    { { 4, 0 }, { 0, 0 }, "Offerforpurchase", sch_offerforpurchase },
    { { 2, 0 }, { 0, 0 }, "Offeritemcondition", sch_offeritemcondition, ns_default, SF_ENUMERATION },
    { { 7, 2 }, { 0, 0 }, "Offershippingdetails", sch_offershippingdetails },
    { { 2, 0 }, { 0, 0 }, "Officeequipmentstore", sch_officeequipmentstore },
    { { 3, 5 }, { 0, 0 }, "Officiallegalvalue", sch_officiallegalvalue },
    { { 7, 0 }, { 0, 0 }, "Offlineeventattendancemode", sch_offlineeventattendancemode },
    { { 3, 5 }, { 0, 0 }, "Offlinepermanently", sch_offlinepermanently },
    { { 3, 5 }, { 0, 0 }, "Offlinetemporarily", sch_offlinetemporarily },
    { { 3, 5 }, { 0, 0 }, "Oncologic", sch_oncologic },
    { { 2, 0 }, { 0, 0 }, "Ondemandevent", sch_ondemandevent },
    { { 7, 4 }, { 0, 0 }, "Onetimepayments", sch_onetimepayments },
    { { 3, 5 }, { 0, 0 }, "Online", sch_online },
    { { 7, 0 }, { 0, 0 }, "Onlineeventattendancemode", sch_onlineeventattendancemode },
    { { 3, 5 }, { 0, 0 }, "Onlinefull", sch_onlinefull },
    { { 3, 5 }, { 0, 0 }, "Onlineonly", sch_onlineonly },
    { { 3, 5 }, { 0, 0 }, "Onsitepickup", sch_onsitepickup },
    { { 2, 0 }, { 0, 0 }, "Openinghoursspecification", sch_openinghoursspecification },
    { { 3, 5 }, { 0, 0 }, "Opentrial", sch_opentrial },
    { { 3, 5 }, { 0, 0 }, "Opinionnewsarticle", sch_opinionnewsarticle },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Optician", sch_optician },
    { { 3, 5 }, { 0, 0 }, "Optometric", sch_optometric },
    { { 2, 0 }, { 0, 0 }, "Order", sch_order },
    { { 2, 0 }, { 0, 0 }, "Orderaction", sch_orderaction },
    { { 3, 5 }, { 0, 0 }, "Ordercancelled", sch_ordercancelled },
    { { 3, 5 }, { 0, 0 }, "Orderdelivered", sch_orderdelivered },
    { { 3, 5 }, { 0, 0 }, "Orderintransit", sch_orderintransit },
    { { 2, 0 }, { 0, 0 }, "Orderitem", sch_orderitem },
    { { 3, 5 }, { 0, 0 }, "Orderpaymentdue", sch_orderpaymentdue },
    { { 3, 5 }, { 0, 0 }, "Orderpickupavailable", sch_orderpickupavailable },
    { { 3, 5 }, { 0, 0 }, "Orderproblem", sch_orderproblem },
    { { 3, 5 }, { 0, 0 }, "Orderprocessing", sch_orderprocessing },
    { { 3, 5 }, { 0, 0 }, "Orderreturned", sch_orderreturned },
    { { 2, 0 }, { 0, 0 }, "Orderstatus", sch_orderstatus, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "Organization", sch_organisation },
    { { 2, 0 }, { 0, 0 }, "Organizationrole", sch_organisationrole },
    { { 2, 0 }, { 0, 0 }, "Organizeaction", sch_organiseaction },
    { { 3, 8 }, { 0, 0 }, "Originalshippingfees", sch_originalshippingfees },
    { { 3, 6 }, { 6, 0 }, "Osteopathic", sch_osteopathic },
    { { 3, 6 }, { 6, 0 }, "Otc", sch_otc },
    { { 3, 5 }, { 0, 0 }, "Otolaryngologic", sch_otolaryngologic },
    { { 2, 0 }, { 0, 0 }, "Outletstore", sch_outletstore },
    { { 3, 5 }, { 0, 0 }, "Outofstock", sch_outofstock },
    { { 5, 0 }, { 0, 0 }, "Overviewhealthaspect", sch_overviewhealthaspect },
    { { 2, 0 }, { 0, 0 }, "Ownershipinfo", sch_ownershipinfo },
    { { 7, 4 }, { 0, 0 }, "Paidleave", sch_paidleave },
    { { 2, 0 }, { 0, 0 }, "Paintaction", sch_paintaction },
    { { 2, 0 }, { 0, 0 }, "Painting", sch_painting },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Palliativeprocedure", sch_palliativeprocedure },
    { { 3, 5 }, { 0, 0 }, "Paperback", sch_paperback },
    { { 2, 0 }, { 0, 0 }, "Parceldelivery", sch_parceldelivery },
    { { 2, 0 }, { 0, 0 }, "Parcelservice", sch_parcelservice },
    { { 7, 4 }, { 0, 0 }, "Parentalsupport", sch_parentalsupport },
    { { 2, 0 }, { 0, 0 }, "Parentaudience", sch_parentaudience },
    { { 2, 0 }, { 0, 0 }, "Park", sch_park },
    { { 2, 0 }, { 0, 0 }, "Parkingfacility", sch_parkingfacility },
    { { 3, 5 }, { 0, 0 }, "Parkingmap", sch_parkingmap },
    { { 3, 5 }, { 0, 0 }, "Partiallyinforce", sch_partiallyinforce },
    { { 3, 6 }, { 6, 0 }, "Pathology", sch_pathology },
    { { 2, 0 }, { 0, 0 }, "Pathologytest", sch_pathologytest },
    { { 3, 5 }, { 0, 0 }, "Patient", sch_patient },
    { { 5, 0 }, { 0, 0 }, "Patientexperiencehealthaspect", sch_patientexperiencehealthaspect },
    { { 2, 0 }, { 0, 0 }, "Pawnshop", sch_pawnshop },
    { { 2, 0 }, { 0, 0 }, "Payaction", sch_payaction },
    { { 3, 5 }, { 0, 0 }, "Paymentautomaticallyapplied", sch_paymentautomaticallyapplied },
    { { 3, 0 }, { 0, 0 }, "Paymentcard", sch_paymentcard },
    { { 2, 0 }, { 0, 0 }, "Paymentchargespecification", sch_paymentchargespecification },
    { { 3, 5 }, { 0, 0 }, "Paymentcomplete", sch_paymentcomplete },
    { { 3, 5 }, { 0, 0 }, "Paymentdeclined", sch_paymentdeclined },
    { { 3, 5 }, { 0, 0 }, "Paymentdue", sch_paymentdue },
    { { 2, 0 }, { 0, 0 }, "Paymentmethod", sch_paymentmethod, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "Paymentpastdue", sch_paymentpastdue },
    { { 3, 1 }, { 0, 0 }, "Paymentservice", sch_paymentservice },
    { { 2, 1 }, { 0, 0 }, "Paymentstatustype", sch_paymentstatustype, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "Pediatric", sch_paediatric },
    { { 2, 0 }, { 0, 0 }, "Peopleaudience", sch_peopleaudience },
    { { 3, 6 }, { 6, 0 }, "Percutaneousprocedure", sch_percutaneousprocedure },
    { { 2, 0 }, { 0, 0 }, "Performaction", sch_performaction },
    { { 2, 0 }, { 0, 0 }, "Performancerole", sch_performancerole },
    { { 2, 0 }, { 0, 0 }, "Performingartstheater", sch_tyreshop },
    { { 2, 0 }, { 0, 0 }, "Performinggroup", sch_performinggroup },
    { { 2, 0 }, { 0, 0 }, "Periodical", sch_periodical },
    { { 2, 0 }, { 0, 0 }, "Permit", sch_permit },
    { { 2, 0 }, { 0, 0 }, "Person", sch_person },
    { { 3, 6 }, { 6, 0 }, "Pet", sch_pet },
    { { 2, 0 }, { 0, 0 }, "Petstore", sch_petstore },
    { { 2, 0 }, { 0, 0 }, "Pharmacy", sch_pharmacy },
    { { 3, 6 }, { 6, 0 }, "Pharmacyspeciality", sch_pharmacyspeciality },
    { { 2, 0 }, { 0, 0 }, "Photograph", sch_photograph },
    { { 2, 0 }, { 0, 0 }, "Photographaction", sch_photographaction },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Physicalactivity", sch_physicalactivity },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Physicalactivitycategory", sch_physicalactivitycategory, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Physicalexam", sch_physicalexam, ns_default, SF_ENUMERATION },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Physicaltherapy", sch_physicaltherapy },
    { { 2, 0 }, { 0, 0 }, "Physician", sch_physician },
    { { 3, 5 }, { 0, 0 }, "Physiotherapy", sch_physiotherapy },
    { { 2, 0 }, { 0, 0 }, "Place", sch_place },
    { { 3, 5 }, { 0, 0 }, "Placebocontrolledtrial", sch_placebocontrolledtrial },
    { { 2, 0 }, { 0, 0 }, "Placeofworship", sch_placeofworship },
    { { 2, 0 }, { 0, 0 }, "Planaction", sch_planaction },
    { { 3, 5 }, { 0, 0 }, "Plasticsurgery", sch_plasticsurgery },
    { { 3, 5 }, { 0, 0 }, "Play", sch_play },
    { { 2, 0 }, { 0, 0 }, "Playaction", sch_playaction },
    { { 2, 0 }, { 0, 0 }, "Playground", sch_playground },
    { { 2, 0 }, { 0, 0 }, "Plumber", sch_plumber },
    { { 4, 0 }, { 0, 0 }, "Podcastepisode", sch_podcastepisode },
    { { 4, 0 }, { 0, 0 }, "Podcastseason", sch_podcastseason },
    { { 4, 0 }, { 0, 0 }, "Podcastseries", sch_podcastseries },
    { { 3, 5 }, { 0, 0 }, "Podiatric", sch_podiatric },
    { { 2, 0 }, { 0, 0 }, "Policestation", sch_policestation },
    { { 2, 0 }, { 0, 0 }, "Pond", sch_pond },
    { { 2, 0 }, { 0, 0 }, "Postaladdress", sch_postaladdress },
    { { 8, 0 }, { 0, 0 }, "Postalcoderangespecification", sch_postalcoderangespecification },
    { { 3, 5 }, { 0, 0 }, "Poster", sch_poster },
    { { 2, 0 }, { 0, 0 }, "Postoffice", sch_postoffice },
    { { 3, 5 }, { 0, 0 }, "Potentialactionstatus", sch_potentialactionstatus },
    { { 3, 5 }, { 0, 0 }, "Preorder", sch_preorder },
    { { 3, 5 }, { 0, 0 }, "Preorderaction", sch_preorderaction },
    { { 2, 0 }, { 0, 0 }, "Prependaction", sch_prependaction },
    { { 3, 5 }, { 0, 0 }, "Presale", sch_presale },
    { { 2, 0 }, { 0, 0 }, "Preschool", sch_preschool },
    { { 3, 6 }, { 6, 0 }, "Prescriptiononly", sch_prescriptiononly },
    { { 3, 0 }, { 0, 0 }, "Presentationdigitaldocument", sch_presentationdigitaldocument },
    { { 5, 0 }, { 0, 0 }, "Preventionhealthaspect", sch_preventionhealthaspect },
    { { 2, 0 }, { 0, 0 }, "Preventionindication", sch_preventionindication },
    { { 2, 0 }, { 0, 0 }, "Pricespecification", sch_pricespecification },
    { { 3, 5 }, { 0, 0 }, "Primarycare", sch_primarycare },
    { { 3, 6 }, { 6, 0 }, "Prion", sch_prion },
    { { 2, 0 }, { 0, 0 }, "Product", sch_product },
    { { 9, 0 }, { 0, 0 }, "Productcollection", sch_productcollection },
    { { 9, 0 }, { 0, 0 }, "Productgroup", sch_productgroup },
    { { 2, 0 }, { 0, 0 }, "Productmodel", sch_productmodel },
    { { 3, 8 }, { 0, 0 }, "Productreturnenumeration", sch_productreturnenumeration },
    { { 3, 8 }, { 0, 0 }, "Productreturnfinitereturnwindow", sch_productreturnfinitereturnwindow },
    { { 3, 8 }, { 0, 0 }, "Productreturnnotpermitted", sch_productreturnnotpermitted },
    { { 3, 8 }, { 0, 0 }, "Productreturnpolicy", sch_productreturnpolicy },
    { { 3, 8 }, { 0, 0 }, "Productreturnunlimitedwindow", sch_productreturnunlimitedwindow },
    { { 3, 8 }, { 0, 0 }, "Productreturnunspecified", sch_productreturnunspecified },
    { { 2, 0 }, { 0, 0 }, "Professionalservice", sch_professionalservice },
    { { 2, 0 }, { 0, 0 }, "Profilepage", sch_profilepage },
    { { 5, 0 }, { 0, 0 }, "Prognosishealthaspect", sch_prognosishealthaspect },
    { { 2, 0 }, { 0, 0 }, "Programmembership", sch_programmemembership },
    { { 3, 5 }, { 0, 0 }, "Project", sch_project },
    { { 6, 0 }, { 0, 0 }, "Pronounceabletext", sch_pronounceabletext },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Property", sch_property },
    { { 2, 0 }, { 0, 0 }, "Propertyvalue", sch_propertyvalue },
    { { 2, 0 }, { 0, 0 }, "Propertyvaluespecification", sch_propertyvaluespecification },
    { { 3, 6 }, { 6, 0 }, "Protozoa", sch_protozoa },
    { { 3, 5 }, { 0, 0 }, "Psychiatric", sch_psychiatric },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Psychologicaltreatment", sch_psychologicaltreatment },
    { { 2, 0 }, { 0, 0 }, "Publicationevent", sch_publicationevent },
    { { 2, 0 }, { 0, 0 }, "Publicationissue", sch_publicationissue },
    { { 2, 0 }, { 0, 0 }, "Publicationvolume", sch_publicationvolume },
    { { 3, 5 }, { 0, 0 }, "Publichealth", sch_publichealth },
    { { 3, 5 }, { 0, 0 }, "Publicholidays", sch_publicholidays },
    { { 2, 0 }, { 0, 0 }, "Publicswimmingpool", sch_publicswimmingpool },
    { { 3, 5 }, { 0, 0 }, "Publictoilet", sch_publictoilet },
    { { 3, 6 }, { 6, 0 }, "Pulmonary", sch_pulmonary },
    { { 2, 0 }, { 0, 0 }, "Qapage", sch_qapage },
    { { 2, 0 }, { 0, 0 }, "Qualitativevalue", sch_qualitativevalue },
    { { 2, 0 }, { 0, 0 }, "Quantitativevalue", sch_quantitativevalue },
    { { 3, 5 }, { 0, 0 }, "Quantitativevaluedistribution", sch_quantitativevaluedistribution },
    { { 2, 0 }, { 0, 0 }, "Quantity", sch_quantity },
    { { 2, 0 }, { 0, 0 }, "Question", sch_question },
    { { 9, 0 }, { 0, 0 }, "Quiz", sch_quiz },
    { { 3, 5 }, { 0, 0 }, "Quotation", sch_quotation },
    { { 2, 0 }, { 0, 0 }, "Quoteaction", sch_quoteaction },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Radiationtherapy", sch_radiationtherapy },
    { { 3, 5 }, { 0, 0 }, "Radiobroadcastservice", sch_radiobroadcastservice },
    { { 2, 0 }, { 0, 0 }, "Radiochannel", sch_radiochannel },
    { { 2, 0 }, { 0, 0 }, "Radioclip", sch_radioclip },
    { { 2, 0 }, { 0, 0 }, "Radioepisode", sch_radioepisode },
    { { 3, 6 }, { 6, 0 }, "Radiography", sch_radiography },
    { { 2, 0 }, { 0, 0 }, "Radioseason", sch_radioseason },
    { { 2, 0 }, { 0, 0 }, "Radioseries", sch_radioseries },
    { { 2, 0 }, { 0, 0 }, "Radiostation", sch_radiostation },
    { { 3, 5 }, { 0, 0 }, "Randomizedtrial", sch_randomisedtrial },
    { { 2, 0 }, { 0, 0 }, "Rating", sch_rating },
    { { 2, 0 }, { 0, 0 }, "Reactaction", sch_reactaction },
    { { 2, 0 }, { 0, 0 }, "Readaction", sch_readaction },
    { { 3, 5 }, { 0, 0 }, "Readpermission", sch_readpermission },
    { { 2, 0 }, { 0, 0 }, "Realestateagent", sch_realestateagent },
    { { 4, 0 }, { 0, 0 }, "Realestatelisting", sch_realestatelisting },
    { { 3, 6 }, { 6, 0 }, "Rearwheeldriveconfiguration", sch_rearwheeldriveconfiguration },
    { { 2, 0 }, { 0, 0 }, "Receiveaction", sch_receiveaction },
    { { 2, 0 }, { 0, 0 }, "Recipe", sch_recipe },
    { { 6, 0 }, { 0, 0 }, "Recommendation", sch_recommendation },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Recommendeddoseschedule", sch_recommendeddoseschedule },
    { { 3, 6 }, { 6, 0 }, "Recruiting", sch_recruiting },
    { { 2, 0 }, { 0, 0 }, "Recyclingcenter", sch_recyclingcentre },
    { { 3, 8 }, { 0, 0 }, "Refundtypeenumeration", sch_refundtypeenumeration, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "Refurbishedcondition", sch_refurbishedcondition },
    { { 2, 0 }, { 0, 0 }, "Registeraction", sch_registeraction },
    { { 3, 6 }, { 6, 0 }, "Registry", sch_registry },
    { { 3, 6 }, { 6, 0 }, "Reimbursementcap", sch_reimbursementcap },
    { { 2, 0 }, { 0, 0 }, "Rejectaction", sch_rejectaction },
    { { 5, 0 }, { 0, 0 }, "Relatedtopicshealthaspect", sch_relatedtopicshealthaspect },
    { { 3, 5 }, { 0, 0 }, "Remixalbum", sch_remixalbum },
    { { 3, 6 }, { 6, 0 }, "Renal", sch_renal },
    { { 2, 0 }, { 0, 0 }, "Rentaction", sch_rentaction },
    { { 2, 0 }, { 0, 0 }, "Rentalcarreservation", sch_rentalcarreservation },
    { { 3, 6 }, { 6, 0 }, "Rentalvehicleusage", sch_rentalvehicleusage },
    { { 3, 5 }, { 0, 0 }, "Repaymentspecification", sch_repaymentspecification },
    { { 2, 0 }, { 0, 0 }, "Replaceaction", sch_replaceaction },
    { { 2, 0 }, { 0, 0 }, "Replyaction", sch_replyaction },
    { { 2, 1 }, { 0, 0 }, "Report", sch_report },
    { { 3, 5 }, { 0, 0 }, "Reportagenewsarticle", sch_reportagenewsarticle },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Reporteddoseschedule", sch_reporteddoseschedule },
    { { 3, 5 }, { 0, 0 }, "Researchproject", sch_researchproject },
    { { 2, 0 }, { 0, 0 }, "Reservation", sch_reservation },
    { { 3, 5 }, { 0, 0 }, "Reservationcancelled", sch_reservationcancelled },
    { { 3, 5 }, { 0, 0 }, "Reservationconfirmed", sch_reservationconfirmed },
    { { 3, 5 }, { 0, 0 }, "Reservationhold", sch_reservationhold },
    { { 2, 0 }, { 0, 0 }, "Reservationpackage", sch_reservationpackage },
    { { 3, 5 }, { 0, 0 }, "Reservationpending", sch_reservationpending },
    { { 2, 0 }, { 0, 0 }, "Reservationstatustype", sch_reservationstatustype, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "Reserveaction", sch_reserveaction },
    { { 2, 0 }, { 0, 0 }, "Reservoir", sch_reservoir },
    { { 2, 0 }, { 0, 0 }, "Residence", sch_residence },
    { { 3, 1 }, { 0, 0 }, "Resort", sch_resort },
    { { 3, 5 }, { 0, 0 }, "Respiratorytherapy", sch_respiratorytherapy },
    { { 2, 0 }, { 0, 0 }, "Restaurant", sch_restaurant },
    { { 3, 8 }, { 0, 0 }, "Restockingfees", sch_restockingfees },
    { { 3, 0 }, { 0, 0 }, "RestrictedDiet", sch_restricteddiet, ns_default, SF_ENUMERATION },
    { { 3, 6 }, { 6, 0 }, "Resultsavailable", sch_resultsavailable },
    { { 3, 6 }, { 6, 0 }, "Resultsnotavailable", sch_resultsnotavailable },
    { { 2, 0 }, { 0, 0 }, "Resumeaction", sch_resumeaction },
    { { 3, 6 }, { 6, 0 }, "Retail", sch_retail },
    { { 2, 0 }, { 0, 0 }, "Returnaction", sch_returnaction },
    { { 3, 8 }, { 0, 0 }, "Returnfeesenumeration", sch_returnfeesenumeration, ns_default, SF_ENUMERATION },
    { { 3, 8 }, { 0, 0 }, "Returnshippingfees", sch_returnshippingfees },
    { { 2, 0 }, { 0, 0 }, "Review", sch_review },
    { { 2, 0 }, { 0, 0 }, "Reviewaction", sch_reviewaction },
    { { 3, 5 }, { 0, 0 }, "Reviewnewsarticle", sch_reviewnewsarticle },
    { { 3, 6 }, { 6, 0 }, "Rheumatologic", sch_rheumatologic },
    { { 3, 6 }, { 6, 0 }, "Righthanddriving", sch_righthanddriving },
    { { 5, 0 }, { 0, 0 }, "Risksorcomplicationshealthaspect", sch_risksorcomplicationshealthaspect },
    { { 2, 0 }, { 0, 0 }, "Riverbodyofwater", sch_riverbodyofwater },
    { { 2, 0 }, { 0, 0 }, "Role", sch_role },
    { { 2, 0 }, { 0, 0 }, "Roofingcontractor", sch_roofingcontractor },
    { { 3, 1 }, { 0, 0 }, "Room", sch_room },
    { { 2, 0 }, { 0, 0 }, "Rsvpaction", sch_rsvpaction },
    { { 3, 5 }, { 0, 0 }, "Rsvpresponsemaybe", sch_rsvpresponsemaybe },
    { { 3, 5 }, { 0, 0 }, "Rsvpresponseno", sch_rsvpresponseno },
    { { 2, 0 }, { 0, 0 }, "Rsvpresponsetype", sch_rsvpresponsetype, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "Rsvpresponseyes", sch_rsvpresponseyes },
    { { 2, 0 }, { 0, 0 }, "Rvpark", sch_rvpark },
    { { 2, 0 }, { 0, 0 }, "Saleevent", sch_saleevent },
    { { 3, 5 }, { 0, 0 }, "Satiricalarticle", sch_satiricalarticle },
    { { 3, 5 }, { 0, 0 }, "Saturday", sch_saturday },
    { { 3, 5 }, { 0, 0 }, "Schedule", sch_schedule },
    { { 2, 0 }, { 0, 0 }, "Scheduleaction", sch_scheduleaction },
    { { 2, 0 }, { 0, 0 }, "Scholarlyarticle", sch_scholarlyarticle },
    { { 2, 0 }, { 0, 0 }, "School", sch_school },
    { { 7, 1 }, { 0, 0 }, "Schooldistrict", sch_schooldistrict },
    { { 2, 0 }, { 0, 0 }, "Screeningevent", sch_screeningevent },
    { { 5, 0 }, { 0, 0 }, "Screeninghealthaspect", sch_screeninghealthaspect },
    { { 2, 0 }, { 0, 0 }, "Sculpture", sch_sculpture },
    { { 2, 0 }, { 0, 0 }, "Seabodyofwater", sch_seabodyofwater },
    { { 2, 0 }, { 0, 0 }, "Searchaction", sch_searchaction },
    { { 2, 0 }, { 0, 0 }, "Searchresultspage", sch_searchresultspage },
    { { 2, 0 }, { 3, 4 }, "Season", sch_season },
    { { 2, 0 }, { 0, 0 }, "Seat", sch_seat },
    { { 3, 5 }, { 0, 0 }, "Seatingmap", sch_seatingmap },
    { { 5, 0 }, { 0, 0 }, "Seedoctorhealthaspect", sch_seedoctorhealthaspect },
    { { 5, 0 }, { 0, 0 }, "Selfcarehealthaspect", sch_selfcarehealthaspect },
    { { 2, 0 }, { 0, 0 }, "Selfstorage", sch_selfstorage },
    { { 2, 0 }, { 0, 0 }, "Sellaction", sch_sellaction },
    { { 2, 0 }, { 0, 0 }, "Sendaction", sch_sendaction },
    { { 2, 0 }, { 0, 0 }, "Series", sch_series },
    { { 2, 0 }, { 0, 0 }, "Service", sch_service },
    { { 2, 0 }, { 0, 0 }, "Servicechannel", sch_servicechannel },
    { { 2, 0 }, { 0, 0 }, "Shareaction", sch_shareaction },
    { { 3, 5 }, { 0, 0 }, "Sheetmusic", sch_sheetmusic },
    { { 8, 0 }, { 0, 0 }, "Shippingdeliverytime", sch_shippingdeliverytime },
    { { 8, 0 }, { 0, 0 }, "Shippingratesettings", sch_shippingratesettings },
    { { 2, 0 }, { 0, 0 }, "Shoestore", sch_shoestore },
    { { 2, 0 }, { 0, 0 }, "Shoppingcenter", sch_shoppingcentre },
    { { 3, 5 }, { 0, 0 }, "Shortstory", sch_shortstory },
    { { 5, 0 }, { 0, 0 }, "Sideeffectshealthaspect", sch_sideeffectshealthaspect },
    { { 3, 5 }, { 0, 0 }, "Singleblindedtrial", sch_singleblindedtrial },
    { { 3, 5 }, { 0, 0 }, "Singlecentertrial", sch_singlecentretrial },
    { { 2, 0 }, { 0, 0 }, "Singlefamilyresidence", sch_singlefamilyresidence },
    { { 3, 5 }, { 0, 0 }, "Singleplayer", sch_singleplayer },
    { { 3, 5 }, { 0, 0 }, "Singlerelease", sch_singlerelease },
    { { 2, 0 }, { 0, 0 }, "Sitenavigationelement", sch_sitenavigationelement },
    { { 3, 6 }, { 6, 0 }, "Skin", sch_skin },
    { { 2, 0 }, { 0, 0 }, "Skiresort", sch_skiresort },
    { { 2, 0 }, { 0, 0 }, "Socialevent", sch_socialevent },
    { { 2, 1 }, { 0, 0 }, "Socialmediaposting", sch_socialmediaposting },
    { { 2, 0 }, { 0, 0 }, "Softwareapplication", sch_softwareapplication },
    { { 2, 0 }, { 0, 0 }, "Softwaresourcecode", sch_softwaresourcecode },
    { { 3, 5 }, { 0, 0 }, "Soldout", sch_soldout },
    { { 2, 0 }, { 0, 0 }, "Someproducts", sch_someproducts },
    { { 3, 5 }, { 0, 0 }, "Soundtrackalbum", sch_soundtrackalbum },
    { { 3, 5 }, { 0, 0 }, "Speakablespecification", sch_speakablespecification },
    { { 7, 0 }, { 0, 0 }, "Specialannouncement", sch_specialannouncement },
    { { 2, 0 }, { 0, 0 }, "Specialty", sch_speciality, ns_default, SF_ENUMERATION },
    { { 3, 6 }, { 6, 0 }, "Speechpathology", sch_speechpathology },
    { { 3, 5 }, { 0, 0 }, "Spokenwordalbum", sch_spokenwordalbum },
    { { 2, 0 }, { 0, 0 }, "Sportinggoodsstore", sch_sportinggoodsstore },
    { { 2, 0 }, { 0, 0 }, "Sportsactivitylocation", sch_sportsactivitylocation },
    { { 2, 0 }, { 0, 0 }, "Sportsclub", sch_sportsclub },
    { { 2, 0 }, { 0, 0 }, "Sportsevent", sch_sportsevent },
    { { 2, 0 }, { 0, 0 }, "SportsOrganization", sch_sportsorganisation },
    { { 2, 0 }, { 0, 0 }, "Sportsteam", sch_sportsteam },
    { { 3, 0 }, { 0, 0 }, "Spreadsheetdigitaldocument", sch_spreadsheetdigitaldocument },
    { { 2, 0 }, { 0, 0 }, "Stadiumorarena", sch_stadiumorarena },
    { { 5, 0 }, { 0, 0 }, "Stageshealthaspect", sch_stageshealthaspect },
    { { 2, 0 }, { 0, 0 }, "State", sch_state },
    { { 3, 9 }, { 0, 0 }, "Statisticalpopulation", sch_statisticalpopulation },
    { { 9, 0 }, { 0, 0 }, "Statusenumeration", sch_statusenumeration },
    { { 2, 1 }, { 0, 0 }, "Steeringpositionvalue", sch_steeringpositionvalue, ns_default, SF_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "Store", sch_store },
    { { 3, 8 }, { 0, 0 }, "Storecreditrefund", sch_storecreditrefund },
    { { 3, 5 }, { 0, 0 }, "Strengthtraining", sch_strengthtraining },
    { { 2, 0 }, { 0, 0 }, "Structuredvalue", sch_structuredvalue },
    { { 3, 5 }, { 0, 0 }, "Studioalbum", sch_studioalbum },
    { { 3, 5 }, { 0, 0 }, "Stupidtype", sch_stupidtype },
    { { 2, 0 }, { 0, 0 }, "Subscribeaction", sch_subscribeaction },
    { { 3, 5 }, { 0, 0 }, "Substance", sch_substance },
    { { 2, 0 }, { 0, 0 }, "Subwaystation", sch_subwaystation },
    { { 3, 1 }, { 0, 0 }, "Suite", sch_suite },
    { { 3, 5 }, { 0, 0 }, "Sunday", sch_sunday },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Superficialanatomy", sch_superficialanatomy },
    { { 3, 6 }, { 6, 0 }, "Surgical", sch_surgical },
    { { 3, 5 }, { 0, 0 }, "Surgicalprocedure", sch_surgicalprocedure },
    { { 2, 0 }, { 0, 0 }, "Suspendaction", sch_suspendaction },
    { { 3, 6 }, { 6, 0 }, "Suspended", sch_suspended },
    { { 5, 0 }, { 0, 0 }, "Symptomshealthaspect", sch_symptomshealthaspect },
    { { 2, 0 }, { 0, 0 }, "Synagogue", sch_synagogue },
    { { 2, 0 }, { 0, 0 }, "Table", sch_table },
    { { 2, 0 }, { 0, 0 }, "Takeaction", sch_takeaction },
    { { 2, 0 }, { 0, 0 }, "Tattooparlor", sch_tattooparlour },
    { { 2, 0 }, { 3, 4 }, "Taxi", sch_taxi },
    { { 2, 0 }, { 0, 0 }, "Taxireservation", sch_taxireservation },
    { { 2, 0 }, { 0, 0 }, "Taxiservice", sch_taxiservice },
    { { 2, 0 }, { 0, 0 }, "Taxistand", sch_taxistand },
    { { 3, 6 }, { 6, 0 }, "Taxivehicleusage", sch_taxivehicleusage },
    { { 2, 0 }, { 0, 0 }, "Techarticle", sch_techarticle },
    { { 2, 0 }, { 0, 0 }, "Televisionchannel", sch_televisionchannel },
    { { 2, 0 }, { 0, 0 }, "Televisionstation", sch_televisionstation },
    { { 2, 0 }, { 0, 0 }, "Tenniscomplex", sch_tenniscomplex },
    { { 3, 6 }, { 6, 0 }, "Terminated", sch_terminated },
    { { 2, 0 }, { 0, 0 }, "Text", sch_text, ns_default, MAKE_SIMPLE_TYPE (t_text) },
    { { 3, 0 }, { 0, 0 }, "Textdigitaldocument", sch_textdigitaldocument },
    { { 2, 0 }, { 0, 0 }, "Theaterevent", sch_theatreevent },
    { { 2, 0 }, { 0, 0 }, "Theatergroup", sch_theatregroup },
    { { 3, 6 }, { 6, 0 }, "Therapeutic", sch_therapeutic },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Therapeuticprocedure", sch_therapeuticprocedure },
    { { 3, 5 }, { 0, 0 }, "Thesis", sch_thesis },
    { { 2, 0 }, { 0, 0 }, "Thing", sch_thing },
    { { 3, 6 }, { 6, 0 }, "Throat", sch_throat },
    { { 3, 5 }, { 0, 0 }, "Thursday", sch_thursday },
    { { 2, 0 }, { 0, 0 }, "Ticket", sch_ticket },
    { { 2, 0 }, { 0, 0 }, "Tieaction", sch_tieaction },
    { { 2, 0 }, { 0, 0 }, "Time", sch_time, ns_default, MAKE_SIMPLE_TYPE (t_just_time) },
    { { 2, 0 }, { 0, 0 }, "Tipaction", sch_tipaction },
    { { 2, 0 }, { 0, 0 }, "Tireshop", sch_tyreshop },
    { { 3, 5 }, { 0, 0 }, "Tollfree", sch_tollfree },
    { { 2, 0 }, { 0, 0 }, "Touristattraction", sch_touristattraction },
    { { 3, 5 }, { 0, 0 }, "Touristdestination", sch_touristdestination },
    { { 2, 0 }, { 0, 0 }, "Touristinformationcenter", sch_touristinformationcentre },
    { { 3, 5 }, { 0, 0 }, "Touristtrip", sch_touristtrip },
    { { 3, 6 }, { 6, 0 }, "Toxicologic", sch_toxicologic },
    { { 2, 0 }, { 0, 0 }, "Toystore", sch_toystore },
    { { 2, 0 }, { 0, 0 }, "Trackaction", sch_trackaction },
    { { 2, 0 }, { 0, 0 }, "Tradeaction", sch_tradeaction },
    { { 3, 6 }, { 6, 0 }, "Traditionalchinese", sch_environmentharm },
    { { 2, 0 }, { 0, 0 }, "Trainreservation", sch_trainreservation },
    { { 2, 0 }, { 0, 0 }, "Trainstation", sch_trainstation },
    { { 2, 0 }, { 0, 0 }, "Traintrip", sch_traintrip },
    { { 2, 0 }, { 0, 0 }, "Transferaction", sch_transferaction },
    { { 3, 5 }, { 0, 0 }, "Transitmap", sch_transitmap },
    { { 2, 0 }, { 0, 0 }, "Travelaction", sch_travelaction },
    { { 2, 0 }, { 0, 0 }, "Travelagency", sch_travelagency },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Treatmentindication", sch_treatmentindication },
    { { 5, 0 }, { 0, 0 }, "Treatmentshealthaspect", sch_treatmentshealthaspect },
    { { 3, 4 }, { 0, 0 }, "Trip", sch_trip },
    { { 3, 5 }, { 0, 0 }, "Tripleblindedtrial", sch_tripleblindedtrial },
    { { 2, 0 }, { 0, 0 }, "True", sch_true },
    { { 3, 5 }, { 0, 0 }, "Tuesday", sch_tuesday },
    { { 2, 0 }, { 0, 0 }, "Tvclip", sch_tvclip },
    { { 2, 0 }, { 0, 0 }, "Tvepisode", sch_tvepisode },
    { { 2, 0 }, { 0, 0 }, "Tvseason", sch_tvseason },
    { { 2, 0 }, { 0, 0 }, "Tvseries", sch_tvseries },
    { { 2, 0 }, { 0, 0 }, "Typeandquantitynode", sch_typeandquantitynode },
    { { 5, 0 }, { 0, 0 }, "Typeshealthaspect", sch_typeshealthaspect },
    { { 8, 0 }, { 0, 0 }, "Uknonprofittype", sch_uknonprofittype, ns_default, SF_ENUMERATION },
    { { 9, 0 }, { 0, 0 }, "Uktrust", sch_uktrust },
    { { 3, 6 }, { 6, 0 }, "Ultrasound", sch_ultrasound },
    { { 7, 4 }, { 0, 0 }, "Unemploymentsupport", sch_unemploymentsupport },
    { { 9, 0 }, { 0, 0 }, "Unincorporatedassociationcharity", sch_unincorporatedassociationcharity },
    { { 2, 0 }, { 0, 0 }, "Unitpricespecification", sch_unitpricespecification },
    { { 3, 5 }, { 0, 0 }, "Unofficiallegalvalue", sch_unofficiallegalvalue },
    { { 2, 0 }, { 0, 0 }, "Unregisteraction", sch_unregisteraction },
    { { 2, 0 }, { 0, 0 }, "Updateaction", sch_updateaction },
    { { 2, 0 }, { 0, 0 }, "Url", sch_url, ns_default, MAKE_SIMPLE_TYPE (t_url) },
    { { 3, 6 }, { 6, 0 }, "Urologic", sch_urologic },
    { { 5, 0 }, { 0, 0 }, "Usageorschedulehealthaspect", sch_usageorschedulehealthaspect },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Useaction", sch_useaction },
    { { 3, 5 }, { 0, 0 }, "Usedcondition", sch_usedcondition },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Userblocks", sch_userblocks },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Usercheckins", sch_usercheckins },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Usercomments", sch_usercomments },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Userdownloads", sch_userdownloads },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Userinteraction", sch_userinteraction },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Userlikes", sch_userlikes },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Userpagevisits", sch_userpagevisits },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Userplays", sch_userplays },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Userplusones", sch_userplusones },
    { { 3, 5 }, { 0, 0 }, "Userreview", sch_userreview },
    { { 2, 0, SV_DEP_3034 }, { 3, 4 }, "Usertweets", sch_usertweets },
    { { 8, 0 }, { 0, 0 }, "Usnonprofittype", sch_usnonprofittype, ns_default, SF_ENUMERATION },
    { { 3, 5 }, { 0, 0 }, "Vegandiet", sch_vegandiet },
    { { 3, 5 }, { 0, 0 }, "Vegetariandiet", sch_vegetariandiet },
    { { 2, 0 }, { 0, 0 }, "Vehicle", sch_vehicle },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Vein", sch_vein },
    { { 3, 5 }, { 0, 0 }, "Venuemap", sch_venuemap },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Vessel", sch_vessel },
    { { 2, 0, SV_NOT_3034 }, { 0, 0 }, "Veterinarycare", sch_veterinarycare },
    { { 2, 0 }, { 0, 0 }, "Videogallery", sch_videogallery },
    { { 2, 0 }, { 0, 0 }, "Videogame", sch_videogame },
    { { 2, 0 }, { 0, 0 }, "Videogameclip", sch_videogameclip },
    { { 2, 0 }, { 0, 0 }, "Videogameseries", sch_videogameseries },
    { { 2, 0 }, { 0, 0 }, "Videoobject", sch_videoobject },
    { { 2, 0 }, { 0, 0 }, "Viewaction", sch_viewaction },
    { { 3, 5 }, { 0, 0 }, "Vinylformat", sch_vinylformat },
    { { 7, 0 }, { 0, 0 }, "Virtuallocation", sch_virtuallocation },
    { { 3, 6 }, { 6, 0 }, "Virus", sch_virus },
    { { 2, 0 }, { 0, 0 }, "Visualartsevent", sch_visualartsevent },
    { { 2, 0 }, { 0, 0 }, "Visualartwork", sch_visualartwork },
    { { 3, 5 }, { 0, 0 }, "Vitalsign", sch_vitalsign },
    { { 2, 0 }, { 0, 0 }, "Volcano", sch_volcano },
    { { 2, 0 }, { 0, 0 }, "Voteaction", sch_voteaction },
    { { 2, 0 }, { 0, 0 }, "Wantaction", sch_wantaction },
    { { 2, 0 }, { 0, 0 }, "Warrantypromise", sch_warrantypromise },
    { { 2, 0 }, { 0, 0 }, "Warrantyscope", sch_warrantyscope, ns_default, SF_EXTERNAL_ENUMERATION },
    { { 2, 0 }, { 0, 0 }, "Watchaction", sch_watchaction },
    { { 2, 0 }, { 0, 0 }, "Waterfall", sch_waterfall },
    { { 2, 0 }, { 0, 0 }, "Wearaction", sch_wearaction },
    { { 3, 5 }, { 0, 0 }, "Webapi", sch_webapi },
    { { 2, 0 }, { 0, 0 }, "Webapplication", sch_webapplication },
    { { 5, 0 }, { 0, 0 }, "Webcontent", sch_webcontent },
    { { 2, 0 }, { 0, 0 }, "Webpage", sch_webpage },
    { { 2, 0 }, { 0, 0 }, "Webpageelement", sch_webpageelement },
    { { 2, 0 }, { 0, 0 }, "Website", sch_website },
    { { 3, 5 }, { 0, 0 }, "Wednesday", sch_wednesday },
    { { 3, 6 }, { 6, 0 }, "Westernconventional", sch_realitybased },
    { { 3, 6 }, { 6, 0 }, "Wholesale", sch_wholesale },
    { { 2, 0 }, { 0, 0 }, "Wholesalestore", sch_wholesalestore },
    { { 2, 0 }, { 0, 0 }, "Winaction", sch_winaction },
    { { 2, 0 }, { 0, 0 }, "Winery", sch_winery },
    { { 3, 6 }, { 6, 0 }, "Withdrawn", sch_withdrawn },
    { { 3, 9 }, { 0, 0 }, "Workbasedprogram", sch_workbasedprogramme },
    { { 3, 5 }, { 0, 0 }, "Workersunion", sch_workersunion },
    { { 2, 0 }, { 0, 0 }, "Wpadblock", sch_wpadblock },
    { { 2, 0 }, { 0, 0 }, "Wpfooter", sch_wpfooter },
    { { 2, 0 }, { 0, 0 }, "Wpheader", sch_wpheader },
    { { 2, 0 }, { 0, 0 }, "Wpsidebar", sch_wpsidebar },
    { { 2, 0 }, { 0, 0 }, "Writeaction", sch_writeaction },
    { { 3, 5 }, { 0, 0 }, "Writepermission", sch_writepermission },
    { { 3, 5 }, { 0, 0 }, "Xpathtype", sch_xpathtype },
    { { 3, 6 }, { 6, 0 }, "Xray", sch_xray },
    { { 3, 5 }, { 0, 0 }, "Zoneboardingpolicy", sch_zoneboardingpolicy },
    { { 0, 0 }, { 0, 0 }, "", sch_illegal } };

sch::sch (nitpick& nits, const html_version& v, const ::std::string& x)
{   e_schema es = parse (nits, v, x);
    if (es != sch_illegal) set (v, es); }

void sch::init (nitpick& nits)
{   symbol::init (nits, schema_symbol_table, sizeof (schema_symbol_table) / sizeof (symbol_entry < e_schema >), true); }

e_schema sch::parse (nitpick& nits, const html_version& v, const ::std::string& x)
{   ::std::string lc (::boost::algorithm::to_lower_copy (trim_the_lot_off (x)));
    if (lc.empty ())
    {   nits.pick (nit_unrecognised_schema, es_error, ec_microdata, "A schema cannot have an empty name");
        return sch_illegal; }
    if (lc.at (0) == '/') lc = lc.substr (1);
    symbol < e_schema > s (lc);
    if (s.unknown ())
    {   if (! check_spelling (nits, v, lc))
            nits.pick (nit_unrecognised_schema, es_error, ec_microdata, "Unknown schema ITEMTYPE ", quote (x)); }
    else
    {   schema_version sv (context.schema_ver ());
        if (! sv.unknown ())
        {   if (may_apply (sv, s.first (), s.last ()))
            {   // context.mark (s.get ());
                return s.get (); }
            nits.pick (nit_unrecognised_schema, es_error, ec_microdata, quote (x), " is invalid in schema ", sv.report ()); } }
    return sch_illegal; }

bool sch::enumerated () const
{ return enumerated_schema_type (flags ()); }

bool sch::has_simple_type () const
{ return has_simple_schema_type (flags ()); }

bool sch::external_enumerated () const
{ return external_enumerated_schema_type (flags ()); }

e_type sch::get_simple_type () const
{ return get_simple_schema_type (flags ()); }

bool enumerated_schema_type (const uint64_t flags)
{ return (flags & SF_ENUMERATION) == SF_ENUMERATION; }

bool has_simple_schema_type (const uint64_t flags)
{ return (flags & SF_SIMPLE_MASK) != 0; }

bool external_enumerated_schema_type (const uint64_t flags)
{ return ( flags & SF_EXTERNAL_ENUMERATION) == SF_EXTERNAL_ENUMERATION; }

e_type get_simple_schema_type (const uint64_t flags)
{ return static_cast < e_type> (flags & SF_SIMPLE_MASK); }
