  /*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "standard.h"
#include "type_mime.h"

struct symbol_entry < e_mimetype > mimetype_symbol_table [] =
{   { { HTML_4_0 }, { HTML_UNDEF }, "example/context-defined", mime_context },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/1d-interleaved-parityfec", mime_application_1d_interleaved_parityfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/3gpdash-qoe-report+xml", mime_application_3gpdash_qoe_report_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/3gpp-ims+xml", mime_application_3gpp_ims_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/A2L", mime_application_A2L },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/activemessage", mime_application_activemessage },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/activity+json", mime_application_activity_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-costmap+json", mime_application_alto_costmap_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-costmapfilter+json", mime_application_alto_costmapfilter_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-directory+json", mime_application_alto_directory_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-endpointprop+json", mime_application_alto_endpointprop_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-endpointpropparams+json", mime_application_alto_endpointpropparams_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-endpointcost+json", mime_application_alto_endpointcost_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-endpointcostparams+json", mime_application_alto_endpointcostparams_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-error+json", mime_application_alto_error_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-networkmapfilter+json", mime_application_alto_networkmapfilter_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-networkmap+json", mime_application_alto_networkmap_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-updatestreamcontrol+json", mime_application_alto_updatestreamcontrol_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/alto-updatestreamparams+json", mime_application_alto_updatestreamparams_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/AML", mime_application_AML },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/andrew-inset", mime_application_andrew_inset },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/applefile", mime_application_applefile },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ATF", mime_application_ATF },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ATFX", mime_application_ATFX },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atom+xml", mime_application_atom_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atomcat+xml", mime_application_atomcat_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atomdeleted+xml", mime_application_atomdeleted_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atomicmail", mime_application_atomicmail },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atomsvc+xml", mime_application_atomsvc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atsc-dwd+xml", mime_application_atsc_dwd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atsc-dynamic-event-message", mime_application_atsc_dynamic_event_message },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atsc-held+xml", mime_application_atsc_held_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atsc-rdt+json", mime_application_atsc_rdt_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/atsc-rsat+xml", mime_application_atsc_rsat_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ATXML", mime_application_ATXML },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/auth-policy+xml", mime_application_auth_policy_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/bacnet-xdd+zip", mime_application_bacnet_xdd_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/batch-SMTP", mime_application_batch_SMTP },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/beep+xml", mime_application_beep_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/calendar+json", mime_application_calendar_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/calendar+xml", mime_application_calendar_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/call-completion", mime_application_call_completion },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/CALS-1840", mime_application_CALS_1840 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cap+xml", mime_application_cap_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cbor", mime_application_cbor },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cbor-seq", mime_application_cbor_seq },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cccex", mime_application_cccex },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ccmp+xml", mime_application_ccmp_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ccxml+xml", mime_application_ccxml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/CDFX+XML", mime_application_CDFX_XML },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cdmi-capability", mime_application_cdmi_capability },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cdmi-container", mime_application_cdmi_container },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cdmi-domain", mime_application_cdmi_domain },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cdmi-object", mime_application_cdmi_object },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cdmi-queue", mime_application_cdmi_queue },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cdni", mime_application_cdni },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/CEA", mime_application_CEA },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cea-2018+xml", mime_application_cea_2018_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cellml+xml", mime_application_cellml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cfw", mime_application_cfw },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/clue_info+xml", mime_application_clue_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/clue+xml", mime_application_clue_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cms", mime_application_cms },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cnrp+xml", mime_application_cnrp_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/coap-group+json", mime_application_coap_group_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/coap-payload", mime_application_coap_payload },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/commonground", mime_application_commonground },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/conference-info+xml", mime_application_conference_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cpl+xml", mime_application_cpl_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cose", mime_application_cose },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cose-key", mime_application_cose_key },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cose-key-set", mime_application_cose_key_set },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/csrattrs", mime_application_csrattrs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/csta+xml", mime_application_csta_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/CSTAdata+xml", mime_application_CSTAdata_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/csvm+json", mime_application_csvm_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cwt", mime_application_cwt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/cybercash", mime_application_cybercash },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dash+xml", mime_application_dash_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dashdelta", mime_application_dashdelta },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/davmount+xml", mime_application_davmount_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dca-rft", mime_application_dca_rft },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/DCD", mime_application_DCD },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dec-dx", mime_application_dec_dx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dialog-info+xml", mime_application_dialog_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dicom", mime_application_dicom },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dicom+json", mime_application_dicom_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dicom+xml", mime_application_dicom_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/DII", mime_application_DII },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/DIT", mime_application_DIT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dns", mime_application_dns },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dns+json", mime_application_dns_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dns-message", mime_application_dns_message },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dots+cbor", mime_application_dots_cbor },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dskpp+xml", mime_application_dskpp_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dssc+der", mime_application_dssc_der },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dssc+xml", mime_application_dssc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/dvcs", mime_application_dvcs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ecmascript", mime_application_ecmascript, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EDI-consent", mime_application_EDI_consent },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EDIFACT", mime_application_EDIFACT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EDI-X12", mime_application_EDI_X12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/efi", mime_application_efi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EmergencyCallData.Comment+xml", mime_application_EmergencyCallData_Comment_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EmergencyCallData.Control+xml", mime_application_EmergencyCallData_Control_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EmergencyCallData.DeviceInfo+xml", mime_application_EmergencyCallData_DeviceInfo_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EmergencyCallData.eCall.MSD", mime_application_EmergencyCallData_eCall_MSD },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EmergencyCallData.ProviderInfo+xml", mime_application_EmergencyCallData_ProviderInfo_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EmergencyCallData.ServiceInfo+xml", mime_application_EmergencyCallData_ServiceInfo_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EmergencyCallData.SubscriberInfo+xml", mime_application_EmergencyCallData_SubscriberInfo_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/EmergencyCallData.VEDS+xml", mime_application_EmergencyCallData_VEDS_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/emma+xml", mime_application_emma_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/emotionml+xml", mime_application_emotionml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/encaprtp", mime_application_encaprtp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/epp+xml", mime_application_epp_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/epub+zip", mime_application_epub_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/eshop", mime_application_eshop },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/example", mime_application_example },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/exi", mime_application_exi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/expect-ct-report+json", mime_application_expect_ct_report_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/fastinfoset", mime_application_fastinfoset },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/fastsoap", mime_application_fastsoap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/fdt+xml", mime_application_fdt_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/fhir+json", mime_application_fhir_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/fhir+xml", mime_application_fhir_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/fits", mime_application_fits },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/flexfec", mime_application_flexfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/font-sfnt", mime_application_font_sfnt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/font-tdpfr", mime_application_font_tdpfr },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/font-woff", mime_application_font_woff },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/framework-attributes+xml", mime_application_framework_attributes_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/geo+json", mime_application_geo_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/geo+json-seq", mime_application_geo_json_seq },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/geopackage+sqlite3", mime_application_geopackage_sqlite3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/geoxacml+xml", mime_application_geoxacml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/gltf-buffer", mime_application_gltf_buffer },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/gml+xml", mime_application_gml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/gzip", mime_application_gzip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/H224", mime_application_H224 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/held+xml", mime_application_held_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/http", mime_application_http },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/hyperstudio", mime_application_hyperstudio },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ibe-key-request+xml", mime_application_ibe_key_request_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ibe-pkg-reply+xml", mime_application_ibe_pkg_reply_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ibe-pp-data", mime_application_ibe_pp_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/iges", mime_application_iges },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/im-iscomposing+xml", mime_application_im_iscomposing_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/index", mime_application_index },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/index.cmd", mime_application_index_cmd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/index.obj", mime_application_index_obj },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/index.response", mime_application_index_response },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/index.vnd", mime_application_index_vnd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/inkml+xml", mime_application_inkml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/IOTP", mime_application_IOTP },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ipfix", mime_application_ipfix },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ipp", mime_application_ipp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ISUP", mime_application_ISUP },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/its+xml", mime_application_its_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/java", mime_application_java, ns_default, SCRIPT }, // in HTML4.01 spec
    { { HTML_4_0 }, { HTML_UNDEF }, "application/java-archive", mime_application_java_archive, ns_default, SCRIPT }, // in HTML4.01 spec
    { { HTML_4_0 }, { HTML_UNDEF }, "application/javascript", mime_application_javascript, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/jf2feed+json", mime_application_jf2feed_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/jose", mime_application_jose },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/jose+json", mime_application_jose_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/jrd+json", mime_application_jrd_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/json", mime_application_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/json-patch+json", mime_application_json_patch_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/json-seq", mime_application_json_seq },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/jwk+json", mime_application_jwk_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/jwk-set+json", mime_application_jwk_set_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/jwt", mime_application_jwt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/kpml-request+xml", mime_application_kpml_request_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/kpml-response+xml", mime_application_kpml_response_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ld+json", mime_application_ld_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/lgr+xml", mime_application_lgr_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/link-format", mime_application_link_format },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/load-control+xml", mime_application_load_control_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/lost+xml", mime_application_lost_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/lostsync+xml", mime_application_lostsync_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/lpf+zip", mime_application_lpf_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/LXF", mime_application_LXF },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mac-binhex40", mime_application_mac_binhex40 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/macwriteii", mime_application_macwriteii },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mads+xml", mime_application_mads_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/marc", mime_application_marc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/marcxml+xml", mime_application_marcxml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mathematica", mime_application_mathematica },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mathml-content+xml", mime_application_mathml_content_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mathml-presentation+xml", mime_application_mathml_presentation_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mathml+xml", mime_application_mathml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-associated-procedure-description+xml", mime_application_mbms_associated_procedure_description_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-deregister+xml", mime_application_mbms_deregister_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-envelope+xml", mime_application_mbms_envelope_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-msk-response+xml", mime_application_mbms_msk_response_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-msk+xml", mime_application_mbms_msk_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-protection-description+xml", mime_application_mbms_protection_description_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-reception-report+xml", mime_application_mbms_reception_report_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-register-response+xml", mime_application_mbms_register_response_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-register+xml", mime_application_mbms_register_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-schedule+xml", mime_application_mbms_schedule_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbms-user-service-description+xml", mime_application_mbms_user_service_description_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mbox", mime_application_mbox },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/media_control+xml", mime_application_media_control_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/media-policy-dataset+xml", mime_application_media_policy_dataset_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mediaservercontrol+xml", mime_application_mediaservercontrol_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/merge-patch+json", mime_application_merge_patch_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/metalink4+xml", mime_application_metalink4_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mets+xml", mime_application_mets_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/MF4", mime_application_MF4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mikey", mime_application_mikey },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mipc", mime_application_mipc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mmt-aei+xml", mime_application_mmt_aei_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mmt-usd+xml", mime_application_mmt_usd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mods+xml", mime_application_mods_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/moss-keys", mime_application_moss_keys },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/moss-signature", mime_application_moss_signature },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mosskey-data", mime_application_mosskey_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mosskey-request", mime_application_mosskey_request },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mp21", mime_application_mp21 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mp4", mime_application_mp4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mpeg4-generic", mime_application_mpeg4_generic },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mpeg4-iod", mime_application_mpeg4_iod },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mpeg4-iod-xmt", mime_application_mpeg4_iod_xmt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mrb-consumer+xml", mime_application_mrb_consumer_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mrb-publish+xml", mime_application_mrb_publish_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/msc-ivr+xml", mime_application_msc_ivr_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/msc-mixer+xml", mime_application_msc_mixer_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/msword", mime_application_msword },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mud+json", mime_application_mud_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/multipart-core", mime_application_multipart_core },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/mxf", mime_application_mxf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/n-quads", mime_application_n_quads },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/n-triples", mime_application_n_triples },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/nasdata", mime_application_nasdata },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/news-checkgroups", mime_application_news_checkgroups },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/news-groupinfo", mime_application_news_groupinfo },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/news-transmission", mime_application_news_transmission },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/nlsml+xml", mime_application_nlsml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/node", mime_application_node },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/nss", mime_application_nss },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ocsp-request", mime_application_ocsp_request },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ocsp-response", mime_application_ocsp_response },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/octet-stream", mime_application_octet_stream, ns_default, NOT_SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ODA", mime_application_ODA },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/odm+xml", mime_application_odm_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ODX", mime_application_ODX },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/oebps-package+xml", mime_application_oebps_package_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ogg", mime_application_ogg },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/oscore", mime_application_oscore },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/oxps", mime_application_oxps },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/p2p-overlay+xml", mime_application_p2p_overlay_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/parityfec", mime_application_parityfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/passport", mime_application_passport },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/patch-ops-error+xml", mime_application_patch_ops_error_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pdf", mime_application_pdf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/PDX", mime_application_PDX },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pem-certificate-chain", mime_application_pem_certificate_chain },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pgp-encrypted", mime_application_pgp_encrypted },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pgp-keys", mime_application_pgp_keys },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pgp-signature", mime_application_pgp_signature },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pidf-diff+xml", mime_application_pidf_diff_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pidf+xml", mime_application_pidf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkcs10", mime_application_pkcs10 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkcs7-mime", mime_application_pkcs7_mime },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkcs7-signature", mime_application_pkcs7_signature },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkcs8", mime_application_pkcs8 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkcs8-encrypted", mime_application_pkcs8_encrypted },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkcs12", mime_application_pkcs12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkix-attr-cert", mime_application_pkix_attr_cert },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkix-cert", mime_application_pkix_cert },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkix-crl", mime_application_pkix_crl },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkix-pkipath", mime_application_pkix_pkipath },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pkixcmp", mime_application_pkixcmp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pls+xml", mime_application_pls_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/poc-settings+xml", mime_application_poc_settings_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/postscript", mime_application_postscript },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ppsp-tracker+json", mime_application_ppsp_tracker_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/problem+json", mime_application_problem_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/problem+xml", mime_application_problem_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/provenance+xml", mime_application_provenance_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/prs.alvestrand.titrax-sheet", mime_application_prs_alvestrand_titrax_sheet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/prs.cww", mime_application_prs_cww },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/prs.hpub+zip", mime_application_prs_hpub_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/prs.nprend", mime_application_prs_nprend },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/prs.plucker", mime_application_prs_plucker },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/prs.rdf-xml-crypt", mime_application_prs_rdf_xml_crypt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/prs.xsf+xml", mime_application_prs_xsf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pskc+xml", mime_application_pskc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/pvd+json", mime_application_pvd_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rdf+xml", mime_application_rdf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/route-apd+xml", mime_application_route_apd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/route-s-tsid+xml", mime_application_route_s_tsid_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/route-usd+xml", mime_application_route_usd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/QSIG", mime_application_QSIG },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/raptorfec", mime_application_raptorfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rdap+json", mime_application_rdap_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/reginfo+xml", mime_application_reginfo_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/relax-ng-compact-syntax", mime_application_relax_ng_compact_syntax },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/remote-printing", mime_application_remote_printing },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/reputon+json", mime_application_reputon_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/resource-lists-diff+xml", mime_application_resource_lists_diff_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/resource-lists+xml", mime_application_resource_lists_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rfc+xml", mime_application_rfc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/riscos", mime_application_riscos },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rlmi+xml", mime_application_rlmi_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rls-services+xml", mime_application_rls_services_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rpki-ghostbusters", mime_application_rpki_ghostbusters },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rpki-manifest", mime_application_rpki_manifest },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rpki-publication", mime_application_rpki_publication },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rpki-roa", mime_application_rpki_roa },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rpki-updown", mime_application_rpki_updown },
    { { HTML_4_01 }, { HTML_UNDEF }, "application/rss+xml", mime_application_rss_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rtf", mime_application_rtf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rtploopback", mime_application_rtploopback },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/rtx", mime_application_rtx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/samlassertion+xml", mime_application_samlassertion_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/samlmetadata+xml", mime_application_samlmetadata_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sbe", mime_application_sbe },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sbml+xml", mime_application_sbml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/scaip+xml", mime_application_scaip_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/scim+json", mime_application_scim_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/scvp-cv-request", mime_application_scvp_cv_request },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/scvp-cv-response", mime_application_scvp_cv_response },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/scvp-vp-request", mime_application_scvp_vp_request },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/scvp-vp-response", mime_application_scvp_vp_response },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sdp", mime_application_sdp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/secevent+jwt", mime_application_secevent_jwt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/senml-etch+cbor", mime_application_senml_etch_cbor },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/senml-etch+json", mime_application_senml_etch_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/senml-exi", mime_application_senml_exi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/senml+cbor", mime_application_senml_cbor },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/senml+json", mime_application_senml_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/senml+xml", mime_application_senml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sensml-exi", mime_application_sensml_exi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sensml+cbor", mime_application_sensml_cbor },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sensml+json", mime_application_sensml_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sensml+xml", mime_application_sensml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sep-exi", mime_application_sep_exi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sep+xml", mime_application_sep_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/session-info", mime_application_session_info },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/set-payment", mime_application_set_payment },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/set-payment-initiation", mime_application_set_payment_initiation },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/set-registration", mime_application_set_registration },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/set-registration-initiation", mime_application_set_registration_initiation },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/SGML", mime_application_SGML },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sgml-open-catalog", mime_application_sgml_open_catalog },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/shf+xml", mime_application_shf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sieve", mime_application_sieve },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/simple-filter+xml", mime_application_simple_filter_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/simple-message-summary", mime_application_simple_message_summary },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/simpleSymbolContainer", mime_application_simpleSymbolContainer },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sipc", mime_application_sipc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/slate", mime_application_slate },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/smil", mime_application_smil },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/smil+xml", mime_application_smil_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/smpte336m", mime_application_smpte336m },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/soap+fastinfoset", mime_application_soap_fastinfoset },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/soap+xml", mime_application_soap_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sparql-query", mime_application_sparql_query },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sparql-results+xml", mime_application_sparql_results_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/spirits-event+xml", mime_application_spirits_event_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sql", mime_application_sql },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/srgs", mime_application_srgs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/srgs+xml", mime_application_srgs_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/sru+xml", mime_application_sru_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ssml+xml", mime_application_ssml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/stix+json", mime_application_stix_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/swid+xml", mime_application_swid_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-apex-update", mime_application_tamp_apex_update },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-apex-update-confirm", mime_application_tamp_apex_update_confirm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-community-update", mime_application_tamp_community_update },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-community-update-confirm", mime_application_tamp_community_update_confirm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-error", mime_application_tamp_error },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-sequence-adjust", mime_application_tamp_sequence_adjust },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-sequence-adjust-confirm", mime_application_tamp_sequence_adjust_confirm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-status-query", mime_application_tamp_status_query },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-status-response", mime_application_tamp_status_response },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-update", mime_application_tamp_update },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tamp-update-confirm", mime_application_tamp_update_confirm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/taxii+json", mime_application_taxii_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tcl", mime_application_tcl, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/td+json", mime_application_td_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tei+xml", mime_application_tei_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/TETRA_ISI", mime_application_TETRA_ISI },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/thraud+xml", mime_application_thraud_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/timestamp-query", mime_application_timestamp_query },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/timestamp-reply", mime_application_timestamp_reply },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/timestamped-data", mime_application_timestamped_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tlsrpt+gzip", mime_application_tlsrpt_gzip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tlsrpt+json", mime_application_tlsrpt_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tnauthlist", mime_application_tnauthlist },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/trickle-ice-sdpfrag", mime_application_trickle_ice_sdpfrag },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/trig", mime_application_trig },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ttml+xml", mime_application_ttml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tve-trigger", mime_application_tve_trigger },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tzif", mime_application_tzif },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/tzif-leap", mime_application_tzif_leap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/ulpfec", mime_application_ulpfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/urc-grpsheet+xml", mime_application_urc_grpsheet_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/urc-ressheet+xml", mime_application_urc_ressheet_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/urc-targetdesc+xml", mime_application_urc_targetdesc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/urc-uisocketdesc+xml", mime_application_urc_uisocketdesc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vbscript", mime_application_vbscript, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vcard+json", mime_application_vcard_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vcard+xml", mime_application_vcard_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vemmi", mime_application_vemmi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.1000minds.decision-model+xml", mime_application_vnd_1000minds_decision_model_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.access-transfer-events+xml", mime_application_vnd_3gpp_access_transfer_events_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.bsf+xml", mime_application_vnd_3gpp_bsf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.GMOP+xml", mime_application_vnd_3gpp_GMOP_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mc-signalling-ear", mime_application_vnd_3gpp_mc_signalling_ear },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcdata-affiliation-command+xml", mime_application_vnd_3gpp_mcdata_affiliation_command_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcdata-info+xml", mime_application_vnd_3gpp_mcdata_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcdata-payload", mime_application_vnd_3gpp_mcdata_payload },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcdata-service-config+xml", mime_application_vnd_3gpp_mcdata_service_config_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcdata-signalling", mime_application_vnd_3gpp_mcdata_signalling },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcdata-ue-config+xml", mime_application_vnd_3gpp_mcdata_ue_config_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcdata-user-profile+xml", mime_application_vnd_3gpp_mcdata_user_profile_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-affiliation-command+xml", mime_application_vnd_3gpp_mcptt_affiliation_command_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-floor-request+xml", mime_application_vnd_3gpp_mcptt_floor_request_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-info+xml", mime_application_vnd_3gpp_mcptt_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-location-info+xml", mime_application_vnd_3gpp_mcptt_location_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-mbms-usage-info+xml", mime_application_vnd_3gpp_mcptt_mbms_usage_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-service-config+xml", mime_application_vnd_3gpp_mcptt_service_config_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-signed+xml", mime_application_vnd_3gpp_mcptt_signed_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-ue-config+xml", mime_application_vnd_3gpp_mcptt_ue_config_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-ue-init-config+xml", mime_application_vnd_3gpp_mcptt_ue_init_config_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcptt-user-profile+xml", mime_application_vnd_3gpp_mcptt_user_profile_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-affiliation-command+xml", mime_application_vnd_3gpp_mcvideo_affiliation_command_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-affiliation-info+xml", mime_application_vnd_3gpp_mcvideo_affiliation_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-info+xml", mime_application_vnd_3gpp_mcvideo_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-location-info+xml", mime_application_vnd_3gpp_mcvideo_location_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-mbms-usage-info+xml", mime_application_vnd_3gpp_mcvideo_mbms_usage_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-service-config+xml", mime_application_vnd_3gpp_mcvideo_service_config_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-transmission-request+xml", mime_application_vnd_3gpp_mcvideo_transmission_request_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-ue-config+xml", mime_application_vnd_3gpp_mcvideo_ue_config_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mcvideo-user-profile+xml", mime_application_vnd_3gpp_mcvideo_user_profile_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.mid-call+xml", mime_application_vnd_3gpp_mid_call_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.pic-bw-large", mime_application_vnd_3gpp_pic_bw_large },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.pic-bw-small", mime_application_vnd_3gpp_pic_bw_small },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.pic-bw-var", mime_application_vnd_3gpp_pic_bw_var },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp-prose-pc3ch+xml", mime_application_vnd_3gpp_prose_pc3ch_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp-prose+xml", mime_application_vnd_3gpp_prose_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.sms", mime_application_vnd_3gpp_sms },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.sms+xml", mime_application_vnd_3gpp_sms_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.srvcc-ext+xml", mime_application_vnd_3gpp_srvcc_ext_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.SRVCC-info+xml", mime_application_vnd_3gpp_SRVCC_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.state-and-event-info+xml", mime_application_vnd_3gpp_state_and_event_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp.ussd+xml", mime_application_vnd_3gpp_ussd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp-v2x-local-service-information", mime_application_vnd_3gpp_v2x_local_service_information },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp2.bcmcsinfo+xml", mime_application_vnd_3gpp2_bcmcsinfo_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp2.sms", mime_application_vnd_3gpp2_sms },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3gpp2.tcap", mime_application_vnd_3gpp2_tcap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3lightssoftware.imagescal", mime_application_vnd_3lightssoftware_imagescal },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.3M.Post-it-Notes", mime_application_vnd_3M_Post_it_Notes },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.accpac.simply.aso", mime_application_vnd_accpac_simply_aso },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.accpac.simply.imp", mime_application_vnd_accpac_simply_imp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.acucobol", mime_application_vnd_acucobol },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.acucorp", mime_application_vnd_acucorp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.adobe.flash.movie", mime_application_vnd_adobe_flash_movie },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.adobe.formscentral.fcdt", mime_application_vnd_adobe_formscentral_fcdt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.adobe.fxp", mime_application_vnd_adobe_fxp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.adobe.partial-upload", mime_application_vnd_adobe_partial_upload },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.adobe.xdp+xml", mime_application_vnd_adobe_xdp_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.adobe.xfdf", mime_application_vnd_adobe_xfdf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.aether.imp", mime_application_vnd_aether_imp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.afplinedata", mime_application_vnd_afpc_afplinedata },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.afplinedata-pagedef", mime_application_vnd_afpc_afplinedata_pagedef },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.foca-charset", mime_application_vnd_afpc_foca_charset },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.foca-codedfont", mime_application_vnd_afpc_foca_codedfont },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.foca-codepage", mime_application_vnd_afpc_foca_codepage },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.modca", mime_application_vnd_afpc_modca },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.modca-formdef", mime_application_vnd_afpc_modca_formdef },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.modca-mediummap", mime_application_vnd_afpc_modca_mediummap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.modca-objectcontainer", mime_application_vnd_afpc_modca_objectcontainer },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.modca-overlay", mime_application_vnd_afpc_modca_overlay },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.afpc.modca-pagesegment", mime_application_vnd_afpc_modca_pagesegment },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ah-barcode", mime_application_vnd_ah_barcode },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ahead.space", mime_application_vnd_ahead_space },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.airzip.filesecure.azf", mime_application_vnd_airzip_filesecure_azf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.airzip.filesecure.azs", mime_application_vnd_airzip_filesecure_azs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.amadeus+json", mime_application_vnd_amadeus_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.amazon.mobi8-ebook", mime_application_vnd_amazon_mobi8_ebook },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.americandynamics.acc", mime_application_vnd_americandynamics_acc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.amiga.ami", mime_application_vnd_amiga_ami },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.amundsen.maze+xml", mime_application_vnd_amundsen_maze_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.android.ota", mime_application_vnd_android_ota },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.anki", mime_application_vnd_anki },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.anser-web-certificate-issue-initiation", mime_application_vnd_anser_web_certificate_issue_initiation },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.antix.game-component", mime_application_vnd_antix_game_component },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apache.thrift.binary", mime_application_vnd_apache_thrift_binary },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apache.thrift.compact", mime_application_vnd_apache_thrift_compact },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apache.thrift.json", mime_application_vnd_apache_thrift_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.api+json", mime_application_vnd_api_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.aplextor.warrp+json", mime_application_vnd_aplextor_warrp_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apothekende.reservation+json", mime_application_vnd_apothekende_reservation_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apple.installer+xml", mime_application_vnd_apple_installer_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apple.keynote", mime_application_vnd_apple_keynote },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apple.mpegurl", mime_application_vnd_apple_mpegurl },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apple.numbers", mime_application_vnd_apple_numbers },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.apple.pages", mime_application_vnd_apple_pages },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.arastra.swi", mime_application_vnd_arastra_swi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.aristanetworks.swi", mime_application_vnd_aristanetworks_swi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.artisan+json", mime_application_vnd_artisan_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.artsquare", mime_application_vnd_artsquare },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.astraea-software.iota", mime_application_vnd_astraea_software_iota },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.audiograph", mime_application_vnd_audiograph },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.autopackage", mime_application_vnd_autopackage },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.avalon+json", mime_application_vnd_avalon_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.avistar+xml", mime_application_vnd_avistar_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.balsamiq.bmml+xml", mime_application_vnd_balsamiq_bmml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.banana-accounting", mime_application_vnd_banana_accounting },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bbf.usp.error", mime_application_vnd_bbf_usp_error },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bbf.usp.msg", mime_application_vnd_bbf_usp_msg },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bbf.usp.msg+json", mime_application_vnd_bbf_usp_msg_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.balsamiq.bmpr", mime_application_vnd_balsamiq_bmpr },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bekitzur-stech+json", mime_application_vnd_bekitzur_stech_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bint.med-content", mime_application_vnd_bint_med_content },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.biopax.rdf+xml", mime_application_vnd_biopax_rdf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.blink-idb-value-wrapper", mime_application_vnd_blink_idb_value_wrapper },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.blueice.multipass", mime_application_vnd_blueice_multipass },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bluetooth.ep.oob", mime_application_vnd_bluetooth_ep_oob },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bluetooth.le.oob", mime_application_vnd_bluetooth_le_oob },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bmi", mime_application_vnd_bmi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bpf", mime_application_vnd_bpf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.bpf3", mime_application_vnd_bpf3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.businessobjects", mime_application_vnd_businessobjects },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.byu.uapi+json", mime_application_vnd_byu_uapi_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cab-jscript", mime_application_vnd_cab_jscript },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.canon-cpdl", mime_application_vnd_canon_cpdl },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.canon-lips", mime_application_vnd_canon_lips },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.capasystems-pg+json", mime_application_vnd_capasystems_pg_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cendio.thinlinc.clientconf", mime_application_vnd_cendio_thinlinc_clientconf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.century-systems.tcp_stream", mime_application_vnd_century_systems_tcp_stream },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.chemdraw+xml", mime_application_vnd_chemdraw_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.chess-pgn", mime_application_vnd_chess_pgn },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.chipnuts.karaoke-mmd", mime_application_vnd_chipnuts_karaoke_mmd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ciedi", mime_application_vnd_ciedi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cinderella", mime_application_vnd_cinderella },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cirpack.isdn-ext", mime_application_vnd_cirpack_isdn_ext },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.citationstyles.style+xml", mime_application_vnd_citationstyles_style_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.claymore", mime_application_vnd_claymore },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cloanto.rp9", mime_application_vnd_cloanto_rp9 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.clonk.c4group", mime_application_vnd_clonk_c4group },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cluetrust.cartomobile-config", mime_application_vnd_cluetrust_cartomobile_config },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cluetrust.cartomobile-config-pkg", mime_application_vnd_cluetrust_cartomobile_config_pkg },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.coffeescript", mime_application_vnd_coffeescript },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collabio.xodocuments.document", mime_application_vnd_collabio_xodocuments_document },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collabio.xodocuments.document-template", mime_application_vnd_collabio_xodocuments_document_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collabio.xodocuments.presentation", mime_application_vnd_collabio_xodocuments_presentation },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collabio.xodocuments.presentation-template", mime_application_vnd_collabio_xodocuments_presentation_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collabio.xodocuments.spreadsheet", mime_application_vnd_collabio_xodocuments_spreadsheet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collabio.xodocuments.spreadsheet-template", mime_application_vnd_collabio_xodocuments_spreadsheet_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collection.doc+json", mime_application_vnd_collection_doc_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collection+json", mime_application_vnd_collection_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.collection.next+json", mime_application_vnd_collection_next_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.comicbook-rar", mime_application_vnd_comicbook_rar },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.comicbook+zip", mime_application_vnd_comicbook_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.commerce-battelle", mime_application_vnd_commerce_battelle },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.commonspace", mime_application_vnd_commonspace },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.coreos.ignition+json", mime_application_vnd_coreos_ignition_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cosmocaller", mime_application_vnd_cosmocaller },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.contact.cmsg", mime_application_vnd_contact_cmsg },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.crick.clicker", mime_application_vnd_crick_clicker },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.crick.clicker.keyboard", mime_application_vnd_crick_clicker_keyboard },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.crick.clicker.palette", mime_application_vnd_crick_clicker_palette },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.crick.clicker.template", mime_application_vnd_crick_clicker_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.crick.clicker.wordbank", mime_application_vnd_crick_clicker_wordbank },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.criticaltools.wbs+xml", mime_application_vnd_criticaltools_wbs_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cryptii.pipe+json", mime_application_vnd_cryptii_pipe_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.crypto-shade-file", mime_application_vnd_crypto_shade_file },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ctc-posml", mime_application_vnd_ctc_posml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ctct.ws+xml", mime_application_vnd_ctct_ws_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cups-pdf", mime_application_vnd_cups_pdf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cups-postscript", mime_application_vnd_cups_postscript },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cups-ppd", mime_application_vnd_cups_ppd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cups-raster", mime_application_vnd_cups_raster },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cups-raw", mime_application_vnd_cups_raw },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.curl", mime_application_vnd_curl },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cyan.dean.root+xml", mime_application_vnd_cyan_dean_root_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.cybank", mime_application_vnd_cybank },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.d2l.coursepackage1p0+zip", mime_application_vnd_d2l_coursepackage1p0_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dart", mime_application_vnd_dart },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.data-vision.rdz", mime_application_vnd_data_vision_rdz },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.datapackage+json", mime_application_vnd_datapackage_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dataresource+json", mime_application_vnd_dataresource_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dbf", mime_application_vnd_dbf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.debian.binary-package", mime_application_vnd_debian_binary_package },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dece.data", mime_application_vnd_dece_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dece.ttml+xml", mime_application_vnd_dece_ttml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dece.unspecified", mime_application_vnd_dece_unspecified },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dece.zip", mime_application_vnd_dece_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.denovo.fcselayout-link", mime_application_vnd_denovo_fcselayout_link },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.desmume.movie", mime_application_vnd_desmume_movie },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dir-bi.plate-dl-nosuffix", mime_application_vnd_dir_bi_plate_dl_nosuffix },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dm.delegation+xml", mime_application_vnd_dm_delegation_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dna", mime_application_vnd_dna },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.document+json", mime_application_vnd_document_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dolby.mobile.1", mime_application_vnd_dolby_mobile_1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dolby.mobile.2", mime_application_vnd_dolby_mobile_2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.doremir.scorecloud-binary-document", mime_application_vnd_doremir_scorecloud_binary_document },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dpgraph", mime_application_vnd_dpgraph },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dreamfactory", mime_application_vnd_dreamfactory },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.drive+json", mime_application_vnd_drive_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dtg.local", mime_application_vnd_dtg_local },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dtg.local.flash", mime_application_vnd_dtg_local_flash },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dtg.local.html", mime_application_vnd_dtg_local_html },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.ait", mime_application_vnd_dvb_ait },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.dvbisl+xml", mime_application_vnd_dvb_dvbisl_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.dvbj", mime_application_vnd_dvb_dvbj },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.esgcontainer", mime_application_vnd_dvb_esgcontainer },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.ipdcdftnotifaccess", mime_application_vnd_dvb_ipdcdftnotifaccess },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.ipdcesgaccess", mime_application_vnd_dvb_ipdcesgaccess },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.ipdcesgaccess2", mime_application_vnd_dvb_ipdcesgaccess2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.ipdcesgpdd", mime_application_vnd_dvb_ipdcesgpdd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.ipdcroaming", mime_application_vnd_dvb_ipdcroaming },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.iptv.alfec-base", mime_application_vnd_dvb_iptv_alfec_base },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.iptv.alfec-enhancement", mime_application_vnd_dvb_iptv_alfec_enhancement },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.notif-aggregate-root+xml", mime_application_vnd_dvb_notif_aggregate_root_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.notif-container+xml", mime_application_vnd_dvb_notif_container_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.notif-generic+xml", mime_application_vnd_dvb_notif_generic_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.notif-ia-msglist+xml", mime_application_vnd_dvb_notif_ia_msglist_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.notif-ia-registration-request+xml", mime_application_vnd_dvb_notif_ia_registration_request_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.notif-ia-registration-response+xml", mime_application_vnd_dvb_notif_ia_registration_response_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.notif-init+xml", mime_application_vnd_dvb_notif_init_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.pfr", mime_application_vnd_dvb_pfr },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dvb.service", mime_application_vnd_dvb_service },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dxr", mime_application_vnd_dxr },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dynageo", mime_application_vnd_dynageo },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.dzr", mime_application_vnd_dzr },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.easykaraoke.cdgdownload", mime_application_vnd_easykaraoke_cdgdownload },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ecip.rlp", mime_application_vnd_ecip_rlp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ecdis-update", mime_application_vnd_ecdis_update },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ecowin.chart", mime_application_vnd_ecowin_chart },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ecowin.filerequest", mime_application_vnd_ecowin_filerequest },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ecowin.fileupdate", mime_application_vnd_ecowin_fileupdate },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ecowin.series", mime_application_vnd_ecowin_series },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ecowin.seriesrequest", mime_application_vnd_ecowin_seriesrequest },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ecowin.seriesupdate", mime_application_vnd_ecowin_seriesupdate },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.efi.img", mime_application_vnd_efi_img },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.efi.iso", mime_application_vnd_efi_iso },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.emclient.accessrequest+xml", mime_application_vnd_emclient_accessrequest_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.enliven", mime_application_vnd_enliven },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.enphase.envoy", mime_application_vnd_enphase_envoy },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.eprints.data+xml", mime_application_vnd_eprints_data_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.epson.esf", mime_application_vnd_epson_esf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.epson.msf", mime_application_vnd_epson_msf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.epson.quickanime", mime_application_vnd_epson_quickanime },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.epson.salt", mime_application_vnd_epson_salt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.epson.ssf", mime_application_vnd_epson_ssf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ericsson.quickcall", mime_application_vnd_ericsson_quickcall },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.espass-espass+zip", mime_application_vnd_espass_espass_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.eszigno3+xml", mime_application_vnd_eszigno3_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.aoc+xml", mime_application_vnd_etsi_aoc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.asic-s+zip", mime_application_vnd_etsi_asic_s_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.asic-e+zip", mime_application_vnd_etsi_asic_e_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.cug+xml", mime_application_vnd_etsi_cug_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvcommand+xml", mime_application_vnd_etsi_iptvcommand_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvdiscovery+xml", mime_application_vnd_etsi_iptvdiscovery_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvprofile+xml", mime_application_vnd_etsi_iptvprofile_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvsad-bc+xml", mime_application_vnd_etsi_iptvsad_bc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvsad-cod+xml", mime_application_vnd_etsi_iptvsad_cod_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvsad-npvr+xml", mime_application_vnd_etsi_iptvsad_npvr_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvservice+xml", mime_application_vnd_etsi_iptvservice_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvsync+xml", mime_application_vnd_etsi_iptvsync_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.iptvueprofile+xml", mime_application_vnd_etsi_iptvueprofile_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.mcid+xml", mime_application_vnd_etsi_mcid_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.mheg5", mime_application_vnd_etsi_mheg5 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.overload-control-policy-dataset+xml", mime_application_vnd_etsi_overload_control_policy_dataset_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.pstn+xml", mime_application_vnd_etsi_pstn_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.sci+xml", mime_application_vnd_etsi_sci_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.simservs+xml", mime_application_vnd_etsi_simservs_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.timestamp-token", mime_application_vnd_etsi_timestamp_token },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.tsl+xml", mime_application_vnd_etsi_tsl_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.etsi.tsl.der", mime_application_vnd_etsi_tsl_der },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.evolv.ecig.profile", mime_application_vnd_evolv_ecig_profile },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.evolv.ecig.settings", mime_application_vnd_evolv_ecig_settings },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.evolv.ecig.theme", mime_application_vnd_evolv_ecig_theme },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.eudora.data", mime_application_vnd_eudora_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.exstream-empower+zip", mime_application_vnd_exstream_empower_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.exstream-package", mime_application_vnd_exstream_package },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ezpix-album", mime_application_vnd_ezpix_album },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ezpix-package", mime_application_vnd_ezpix_package },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.f-secure.mobile", mime_application_vnd_f_secure_mobile },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fastcopy-disk-image", mime_application_vnd_fastcopy_disk_image },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fdf", mime_application_vnd_fdf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fdsn.mseed", mime_application_vnd_fdsn_mseed },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fdsn.seed", mime_application_vnd_fdsn_seed },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ffsns", mime_application_vnd_ffsns },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ficlab.flb+zip", mime_application_vnd_ficlab_flb_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.filmit.zfc", mime_application_vnd_filmit_zfc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fints", mime_application_vnd_fints },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.firemonkeys.cloudcell", mime_application_vnd_firemonkeys_cloudcell },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.FloGraphIt", mime_application_vnd_FloGraphIt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fluxtime.clip", mime_application_vnd_fluxtime_clip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.font-fontforge-sfd", mime_application_vnd_font_fontforge_sfd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.framemaker", mime_application_vnd_framemaker },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.frogans.fnc", mime_application_vnd_frogans_fnc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.frogans.ltf", mime_application_vnd_frogans_ltf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fsc.weblaunch", mime_application_vnd_fsc_weblaunch },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujitsu.oasys", mime_application_vnd_fujitsu_oasys },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujitsu.oasys2", mime_application_vnd_fujitsu_oasys2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujitsu.oasys3", mime_application_vnd_fujitsu_oasys3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujitsu.oasysgp", mime_application_vnd_fujitsu_oasysgp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujitsu.oasysprs", mime_application_vnd_fujitsu_oasysprs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujixerox.ART4", mime_application_vnd_fujixerox_ART4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujixerox.ART-EX", mime_application_vnd_fujixerox_ART_EX },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujixerox.ddd", mime_application_vnd_fujixerox_ddd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujixerox.docuworks", mime_application_vnd_fujixerox_docuworks },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujixerox.docuworks.binder", mime_application_vnd_fujixerox_docuworks_binder },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujixerox.docuworks.container", mime_application_vnd_fujixerox_docuworks_container },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fujixerox.HBPL", mime_application_vnd_fujixerox_HBPL },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fut-misnet", mime_application_vnd_fut_misnet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.futoin+cbor", mime_application_vnd_futoin_cbor },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.futoin+json", mime_application_vnd_futoin_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.fuzzysheet", mime_application_vnd_fuzzysheet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.genomatix.tuxedo", mime_application_vnd_genomatix_tuxedo },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.gentics.grd+json", mime_application_vnd_gentics_grd_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.geo+json", mime_application_vnd_geo_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.geocube+xml", mime_application_vnd_geocube_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.geogebra.file", mime_application_vnd_geogebra_file },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.geogebra.tool", mime_application_vnd_geogebra_tool },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.geometry-explorer", mime_application_vnd_geometry_explorer },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.geonext", mime_application_vnd_geonext },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.geoplan", mime_application_vnd_geoplan },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.geospace", mime_application_vnd_geospace },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.gerber", mime_application_vnd_gerber },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.globalplatform.card-content-mgt", mime_application_vnd_globalplatform_card_content_mgt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.globalplatform.card-content-mgt-response", mime_application_vnd_globalplatform_card_content_mgt_response },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.gmx", mime_application_vnd_gmx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.google-earth.kml+xml", mime_application_vnd_google_earth_kml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.google-earth.kmz", mime_application_vnd_google_earth_kmz },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.gov.sk.e-form+xml", mime_application_vnd_gov_sk_e_form_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.gov.sk.e-form+zip", mime_application_vnd_gov_sk_e_form_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.gov.sk.xmldatacontainer+xml", mime_application_vnd_gov_sk_xmldatacontainer_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.grafeq", mime_application_vnd_grafeq },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.gridmp", mime_application_vnd_gridmp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.groove-account", mime_application_vnd_groove_account },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.groove-help", mime_application_vnd_groove_help },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.groove-identity-message", mime_application_vnd_groove_identity_message },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.groove-injector", mime_application_vnd_groove_injector },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.groove-tool-message", mime_application_vnd_groove_tool_message },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.groove-tool-template", mime_application_vnd_groove_tool_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.groove-vcard", mime_application_vnd_groove_vcard },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hal+json", mime_application_vnd_hal_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hal+xml", mime_application_vnd_hal_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.HandHeld-Entertainment+xml", mime_application_vnd_HandHeld_Entertainment_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hbci", mime_application_vnd_hbci },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hc+json", mime_application_vnd_hc_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hcl-bireports", mime_application_vnd_hcl_bireports },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hdt", mime_application_vnd_hdt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.heroku+json", mime_application_vnd_heroku_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hhe.lesson-player", mime_application_vnd_hhe_lesson_player },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hp-HPGL", mime_application_vnd_hp_HPGL },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hp-hpid", mime_application_vnd_hp_hpid },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hp-hps", mime_application_vnd_hp_hps },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hp-jlyt", mime_application_vnd_hp_jlyt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hp-PCL", mime_application_vnd_hp_PCL },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hp-PCLXL", mime_application_vnd_hp_PCLXL },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.httphone", mime_application_vnd_httphone },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hydrostatix.sof-data", mime_application_vnd_hydrostatix_sof_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hyper-item+json", mime_application_vnd_hyper_item_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hyper+json", mime_application_vnd_hyper_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hyperdrive+json", mime_application_vnd_hyperdrive_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.hzn-3d-crossword", mime_application_vnd_hzn_3d_crossword },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ibm.afplinedata", mime_application_vnd_ibm_afplinedata },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ibm.electronic-media", mime_application_vnd_ibm_electronic_media },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ibm.MiniPay", mime_application_vnd_ibm_MiniPay },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ibm.modcap", mime_application_vnd_ibm_modcap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ibm.rights-management", mime_application_vnd_ibm_rights_management },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ibm.secure-container", mime_application_vnd_ibm_secure_container },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iccprofile", mime_application_vnd_iccprofile },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ieee.1905", mime_application_vnd_ieee_1905 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.igloader", mime_application_vnd_igloader },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.imagemeter.folder+zip", mime_application_vnd_imagemeter_folder_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.imagemeter.image+zip", mime_application_vnd_imagemeter_image_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.immervision-ivp", mime_application_vnd_immervision_ivp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.immervision-ivu", mime_application_vnd_immervision_ivu },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.imsccv1p1", mime_application_vnd_ims_imsccv1p1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.imsccv1p2", mime_application_vnd_ims_imsccv1p2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.imsccv1p3", mime_application_vnd_ims_imsccv1p3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.lis.v2.result+json", mime_application_vnd_ims_lis_v2_result_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.lti.v2.toolconsumerprofile+json", mime_application_vnd_ims_lti_v2_toolconsumerprofile_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.lti.v2.toolproxy.id+json", mime_application_vnd_ims_lti_v2_toolproxy_id_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.lti.v2.toolproxy+json", mime_application_vnd_ims_lti_v2_toolproxy_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.lti.v2.toolsettings+json", mime_application_vnd_ims_lti_v2_toolsettings_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ims.lti.v2.toolsettings.simple+json", mime_application_vnd_ims_lti_v2_toolsettings_simple_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.informedcontrol.rms+xml", mime_application_vnd_informedcontrol_rms_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.infotech.project", mime_application_vnd_infotech_project },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.infotech.project+xml", mime_application_vnd_infotech_project_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.informix-visionary", mime_application_vnd_informix_visionary },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.innopath.wamp.notification", mime_application_vnd_innopath_wamp_notification },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.insors.igm", mime_application_vnd_insors_igm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.intercon.formnet", mime_application_vnd_intercon_formnet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.intergeo", mime_application_vnd_intergeo },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.intertrust.digibox", mime_application_vnd_intertrust_digibox },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.intertrust.nncp", mime_application_vnd_intertrust_nncp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.intu.qbo", mime_application_vnd_intu_qbo },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.intu.qfx", mime_application_vnd_intu_qfx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iptc.g2.catalogitem+xml", mime_application_vnd_iptc_g2_catalogitem_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iptc.g2.conceptitem+xml", mime_application_vnd_iptc_g2_conceptitem_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iptc.g2.knowledgeitem+xml", mime_application_vnd_iptc_g2_knowledgeitem_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iptc.g2.newsitem+xml", mime_application_vnd_iptc_g2_newsitem_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iptc.g2.newsmessage+xml", mime_application_vnd_iptc_g2_newsmessage_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iptc.g2.packageitem+xml", mime_application_vnd_iptc_g2_packageitem_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iptc.g2.planningitem+xml", mime_application_vnd_iptc_g2_planningitem_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ipunplugged.rcprofile", mime_application_vnd_ipunplugged_rcprofile },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.irepository.package+xml", mime_application_vnd_irepository_package_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.is-xpr", mime_application_vnd_is_xpr },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.isac.fcs", mime_application_vnd_isac_fcs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.jam", mime_application_vnd_jam },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.iso11783-10+zip", mime_application_vnd_iso11783_10_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.japannet-directory-service", mime_application_vnd_japannet_directory_service },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.japannet-jpnstore-wakeup", mime_application_vnd_japannet_jpnstore_wakeup },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.japannet-payment-wakeup", mime_application_vnd_japannet_payment_wakeup },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.japannet-registration", mime_application_vnd_japannet_registration },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.japannet-registration-wakeup", mime_application_vnd_japannet_registration_wakeup },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.japannet-setstore-wakeup", mime_application_vnd_japannet_setstore_wakeup },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.japannet-verification", mime_application_vnd_japannet_verification },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.japannet-verification-wakeup", mime_application_vnd_japannet_verification_wakeup },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.jcp.javame.midlet-rms", mime_application_vnd_jcp_javame_midlet_rms },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.jisp", mime_application_vnd_jisp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.joost.joda-archive", mime_application_vnd_joost_joda_archive },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.jsk.isdn-ngn", mime_application_vnd_jsk_isdn_ngn },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kahootz", mime_application_vnd_kahootz },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kde.karbon", mime_application_vnd_kde_karbon },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kde.kchart", mime_application_vnd_kde_kchart },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kde.kformula", mime_application_vnd_kde_kformula },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kde.kivio", mime_application_vnd_kde_kivio },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kde.kontour", mime_application_vnd_kde_kontour },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kde.kpresenter", mime_application_vnd_kde_kpresenter },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kde.kspread", mime_application_vnd_kde_kspread },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kde.kword", mime_application_vnd_kde_kword },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kenameaapp", mime_application_vnd_kenameaapp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kidspiration", mime_application_vnd_kidspiration },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Kinar", mime_application_vnd_Kinar },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.koan", mime_application_vnd_koan },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.kodak-descriptor", mime_application_vnd_kodak_descriptor },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.las", mime_application_vnd_las },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.las.las+json", mime_application_vnd_las_las_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.las.las+xml", mime_application_vnd_las_las_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.laszip", mime_application_vnd_laszip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.leap+json", mime_application_vnd_leap_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.liberty-request+xml", mime_application_vnd_liberty_request_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.llamagraphics.life-balance.desktop", mime_application_vnd_llamagraphics_life_balance_desktop },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.llamagraphics.life-balance.exchange+xml", mime_application_vnd_llamagraphics_life_balance_exchange_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.logipipe.circuit+zip", mime_application_vnd_logipipe_circuit_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.loom", mime_application_vnd_loom },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.lotus-1-2-3", mime_application_vnd_lotus_1_2_3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.lotus-approach", mime_application_vnd_lotus_approach },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.lotus-freelance", mime_application_vnd_lotus_freelance },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.lotus-notes", mime_application_vnd_lotus_notes },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.lotus-organizer", mime_application_vnd_lotus_organiser },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.lotus-screencam", mime_application_vnd_lotus_screencam },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.lotus-wordpro", mime_application_vnd_lotus_wordpro },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.macports.portpkg", mime_application_vnd_macports_portpkg },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mapbox-vector-tile", mime_application_vnd_mapbox_vector_tile },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.marlin.drm.actiontoken+xml", mime_application_vnd_marlin_drm_actiontoken_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.marlin.drm.conftoken+xml", mime_application_vnd_marlin_drm_conftoken_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.marlin.drm.license+xml", mime_application_vnd_marlin_drm_license_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.marlin.drm.mdcf", mime_application_vnd_marlin_drm_mdcf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mason+json", mime_application_vnd_mason_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.maxmind.maxmind-db", mime_application_vnd_maxmind_maxmind_db },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mcd", mime_application_vnd_mcd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.medcalcdata", mime_application_vnd_medcalcdata },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mediastation.cdkey", mime_application_vnd_mediastation_cdkey },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.meridian-slingshot", mime_application_vnd_meridian_slingshot },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.MFER", mime_application_vnd_MFER },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mfmp", mime_application_vnd_mfmp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.micro+json", mime_application_vnd_micro_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.micrografx.flo", mime_application_vnd_micrografx_flo },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.micrografx.igx", mime_application_vnd_micrografx_igx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.microsoft.portable-executable", mime_application_vnd_microsoft_portable_executable },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.microsoft.windows.thumbnail-cache", mime_application_vnd_microsoft_windows_thumbnail_cache },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.miele+json", mime_application_vnd_miele_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mif", mime_application_vnd_mif },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.minisoft-hp3000-save", mime_application_vnd_minisoft_hp3000_save },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mitsubishi.misty-guard.trustweb", mime_application_vnd_mitsubishi_misty_guard_trustweb },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Mobius.DAF", mime_application_vnd_Mobius_DAF },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Mobius.DIS", mime_application_vnd_Mobius_DIS },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Mobius.MBK", mime_application_vnd_Mobius_MBK },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Mobius.MQY", mime_application_vnd_Mobius_MQY },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Mobius.MSL", mime_application_vnd_Mobius_MSL },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Mobius.PLC", mime_application_vnd_Mobius_PLC },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Mobius.TXF", mime_application_vnd_Mobius_TXF },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mophun.application", mime_application_vnd_mophun_application },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mophun.certificate", mime_application_vnd_mophun_certificate },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.motorola.flexsuite", mime_application_vnd_motorola_flexsuite },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.motorola.flexsuite.adsi", mime_application_vnd_motorola_flexsuite_adsi },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.motorola.flexsuite.fis", mime_application_vnd_motorola_flexsuite_fis },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.motorola.flexsuite.gotap", mime_application_vnd_motorola_flexsuite_gotap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.motorola.flexsuite.kmr", mime_application_vnd_motorola_flexsuite_kmr },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.motorola.flexsuite.ttc", mime_application_vnd_motorola_flexsuite_ttc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.motorola.flexsuite.wem", mime_application_vnd_motorola_flexsuite_wem },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.motorola.iprm", mime_application_vnd_motorola_iprm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mozilla.xul+xml", mime_application_vnd_mozilla_xul_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-artgalry", mime_application_vnd_ms_artgalry },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-asf", mime_application_vnd_ms_asf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-cab-compressed", mime_application_vnd_ms_cab_compressed },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-3mfdocument", mime_application_vnd_ms_3mfdocument },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-excel", mime_application_vnd_ms_excel },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-excel.addin.macroEnabled.12", mime_application_vnd_ms_excel_addin_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-excel.sheet.binary.macroEnabled.12", mime_application_vnd_ms_excel_sheet_binary_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-excel.sheet.macroEnabled.12", mime_application_vnd_ms_excel_sheet_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-excel.template.macroEnabled.12", mime_application_vnd_ms_excel_template_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-fontobject", mime_application_vnd_ms_fontobject },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-htmlhelp", mime_application_vnd_ms_htmlhelp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-ims", mime_application_vnd_ms_ims },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-lrm", mime_application_vnd_ms_lrm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-office.activeX+xml", mime_application_vnd_ms_office_activeX_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-officetheme", mime_application_vnd_ms_officetheme },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-playready.initiator+xml", mime_application_vnd_ms_playready_initiator_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-powerpoint", mime_application_vnd_ms_powerpoint },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-powerpoint.addin.macroEnabled.12", mime_application_vnd_ms_powerpoint_addin_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-powerpoint.presentation.macroEnabled.12", mime_application_vnd_ms_powerpoint_presentation_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-powerpoint.slide.macroEnabled.12", mime_application_vnd_ms_powerpoint_slide_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-powerpoint.slideshow.macroEnabled.12", mime_application_vnd_ms_powerpoint_slideshow_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-powerpoint.template.macroEnabled.12", mime_application_vnd_ms_powerpoint_template_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-PrintDeviceCapabilities+xml", mime_application_vnd_ms_PrintDeviceCapabilities_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-PrintSchemaTicket+xml", mime_application_vnd_ms_PrintSchemaTicket_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-project", mime_application_vnd_ms_project },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-tnef", mime_application_vnd_ms_tnef },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-windows.devicepairing", mime_application_vnd_ms_windows_devicepairing },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-windows.nwprinting.oob", mime_application_vnd_ms_windows_nwprinting_oob },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-windows.printerpairing", mime_application_vnd_ms_windows_printerpairing },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-windows.wsd.oob", mime_application_vnd_ms_windows_wsd_oob },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-wmdrm.lic-chlg-req", mime_application_vnd_ms_wmdrm_lic_chlg_req },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-wmdrm.lic-resp", mime_application_vnd_ms_wmdrm_lic_resp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-wmdrm.meter-chlg-req", mime_application_vnd_ms_wmdrm_meter_chlg_req },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-wmdrm.meter-resp", mime_application_vnd_ms_wmdrm_meter_resp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-word.document.macroEnabled.12", mime_application_vnd_ms_word_document_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-word.template.macroEnabled.12", mime_application_vnd_ms_word_template_macroEnabled_12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-works", mime_application_vnd_ms_works },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-wpl", mime_application_vnd_ms_wpl },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ms-xpsdocument", mime_application_vnd_ms_xpsdocument },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.msa-disk-image", mime_application_vnd_msa_disk_image },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mseq", mime_application_vnd_mseq },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.msign", mime_application_vnd_msign },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.multiad.creator", mime_application_vnd_multiad_creator },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.multiad.creator.cif", mime_application_vnd_multiad_creator_cif },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.musician", mime_application_vnd_musician },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.music-niff", mime_application_vnd_music_niff },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.muvee.style", mime_application_vnd_muvee_style },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.mynfc", mime_application_vnd_mynfc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ncd.control", mime_application_vnd_ncd_control },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ncd.reference", mime_application_vnd_ncd_reference },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nearst.inv+json", mime_application_vnd_nearst_inv_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nervana", mime_application_vnd_nervana },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.netfpx", mime_application_vnd_netfpx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.neurolanguage.nlu", mime_application_vnd_neurolanguage_nlu },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nimn", mime_application_vnd_nimn },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nintendo.snes.rom", mime_application_vnd_nintendo_snes_rom },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nintendo.nitro.rom", mime_application_vnd_nintendo_nitro_rom },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nitf", mime_application_vnd_nitf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.noblenet-directory", mime_application_vnd_noblenet_directory },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.noblenet-sealer", mime_application_vnd_noblenet_sealer },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.noblenet-web", mime_application_vnd_noblenet_web },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.catalogs", mime_application_vnd_nokia_catalogs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.conml+wbxml", mime_application_vnd_nokia_conml_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.conml+xml", mime_application_vnd_nokia_conml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.iptv.config+xml", mime_application_vnd_nokia_iptv_config_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.iSDS-radio-presets", mime_application_vnd_nokia_iSDS_radio_presets },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.landmark+wbxml", mime_application_vnd_nokia_landmark_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.landmark+xml", mime_application_vnd_nokia_landmark_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.landmarkcollection+xml", mime_application_vnd_nokia_landmarkcollection_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.ncd", mime_application_vnd_nokia_ncd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.n-gage.ac+xml", mime_application_vnd_nokia_n_gage_ac_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.n-gage.data", mime_application_vnd_nokia_n_gage_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.n-gage.symbian.install", mime_application_vnd_nokia_n_gage_symbian_install },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.pcd+wbxml", mime_application_vnd_nokia_pcd_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.pcd+xml", mime_application_vnd_nokia_pcd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.radio-preset", mime_application_vnd_nokia_radio_preset },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.nokia.radio-presets", mime_application_vnd_nokia_radio_presets },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.novadigm.EDM", mime_application_vnd_novadigm_EDM },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.novadigm.EDX", mime_application_vnd_novadigm_EDX },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.novadigm.EXT", mime_application_vnd_novadigm_EXT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ntt-local.content-share", mime_application_vnd_ntt_local_content_share },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ntt-local.file-transfer", mime_application_vnd_ntt_local_file_transfer },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ntt-local.ogw_remote-access", mime_application_vnd_ntt_local_ogw_remote_access },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ntt-local.sip-ta_remote", mime_application_vnd_ntt_local_sip_ta_remote },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ntt-local.sip-ta_tcp_stream", mime_application_vnd_ntt_local_sip_ta_tcp_stream },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.chart", mime_application_vnd_oasis_opendocument_chart },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.chart-template", mime_application_vnd_oasis_opendocument_chart_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.database", mime_application_vnd_oasis_opendocument_database },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.formula", mime_application_vnd_oasis_opendocument_formula },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.formula-template", mime_application_vnd_oasis_opendocument_formula_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.graphics", mime_application_vnd_oasis_opendocument_graphics },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.graphics-template", mime_application_vnd_oasis_opendocument_graphics_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.image", mime_application_vnd_oasis_opendocument_image },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.image-template", mime_application_vnd_oasis_opendocument_image_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.presentation", mime_application_vnd_oasis_opendocument_presentation },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.presentation-template", mime_application_vnd_oasis_opendocument_presentation_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.spreadsheet", mime_application_vnd_oasis_opendocument_spreadsheet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.spreadsheet-template", mime_application_vnd_oasis_opendocument_spreadsheet_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.text", mime_application_vnd_oasis_opendocument_text },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.text-master", mime_application_vnd_oasis_opendocument_text_master },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.text-template", mime_application_vnd_oasis_opendocument_text_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oasis.opendocument.text-web", mime_application_vnd_oasis_opendocument_text_web },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.obn", mime_application_vnd_obn },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ocf+cbor", mime_application_vnd_ocf_cbor },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oci.image.manifest.v1+json", mime_application_vnd_oci_image_manifest_v1_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oftn.l10n+json", mime_application_vnd_oftn_l10n_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.contentaccessdownload+xml", mime_application_vnd_oipf_contentaccessdownload_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.contentaccessstreaming+xml", mime_application_vnd_oipf_contentaccessstreaming_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.cspg-hexbinary", mime_application_vnd_oipf_cspg_hexbinary },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.dae.svg+xml", mime_application_vnd_oipf_dae_svg_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.dae.xhtml+xml", mime_application_vnd_oipf_dae_xhtml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.mippvcontrolmessage+xml", mime_application_vnd_oipf_mippvcontrolmessage_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.pae.gem", mime_application_vnd_oipf_pae_gem },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.spdiscovery+xml", mime_application_vnd_oipf_spdiscovery_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.spdlist+xml", mime_application_vnd_oipf_spdlist_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.ueprofile+xml", mime_application_vnd_oipf_ueprofile_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oipf.userprofile+xml", mime_application_vnd_oipf_userprofile_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.olpc-sugar", mime_application_vnd_olpc_sugar },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.associated-procedure-parameter+xml", mime_application_vnd_oma_bcast_associated_procedure_parameter_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.drm-trigger+xml", mime_application_vnd_oma_bcast_drm_trigger_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.imd+xml", mime_application_vnd_oma_bcast_imd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.ltkm", mime_application_vnd_oma_bcast_ltkm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.notification+xml", mime_application_vnd_oma_bcast_notification_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.provisioningtrigger", mime_application_vnd_oma_bcast_provisioningtrigger },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.sgboot", mime_application_vnd_oma_bcast_sgboot },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.sgdd+xml", mime_application_vnd_oma_bcast_sgdd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.sgdu", mime_application_vnd_oma_bcast_sgdu },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.simple-symbol-container", mime_application_vnd_oma_bcast_simple_symbol_container },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.smartcard-trigger+xml", mime_application_vnd_oma_bcast_smartcard_trigger_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.sprov+xml", mime_application_vnd_oma_bcast_sprov_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.bcast.stkm", mime_application_vnd_oma_bcast_stkm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.cab-address-book+xml", mime_application_vnd_oma_cab_address_book_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.cab-feature-handler+xml", mime_application_vnd_oma_cab_feature_handler_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.cab-pcc+xml", mime_application_vnd_oma_cab_pcc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.cab-subs-invite+xml", mime_application_vnd_oma_cab_subs_invite_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.cab-user-prefs+xml", mime_application_vnd_oma_cab_user_prefs_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.dcd", mime_application_vnd_oma_dcd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.dcdc", mime_application_vnd_oma_dcdc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.dd2+xml", mime_application_vnd_oma_dd2_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.drm.risd+xml", mime_application_vnd_oma_drm_risd_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.group-usage-list+xml", mime_application_vnd_oma_group_usage_list_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.lwm2m+json", mime_application_vnd_oma_lwm2m_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.lwm2m+tlv", mime_application_vnd_oma_lwm2m_tlv },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.pal+xml", mime_application_vnd_oma_pal_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.poc.detailed-progress-report+xml", mime_application_vnd_oma_poc_detailed_progress_report_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.poc.final-report+xml", mime_application_vnd_oma_poc_final_report_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.poc.groups+xml", mime_application_vnd_oma_poc_groups_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.poc.invocation-descriptor+xml", mime_application_vnd_oma_poc_invocation_descriptor_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.poc.optimized-progress-report+xml", mime_application_vnd_oma_poc_optimized_progress_report_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.push", mime_application_vnd_oma_push },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.scidm.messages+xml", mime_application_vnd_oma_scidm_messages_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma.xcap-directory+xml", mime_application_vnd_oma_xcap_directory_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.omads-email+xml", mime_application_vnd_omads_email_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.omads-file+xml", mime_application_vnd_omads_file_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.omads-folder+xml", mime_application_vnd_omads_folder_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.omaloc-supl-init", mime_application_vnd_omaloc_supl_init },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma-scws-config", mime_application_vnd_oma_scws_config },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma-scws-http-request", mime_application_vnd_oma_scws_http_request },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oma-scws-http-response", mime_application_vnd_oma_scws_http_response },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.onepager", mime_application_vnd_onepager },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.onepagertamp", mime_application_vnd_onepagertamp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.onepagertamx", mime_application_vnd_onepagertamx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.onepagertat", mime_application_vnd_onepagertat },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.onepagertatp", mime_application_vnd_onepagertatp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.onepagertatx", mime_application_vnd_onepagertatx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openblox.game-binary", mime_application_vnd_openblox_game_binary },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openblox.game+xml", mime_application_vnd_openblox_game_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openeye.oeb", mime_application_vnd_openeye_oeb },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openstreetmap.data+xml", mime_application_vnd_openstreetmap_data_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.custom-properties+xml", mime_application_vnd_openxmlformats_officedocument_custom_properties_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.customXmlProperties+xml", mime_application_vnd_openxmlformats_officedocument_customXmlProperties_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.drawing+xml", mime_application_vnd_openxmlformats_officedocument_drawing_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.drawingml.chart+xml", mime_application_vnd_openxmlformats_officedocument_drawingml_chart_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml", mime_application_vnd_openxmlformats_officedocument_drawingml_chartshapes_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml", mime_application_vnd_openxmlformats_officedocument_drawingml_diagramColors_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml", mime_application_vnd_openxmlformats_officedocument_drawingml_diagramData_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml", mime_application_vnd_openxmlformats_officedocument_drawingml_diagramLayout_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml", mime_application_vnd_openxmlformats_officedocument_drawingml_diagramStyle_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.extended-properties+xml", mime_application_vnd_openxmlformats_officedocument_extended_properties_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.commentAuthors+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_commentAuthors_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.comments+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_comments_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.handoutMaster+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_handoutMaster_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_notesMaster_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.notesSlide+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_notesSlide_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.presentation", mime_application_vnd_openxmlformats_officedocument_presentationml_presentation },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_presentation_main_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.presProps+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_presProps_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.slide", mime_application_vnd_openxmlformats_officedocument_presentationml_slide },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.slide+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_slide_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_slideLayout_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_slideMaster_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.slideshow", mime_application_vnd_openxmlformats_officedocument_presentationml_slideshow },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_slideshow_main_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.slideUpdateInfo+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_slideUpdateInfo_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.tableStyles+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_tableStyles_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.tags+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_tags_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.template", mime_application_vnd_openxmlformats_officedocument_presentationml_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_template_main_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.presentationml.viewProps+xml", mime_application_vnd_openxmlformats_officedocument_presentationml_viewProps_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_calcChain_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_chartsheet_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_comments_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_connections_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_dialogsheet_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_externalLink_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_pivotCacheDefinition_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_pivotCacheRecords_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_pivotTable_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_queryTable_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_revisionHeaders_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_revisionLog_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_sharedStrings_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_sheet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_sheet_main_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_sheetMetadata_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_styles_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_table_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_tableSingleCells_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.template", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_template_main_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_userNames_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_volatileDependencies_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml", mime_application_vnd_openxmlformats_officedocument_spreadsheetml_worksheet_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.theme+xml", mime_application_vnd_openxmlformats_officedocument_theme_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.themeOverride+xml", mime_application_vnd_openxmlformats_officedocument_themeOverride_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.vmlDrawing", mime_application_vnd_openxmlformats_officedocument_vmlDrawing },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_comments_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.document", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_document },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_document_glossary_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_document_main_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_endnotes_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_fontTable_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_footer_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_footnotes_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_numbering_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_settings_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_styles_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.template", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_template },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_template_main_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml", mime_application_vnd_openxmlformats_officedocument_wordprocessingml_webSettings_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-package.core-properties+xml", mime_application_vnd_openxmlformats_package_core_properties_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml", mime_application_vnd_openxmlformats_package_digital_signature_xmlsignature_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.openxmlformats-package.relationships+xml", mime_application_vnd_openxmlformats_package_relationships_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oracle.resource+json", mime_application_vnd_oracle_resource_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.orange.indata", mime_application_vnd_orange_indata },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.osa.netdeploy", mime_application_vnd_osa_netdeploy },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.osgeo.mapguide.package", mime_application_vnd_osgeo_mapguide_package },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.osgi.bundle", mime_application_vnd_osgi_bundle },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.osgi.dp", mime_application_vnd_osgi_dp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.osgi.subsystem", mime_application_vnd_osgi_subsystem },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.otps.ct-kip+xml", mime_application_vnd_otps_ct_kip_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.oxli.countgraph", mime_application_vnd_oxli_countgraph },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pagerduty+json", mime_application_vnd_pagerduty_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.palm", mime_application_vnd_palm },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.panoply", mime_application_vnd_panoply },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.paos.xml", mime_application_vnd_paos_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.patentdive", mime_application_vnd_patentdive },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.patientecommsdoc", mime_application_vnd_patientecommsdoc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pawaafile", mime_application_vnd_pawaafile },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pcos", mime_application_vnd_pcos },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pg.format", mime_application_vnd_pg_format },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pg.osasli", mime_application_vnd_pg_osasli },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.piaccess.application-licence", mime_application_vnd_piaccess_application_licence },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.picsel", mime_application_vnd_picsel },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pmi.widget", mime_application_vnd_pmi_widget },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.poc.group-advertisement+xml", mime_application_vnd_poc_group_advertisement_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pocketlearn", mime_application_vnd_pocketlearn },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.powerbuilder6", mime_application_vnd_powerbuilder6 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.powerbuilder6-s", mime_application_vnd_powerbuilder6_s },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.powerbuilder7", mime_application_vnd_powerbuilder7 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.powerbuilder75", mime_application_vnd_powerbuilder75 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.powerbuilder75-s", mime_application_vnd_powerbuilder75_s },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.powerbuilder7-s", mime_application_vnd_powerbuilder7_s },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.preminet", mime_application_vnd_preminet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.previewsystems.box", mime_application_vnd_previewsystems_box },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.proteus.magazine", mime_application_vnd_proteus_magazine },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.psfs", mime_application_vnd_psfs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.publishare-delta-tree", mime_application_vnd_publishare_delta_tree },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pvi.ptid1", mime_application_vnd_pvi_ptid1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pwg-multiplexed", mime_application_vnd_pwg_multiplexed },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.pwg-xhtml-print+xml", mime_application_vnd_pwg_xhtml_print_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.qualcomm.brew-app-res", mime_application_vnd_qualcomm_brew_app_res },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.quarantainenet", mime_application_vnd_quarantainenet },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.Quark.QuarkXPress", mime_application_vnd_Quark_QuarkXPress },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.quobject-quoxdocument", mime_application_vnd_quobject_quoxdocument },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.moml+xml", mime_application_vnd_radisys_moml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-audit-conf+xml", mime_application_vnd_radisys_msml_audit_conf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-audit-conn+xml", mime_application_vnd_radisys_msml_audit_conn_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-audit-dialog+xml", mime_application_vnd_radisys_msml_audit_dialog_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-audit-stream+xml", mime_application_vnd_radisys_msml_audit_stream_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-audit+xml", mime_application_vnd_radisys_msml_audit_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-conf+xml", mime_application_vnd_radisys_msml_conf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-dialog-base+xml", mime_application_vnd_radisys_msml_dialog_base_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-dialog-fax-detect+xml", mime_application_vnd_radisys_msml_dialog_fax_detect_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-dialog-fax-sendrecv+xml", mime_application_vnd_radisys_msml_dialog_fax_sendrecv_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-dialog-group+xml", mime_application_vnd_radisys_msml_dialog_group_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-dialog-speech+xml", mime_application_vnd_radisys_msml_dialog_speech_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-dialog-transform+xml", mime_application_vnd_radisys_msml_dialog_transform_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml-dialog+xml", mime_application_vnd_radisys_msml_dialog_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.radisys.msml+xml", mime_application_vnd_radisys_msml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.rainstor.data", mime_application_vnd_rainstor_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.rapid", mime_application_vnd_rapid },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.rar", mime_application_vnd_rar },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.realvnc.bed", mime_application_vnd_realvnc_bed },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.recordare.musicxml", mime_application_vnd_recordare_musicxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.recordare.musicxml+xml", mime_application_vnd_recordare_musicxml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.RenLearn.rlprint", mime_application_vnd_RenLearn_rlprint },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.restful+json", mime_application_vnd_restful_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.rig.cryptonote", mime_application_vnd_rig_cryptonote },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.route66.link66+xml", mime_application_vnd_route66_link66_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.rs-274x", mime_application_vnd_rs_274x },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ruckus.download", mime_application_vnd_ruckus_download },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.s3sms", mime_application_vnd_s3sms },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sailingtracker.track", mime_application_vnd_sailingtracker_track },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sar", mime_application_vnd_sar },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sbm.cid", mime_application_vnd_sbm_cid },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sbm.mid2", mime_application_vnd_sbm_mid2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.scribus", mime_application_vnd_scribus },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.3df", mime_application_vnd_sealed_3df },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.csf", mime_application_vnd_sealed_csf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.doc", mime_application_vnd_sealed_doc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.eml", mime_application_vnd_sealed_eml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.mht", mime_application_vnd_sealed_mht },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.net", mime_application_vnd_sealed_net },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.ppt", mime_application_vnd_sealed_ppt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.tiff", mime_application_vnd_sealed_tiff },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealed.xls", mime_application_vnd_sealed_xls },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealedmedia.softseal.html", mime_application_vnd_sealedmedia_softseal_html },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sealedmedia.softseal.pdf", mime_application_vnd_sealedmedia_softseal_pdf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.seemail", mime_application_vnd_seemail },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sema", mime_application_vnd_sema },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.semd", mime_application_vnd_semd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.semf", mime_application_vnd_semf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shade-save-file", mime_application_vnd_shade_save_file },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shana.informed.formdata", mime_application_vnd_shana_informed_formdata },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shana.informed.formtemplate", mime_application_vnd_shana_informed_formtemplate },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shana.informed.interchange", mime_application_vnd_shana_informed_interchange },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shana.informed.package", mime_application_vnd_shana_informed_package },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shootproof+json", mime_application_vnd_shootproof_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shopkick+json", mime_application_vnd_shopkick_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shp", mime_application_vnd_shp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.shx", mime_application_vnd_shx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sigrok.session", mime_application_vnd_sigrok_session },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.SimTech-MindMapper", mime_application_vnd_SimTech_MindMapper },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.siren+json", mime_application_vnd_siren_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.smaf", mime_application_vnd_smaf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.smart.notebook", mime_application_vnd_smart_notebook },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.smart.teacher", mime_application_vnd_smart_teacher },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.snesdev-page-table", mime_application_vnd_snesdev_page_table },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.software602.filler.form+xml", mime_application_vnd_software602_filler_form_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.software602.filler.form-xml-zip", mime_application_vnd_software602_filler_form_xml_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.solent.sdkm+xml", mime_application_vnd_solent_sdkm_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.spotfire.dxp", mime_application_vnd_spotfire_dxp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.spotfire.sfs", mime_application_vnd_spotfire_sfs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sqlite3", mime_application_vnd_sqlite3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sss-cod", mime_application_vnd_sss_cod },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sss-dtf", mime_application_vnd_sss_dtf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sss-ntf", mime_application_vnd_sss_ntf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.stepmania.package", mime_application_vnd_stepmania_package },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.stepmania.stepchart", mime_application_vnd_stepmania_stepchart },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.street-stream", mime_application_vnd_street_stream },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sun.wadl+xml", mime_application_vnd_sun_wadl_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.sus-calendar", mime_application_vnd_sus_calendar },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.svd", mime_application_vnd_svd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.swiftview-ics", mime_application_vnd_swiftview_ics },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml.dm.notification", mime_application_vnd_syncml_dm_notification },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml.dmddf+xml", mime_application_vnd_syncml_dmddf_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml.dmtnds+wbxml", mime_application_vnd_syncml_dmtnds_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml.dmtnds+xml", mime_application_vnd_syncml_dmtnds_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml.dmddf+wbxml", mime_application_vnd_syncml_dmddf_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml.dm+wbxml", mime_application_vnd_syncml_dm_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml.dm+xml", mime_application_vnd_syncml_dm_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml.ds.notification", mime_application_vnd_syncml_ds_notification },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.syncml+xml", mime_application_vnd_syncml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.tableschema+json", mime_application_vnd_tableschema_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.tao.intent-module-archive", mime_application_vnd_tao_intent_module_archive },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.tcpdump.pcap", mime_application_vnd_tcpdump_pcap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.think-cell.ppttc+json", mime_application_vnd_think_cell_ppttc_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.tml", mime_application_vnd_tml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.tmd.mediaflex.api+xml", mime_application_vnd_tmd_mediaflex_api_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.tmobile-livetv", mime_application_vnd_tmobile_livetv },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.tri.onesource", mime_application_vnd_tri_onesource },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.trid.tpt", mime_application_vnd_trid_tpt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.triscape.mxs", mime_application_vnd_triscape_mxs },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.trueapp", mime_application_vnd_trueapp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.truedoc", mime_application_vnd_truedoc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ubisoft.webplayer", mime_application_vnd_ubisoft_webplayer },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ufdl", mime_application_vnd_ufdl },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uiq.theme", mime_application_vnd_uiq_theme },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.umajin", mime_application_vnd_umajin },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.unity", mime_application_vnd_unity },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uoml+xml", mime_application_vnd_uoml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.alert", mime_application_vnd_uplanet_alert },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.alert-wbxml", mime_application_vnd_uplanet_alert_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.bearer-choice", mime_application_vnd_uplanet_bearer_choice },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.bearer-choice-wbxml", mime_application_vnd_uplanet_bearer_choice_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.cacheop", mime_application_vnd_uplanet_cacheop },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.cacheop-wbxml", mime_application_vnd_uplanet_cacheop_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.channel", mime_application_vnd_uplanet_channel },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.channel-wbxml", mime_application_vnd_uplanet_channel_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.list", mime_application_vnd_uplanet_list },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.listcmd", mime_application_vnd_uplanet_listcmd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.listcmd-wbxml", mime_application_vnd_uplanet_listcmd_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.list-wbxml", mime_application_vnd_uplanet_list_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uri-map", mime_application_vnd_uri_map },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.uplanet.signal", mime_application_vnd_uplanet_signal },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.valve.source.material", mime_application_vnd_valve_source_material },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.vcx", mime_application_vnd_vcx },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.vd-study", mime_application_vnd_vd_study },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.vectorworks", mime_application_vnd_vectorworks },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.vel+json", mime_application_vnd_vel_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.verimatrix.vcas", mime_application_vnd_verimatrix_vcas },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.veryant.thin", mime_application_vnd_veryant_thin },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.ves.encrypted", mime_application_vnd_ves_encrypted },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.vidsoft.vidconference", mime_application_vnd_vidsoft_vidconference },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.visio", mime_application_vnd_visio },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.visionary", mime_application_vnd_visionary },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.vividence.scriptfile", mime_application_vnd_vividence_scriptfile },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.vsf", mime_application_vnd_vsf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wap.sic", mime_application_vnd_wap_sic },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wap.slc", mime_application_vnd_wap_slc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wap.wbxml", mime_application_vnd_wap_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wap.wmlc", mime_application_vnd_wap_wmlc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wap.wmlscriptc", mime_application_vnd_wap_wmlscriptc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.webturbo", mime_application_vnd_webturbo },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wfa.p2p", mime_application_vnd_wfa_p2p },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wfa.wsc", mime_application_vnd_wfa_wsc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.windows.devicepairing", mime_application_vnd_windows_devicepairing },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wmc", mime_application_vnd_wmc },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wmf.bootstrap", mime_application_vnd_wmf_bootstrap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wolfram.mathematica", mime_application_vnd_wolfram_mathematica },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wolfram.mathematica.package", mime_application_vnd_wolfram_mathematica_package },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wolfram.player", mime_application_vnd_wolfram_player },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wordperfect", mime_application_vnd_wordperfect },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wqd", mime_application_vnd_wqd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wrq-hp3000-labelled", mime_application_vnd_wrq_hp3000_labelled },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wt.stf", mime_application_vnd_wt_stf },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wv.csp+xml", mime_application_vnd_wv_csp_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wv.csp+wbxml", mime_application_vnd_wv_csp_wbxml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.wv.ssp+xml", mime_application_vnd_wv_ssp_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xacml+json", mime_application_vnd_xacml_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xara", mime_application_vnd_xara },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xfdl", mime_application_vnd_xfdl },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xfdl.webform", mime_application_vnd_xfdl_webform },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xmi+xml", mime_application_vnd_xmi_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xmpie.cpkg", mime_application_vnd_xmpie_cpkg },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xmpie.dpkg", mime_application_vnd_xmpie_dpkg },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xmpie.plan", mime_application_vnd_xmpie_plan },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xmpie.ppkg", mime_application_vnd_xmpie_ppkg },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.xmpie.xlim", mime_application_vnd_xmpie_xlim },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.hv-dic", mime_application_vnd_yamaha_hv_dic },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.hv-script", mime_application_vnd_yamaha_hv_script },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.hv-voice", mime_application_vnd_yamaha_hv_voice },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.openscoreformat.osfpvg+xml", mime_application_vnd_yamaha_openscoreformat_osfpvg_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.openscoreformat", mime_application_vnd_yamaha_openscoreformat },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.remote-setup", mime_application_vnd_yamaha_remote_setup },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.smaf-audio", mime_application_vnd_yamaha_smaf_audio },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.smaf-phrase", mime_application_vnd_yamaha_smaf_phrase },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.through-ngn", mime_application_vnd_yamaha_through_ngn },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yamaha.tunnel-udpencap", mime_application_vnd_yamaha_tunnel_udpencap },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yaoweme", mime_application_vnd_yaoweme },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.yellowriver-custom-menu", mime_application_vnd_yellowriver_custom_menu },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.youtube.yt", mime_application_vnd_youtube_yt },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.zul", mime_application_vnd_zul },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vnd.zzazz.deck+xml", mime_application_vnd_zzazz_deck_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/voicexml+xml", mime_application_voicexml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/voucher-cms+json", mime_application_voucher_cms_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/vq-rtcpxr", mime_application_vq_rtcpxr },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/watcherinfo+xml", mime_application_watcherinfo_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/webpush-options+json", mime_application_webpush_options_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/whoispp-query", mime_application_whoispp_query },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/whoispp-response", mime_application_whoispp_response },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/widget", mime_application_widget },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/wita", mime_application_wita },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/wordperfect5.1", mime_application_wordperfect5_1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/wsdl+xml", mime_application_wsdl_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/wspolicy+xml", mime_application_wspolicy_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x-ecmascript", mime_application_x_ecmascript, ns_default, SCRIPT },
    { { XHTML_2_0 }, { HTML_UNDEF }, "application/x-java-applet", mime_application_x_java_applet, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x-javascript", mime_application_x_javascript, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x-pki-message", mime_application_x_pki_message },
    { { HTML_5_0 }, { HTML_UNDEF }, "application/x-shockwave-flash", mime_application_x_shockwave_flash },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x-webfont", mime_application_x_webfont },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x-www-form-urlencoded", mime_application_x_www_form_urlencoded },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x-x509-ca-cert", mime_application_x_x509_ca_cert },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x-x509-ca-ra-cert", mime_application_x_x509_ca_ra_cert },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x-x509-next-ca-cert", mime_application_x_x509_next_ca_cert },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/x400-bp", mime_application_x400_bp },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xacml+xml", mime_application_xacml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xcap-att+xml", mime_application_xcap_att_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xcap-caps+xml", mime_application_xcap_caps_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xcap-diff+xml", mime_application_xcap_diff_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xcap-el+xml", mime_application_xcap_el_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xcap-error+xml", mime_application_xcap_error_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xcap-ns+xml", mime_application_xcap_ns_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xcon-conference-info-diff+xml", mime_application_xcon_conference_info_diff_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xcon-conference-info+xml", mime_application_xcon_conference_info_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xenc+xml", mime_application_xenc_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xhtml+xml", mime_application_xhtml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xliff+xml", mime_application_xliff_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xml", mime_application_xml, ns_default, NOT_SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xml-dtd", mime_application_xml_dtd },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xml-external-parsed-entity", mime_application_xml_external_parsed_entity },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xml-patch+xml", mime_application_xml_patch_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xmpp+xml", mime_application_xmpp_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xop+xml", mime_application_xop_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xslt+xml", mime_application_xslt_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/xv+xml", mime_application_xv_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/yang", mime_application_yang },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/yang-data+json", mime_application_yang_data_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/yang-data+xml", mime_application_yang_data_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/yang-patch+json", mime_application_yang_patch_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/yang-patch+xml", mime_application_yang_patch_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/yin+xml", mime_application_yin_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/zip", mime_application_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/zlib", mime_application_zlib },
    { { HTML_4_0 }, { HTML_UNDEF }, "application/zstd", mime_application_zstd },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/1d-interleaved-parityfec", mime_audio_1d_interleaved_parityfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/32kadpcm", mime_audio_32kadpcm },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/3gpp", mime_audio_3gpp },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/3gpp2", mime_audio_3gpp2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/aac", mime_audio_aac },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/ac3", mime_audio_ac3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/AMR", mime_audio_AMR },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/AMR-WB", mime_audio_AMR_WB },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/amr-wb+", mime_audio_amr_wb_ },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/aptx", mime_audio_aptx },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/asc", mime_audio_asc },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/ATRAC-ADVANCED-LOSSLESS", mime_audio_ATRAC_ADVANCED_LOSSLESS },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/ATRAC-X", mime_audio_ATRAC_X },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/ATRAC3", mime_audio_ATRAC3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/basic", mime_audio_basic },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/BV16", mime_audio_BV16 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/BV32", mime_audio_BV32 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/clearmode", mime_audio_clearmode },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/CN", mime_audio_CN },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/DAT12", mime_audio_DAT12 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/dls", mime_audio_dls },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/dsr-es201108", mime_audio_dsr_es201108 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/dsr-es202050", mime_audio_dsr_es202050 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/dsr-es202211", mime_audio_dsr_es202211 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/dsr-es202212", mime_audio_dsr_es202212 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/DV", mime_audio_DV },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/DVI4", mime_audio_DVI4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/eac3", mime_audio_eac3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/encaprtp", mime_audio_encaprtp },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRC", mime_audio_EVRC },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRC-QCP", mime_audio_EVRC_QCP },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRC0", mime_audio_EVRC0 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRC1", mime_audio_EVRC1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCB", mime_audio_EVRCB },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCB0", mime_audio_EVRCB0 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCB1", mime_audio_EVRCB1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCNW", mime_audio_EVRCNW },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCNW0", mime_audio_EVRCNW0 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCNW1", mime_audio_EVRCNW1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCWB", mime_audio_EVRCWB },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCWB0", mime_audio_EVRCWB0 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVRCWB1", mime_audio_EVRCWB1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/EVS", mime_audio_EVS },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/example", mime_audio_example },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/flexfec", mime_audio_flexfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/fwdred", mime_audio_fwdred },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G711-0", mime_audio_G711_0 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G719", mime_audio_G719 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G7221", mime_audio_G7221 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G722", mime_audio_G722 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G723", mime_audio_G723 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G726-16", mime_audio_G726_16 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G726-24", mime_audio_G726_24 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G726-32", mime_audio_G726_32 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G726-40", mime_audio_G726_40 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G728", mime_audio_G728 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G729", mime_audio_G729 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G7291", mime_audio_G7291 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G729D", mime_audio_G729D },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/G729E", mime_audio_G729E },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/GSM", mime_audio_GSM },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/GSM-EFR", mime_audio_GSM_EFR },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/GSM-HR-08", mime_audio_GSM_HR_08 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/iLBC", mime_audio_iLBC },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/ip-mr_v2.5", mime_audio_ip_mr_v2_5 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/L8", mime_audio_L8 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/L16", mime_audio_L16 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/L20", mime_audio_L20 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/L24", mime_audio_L24 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/LPC", mime_audio_LPC },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/MELP", mime_audio_MELP },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/MELP600", mime_audio_MELP600 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/MELP1200", mime_audio_MELP1200 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/MELP2400", mime_audio_MELP2400 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/mhas", mime_audio_mhas },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/mobile-xmf", mime_audio_mobile_xmf },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/MPA", mime_audio_MPA },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/mp4", mime_audio_mp4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/MP4A-LATM", mime_audio_MP4A_LATM },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/mpa-robust", mime_audio_mpa_robust },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/mpeg", mime_audio_mpeg },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/mpeg4-generic", mime_audio_mpeg4_generic },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/ogg", mime_audio_ogg },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/opus", mime_audio_opus },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/parityfec", mime_audio_parityfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/PCMA", mime_audio_PCMA },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/PCMA-WB", mime_audio_PCMA_WB },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/PCMU", mime_audio_PCMU },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/PCMU-WB", mime_audio_PCMU_WB },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/prs.sid", mime_audio_prs_sid },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/QCELP", mime_audio_QCELP },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/raptorfec", mime_audio_raptorfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/RED", mime_audio_RED },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/rtp-enc-aescm128", mime_audio_rtp_enc_aescm128 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/rtploopback", mime_audio_rtploopback },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/rtp-midi", mime_audio_rtp_midi },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/rtx", mime_audio_rtx },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/SMV", mime_audio_SMV },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/SMV0", mime_audio_SMV0 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/SMV-QCP", mime_audio_SMV_QCP },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/sp-midi", mime_audio_sp_midi },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/speex", mime_audio_speex },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/t140c", mime_audio_t140c },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/t38", mime_audio_t38 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/telephone-event", mime_audio_telephone_event },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/TETRA_ACELP", mime_audio_TETRA_ACELP },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/TETRA_ACELP_BB", mime_audio_TETRA_ACELP_BB },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/tone", mime_audio_tone },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/UEMCLIP", mime_audio_UEMCLIP },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/ulpfec", mime_audio_ulpfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/usac", mime_audio_usac },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/VDVI", mime_audio_VDVI },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/VMR-WB", mime_audio_VMR_WB },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.3gpp.iufp", mime_audio_vnd_3gpp_iufp },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.4SB", mime_audio_vnd_4SB },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.audiokoz", mime_audio_vnd_audiokoz },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.CELP", mime_audio_vnd_CELP },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.cisco.nse", mime_audio_vnd_cisco_nse },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.cmles.radio-events", mime_audio_vnd_cmles_radio_events },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.cns.anp1", mime_audio_vnd_cns_anp1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.cns.inf1", mime_audio_vnd_cns_inf1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dece.audio", mime_audio_vnd_dece_audio },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.digital-winds", mime_audio_vnd_digital_winds },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dlna.adts", mime_audio_vnd_dlna_adts },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dolby.heaac.1", mime_audio_vnd_dolby_heaac_1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dolby.heaac.2", mime_audio_vnd_dolby_heaac_2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dolby.mlp", mime_audio_vnd_dolby_mlp },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dolby.mps", mime_audio_vnd_dolby_mps },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dolby.pl2", mime_audio_vnd_dolby_pl2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dolby.pl2x", mime_audio_vnd_dolby_pl2x },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dolby.pl2z", mime_audio_vnd_dolby_pl2z },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dolby.pulse.1", mime_audio_vnd_dolby_pulse_1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dra", mime_audio_vnd_dra },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dts", mime_audio_vnd_dts },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dts.hd", mime_audio_vnd_dts_hd },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dts.uhd", mime_audio_vnd_dts_uhd },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.dvb.file", mime_audio_vnd_dvb_file },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.everad.plj", mime_audio_vnd_everad_plj },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.hns.audio", mime_audio_vnd_hns_audio },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.lucent.voice", mime_audio_vnd_lucent_voice },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.ms-playready.media.pya", mime_audio_vnd_ms_playready_media_pya },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.nokia.mobile-xmf", mime_audio_vnd_nokia_mobile_xmf },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.nortel.vbk", mime_audio_vnd_nortel_vbk },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.nuera.ecelp4800", mime_audio_vnd_nuera_ecelp4800 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.nuera.ecelp7470", mime_audio_vnd_nuera_ecelp7470 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.nuera.ecelp9600", mime_audio_vnd_nuera_ecelp9600 },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.octel.sbc", mime_audio_vnd_octel_sbc },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.presonus.multitrack", mime_audio_vnd_presonus_multitrack },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.qcelp", mime_audio_vnd_qcelp },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.rhetorex.32kadpcm", mime_audio_vnd_rhetorex_32kadpcm },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.rip", mime_audio_vnd_rip },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.sealedmedia.softseal.mpeg", mime_audio_vnd_sealedmedia_softseal_mpeg },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vnd.vmx.cvsd", mime_audio_vnd_vmx_cvsd },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vorbis", mime_audio_vorbis },
    { { HTML_4_0 }, { HTML_UNDEF }, "audio/vorbis-config", mime_audio_vorbis_config },
    { { HTML_4_0 }, { HTML_UNDEF }, "font/collection", mime_font_collection },
    { { HTML_4_0 }, { HTML_UNDEF }, "font/otf", mime_font_otf },
    { { HTML_4_0 }, { HTML_UNDEF }, "font/sfnt", mime_font_sfnt },
    { { HTML_4_0 }, { HTML_UNDEF }, "font/ttf", mime_font_ttf },
    { { HTML_4_0 }, { HTML_UNDEF }, "font/woff", mime_font_woff },
    { { HTML_4_0 }, { HTML_UNDEF }, "font/woff2", mime_font_woff2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/aces", mime_image_aces },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/avci", mime_image_avci },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/avcs", mime_image_avcs },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/bmp", mime_image_bmp },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/cgm", mime_image_cgm },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/dicom-rle", mime_image_dicom_rle },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/emf", mime_image_emf },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/example", mime_image_example },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/fits", mime_image_fits },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/g3fax", mime_image_g3fax },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/gif", mime_image_gif },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/heic", mime_image_heic },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/heic-sequence", mime_image_heic_sequence },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/heif", mime_image_heif },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/heif-sequence", mime_image_heif_sequence },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/hej2k", mime_image_hej2k },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/hsj2", mime_image_hsj2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/ief", mime_image_ief },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jls", mime_image_jls },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jp2", mime_image_jp2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jpeg", mime_image_jpeg },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jph", mime_image_jph },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jphc", mime_image_jphc },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jpm", mime_image_jpm },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jpx", mime_image_jpx },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jxr", mime_image_jxr },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jxrA", mime_image_jxrA },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jxrS", mime_image_jxrS },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jxs", mime_image_jxs },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jxsc", mime_image_jxsc },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jxsi", mime_image_jxsi },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/jxss", mime_image_jxss },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/ktx", mime_image_ktx },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/naplps", mime_image_naplps },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/png", mime_image_png },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/prs.btif", mime_image_prs_btif },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/prs.pti", mime_image_prs_pti },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/pwg-raster", mime_image_pwg_raster },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/svg+xml", mime_image_svg_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/t38", mime_image_t38 },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/tiff", mime_image_tiff },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/tiff-fx", mime_image_tiff_fx },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.adobe.photoshop", mime_image_vnd_adobe_photoshop },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.airzip.accelerator.azv", mime_image_vnd_airzip_accelerator_azv },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.cns.inf2", mime_image_vnd_cns_inf2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.dece.graphic", mime_image_vnd_dece_graphic },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.djvu", mime_image_vnd_djvu },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.dwg", mime_image_vnd_dwg },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.dxf", mime_image_vnd_dxf },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.dvb.subtitle", mime_image_vnd_dvb_subtitle },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.fastbidsheet", mime_image_vnd_fastbidsheet },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.fpx", mime_image_vnd_fpx },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.fst", mime_image_vnd_fst },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.fujixerox.edmics-mmr", mime_image_vnd_fujixerox_edmics_mmr },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.fujixerox.edmics-rlc", mime_image_vnd_fujixerox_edmics_rlc },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.globalgraphics.pgb", mime_image_vnd_globalgraphics_pgb },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.microsoft.icon", mime_image_vnd_microsoft_icon },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.mix", mime_image_vnd_mix },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.ms-modi", mime_image_vnd_ms_modi },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.mozilla.apng", mime_image_vnd_mozilla_apng },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.net-fpx", mime_image_vnd_net_fpx },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.radiance", mime_image_vnd_radiance },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.sealed.png", mime_image_vnd_sealed_png },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.sealedmedia.softseal.gif", mime_image_vnd_sealedmedia_softseal_gif },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.sealedmedia.softseal.jpg", mime_image_vnd_sealedmedia_softseal_jpg },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.svf", mime_image_vnd_svf },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.tencent.tap", mime_image_vnd_tencent_tap },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.valve.source.texture", mime_image_vnd_valve_source_texture },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.wap.wbmp", mime_image_vnd_wap_wbmp },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.xiff", mime_image_vnd_xiff },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/vnd.zbrush.pcx", mime_image_vnd_zbrush_pcx },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/wmf", mime_image_wmf },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/x-emf", mime_image_xemf },
    { { HTML_4_0 }, { HTML_UNDEF }, "image/x-wmf", mime_image_xwmf },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/CPIM", mime_message_CPIM },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/delivery-status", mime_message_delivery_status },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/disposition-notification", mime_message_disposition_notification },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/example", mime_message_example },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/external-body", mime_message_external_body },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/feedback-report", mime_message_feedback_report },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/global", mime_message_global },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/global-delivery-status", mime_message_global_delivery_status },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/global-disposition-notification", mime_message_global_disposition_notification },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/global-headers", mime_message_global_headers },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/http", mime_message_http },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/imdn+xml", mime_message_imdn_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/news", mime_message_news },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/partial", mime_message_partial },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/rfc822", mime_message_rfc822 },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/s-http", mime_message_s_http },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/sip", mime_message_sip },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/sipfrag", mime_message_sipfrag },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/tracking-status", mime_message_tracking_status },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/vnd.si.simp", mime_message_vnd_si_simp },
    { { HTML_4_0 }, { HTML_UNDEF }, "message/vnd.wfa.wsc", mime_message_vnd_wfa_wsc },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/3mf", mime_model_3mf },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/example", mime_model_example },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/gltf-binary", mime_model_gltf_binary },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/gltf+json", mime_model_gltf_json },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/iges", mime_model_iges },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/mesh", mime_model_mesh },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/mtl", mime_model_mtl },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/obj", mime_model_obj },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/stl", mime_model_stl },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.collada+xml", mime_model_vnd_collada_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.dwf", mime_model_vnd_dwf },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.flatland.3dml", mime_model_vnd_flatland_3dml },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.gdl", mime_model_vnd_gdl },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.gs-gdl", mime_model_vnd_gs_gdl },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.gtw", mime_model_vnd_gtw },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.moml+xml", mime_model_vnd_moml_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.mts", mime_model_vnd_mts },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.opengex", mime_model_vnd_opengex },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.parasolid.transmit.binary", mime_model_vnd_parasolid_transmit_binary },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.parasolid.transmit.text", mime_model_vnd_parasolid_transmit_text },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.rosette.annotated-data-model", mime_model_vnd_rosette_annotated_data_model },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.usdz+zip", mime_model_vnd_usdz_zip },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.valve.source.compiled-map", mime_model_vnd_valve_source_compiled_map },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vnd.vtu", mime_model_vnd_vtu },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/vrml", mime_model_vrml },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/x3d-vrml", mime_model_x3d_vrml },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/x3d+fastinfoset", mime_model_x3d_fastinfoset },
    { { HTML_4_0 }, { HTML_UNDEF }, "model/x3d+xml", mime_model_x3d_xml },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/alternative", mime_multipart_alternative },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/appledouble", mime_multipart_appledouble },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/byteranges", mime_multipart_byteranges },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/digest", mime_multipart_digest },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/encrypted", mime_multipart_encrypted },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/example", mime_multipart_example },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/form-data", mime_multipart_form_data },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/header-set", mime_multipart_header_set },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/mixed", mime_multipart_mixed },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/multilingual", mime_multipart_multilingual },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/parallel", mime_multipart_parallel },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/related", mime_multipart_related },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/report", mime_multipart_report },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/signed", mime_multipart_signed },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/vnd.bint.med-plus", mime_multipart_vnd_bint_med_plus },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/voice-message", mime_multipart_voice_message },
    { { HTML_4_0 }, { HTML_UNDEF }, "multipart/x-mixed-replace", mime_multipart_x_mixed_replace },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/1d-interleaved-parityfec", mime_text_1d_interleaved_parityfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/cache-manifest", mime_text_cache_manifest },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/calendar", mime_text_calendar },
    { { HTML_4_0 }, { HTML_UNDEF }, CSS_TYPE, mime_text_css, ns_default, STYLE },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/csv", mime_text_csv },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/csv-schema", mime_text_csv_schema },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/directory", mime_text_directory },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/dns", mime_text_dns },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/ecmascript", mime_text_ecmascript, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/encaprtp", mime_text_encaprtp },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/enriched", mime_text_enriched },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/example", mime_text_example },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/flexfec", mime_text_flexfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/fwdred", mime_text_fwdred },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/grammar-ref-list", mime_text_grammar_ref_list },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/html", mime_text_html },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/javascript", mime_text_javascript, ns_default, SCRIPT },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/javascript1.0", mime_text_javascript10, ns_default, SCRIPT },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/javascript1.1", mime_text_javascript11, ns_default, SCRIPT },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/javascript1.2", mime_text_javascript12, ns_default, SCRIPT },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/javascript1.3", mime_text_javascript13, ns_default, SCRIPT },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/javascript1.4", mime_text_javascript14, ns_default, SCRIPT },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/javascript1.5", mime_text_javascript15, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/jcr-cnd", mime_text_jcr_cnd },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/jscript", mime_text_jscript, ns_default, SCRIPT },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/livescript", mime_text_livescript, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/markdown", mime_text_markdown },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/mizar", mime_text_mizar },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/n3", mime_text_n3 },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/parameters", mime_text_parameters },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/parityfec", mime_text_parityfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/plain", mime_text_plain, ns_default, NOT_SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/provenance-notation", mime_text_provenance_notation },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/prs.fallenstein.rst", mime_text_prs_fallenstein_rst },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/prs.lines.tag", mime_text_prs_lines_tag },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/prs.prop.logic", mime_text_prs_prop_logic },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/raptorfec", mime_text_raptorfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/RED", mime_text_RED },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/rfc822-headers", mime_text_rfc822_headers },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/richtext", mime_text_richtext },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/rtf", mime_text_rtf },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/rtp-enc-aescm128", mime_text_rtp_enc_aescm128 },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/rtploopback", mime_text_rtploopback },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/rtx", mime_text_rtx },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/SGML", mime_text_SGML },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/strings", mime_text_strings },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/t140", mime_text_t140 },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/tab-separated-values", mime_text_tab_separated_values },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/tcl", mime_text_tcl, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/troff", mime_text_troff },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/turtle", mime_text_turtle },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/ulpfec", mime_text_ulpfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/uri-list", mime_text_uri_list },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vbscript", mime_text_vbscript, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vcard", mime_text_vcard },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.a", mime_text_vnd_a },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.abc", mime_text_vnd_abc },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.ascii-art", mime_text_vnd_ascii_art },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.curl", mime_text_vnd_curl },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.debian.copyright", mime_text_vnd_debian_copyright },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.DMClientScript", mime_text_vnd_DMClientScript },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.dvb.subtitle", mime_text_vnd_dvb_subtitle },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.esmertec.theme-descriptor", mime_text_vnd_esmertec_theme_descriptor },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.ficlab.flt", mime_text_vnd_ficlab_flt },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.fly", mime_text_vnd_fly },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.fmi.flexstor", mime_text_vnd_fmi_flexstor },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.gml", mime_text_vnd_gml },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.graphviz", mime_text_vnd_graphviz },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.hgl", mime_text_vnd_hgl },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.in3d.3dml", mime_text_vnd_in3d_3dml },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.in3d.spot", mime_text_vnd_in3d_spot },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.IPTC.NewsML", mime_text_vnd_IPTC_NewsML },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.IPTC.NITF", mime_text_vnd_IPTC_NITF },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.latex-z", mime_text_vnd_latex_z },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.motorola.reflex", mime_text_vnd_motorola_reflex },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.ms-mediapackage", mime_text_vnd_ms_mediapackage },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.net2phone.commcenter.command", mime_text_vnd_net2phone_commcenter_command },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.radisys.msml-basic-layout", mime_text_vnd_radisys_msml_basic_layout },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.senx.warpscript", mime_text_vnd_senx_warpscript },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.si.uricatalogue", mime_text_vnd_si_uricatalogue },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.sun.j2me.app-descriptor", mime_text_vnd_sun_j2me_app_descriptor },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.sosi", mime_text_vnd_sosi },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.trolltech.linguist", mime_text_vnd_trolltech_linguist },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.wap.si", mime_text_vnd_wap_si },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.wap.sl", mime_text_vnd_wap_sl },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.wap.wml", mime_text_vnd_wap_wml },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vnd.wap.wmlscript", mime_text_vnd_wap_wmlscript },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/vtt", mime_text_vtt },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/x-ecmascript", mime_text_x_ecmascript, ns_default, SCRIPT },
    { { HTML_5_0 }, { HTML_UNDEF }, "text/x-javascript", mime_text_x_javascript, ns_default, SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/xml", mime_text_xml, ns_default, NOT_SCRIPT },
    { { HTML_4_0 }, { HTML_UNDEF }, "text/xml-external-parsed-entity", mime_text_xml_external_parsed_entity },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/1d-interleaved-parityfec", mime_video_1d_interleaved_parityfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/3gpp", mime_video_3gpp },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/3gpp2", mime_video_3gpp2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/3gpp-tt", mime_video_3gpp_tt },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/BMPEG", mime_video_BMPEG },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/BT656", mime_video_BT656 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/CelB", mime_video_CelB },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/DV", mime_video_DV },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/encaprtp", mime_video_encaprtp },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/example", mime_video_example },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/flexfec", mime_video_flexfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/H261", mime_video_H261 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/H263", mime_video_H263 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/H263-1998", mime_video_H263_1998 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/H263-2000", mime_video_H263_2000 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/H264", mime_video_H264 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/H264-RCDO", mime_video_H264_RCDO },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/H264-SVC", mime_video_H264_SVC },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/H265", mime_video_H265 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/iso.segment", mime_video_iso_segment },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/JPEG", mime_video_JPEG },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/jpeg2000", mime_video_jpeg2000 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/mj2", mime_video_mj2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/MP1S", mime_video_MP1S },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/MP2P", mime_video_MP2P },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/MP2T", mime_video_MP2T },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/mp4", mime_video_mp4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/MP4V-ES", mime_video_MP4V_ES },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/MPV", mime_video_MPV },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/mpeg", mime_video_mpeg },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/mpeg4-generic", mime_video_mpeg4_generic },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/nv", mime_video_nv },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/ogg", mime_video_ogg },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/parityfec", mime_video_parityfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/pointer", mime_video_pointer },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/quicktime", mime_video_quicktime },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/raptorfec", mime_video_raptorfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/raw", mime_video_raw },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/rtp-enc-aescm128", mime_video_rtp_enc_aescm128 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/rtploopback", mime_video_rtploopback },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/rtx", mime_video_rtx },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/smpte291", mime_video_smpte291 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/SMPTE292M", mime_video_SMPTE292M },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/ulpfec", mime_video_ulpfec },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vc1", mime_video_vc1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vc2", mime_video_vc2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.CCTV", mime_video_vnd_CCTV },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.dece.hd", mime_video_vnd_dece_hd },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.dece.mobile", mime_video_vnd_dece_mobile },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.dece.mp4", mime_video_vnd_dece_mp4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.dece.pd", mime_video_vnd_dece_pd },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.dece.sd", mime_video_vnd_dece_sd },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.dece.video", mime_video_vnd_dece_video },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.directv.mpeg", mime_video_vnd_directv_mpeg },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.directv.mpeg-tts", mime_video_vnd_directv_mpeg_tts },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.dlna.mpeg-tts", mime_video_vnd_dlna_mpeg_tts },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.dvb.file", mime_video_vnd_dvb_file },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.fvt", mime_video_vnd_fvt },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.hns.video", mime_video_vnd_hns_video },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.iptvforum.1dparityfec-1010", mime_video_vnd_iptvforum_1dparityfec_1010 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.iptvforum.1dparityfec-2005", mime_video_vnd_iptvforum_1dparityfec_2005 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.iptvforum.2dparityfec-1010", mime_video_vnd_iptvforum_2dparityfec_1010 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.iptvforum.2dparityfec-2005", mime_video_vnd_iptvforum_2dparityfec_2005 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.iptvforum.ttsavc", mime_video_vnd_iptvforum_ttsavc },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.iptvforum.ttsmpeg2", mime_video_vnd_iptvforum_ttsmpeg2 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.motorola.video", mime_video_vnd_motorola_video },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.motorola.videop", mime_video_vnd_motorola_videop },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.mpegurl", mime_video_vnd_mpegurl },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.ms-playready.media.pyv", mime_video_vnd_ms_playready_media_pyv },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.nokia.interleaved-multimedia", mime_video_vnd_nokia_interleaved_multimedia },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.nokia.mp4vr", mime_video_vnd_nokia_mp4vr },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.nokia.videovoip", mime_video_vnd_nokia_videovoip },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.objectvideo", mime_video_vnd_objectvideo },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.radgamettools.bink", mime_video_vnd_radgamettools_bink },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.radgamettools.smacker", mime_video_vnd_radgamettools_smacker },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.sealed.mpeg1", mime_video_vnd_sealed_mpeg1 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.sealed.mpeg4", mime_video_vnd_sealed_mpeg4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.sealed.swf", mime_video_vnd_sealed_swf },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.sealedmedia.softseal.mov", mime_video_vnd_sealedmedia_softseal_mov },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.uvvu.mp4", mime_video_vnd_uvvu_mp4 },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.youtube.yt", mime_video_vnd_youtube_yt },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/vnd.vivo", mime_video_vnd_vivo },
    { { HTML_4_0 }, { HTML_UNDEF }, "video/VP8", mime_video_VP8 } };

void mime_init (nitpick& nits)
{   type_master < t_mime > :: init (nits, mimetype_symbol_table, sizeof (mimetype_symbol_table) / sizeof (symbol_entry < e_mimetype >)); }
