/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "attr.h"
#include "myhtml/api.h"

class myhtml_attribute
{   myhtml_tree_attr_t *attribute_;
    e_attribute e_;
    void parse ();
public:
    myhtml_attribute (myhtml_tree_attr_t* a) : attribute_ (a), e_ (a_unknown) { parse (); }
    void swap (myhtml_attribute& a) noexcept
    {   ::std::swap (attribute_, a.attribute_);
        ::std::swap (e_, a.e_); }
    bool has_value () const;
    bool has_key () const;
    const char* get_value () const;
    const char* get_key () const;
    e_attribute get_enum () const { return e_; }
    bool unknown () const { return get_enum () == a_unknown; }
    bool next ();
    bool invalid () const { return attribute_ == nullptr; } };
