/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "context.h"
#include "options.h"
#include "irt.h"
#include "hook.h"

context_t context;

context_t::context_t ()
    : code_ (0), output_ (default_output),
      checking_urls_ (false), clear_ (false), external_ (false), forwarded_ (false), links_ (false), microdata_ (false), nochange_ (false),
      notify_ (false), once_ (false), repeated_ (false), reset_ (false), revoke_ (false), valid_ (false),
      wm_status_ (wm_undefined) {}

int context_t::parameters (int argc, char** argv)
{   options o (argc, argv);
    if (o.stop ()) return STOP_OK;
    if (o.invalid ()) return ERROR_STATE;
    o.contextualise ();
    if (tell (e_debug)) ::std::cout << o.report ();
    for (const ::std::string& name : site_)
        if (name.find_first_not_of (ALPHABET DDD) != ::std::string::npos)
        {   valid_ = false;
            ::std::cerr << name << " is not a valid domain name (do not include protocols)\n";
            return false; }
    valid_ = ! root ().empty ();
    return valid_ ? VALID_RESULT : ERROR_STATE; }

context_t& context_t::webmention (const ::std::string& w, const e_wm_status status)
{   if (! w.empty () && status > wm_status_)
    {   webmention_ = w;
//        if (tell (e_debug)) ::std::cout << "setting context_t " WEBMENTION " to " << w << "\n";
        wm_status_ = status; }
    return *this; }

::std::string context_t::make_absolute_url (const ::std::string& link, bool can_use_index ) const
{    ::std::string res, srv;
    if (site_.size () > 0)
    {   srv = HTTPS;
        srv += site_ [0];
        srv += SLASH; }
    if (link.empty ()) res = srv;
    else
    {   if (link.find (COLON) != link.npos) res = link;
        else
        {   res = srv;
            if (link [0] != SLASH) res += link;
            else res += link.substr (1); } }
    size_t last = res.length () - 1;
    if (can_use_index )
    {   bool slashed = res [last] == SLASH;
        if (slashed) if (! index ().empty ()) res += index (); }
    return res; }

void context_t::process_outgoing_webmention (::std::ostringstream& ss, const int depth)
{   if (notify ()) replies_.process (ss, depth); }

void context_t::process_incoming_webmention (::std::ostringstream& ss)
{   if (! mentions_.empty ()) hooks_.process (ss); }
