/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "irt.h"
#include "hook.h"

typedef enum { e_silent, e_severe, e_error, e_warning, e_info, e_comment, e_debug, e_variable, e_structure, e_detail, e_callstack, e_splurge, e_all } e_output;
typedef enum { wm_undefined, wm_addr, wm_link, wm_root } e_wm_status;
const e_output default_output = e_warning;

// ah ... good old bash ... :-)
#define VALID_RESULT 0
#define STOP_OK 1
#define NOTHING_TO_DO 2
#define ERROR_STATE 3

class hook;
class replies;


class context_t
{   bool checking_urls_, clear_, external_, forwarded_, links_, mf_export_, mf_verify_, microdata_, nochange_, notify_, once_, process_webmentions_, repeated_, reset_, revoke_, valid_;
    int code_;
    e_output output_;
    ::std::string base_, filename_, stub_, hook_, incoming_, index_, macro_end_, macro_start_, path_, persisted_, root_, secret_, server_, test_header_, webmention_, write_path_;
    e_wm_status wm_status_;
    vstr_t extensions_, mentions_, site_, templates_, virtuals_;
    replies replies_;
    hooks hooks_;
public:
    context_t ();
    int parameters (int argc, char** argv);
    const ::std::string base () const { return base_; }
    bool checking_urls () const { return checking_urls_; }
    bool clear () const { return clear_; }
    int code () const { return code_; }
    const vstr_t extensions () const { return extensions_; }
    bool external () const { return external_; }
    const ::std::string filename () const { return filename_; }
    bool forwarded () const { return forwarded_; }
    const ::std::string incoming () const { return incoming_; }
    const ::std::string index () const { return index_; }
    bool invalid () const { return ! valid_; }
    bool links () const { return links_; }
    const ::std::string macro_end () const { return macro_end_; }
    const ::std::string macro_start () const { return macro_start_; }
    const vstr_t mentions () const { return mentions_; }
    bool mf_export () const { return mf_export_; }
    bool mf_verify () const { return mf_verify_; }
    bool microdata () const { return microdata_; }
    bool microformats () const { return mf_verify_ || mf_export_; }
    bool nochange () const { return nochange_; }
    bool notify () const { return notify_; }
    bool once () const { return once_; }
    int output () const { return output_; }
    ::std::string path () const { return path_; }
    const ::std::string persisted () const { return persisted_; }
    bool process_webmentions () const { return process_webmentions_; }
    bool repeated () const { return repeated_; }
    bool reset () const { return reset_; }
    bool revoke () const { return revoke_; }
    const ::std::string root () const { return root_; }
    const ::std::string secret () const { return secret_; }
    const ::std::string server () const { return server_; }
    const vstr_t site () const { return site_; }
    const ::std::string stub () const { return stub_; }
    const vstr_t templates () const { return templates_; }
    const ::std::string test_header () const { return test_header_; }
    const vstr_t virtuals () const { return virtuals_; }
    const ::std::string webmention () const { return webmention_; }
    const ::std::string write_path () const { return write_path_; }
    context_t& base (const ::std::string& s) { base_ = s; return *this; }
    context_t& checking_urls (const bool b) { checking_urls_ = b; return *this; }
    context_t& clear (const bool b) { clear_ = b; return *this; }
    context_t& code (const int i) { code_ = i; return *this; }
    context_t& extensions (const vstr_t& s) { extensions_ = s; return *this; }
    context_t& external (const bool b)
    {   external_ = b;
        if (b) links (b);
        else { forwarded (false); once (false); revoke (false); microdata (false); }
        return *this; }
    context_t& filename (const ::std::string& s) { filename_ = s; return *this; }
    context_t& stub (const ::std::string& s) { stub_ = s; return *this; }
    context_t& forwarded (const bool b)
    {   forwarded_ = b;
        if (b) external (b);
        return *this; }
    context_t& hook (const ::std::string& s) { hook_ = s; return *this; }
    context_t& incoming (const ::std::string& s) { incoming_ = s; return *this; }
    context_t& index (const ::std::string& s) { index_ = s; return *this; }
    context_t& links (const bool b)
    {   links_ = b;
        if (! b) { external (false); }
        return *this; }
    context_t& macro_end (const ::std::string& s) { macro_end_ = s; return *this; }
    context_t& macro_start (const ::std::string& s) { macro_start_ = s; return *this; }
    context_t& mentions (const vstr_t& s) { mentions_ = s; return *this; }
    context_t& mf_export (const bool b) { mf_export_ = b; return *this; }
    context_t& mf_verify (const bool b) { mf_verify_ = b; return *this; }
    context_t& microdata (const bool b)
    {   microdata_ = b;
        if (b) external (b);
        return *this; }
    context_t& nochange (const bool b) { nochange_ = b; return *this; }
    context_t& notify (const bool b) { notify_ = b; return *this; }
    context_t& once (const bool b)
    {   once_ = b;
        if (b) external (b);
        return *this; }
    context_t& output (const e_output i) { output_ = i; return *this; }
    context_t& path (const ::std::string& s) { path_ = s; return *this; }
    context_t& persisted (const ::std::string& s) { persisted_ = s; return *this; }
    context_t& process_webmentions (const bool b) { process_webmentions_ = b; return *this; }
    context_t& repeated (const bool b) { repeated_ = b; return *this; }
    context_t& reset (const bool b) { reset_ = b; return *this; }
    context_t& revoke (const bool b)
    {   revoke_ = b;
        if (b) external (b);
        return *this; }
    context_t& root (const ::std::string& s) { root_ = s; return *this; }
    context_t& secret (const ::std::string& s) { secret_ = s; return *this; }
    context_t& server (const ::std::string& s) { server_ = s; return *this; }
    context_t& site (const vstr_t& s) { site_ = s; return *this; }
    context_t& templates (const vstr_t& s) { templates_ = s; return *this; }
    context_t& test_header (const ::std::string& s) { test_header_ = s; return *this; }
    context_t& virtuals (const vstr_t& s) { virtuals_ = s; return *this; }
    context_t& webmention (const ::std::string& w, const e_wm_status status);
    context_t& write_path (const ::std::string& s) { write_path_ = s; return *this; }
    void reset_webmention ()
    {   webmention_.clear ();
        wm_status_ = wm_undefined; }
    void note_reply (const ::std::string& file, const ::std::string& id, const ::std::string& target, const ::std::string& content)
    {   if (notify ()) replies_.append (file, id, target, content); }
    replies& get_replies () { return replies_; }
    void process_outgoing_webmention (::std::ostringstream& ss, const int depth);
    void process_incoming_webmention (::std::ostringstream& ss);
    bool tell (const e_output n) const { return n <= output_; }
    ::std::string make_absolute_url (const ::std::string& link, bool can_use_index = true) const; };

extern context_t context; // enforce singleton
