/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "attribute_classes.h"
#include "tuple.h"
#include "element_myhtml.h"

class context;
class directory;

template < class ELEMENT, int TAG > struct html_element_post_parse
{   static void apply (ELEMENT& ) { } };

template < class ELEMENT > struct html_element_post_parse < ELEMENT, MyHTML_TAG_META >
{   static void apply (ELEMENT& el); };

template < class ELEMENT > void html_element_post_parse < ELEMENT, MyHTML_TAG_META > :: apply (ELEMENT& el)
{   attr_name* p = nullptr;
    el. template get < attr_name > (&p);
    if (p != nullptr)
    {   if (p -> status () == s_good)
        {   ::std::string value = el. template get_value < attr_name > ();
            el. template set_value < attr_metaname > (value); }
        p -> reset (); } }

template < class ELEMENT > struct html_element_post_parse < ELEMENT, MyHTML_TAG_INPUT >
{   static void apply (ELEMENT& el); };

template < class ELEMENT > void html_element_post_parse < ELEMENT, MyHTML_TAG_INPUT > :: apply (ELEMENT& el)
{   attr_type* p = nullptr;
    el. template get < attr_type > (&p);
    if (p != nullptr)
    {   ::std::string value = p -> original ();
        el. template set_value < attr_inputtype > (value);
        p -> reset (); } }

template < class ATTRIBUTE, class TUPLE, bool B > struct get_attribute_imp
{   static void get (TUPLE& , ATTRIBUTE** ) { }
    static void get (const TUPLE& , const ATTRIBUTE** ) { }
    static void get_value (const TUPLE& , ::std::string& ) { }
    static void set_value (TUPLE& , const ::std::string& ) { }
    static bool has () { return false; } };

template < class ATTRIBUTE, class TUPLE > struct get_attribute_imp < ATTRIBUTE, TUPLE, true >
{   static void get (TUPLE& t, ATTRIBUTE** p)
    {   assert (p != nullptr);
        *p = & ::std::get < ATTRIBUTE > (t); }
    static void get (const TUPLE& t, const ATTRIBUTE** p)
    {   assert (p != nullptr);
        *p = & ::std::get < ATTRIBUTE > (t); }
    static void get_value (const TUPLE& t, ::std::string& s)
    {   s = ::std::get < ATTRIBUTE > (t).get_value (); }
    static void set_value (TUPLE& t, const ::std::string& s)
    {   ::std::get < ATTRIBUTE > (t).set_value (s); }
    static bool has () { return true; } };

template < class ATTRIBUTE, class... ATTRIBUTES >
void get_attribute (::std::tuple < ATTRIBUTES... >& t, ATTRIBUTE** p)
{   get_attribute_imp < ATTRIBUTE, ::std::tuple < ATTRIBUTES... >, has_type < ATTRIBUTE, ATTRIBUTES... >::value > :: get (t, p); }

template < class ATTRIBUTE, class... ATTRIBUTES >
void get_attribute (const ::std::tuple < ATTRIBUTES... >& t, const ATTRIBUTE** p)
{   get_attribute_imp < ATTRIBUTE, ::std::tuple < ATTRIBUTES... >, has_type < ATTRIBUTE, ATTRIBUTES... >::value > :: get (t, p); }

template < class ATTRIBUTE, class... ATTRIBUTES >
void get_attribute_value (const ::std::tuple < ATTRIBUTES... >& t, ::std::string& s)
{  get_attribute_imp < ATTRIBUTE, ::std::tuple < ATTRIBUTES... >, has_type < ATTRIBUTE, ATTRIBUTES... >::value > :: get_value (t, s); }

template < class ATTRIBUTE, class... ATTRIBUTES >
void set_attribute_value (::std::tuple < ATTRIBUTES... >& t, const ::std::string& s)
{   get_attribute_imp < ATTRIBUTE, ::std::tuple < ATTRIBUTES... >, has_type < ATTRIBUTE, ATTRIBUTES... >::value > :: set_value (t, s); }

template < class ATTRIBUTE, class... ATTRIBUTES >
bool has_attribute ()
{   return get_attribute_imp < ATTRIBUTE, ::std::tuple < ATTRIBUTES... >, has_type < ATTRIBUTE, ATTRIBUTES... >::value > :: has (); }
