/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "element_constructor.h"

template < class ELEMENT, class ... X > struct element_constructor : public element_constructor < X ... >
{   static element_v_ptr make (const myhtml_element& node, const myhtml_tag_id_t tag); };

template < class ELEMENT > struct element_constructor < ELEMENT >
{   static element_v_ptr make (const myhtml_element& node, const myhtml_tag_id_t tag); };


template < class ELEMENT, class ... X > element_v_ptr element_constructor < ELEMENT, X ... > :: make (const myhtml_element& node, const myhtml_tag_id_t tag)
{   if (tag == ELEMENT :: tag ()) return element_v_ptr (new ELEMENT (node));
    return element_constructor < X... > :: make (node, tag); }

template < class ELEMENT > element_v_ptr element_constructor < ELEMENT > :: make (const myhtml_element& node, const myhtml_tag_id_t tag)
{   if (tag == ELEMENT :: tag ()) return element_v_ptr (new ELEMENT (node));
    return element_v_ptr (new generic_element (node)); }


element_v_ptr make_element_v_ptr (const myhtml_element& node)
{   return element_constructor < ELEMENTS > :: make (node, node.tag ()); }
