/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "element_constructor.h"

//this class should be folded in to element

class element_wrapper
{   element_v_ptr v_;
public:
    element_wrapper () { }
    element_wrapper (const element_wrapper& w) : v_ (w.v_) { }
    explicit element_wrapper (const element_v_ptr& ptr) : v_ (ptr) { }
    element_wrapper (const myhtml_element& node);

    void reset () { v_.reset (); }
    void reset (const myhtml_element& node);
    void swap (element_wrapper& w) noexcept { v_.swap (w.v_); }
    template < class ELEMENT > void swap (ELEMENT& t) noexcept;
    template < class ELEMENT > bool holds_element () const;
    template < class ELEMENT > void set_element (const ELEMENT& t);

    template < class ELEMENT > ELEMENT& get ();
    template < class ELEMENT > const ELEMENT& get () const;
    template < class ELEMENT, class ATTRIBUTE > void get (ATTRIBUTE** p);
    template < class ELEMENT, class ATTRIBUTE > void get (const ATTRIBUTE** p) const;
    template < class ELEMENT, class ATTRIBUTE > ::std::string get_value () const;
    template < class ELEMENT, class ATTRIBUTE > void set_value (const ::std::string& s);
    template < class ELEMENT, class ATTRIBUTE > bool has () const;

    template < class ATTRIBUTE > ::std::string get_value () const;
    template < class ATTRIBUTE > void set_value (const ::std::string& s);
    template < class ATTRIBUTE > bool has () const;
    template < class ATTRIBUTE > bool invalid () const;
    template < class ATTRIBUTE > bool valid () const;

    size_t tag () const;
    void set_tag (const size_t tag);
    bool empty () const;
    bool invalid () const;
    bool valid () const;
    ::std::string diagnose (const int n) const;
    void verify (sstr_t* ssi);
    bool invalid_id (sstr_t* ids);
    bool has_url () const;
    bool verify_url (const directory& d);
    ::std::string content (bool text, bool anything) const;
    ::std::string report (const int n) const; };


template < class ELEMENT > inline void element_wrapper::swap (ELEMENT& t) noexcept
{   v_ -> swap (t); }

template < class ELEMENT > inline bool element_wrapper::holds_element () const
{   if (! v_) return false;
    return (v_ -> whoami () == ELEMENT::tag ()); }

template < class ELEMENT > inline void element_wrapper::set_element (const ELEMENT& t)
{   if (! v_) v_ = element_v_ptr (new element_v (t));
    else *v_ = t; }

template < class ELEMENT > inline ELEMENT& element_wrapper::get ()
{   assert (v_);
    assert (holds_element < ELEMENT > ());
    return *v_; }

template < class ELEMENT > inline const ELEMENT& element_wrapper::get () const
{   assert (v_);
    assert (holds_element < ELEMENT > ());
    return *v_; }

template < class ELEMENT, class ATTRIBUTE > inline void element_wrapper::get (ATTRIBUTE** p)
{   assert (v_);
    assert (holds_element < ELEMENT > ());
    get < ELEMENT > ().template get < ATTRIBUTE > (p); }

template < class ELEMENT, class ATTRIBUTE > inline void element_wrapper::get (const ATTRIBUTE** p) const
{   assert (v_);
    assert (holds_element < ELEMENT > ());
    get < ELEMENT > ().template get < ATTRIBUTE > (p); }

template < class ELEMENT, class ATTRIBUTE > inline ::std::string element_wrapper::get_value () const
{   assert (v_);
    assert (holds_element < ELEMENT > ());
    return get < ELEMENT > (). template get_value < ATTRIBUTE > (); }

template < class ELEMENT, class ATTRIBUTE > inline void element_wrapper::set_value (const ::std::string& s)
{   assert (v_);
    assert (holds_element < ELEMENT > ());
    return get < ELEMENT > (). template set_value < ATTRIBUTE > (s); }

template < class ELEMENT, class ATTRIBUTE > inline bool element_wrapper::has () const
{   assert (v_);
    assert (holds_element < ELEMENT > ());
    return get < ELEMENT > (). template has < ATTRIBUTE > (); }

template < class ATTRIBUTE > inline ::std::string element_wrapper::get_value () const
{   assert (v_);
    return v_ -> get_value (ATTRIBUTE::whoami ()); }

template < class ATTRIBUTE > inline void element_wrapper::set_value (const ::std::string& s)
{   assert (v_);
    v_ -> set_value (ATTRIBUTE::whoami (), s); }

template < class ATTRIBUTE > inline bool element_wrapper::has () const
{   if (v_ == nullptr) return false;
    return v_ -> has (ATTRIBUTE::whoami ()); }

template < class ATTRIBUTE > inline bool element_wrapper::invalid () const
{   if (! v_) return false;
    return v_ -> invalid (ATTRIBUTE::whoami ()); }

template < class ATTRIBUTE > inline bool element_wrapper::valid () const
{   if (! v_) return false;
    return v_ -> valid (ATTRIBUTE::whoami ()); }  // FFS this needs something better
