/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "microformat_classes.h"

// annoying, declaring this structure thus:
//     typedef ::std::variant < MICROFORMATS > microformat_v;
//     typedef ::std::shared_ptr < microformat_v > microformat_pv;
// causes gcc 10 to drop out with an out of memory error, visual C++ 2019 to drop out with a compiler error,
// and clang 9 to (impressively) crash linux. They can't handle boost's variant or variant2 either.
// I can't really blame them, the type structures are somewhat complex.
// Anyway, all this means I have to go old school.

struct microformat_pv
{   e_vocabulary            vocabulary_;
    microformat_base_ptr    microformat_;
    microformat_pv () noexcept
        :   vocabulary_ (v_error)
    { }
    explicit microformat_pv (const e_vocabulary v) noexcept
        :   vocabulary_ (v)
    { }
    microformat_pv (const microformat_pv& mf) = default;
    microformat_pv (microformat_pv&& mf) = default;
    microformat_pv& operator = (const microformat_pv& mf) = default;
    microformat_pv& operator = (microformat_pv&& mf) = default;
    ~microformat_pv () = default;

    static microformat_pv alloc_microformat_pv (const e_vocabulary v);

    void reset () { if (is_allocated ()) microformat_ -> reset (); }
    void swap (microformat_pv& m) noexcept
    {   ::std::swap (vocabulary_, m.vocabulary_);
        microformat_.swap (m.microformat_); }
//    void swap (microformat_base* mf) { if (is_allocated ()) microformat_ -> swap (*mf); } };

    template < class MICROFORMAT > const MICROFORMAT* get () const
    {   assert (MICROFORMAT::whoami () == vocabulary_);
        return reinterpret_cast <const MICROFORMAT*> (microformat_.get ()); }
    template < class MICROFORMAT > MICROFORMAT* get ()
    {   assert (MICROFORMAT::whoami () == vocabulary_);
        return reinterpret_cast <MICROFORMAT*> (microformat_.get ()); }
    const microformat_base* get () const
    {   return microformat_.get (); }
    microformat_base* get ()
    {   return microformat_.get (); }

    e_vocabulary whoami () const { return vocabulary_; }
    bool operator ! () const { return is_empty (); }
    bool is_empty () const { return ! microformat_; }
    bool is_valid () const { return vocabulary_ != v_error; }
    bool is_allocated () const { return is_valid () && ! is_empty (); }
    bool holds_alternative (const e_vocabulary v) const { return (v == vocabulary_) && ! is_empty (); }
    bool has_prop (const e_property p) const { return is_allocated () && microformat_ -> has_prop (p); }
    bool is_relational () const { return is_allocated () && microformat_ -> is_relational (); }
    void validate_element (const size_t e) const { if (is_allocated ()) microformat_ -> validate_element (e); }
    bool declared () const { return is_allocated () && microformat_ -> declared (); }
    void set_mf_value (const e_property pp, element& e) { if (is_allocated ()) microformat_ -> set_mf_value (pp, e); }
    ::std::string get_value (const e_property pp) { if (! is_allocated ()) return ::std::string (); return microformat_ -> get_value (pp); }
    ::std::string diagnose (const int n) const { if (! is_allocated ()) return ::std::string (); return microformat_ -> diagnose (n); }
    ::std::string report (const int n) const { if (! is_allocated ()) return ::std::string (); return microformat_ -> report (n); } };
