/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once
#include "microformat_constructor.h"

typedef ::std::vector < microformat_pv > microformat_vpv; // indexed by VOCAB
typedef microformat_vpv::const_iterator microformat_vpv_ci;
typedef microformat_vpv::iterator microformat_vpv_i;

class microformats
{   microformat_vpv mf_;
public:
    microformats () { mf_.resize (e_vocabulary_size); }
    void swap (microformats& m) noexcept
    {   mf_.swap (m.mf_); }
    bool allocated (const e_vocabulary v) const;
    void alloc (const e_vocabulary v);
    template < class VOCAB > VOCAB& get ();
    template < class VOCAB > const VOCAB& get () const;
    template < class VOCAB > bool has () const;
    bool has (const e_vocabulary v, const e_property p) const;
    bool has (const e_vocabulary v) const;
    void reset ();
    void declare (const vocab& v);
    bool has_property (const e_vocabulary v, const e_property p) const;
    e_vocabulary plausible_vocabulary (const e_property p) const;
    bool is_relational () const;
    void validate_element (const size_t e) const;
    bool is_declared (const e_vocabulary v) const;
    void set_mf_value (const e_vocabulary v, const e_property pp, element& e);
    ::std::string get_value (const e_vocabulary v, const e_property pp);
    bool empty () const;
    bool empty (const e_vocabulary v) const;
    ::std::string diagnose (const int n) const;
    ::std::string report (const int n) const; };


template < class VOCAB > VOCAB& microformats::get ()
{   assert (allocated (VOCAB::whoami ()));
    return * (reinterpret_cast < VOCAB* > (mf_ [VOCAB::whoami ()].get ())); }

template < class VOCAB > const VOCAB& microformats::get () const
{   assert (allocated (VOCAB::whoami ()));
    return * (reinterpret_cast < const VOCAB* > (mf_ [VOCAB::whoami ()].get ())); }

template < class VOCAB > bool microformats::has () const
{   if (! allocated (VOCAB::whoami ())) return true;
    return has (VOCAB::whoami ()); }
