/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "symbol_table.h"
#include "element.h"
#include "byteorder.h"
#include "microformat_export.h"
class directory;

class page
{   myhtml_tree_t* tree_;
    myhtml_t* html_;
    mutable sstr_t ids_;
    mutable element_ptr document_;
    ::std::string name_;
    microformat_export export_;
    void init ();
    void zap ();
    friend class tag;
public:
    page () : tree_ (nullptr), html_ (nullptr) { init (); }
    page (const ::std::string& name, const ::std::string& content, const myencoding_t encoding = MyENCODING_DEFAULT);
    ~page () { zap (); }
    void swap (page& p) noexcept
    {   ::std::swap (tree_, p.tree_);
        ::std::swap (html_, p.html_);
        ids_.swap (p.ids_);
        document_.swap (p.document_);
        name_.swap (p.name_);
        export_.swap (p.export_);  }
    bool parse (const ::std::string& content, const myencoding_t encoding = MyENCODING_DEFAULT);
    bool invalid () const { return (tree_ == nullptr) || (html_ == nullptr); }
    void examine (const directory& d, const int depth);
    ::std::string find_webmention (const int depth) const;
    ::std::string find_mention_info (const url& u, bool text, bool anything);
    const ::std::string name () const { return name_; }
    myhtml_tag_id_t check_bespoke_tag (myhtml_tag_id_t tag, const ::std::string& name, ::std::ostringstream& ss);
    void export_rel (const ::std::string& url, const ::std::string& hreflang, const ::std::string& media, const vstr_t& rels, const ::std::string& text, const ::std::string& title, const ::std::string& type)
    {   export_.rel (url, hreflang, media, rels, text, title, type); }
    void export_item (const ::std::string& wo, const ::std::string& was)
    {   export_.item (wo, was); }
    bool mf_write (::std::ostringstream& ss, const ::boost::filesystem::path& name)
    {   return export_.write (ss, name); }
    ::std::string report () const; };

::std::string get_page_url (const ::std::string& url);
