/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "prop.h"
#include "property_value.h"


template < class CATEGORY, e_type TYPE, CATEGORY IDENTITY > struct typed_mf_value : public typed_value < CATEGORY, TYPE, IDENTITY >
{   static ::std::string name () { return prop :: name (IDENTITY); }
    static e_type prop () { return TYPE; }
    void set_mf_value (const element& e)
    {   typed_value < CATEGORY, TYPE, IDENTITY > :: set_value (find_value < TYPE > (e)); }
    ::std::string diagnose () const
    {   return typed_value < CATEGORY, TYPE, IDENTITY > :: diagnose (name ()); }
    ::std::string report () const
    {   return typed_value < CATEGORY, TYPE, IDENTITY > :: report (name ()); } };
