/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "context.h"
#include "directory.h"
#include "attr.h"
#include "elem.h"
#include "family.h"
#include "field.h"
#include "property.h"
#include "type.h"
#include "vocab.h"
#include "url_sanitise.h"

//extern "C" {
//  #include <curl/curl.h>
//}

void init ()
{   // curl_global_init (CURL_GLOBAL_WIN32 | CURL_GLOBAL_SSL);
    attr::init ();
    code_map_init ();
    elem::init ();
    fields_init ();
    family_init ();
    types_init ();
    prop::init ();
    protocol::init ();
    vocab::init (); }

void ciao ()
{   /* curl_global_cleanup (); */ }

int examine (directory& d)
{   vstr_t virt (context.virtuals ());
    try
    {   if (! d.scan ())
        {   if (context.tell (e_error)) ::std::cerr << "scan of " << context.root () << " failed\n";
            return ERROR_STATE; }
        for (::std::string v : virt)
            if (! add_virtual (d, v))
            {   if (context.tell (e_error)) ::std::cout << "scan of " << v << " failed\n";
                return ERROR_STATE; } }
    catch (const ::std::system_error& e)
    { if (context.tell (e_severe)) ::std::cout << "scan, system error " << e.code () << ": " << e.what () << "\n"; return ERROR_STATE; }
    catch (...)
    { if (context.tell (e_severe)) ::std::cout << "scan, unknown exception\n"; return ERROR_STATE; }
    return VALID_RESULT; };

int check (directory& d)
{   if (d.empty ()) { if (context.tell (e_debug)) ::std::cout << "no content\n"; return NOTHING_TO_DO; }
    if (context.tell (e_comment)) ::std::cout << "Checking links..\n";
    try
    {   d.examine (); }
    catch (const ::std::system_error& e)
    { if (context.tell (e_severe)) ::std::cerr << "verify, system error " << e.code () << ": " << e.what () << "\n"; return ERROR_STATE; }
    catch (...)
    { if (context.tell (e_severe)) ::std::cerr << "verify, unknown exception\n"; return ERROR_STATE; }
    return VALID_RESULT; };

int main (int argc, char** argv)
{   init ();
    int res = context.parameters (argc, argv);
    if (res == VALID_RESULT)
    {   if (context.tell (e_info)) ::std::cout << "Collecting information..\n";
        directory d (context.root ());
        res = examine (d);
        if (res == VALID_RESULT) res = check (d);
        if ((res == VALID_RESULT) && context.process_webmentions ())
        {   ::std::ostringstream ss;
            context.process_outgoing_webmention (ss, 0);
            context.process_incoming_webmention (ss);
            ::std::cout << ss.str (); }
        ciao (); }
    return res; };
