/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "type_master.h"

template < e_type TYPE > class one_value : public type_base < TYPE >
{   static const char* exists_;
public:
    static void init (const char* sz1)
    {   exists_ = sz1; }
    ::std::string get_value () const
    {   if (! type_base < TYPE > :: unknown ()) return exists_; return ::std::string (); }
    void set_value (const ::std::string& s);
    ::std::string diagnose () const; };

#define DECLARE_ONE_TYPE(TT) \
template < > struct type_master < TT > : public one_value < TT > { }; \
template < > const char* one_value < TT > :: exists_;

DECLARE_ONE_TYPE (t_1)
DECLARE_ONE_TYPE (t_boolean)
DECLARE_ONE_TYPE (t_charset)

template < e_type TYPE > void one_value < TYPE > :: set_value (const ::std::string& s)
{   ::std::string t = (::boost::algorithm::to_lower_copy (trim_the_lot_off (s)));
    type_base < TYPE > :: status (t == exists_); }

template < e_type TYPE > ::std::string one_value < TYPE > :: diagnose () const
{   if (! type_base < TYPE > :: invalid ()) return ::std::string ();
    if (! context.tell (e_error)) return ::std::string ();
    ::std::string s ("must be ");
    s += exists_;
    s += ", or unspecified";
    return s; }

