/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence,  or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#pragma once

#include "common.h"

class context;
class directory;

typedef enum
{   t_unknown, t_1, t_accept, t_action, t_aria, t_as, t_autocapitalise, t_boolean, t_capture, t_charset, t_coords, t_cors, t_css, t_currency,
    t_data, t_date, t_decoding, t_dir, t_dosh, t_duration, t_enctype, t_existential, t_filename, t_generic, t_html, t_httpequiv, t_id, t_identifier_url, t_illegal, t_inputtype,
    t_integer, t_is, t_javascript, t_key, t_kind, t_lang, t_marked_up, t_metaname, t_method, t_mime, t_mql, t_rating, t_real,
    t_referrer, t_regex, t_rel, t_rel_a, t_rel_avoid, t_rel_illegal, t_rel_link, t_rel_obsolete, t_rsvp, t_sandbox, t_schema,
    t_scope, t_sex, t_shape, t_sizes, t_srcset, t_step, t_target, t_text, t_tokens, t_truefalse, t_ugeo, t_unsigned, t_url,
    t_urls, t_useid, t_wrap, t_yesno }
e_type;

typedef enum { s_unset, s_invalid, s_empty, s_good } e_status;

template < e_type E > class type_base
{   ::std::string id_;
    mutable e_status status_ = s_unset;
public:
    static e_type get_type () { return E; }
    static bool is_relational () { return false; }
    static bool is_url () { return false; }
    static bool is_existential () { return false; }
    void swap (type_base& t) noexcept { id_.swap (t.id_); ::std::swap (status_, t.status_); }
    void reset () { status_ = s_unset; id_.clear (); }
    void validate_element (const size_t ) const { }
    bool verify_url (const directory& ) { return true; }
    ::std::string get_value () const { return ::std::string (); }
    ::std::string original () const { return get_value (); }
    void set_value (const ::std::string& ) { status_ = s_empty; }
    ::std::string get_id () const { return id_; }
    void set_id (const ::std::string& s) { id_ = s; }
    bool invalid_id (sstr_t* ) { return false; }
    bool has_id () const { return ! id_.empty (); }
    bool empty () const { return status_ == s_empty; }
    bool good () const { return status_ == s_good; }
    bool bad () const { return ! good (); }
    bool invalid () const { return status_ == s_invalid; }
    void verify_id (sstr_t* ) const { }
    e_status status () const { return status_; }
    void status (const e_status s) const { status_ = s; }
    void status (const bool b) const { if (b) status_ = s_good; else status_ = s_invalid; }
    bool unknown () const { return status_ == s_unset; }
    ::std::string diagnose () const { return ::std::string (); }
    ::std::string report () const
    {   ::std::string s;
        if (status_ == s_invalid) s = "x";
        if (has_id ())
        {   s += "(";
            s += id_;
            s += ")"; } return s; } };
