/*
ssc (static site checker)
Copyright (c) 2020 Dylan Harris
https://dylanharris.org/

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public Licence as published by
the Free Software Foundation, either version 3 of the Licence, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public Licence for more details.

You should have received a copy of the GNU General Public
Licence along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include "type.h"

#define MN_APPLICATION "application"
#define MN_AUTHOR "author"
#define MN_DESCRIPTION "description"
#define MN_GENERATOR "generator"
#define MN_KEYWORDS "keywords"

#define MN_CLASSIFICATION "classification"

#define MN_AGLSTERMS_ACCESSMODE "AGLSTERMS.accessMode"
#define MN_AGLSTERMS_ACCESSIBILITY "AGLSTERMS.accessibility"
#define MN_AGLSTERMS_ACT "AGLSTERMS.act"
#define MN_AGLSTERMS_AGGREGATIONLEVEL "AGLSTERMS.aggregationLevel"
#define MN_AGLSTERMS_ALLOW_SEARCH "AGLSTERMS.allow-search"
#define MN_AGLSTERMS_AVAILABILITY "AGLSTERMS.availability"
#define MN_AGLSTERMS_CASE "AGLSTERMS.case"
#define MN_AGLSTERMS_CATEGORY "AGLSTERMS.category"
#define MN_AGLSTERMS_DATELICENSED "AGLSTERMS.dateLicensed"
#define MN_AGLSTERMS_DOCUMENTTYPE "AGLSTERMS.documentType"
#define MN_AGLSTERMS_FUNCTION "AGLSTERMS.function"
#define MN_AGLSTERMS_ISBASEDON "AGLSTERMS.isBasedOn"
#define MN_AGLSTERMS_ISBASISFOR "AGLSTERMS.isBasisFor"
#define MN_AGLSTERMS_JURISDICTION "AGLSTERMS.jurisdiction"
#define MN_AGLSTERMS_MANDATE "AGLSTERMS.mandate"
#define MN_AGLSTERMS_PROTECTIVEMARKING "AGLSTERMS.protectiveMarking"
#define MN_AGLSTERMS_REGULATION "AGLSTERMS.regulation"
#define MN_AGLSTERMS_SERVICETYPE "AGLSTERMS.serviceType"
#define MN_DCS_DCSSTA "DCS.dcssta"
#define MN_ESSAYDIRECTORY "EssayDirectory"
#define MN_FLBLOGAUTHOR "FLBlogAuthor"
#define MN_FSDATECREATION "FSDateCreation"
#define MN_FSDATEPUBLISH "FSDatePublish"
#define MN_FSFLCONTENT "FSFLContent"
#define MN_FSLANGUAGE "FSLanguage"
#define MN_FSONSITEMAP "FSOnSitemap"
#define MN_FSPAGEDESCRIPTION "FSPageDescription"
#define MN_FSPAGENAME "FSPageName"
#define MN_FSSEARCHABLE "FSSearchable"
#define MN_FSSECTION "FSSection"
#define MN_FSWRITERTOOLPAGETYPE "FSWritertoolPageType"
#define MN_IE_RM_OFF "IE_RM_OFF"
#define MN_MSSMARTTAGSPREVENTPARSING "MSSmartTagsPreventParsing"
#define MN_REPOSTUSAPIKEY "RepostUsAPIKey"
#define MN_RESOURCELOADERDYNAMICSTYLES "ResourceLoaderDynamicStyles"
#define MN_WT_SI_N "WT.si_n"
#define MN_WT_SI_P "WT.si_p"
#define MN_WT_SI_X "WT.si_x"
#define MN_ZOOMCATEGORY "ZOOMCATEGORY"
#define MN_ZOOMDESCRIPTION "ZOOMDESCRIPTION"
#define MN_ZOOMIMAGE "ZOOMIMAGE"
#define MN_ZOOMPAGEBOOST "ZOOMPAGEBOOST"
#define MN_ZOOMTITLE "ZOOMTITLE"
#define MN_ZOOMWORDS "ZOOMWORDS"
#define MN_ALEXAVERIFYID "alexaverifyid"
#define MN_APPLE_ITUNES_APP "apple-itunes-app"
#define MN_APPLE_MOBILE_WEB_APP_CAPABLE "apple-mobile-web-app-capable"
#define MN_APPLE_MOBILE_WEB_APP_STATUS_BAR_STYLE "apple-mobile-web-app-status-bar-style"
#define MN_APPLE_MOBILE_WEB_APP_TITLE "apple-mobile-web-app-title"
#define MN_APPLE_TOUCH_FULLSCREEN "apple-touch-fullscreen"
#define MN_APPLICATION_NAME "application-name"
#define MN_APPLICATION_URL "application-url"
#define MN_APPSTORE_BUNDLE_ID "appstore:bundle_id"
#define MN_APPSTORE_DEVELOPER_URL "appstore:developer_url"
#define MN_APPSTORE_STORE_ID "appstore:store_id"
#define MN_AUDIENCE "audience"
#define MN_BITCOIN "bitcoin"
#define MN_BLAZERR_SECURE "blazerr-secure"
#define MN_BLAZERR_SEO "blazerr-seo"
#define MN_BLAZERR_SSL "blazerr-ssl"
#define MN_BLAZERR_SUPPORT_ID_NONCOOKIES "blazerr-support-id-noncookies"
#define MN_BLAZERR_SUPPORT_IDENTIFIER "blazerr-support-identifier"
#define MN_BLOGCATALOG "blogcatalog"
#define MN_BUG_BLOCKED "bug.blocked"
#define MN_BUG_COMMENT "bug.comment"
#define MN_BUG_COMPONENT "bug.component"
#define MN_BUG_PRODUCT "bug.product"
#define MN_BUG_SHORT_DESC "bug.short_desc"
#define MN_CACHE "cache"
#define MN_CFIA_GDR_ACTIVITY "cfia.gdr.activity"
#define MN_CFIA_GDR_COMMODITY "cfia.gdr.commodity"
#define MN_CFIA_GDR_INCLUDE "cfia.gdr.include"
#define MN_CFIA_GDR_PROGRAM "cfia.gdr.program"
#define MN_CITATION_AUTHOR "citation_author"
#define MN_CITATION_AUTHOR_EMAIL "citation_author_email"
#define MN_CITATION_AUTHOR_INSTITUTION "citation_author_institution"
#define MN_CITATION_CONFERENCE_TITLE "citation_conference_title"
#define MN_CITATION_DATE "citation_date"
#define MN_CITATION_DISSERTATION_INSTITUTION "citation_dissertation_institution"
#define MN_CITATION_DOI "citation_doi"
#define MN_CITATION_FIRSTPAGE "citation_firstpage"
#define MN_CITATION_FULLTEXT_HTML_URL "citation_fulltext_html_url"
#define MN_CITATION_ISBN "citation_isbn"
#define MN_CITATION_ISSN "citation_issn"
#define MN_CITATION_ISSUE "citation_issue"
#define MN_CITATION_JOURNAL_ABBREV "citation_journal_abbrev"
#define MN_CITATION_JOURNAL_TITLE "citation_journal_title"
#define MN_CITATION_KEYWORDS "citation_keywords"
#define MN_CITATION_LANGUAGE "citation_language"
#define MN_CITATION_LASTPAGE "citation_lastpage"
#define MN_CITATION_PDF_URL "citation_pdf_url"
#define MN_CITATION_PUBLICATION_DATE "citation_publication_date"
#define MN_CITATION_PUBLISHER "citation_publisher"
#define MN_CITATION_TECHNICAL_REPORT_INSTITUTION "citation_technical_report_institution"
#define MN_CITATION_TECHNICAL_REPORT_NUMBER "citation_technical_report_number"
#define MN_CITATION_TITLE "citation_title"
#define MN_CITATION_VOLUME "citation_volume"
#define MN_COLLECTION "collection"
#define MN_CONTACT "contact"
#define MN_CREATED "created"
#define MN_CREATOR "creator"
#define MN_CSRF_PARAM "csrf-param"
#define MN_CSRF_TOKEN "csrf-token"
#define MN_DA_ANONYMISEIP "da_anonymiseIP"
#define MN_DA_CONTACTCOMPANY "da_contactCompany"
#define MN_DA_CONTACTEMAIL "da_contactEmail"
#define MN_DA_CONTACTFIRSTNAME "da_contactFirstName"
#define MN_DA_CONTACTLASTNAME "da_contactLastName"
#define MN_DA_CONTACTNAME "da_contactName"
#define MN_DA_CONTACTTELEPHONE "da_contactTelephone"
#define MN_DA_CONVERSIONCURRENCY "da_conversionCurrency"
#define MN_DA_CONVERSIONID "da_conversionId"
#define MN_DA_CONVERSIONVALUE "da_conversionValue"
#define MN_DA_GOALCURRENCY "da_goalCurrency"
#define MN_DA_GOALID "da_goalId"
#define MN_DA_GOALVALUE "da_goalValue"
#define MN_DA_INTERACTIONSELECTOR "da_interactionSelector"
#define MN_DA_PAGEROLE "da_pageRole"
#define MN_DA_PAGETAXONOMY "da_pageTaxonomy"
#define MN_DA_PAGETITLE "da_pageTitle"
#define MN_DA_PAGEVERSION "da_pageVersion"
#define MN_DA_SESSIONID "da_sessionId"
#define MN_DA_USERID "da_userId"
#define MN_DC_CREATED "dc.created"
#define MN_DC_CREATOR "dc.creator"
#define MN_DC_DATE_ISSUED "dc.date.issued"
#define MN_DC_DATECOPYRIGHTED "dc.dateCopyrighted"
#define MN_DC_DATESUBMITTED "dc.dateSubmitted"
#define MN_DC_DESCRIPTION "dc.description"
#define MN_DC_LANGUAGE "dc.language"
#define MN_DC_LICENSE "dc.license"
#define MN_DC_MEDIATOR "dc.mediator"
#define MN_DC_MEDIUM "dc.medium"
#define MN_DC_MODIFIED "dc.modified"
#define MN_DC_PROVENANCE "dc.provenance"
#define MN_DC_PUBLISHER "dc.publisher"
#define MN_DC_REFERENCES "dc.references"
#define MN_DC_TEMPORAL "dc.temporal"
#define MN_DC_TITLE "dc.title"
#define MN_DC_TYPE "dc.type"
#define MN_DC_VALID "dc.valid"
#define MN_DCTERMS_ABSTRACT "dcterms.abstract"
#define MN_DCTERMS_ACCESSRIGHTS "dcterms.accessRights"
#define MN_DCTERMS_ACCRUALMETHOD "dcterms.accrualMethod"
#define MN_DCTERMS_ACCRUALPERIODICITY "dcterms.accrualPeriodicity"
#define MN_DCTERMS_ACCRUALPOLICY "dcterms.accrualPolicy"
#define MN_DCTERMS_ALTERNATIVE "dcterms.alternative"
#define MN_DCTERMS_AUDIENCE "dcterms.audience"
#define MN_DCTERMS_AVAILABLE "dcterms.available"
#define MN_DCTERMS_BIBLIOGRAPHICCITATION "dcterms.bibliographicCitation"
#define MN_DCTERMS_COLLECTION "dcterms.collection"
#define MN_DCTERMS_CONFORMSTO "dcterms.conformsTo"
#define MN_DCTERMS_CONTRIBUTOR "dcterms.contributor"
#define MN_DCTERMS_COVERAGE "dcterms.coverage"
#define MN_DCTERMS_CREATED "dcterms.created"
#define MN_DCTERMS_CREATOR "dcterms.creator"
#define MN_DCTERMS_DATE "dcterms.date"
#define MN_DCTERMS_DATEACCEPTED "dcterms.dateAccepted"
#define MN_DCTERMS_DATECOPYRIGHTED "dcterms.dateCopyrighted"
#define MN_DCTERMS_DATESUBMITTED "dcterms.dateSubmitted"
#define MN_DCTERMS_DESCRIPTION "dcterms.description"
#define MN_DCTERMS_EDUCATIONLEVEL "dcterms.educationLevel"
#define MN_DCTERMS_EXTENT "dcterms.extent"
#define MN_DCTERMS_FORMAT "dcterms.format"
#define MN_DCTERMS_HASFORMAT "dcterms.hasFormat"
#define MN_DCTERMS_HASPART "dcterms.hasPart"
#define MN_DCTERMS_HASVERSION "dcterms.hasVersion"
#define MN_DCTERMS_IDENTIFIER "dcterms.identifier"
#define MN_DCTERMS_INSTRUCTIONALMETHOD "dcterms.instructionalMethod"
#define MN_DCTERMS_ISFORMATOF "dcterms.isFormatOf"
#define MN_DCTERMS_ISPARTOF "dcterms.isPartOf"
#define MN_DCTERMS_ISREFERENCEDBY "dcterms.isReferencedBy"
#define MN_DCTERMS_ISREPLACEDBY "dcterms.isReplacedBy"
#define MN_DCTERMS_ISREQUIREDBY "dcterms.isRequiredBy"
#define MN_DCTERMS_ISVERSIONOF "dcterms.isVersionOf"
#define MN_DCTERMS_ISSUED "dcterms.issued"
#define MN_DCTERMS_LANGUAGE "dcterms.language"
#define MN_DCTERMS_LICENSE "dcterms.license"
#define MN_DCTERMS_MEDIATOR "dcterms.mediator"
#define MN_DCTERMS_MEDIUM "dcterms.medium"
#define MN_DCTERMS_MODIFIED "dcterms.modified"
#define MN_DCTERMS_PROVENANCE "dcterms.provenance"
#define MN_DCTERMS_PUBLISHER "dcterms.publisher"
#define MN_DCTERMS_REFERENCES "dcterms.references"
#define MN_DCTERMS_RELATION "dcterms.relation"
#define MN_DCTERMS_REPLACES "dcterms.replaces"
#define MN_DCTERMS_REQUIRES "dcterms.requires"
#define MN_DCTERMS_RIGHTS "dcterms.rights"
#define MN_DCTERMS_RIGHTSHOLDER "dcterms.rightsHolder"
#define MN_DCTERMS_SOURCE "dcterms.source"
#define MN_DCTERMS_SPATIAL "dcterms.spatial"
#define MN_DCTERMS_SUBJECT "dcterms.subject"
#define MN_DCTERMS_TABLEOFCONTENTS "dcterms.tableOfContents"
#define MN_DCTERMS_TEMPORAL "dcterms.temporal"
#define MN_DCTERMS_TITLE "dcterms.title"
#define MN_DCTERMS_TYPE "dcterms.type"
#define MN_DCTERMS_VALID "dcterms.valid"
#define MN_DESIGNER "designer"
#define MN_DETECTIFY_VERIFICATION "detectify-verification"
#define MN_DIR_CONTENT_POINTER "dir-content-pointer"
#define MN_ENTITY "entity"
#define MN_EXPIRES "expires"
#define MN_FB_ADMINS "fb:admins"
#define MN_FB_PAGE_ID "fb:page_id"
#define MN_FDSE_DESCRIPTION "fdse-description"
#define MN_FDSE_INDEX_AS "fdse-index-as"
#define MN_FDSE_KEYWORDS "fdse-keywords"
#define MN_FDSE_REFRESH "fdse-refresh"
#define MN_FDSE_ROBOTS "fdse-robots"
#define MN_FORMAT_DETECTION "format-detection"
#define MN_FORMAT_PRINT "format-print"
#define MN_FRAGMENT "fragment"
#define MN_GCTERMS_TOPICTAXONOMY "gcterms.topicTaxonomy"
#define MN_GEO_A1 "geo.a1"
#define MN_GEO_A2 "geo.a2"
#define MN_GEO_A3 "geo.a3"
#define MN_GEO_COUNTRY "geo.country"
#define MN_GEO_LMK "geo.lmk"
#define MN_GEO_PLACENAME "geo.placename"
#define MN_GEO_POSITION "geo.position"
#define MN_GEO_REGION "geo.region"
#define MN_GLOBRIX_BATHROOMS "globrix.bathrooms"
#define MN_GLOBRIX_BEDROOMS "globrix.bedrooms"
#define MN_GLOBRIX_CONDITION "globrix.condition"
#define MN_GLOBRIX_FEATURES "globrix.features"
#define MN_GLOBRIX_INSTRUCTION "globrix.instruction"
#define MN_GLOBRIX_LATITUDE "globrix.latitude"
#define MN_GLOBRIX_LONGITUDE "globrix.longitude"
#define MN_GLOBRIX_OUTSIDESPACE "globrix.outsidespace"
#define MN_GLOBRIX_PARKING "globrix.parking"
#define MN_GLOBRIX_PERIOD "globrix.period"
#define MN_GLOBRIX_POA "globrix.poa"
#define MN_GLOBRIX_POSTCODE "globrix.postcode"
#define MN_GLOBRIX_PRICE "globrix.price"
#define MN_GLOBRIX_PRICEPROXIMITY "globrix.priceproximity"
#define MN_GLOBRIX_TENURE "globrix.tenure"
#define MN_GLOBRIX_TYPE "globrix.type"
#define MN_GLOBRIX_UNDEROFFER "globrix.underoffer"
#define MN_GM_GPX_V "gm-gpx-v"
#define MN_GO_IMPORT "go-import"
#define MN_GOOGLE "google"
#define MN_GOOGLE_PLAY_APP "google-play-app"
#define MN_GOOGLE_SITE_VERIFICATION "google-site-verification"
#define MN_GOOGLE_TRANSLATE_CUSTOMIZATION "google-translate-customization"
#define MN_GWT_PROPERTY "gwt:property"
#define MN_HANDHELDFRIENDLY "handheldfriendly"
#define MN_ICAS_DATETIME "icas.datetime"
#define MN_ICAS_DATETIME_ABBR "icas.datetime.abbr"
#define MN_ICAS_DATETIME_DAY "icas.datetime.day"
#define MN_ICAS_DATETIME_LONG "icas.datetime.long"
#define MN_ICBM "icbm"
#define MN_ITEMSPERPAGE "itemsPerPage"
#define MN_KEYWORDS_NOT "keywords-not"
#define MN_META_DATE "meta_date"
#define MN_MICROTIP "microtip"
#define MN_MOBILE_AGENT "mobile-agent"
#define MN_MOBILE_WEB_APP_CAPABLE "mobile-web-app-capable"
#define MN_MOBILEOPTIMIZED "mobileoptimized"
#define MN_MSAPPLICATION_TILECOLOR "msapplication-TileColor"
#define MN_MSAPPLICATION_TILEIMAGE "msapplication-TileImage"
#define MN_MSAPPLICATION_CONFIG "msapplication-config"
#define MN_MSAPPLICATION_NAVBUTTON_COLOR "msapplication-navbutton-color"
#define MN_MSAPPLICATION_NOTIFICATION "msapplication-notification"
#define MN_MSAPPLICATION_SQUARE150X150LOGO "msapplication-square150x150logo"
#define MN_MSAPPLICATION_SQUARE310X310LOGO "msapplication-square310x310logo"
#define MN_MSAPPLICATION_SQUARE70X70LOGO "msapplication-square70x70logo"
#define MN_MSAPPLICATION_STARTURL "msapplication-starturl"
#define MN_MSAPPLICATION_TAP_HIGHLIGHT "msapplication-tap-highlight"
#define MN_MSAPPLICATION_TASK "msapplication-task"
#define MN_MSAPPLICATION_TOOLTIP "msapplication-tooltip"
#define MN_MSAPPLICATION_WIDE310X150LOGO "msapplication-wide310x150logo"
#define MN_MSAPPLICATION_WINDOW "msapplication-window"
#define MN_MSVALIDATE_01 "msvalidate.01"
#define MN_NEXTGEN "nextgen"
#define MN_NIBBLER_SITE_VERIFICATION "nibbler-site-verification"
#define MN_NO_EMAIL_COLLECTION "no-email-collection"
#define MN_NONFICTION "nonfiction"
#define MN_NORTON_SAFEWEB_SITE_VERIFICATION "norton-safeweb-site-verification"
#define MN_OG_DESCRIPTION "og:description"
#define MN_OG_IMAGE "og:image"
#define MN_OG_LOCALE "og:locale"
#define MN_OG_SITE_NAME "og:site_name"
#define MN_OG_TITLE "og:title"
#define MN_OG_TYPE "og:type"
#define MN_OG_URL "og:url"
#define MN_ORIGIN "origin"
#define MN_ORIGIN_TRIALS "origin-trials"
#define MN_P_DOMAIN_VERIFY "p:domain_verify"
#define MN_PAGE_VERSION "page-version"
#define MN_PINGDOM "pingdom"
#define MN_PINTEREST "pinterest"
#define MN_PRISM_ALTERNATETITLE "prism:alternateTitle"
#define MN_PRO "pro"
#define MN_PRO_AUTH "pro-auth"
#define MN_PRO_AUTH_FIELD "pro-auth-field"
#define MN_PRO_AUTH_FRAGMENT "pro-auth-fragment"
#define MN_RATING "rating"
#define MN_REFERRER "referrer"
#define MN_RESOLUTIONS "resolutions"
#define MN_REVIEW_DATE "review_date"
#define MN_REVISION "revision"
#define MN_REVISIT_AFTER "revisit-after"
#define MN_RIGHTS "rights"
#define MN_RIGHTS_STANDARD "rights-standard"
#define MN_ROBOTS "robots"
#define MN_RPUPLUGIN "rpuPlugin"
#define MN_RQID "rqid"
#define MN_SHAREAHOLIC_ANALYTICS "shareaholic:analytics"
#define MN_SHAREAHOLIC_ARTICLE_AUTHOR "shareaholic:article_author"
#define MN_SHAREAHOLIC_ARTICLE_AUTHOR_NAME "shareaholic:article_author_name"
#define MN_SHAREAHOLIC_ARTICLE_MODIFIED_TIME "shareaholic:article_modified_time"
#define MN_SHAREAHOLIC_ARTICLE_PUBLISHED_TIME "shareaholic:article_published_time"
#define MN_SHAREAHOLIC_ARTICLE_VISIBILITY "shareaholic:article_visibility"
#define MN_SHAREAHOLIC_DRUPAL_VERSION "shareaholic:drupal_version"
#define MN_SHAREAHOLIC_IMAGE "shareaholic:image"
#define MN_SHAREAHOLIC_KEYWORDS "shareaholic:keywords"
#define MN_SHAREAHOLIC_LANGUAGE "shareaholic:language"
#define MN_SHAREAHOLIC_OUTSTREAMADS "shareaholic:outstreamads"
#define MN_SHAREAHOLIC_SHAREABLE_PAGE "shareaholic:shareable_page"
#define MN_SHAREAHOLIC_SITE_ID "shareaholic:site_id"
#define MN_SHAREAHOLIC_SITE_NAME "shareaholic:site_name"
#define MN_SHAREAHOLIC_URL "shareaholic:url"
#define MN_SHAREAHOLIC_WP_VERSION "shareaholic:wp_version"
#define MN_SIGNET_AUTHORS "signet:authors"
#define MN_SIGNET_LINKS "signet:links"
#define MN_SKYPE_TOOLBAR "skype_toolbar"
#define MN_STARTINDEX "startIndex"
#define MN_STARTVER "startver"
#define MN_SUBJECT_DATETIME "subject-datetime"
#define MN_SUBJECT_SYSTEM "subject-system"
#define MN_THEME_COLOR "theme-color"
#define MN_THUMBNAIL "thumbnail"
#define MN_TOPPER "topper"
#define MN_TOPPER_MAJOR "topper-major"
#define MN_TOPPER_MINOR "topper-minor"
#define MN_TOTALRESULTS "totalResults"
#define MN_TRANSLATOR "translator"
#define MN_TWITTER_APP_COUNTRY "twitter:app:country"
#define MN_TWITTER_APP_ID_GOOGLEPLAY "twitter:app:id:googleplay"
#define MN_TWITTER_APP_ID_IPAD "twitter:app:id:ipad"
#define MN_TWITTER_APP_ID_IPHONE "twitter:app:id:iphone"
#define MN_TWITTER_APP_NAME_GOOGLEPLAY "twitter:app:name:googleplay"
#define MN_TWITTER_APP_NAME_IPAD "twitter:app:name:ipad"
#define MN_TWITTER_APP_NAME_IPHONE "twitter:app:name:iphone"
#define MN_TWITTER_APP_URL_GOOGLEPLAY "twitter:app:url:googleplay"
#define MN_TWITTER_APP_URL_IPAD "twitter:app:url:ipad"
#define MN_TWITTER_APP_URL_IPHONE "twitter:app:url:iphone"
#define MN_TWITTER_CARD "twitter:card"
#define MN_TWITTER_CREATOR "twitter:creator"
#define MN_TWITTER_CREATOR_ID "twitter:creator:id"
#define MN_TWITTER_DATA1 "twitter:data1"
#define MN_TWITTER_DATA2 "twitter:data2"
#define MN_TWITTER_DESCRIPTION "twitter:description"
#define MN_TWITTER_DOMAIN "twitter:domain"
#define MN_TWITTER_IMAGE "twitter:image"
#define MN_TWITTER_IMAGE0 "twitter:image0"
#define MN_TWITTER_IMAGE1 "twitter:image1"
#define MN_TWITTER_IMAGE2 "twitter:image2"
#define MN_TWITTER_IMAGE3 "twitter:image3"
#define MN_TWITTER_IMAGE_HEIGHT "twitter:image:height"
#define MN_TWITTER_IMAGE_SRC "twitter:image:src"
#define MN_TWITTER_IMAGE_WIDTH "twitter:image:width"
#define MN_TWITTER_LABEL1 "twitter:label1"
#define MN_TWITTER_LABEL2 "twitter:label2"
#define MN_TWITTER_PLAYER "twitter:player"
#define MN_TWITTER_PLAYER_HEIGHT "twitter:player:height"
#define MN_TWITTER_PLAYER_STREAM "twitter:player:stream"
#define MN_TWITTER_PLAYER_STREAM_CONTENT_TYPE "twitter:player:stream:content_type"
#define MN_TWITTER_PLAYER_WIDTH "twitter:player:width"
#define MN_TWITTER_SITE "twitter:site"
#define MN_TWITTER_SITE_ID "twitter:site:id"
#define MN_TWITTER_TITLE "twitter:title"
#define MN_TWITTER_URL "twitter:url"
#define MN_TYPEMETAL_FORMATPREFS "typemetal.formatprefs"
#define MN_VERIFY_V1 "verify-v1"
#define MN_VERSION "version"
#define MN_VFB_VERSION "vfb-version"
#define MN_VIEWPORT "viewport"
#define MN_WEB_AUTHOR "web_author"
#define MN_WITGET "witget"
#define MN_WOT_VERIFICATION "wot-verification"
#define MN_WT_AC "wt.ac"
#define MN_WT_AD "wt.ad"
#define MN_WT_CG_N "wt.cg_n"
#define MN_WT_CG_S "wt.cg_s"
#define MN_WT_MC_ID "wt.mc_id"
#define MN_WT_SV "wt.sv"
#define MN_WT_TI "wt.ti"
#define MN_Y_KEY "y_key"
#define MN_YANDEX_VERIFICATION "yandex-verification"

#define MN_IDENTIFIER_URL "identifier-URL"
#define MN_DISTRIBUTION "distribution"
#define MN_NOTE "note"
#define MN_SUBJECT "subject"
#define MN_COPYRIGHT "copyright"
#define MN_LANGUAGE "language"
#define MN_GENERATOR "generator"
#define MN_ID "id"
#define MN_PRESDATE "presdate"
#define MN_TEMPLATE "template"
#define MN_OPERATOR "operator"
#define MN_CREATION "creation"
#define MN_HOST "host"
#define MN_HOST_ADMIN "host-admin"
#define MN_CONTACTNAME "contactName"
#define MN_CONTACTORGANIZATION "contactOrganization"
#define MN_CONTACTSTREETADDRESS1 "contactStreetAddress1"
#define MN_CONTACTZIPCODE "contactZipcode"
#define MN_CONTACTCITY "contactCity"
#define MN_CONTACTCOUNTRY "contactCountry"
#define MN_CONTACTPHONENUMBER "contactPhoneNumber"
#define MN_CONTACTFAXNUMBER "contactFaxNumber"
#define MN_CONTACTNETWORKADDRESS "contactNetworkAddress"
#define MN_LINKAGE "linkage"

#define MN_ABSTRACT "abstract"
#define MN_COVERAGE "coverage"
#define MN_OG_EMAIL "og:email"
#define MN_OG_PHONE_NUMBER "og:phone_number"
#define MN_OG_FAX_NUMBER "og:fax_number"
#define MN_OG_LATITUDE "og:latitude"
#define MN_OG_LONGITUDE "og:longitude"
#define MN_OG_STREET_ADDRESS "og:street-address"
#define MN_OG_LOCALITY "og:locality"
#define MN_OG_REGION "og:region"
#define MN_OG_POSTAL_CODE "og:postal-code"
#define MN_OG_COUNTRY_NAME "og:country-name"
#define MN_MICROID "microid"
#define MN_OWNER "owner"
#define MN_REVISED "revised"
#define MN_TOPIC "topic"
#define MN_SUMMARY "summary"
#define MN_TWEETMEME_TITLE "tweetmeme-title"


struct symbol_entry < e_action > action_symbol_table [] =
{   {  "sell", av_sell },
    {  "rent", av_rent },
    {  "trade", av_trade },
    {  "meet", av_meet },
    {  "announce", av_announce },
    {  "offer", av_offer },
    {  "wanted", av_wanted },
    {  "event", av_event },
    {  "service", av_service } };

void action::init ()
{   symbol::init (action_symbol_table, sizeof (action_symbol_table) / sizeof (symbol_entry < e_action >)); };

struct symbol_entry < e_currency > currency_symbol_table [] =
{   { "AED", e_iso_AED },
    { "AFN", e_iso_AFN },
    { "ALL", e_iso_ALL },
    { "AMD", e_iso_AMD },
    { "ANG", e_iso_ANG },
    { "AOA", e_iso_AOA },
    { "ARS", e_iso_ARS },
    { "AUD", e_iso_AUD },
    { "AWG", e_iso_AWG },
    { "AZN", e_iso_AZN },
    { "BAM", e_iso_BAM },
    { "BBD", e_iso_BBD },
    { "BDT", e_iso_BDT },
    { "BGN", e_iso_BGN },
    { "BHD", e_iso_BHD },
    { "BIF", e_iso_BIF },
    { "BMD", e_iso_BMD },
    { "BND", e_iso_BND },
    { "BOB", e_iso_BOB },
    { "BOV", e_iso_BOV },
    { "BRL", e_iso_BRL },
    { "BSD", e_iso_BSD },
    { "BTN", e_iso_BTN },
    { "BWP", e_iso_BWP },
    { "BYN", e_iso_BYN },
    { "BZD", e_iso_BZD },
    { "CAD", e_iso_CAD },
    { "CDF", e_iso_CDF },
    { "CHE", e_iso_CHE },
    { "CHF", e_iso_CHF },
    { "CHW", e_iso_CHW },
    { "CLF", e_iso_CLF },
    { "CLP", e_iso_CLP },
    { "CNY", e_iso_CNY },
    { "COP", e_iso_COP },
    { "COU", e_iso_COU },
    { "CRC", e_iso_CRC },
    { "CUC", e_iso_CUC },
    { "CUP", e_iso_CUP },
    { "CVE", e_iso_CVE },
    { "CZK", e_iso_CZK },
    { "DJF", e_iso_DJF },
    { "DKK", e_iso_DKK },
    { "DOP", e_iso_DOP },
    { "DZD", e_iso_DZD },
    { "EGP", e_iso_EGP },
    { "ERN", e_iso_ERN },
    { "ETB", e_iso_ETB },
    { "EUR", e_iso_EUR },
    { "FJD", e_iso_FJD },
    { "FKP", e_iso_FKP },
    { "GBP", e_iso_GBP },
    { "GEL", e_iso_GEL },
    { "GHS", e_iso_GHS },
    { "GIP", e_iso_GIP },
    { "GMD", e_iso_GMD },
    { "GNF", e_iso_GNF },
    { "GTQ", e_iso_GTQ },
    { "GYD", e_iso_GYD },
    { "HKD", e_iso_HKD },
    { "HNL", e_iso_HNL },
    { "HRK", e_iso_HRK },
    { "HTG", e_iso_HTG },
    { "HUF", e_iso_HUF },
    { "IDR", e_iso_IDR },
    { "ILS", e_iso_ILS },
    { "INR", e_iso_INR },
    { "IQD", e_iso_IQD },
    { "IRR", e_iso_IRR },
    { "ISK", e_iso_ISK },
    { "JMD", e_iso_JMD },
    { "JOD", e_iso_JOD },
    { "JPY", e_iso_JPY },
    { "KES", e_iso_KES },
    { "KGS", e_iso_KGS },
    { "KHR", e_iso_KHR },
    { "KMF", e_iso_KMF },
    { "KPW", e_iso_KPW },
    { "KRW", e_iso_KRW },
    { "KWD", e_iso_KWD },
    { "KYD", e_iso_KYD },
    { "KZT", e_iso_KZT },
    { "LAK", e_iso_LAK },
    { "LBP", e_iso_LBP },
    { "LKR", e_iso_LKR },
    { "LRD", e_iso_LRD },
    { "LSL", e_iso_LSL },
    { "LYD", e_iso_LYD },
    { "MAD", e_iso_MAD },
    { "MDL", e_iso_MDL },
    { "MGA", e_iso_MGA },
    { "MKD", e_iso_MKD },
    { "MMK", e_iso_MMK },
    { "MNT", e_iso_MNT },
    { "MOP", e_iso_MOP },
    { "MRU", e_iso_MRU },
    { "MUR", e_iso_MUR },
    { "MVR", e_iso_MVR },
    { "MWK", e_iso_MWK },
    { "MXN", e_iso_MXN },
    { "MXV", e_iso_MXV },
    { "MYR", e_iso_MYR },
    { "MZN", e_iso_MZN },
    { "NAD", e_iso_NAD },
    { "NGN", e_iso_NGN },
    { "NIO", e_iso_NIO },
    { "NOK", e_iso_NOK },
    { "NPR", e_iso_NPR },
    { "NZD", e_iso_NZD },
    { "OMR", e_iso_OMR },
    { "PAB", e_iso_PAB },
    { "PEN", e_iso_PEN },
    { "PGK", e_iso_PGK },
    { "PHP", e_iso_PHP },
    { "PKR", e_iso_PKR },
    { "PLN", e_iso_PLN },
    { "PYG", e_iso_PYG },
    { "QAR", e_iso_QAR },
    { "RON", e_iso_RON },
    { "RSD", e_iso_RSD },
    { "RUB", e_iso_RUB },
    { "RWF", e_iso_RWF },
    { "SAR", e_iso_SAR },
    { "SBD", e_iso_SBD },
    { "SCR", e_iso_SCR },
    { "SDG", e_iso_SDG },
    { "SEK", e_iso_SEK },
    { "SGD", e_iso_SGD },
    { "SHP", e_iso_SHP },
    { "SLL", e_iso_SLL },
    { "SOS", e_iso_SOS },
    { "SRD", e_iso_SRD },
    { "SSP", e_iso_SSP },
    { "STN", e_iso_STN },
    { "SVC", e_iso_SVC },
    { "SYP", e_iso_SYP },
    { "SZL", e_iso_SZL },
    { "THB", e_iso_THB },
    { "TJS", e_iso_TJS },
    { "TMT", e_iso_TMT },
    { "TND", e_iso_TND },
    { "TOP", e_iso_TOP },
    { "TRY", e_iso_TRY },
    { "TTD", e_iso_TTD },
    { "TWD", e_iso_TWD },
    { "TZS", e_iso_TZS },
    { "UAH", e_iso_UAH },
    { "UGX", e_iso_UGX },
    { "USD", e_iso_USD },
    { "USN", e_iso_USN },
    { "UYI", e_iso_UYI },
    { "UYU", e_iso_UYU },
    { "UYW", e_iso_UYW },
    { "UZS", e_iso_UZS },
    { "VES", e_iso_VES },
    { "VND", e_iso_VND },
    { "VUV", e_iso_VUV },
    { "WST", e_iso_WST },
    { "XAF", e_iso_XAF },
    { "XAG", e_iso_XAG },
    { "XAU", e_iso_XAU },
    { "XBA", e_iso_XBA },
    { "XBB", e_iso_XBB },
    { "XBC", e_iso_XBC },
    { "XBD", e_iso_XBD },
    { "XCD", e_iso_XCD },
    { "XDR", e_iso_XDR },
    { "XOF", e_iso_XOF },
    { "XPD", e_iso_XPD },
    { "XPF", e_iso_XPF },
    { "XPT", e_iso_XPT },
    { "XSU", e_iso_XSU },
    { "XTS", e_iso_XTS },
    { "XUA", e_iso_XUA },
    { "XXX", e_iso_XXX },
    { "YER", e_iso_YER },
    { "ZAR", e_iso_ZAR },
    { "ZMW", e_iso_ZMW },
    { "ZWL", e_iso_ZWL } };

void currency::init ()
{   symbol::init (currency_symbol_table, sizeof (currency_symbol_table) / sizeof (symbol_entry < e_currency >)); };

struct symbol_entry < e_httpequiv > httpequiv_symbol_table [] =
{   {  "content-language", he_language },
    {  "content-type", he_type },
    {  "default-style", he_style },
    {  "refresh", he_refresh },
    {  "set-cookie", he_cookie },
    {  "content-security-policy", he_policy } };

void httpequiv::init ()
{   symbol::init (httpequiv_symbol_table, sizeof (httpequiv_symbol_table) / sizeof (symbol_entry < e_httpequiv >)); }

struct symbol_entry < e_kind > kind_symbol_table [] =
{   {  "subtitles", k_subtitles },
    {  "captions", k_captions },
    {  "descriptions", k_descriptions },
    {  "chapters", k_chapters },
    {  "metadata", k_metadata } };

void kind::init ()
{   symbol::init (kind_symbol_table, sizeof (kind_symbol_table) / sizeof (symbol_entry < e_kind >)); };

struct symbol_entry < e_metaname > metaname_symbol_table [] =
{  { MN_APPLICATION, mn_application },
   { MN_AUTHOR, mn_author },
   { MN_DESCRIPTION, mn_description },
   { MN_GENERATOR, mn_generator },
   { MN_KEYWORDS, mn_keywords },

   { MN_CLASSIFICATION, mn_classification },

   { MN_AGLSTERMS_ACCESSMODE, mn_aglsterms_accessmode },
   { MN_AGLSTERMS_ACCESSIBILITY, mn_aglsterms_accessibility },
   { MN_AGLSTERMS_ACT, mn_aglsterms_act },
   { MN_AGLSTERMS_AGGREGATIONLEVEL, mn_aglsterms_aggregationlevel },
   { MN_AGLSTERMS_ALLOW_SEARCH, mn_aglsterms_allow_search },
   { MN_AGLSTERMS_AVAILABILITY, mn_aglsterms_availability },
   { MN_AGLSTERMS_CASE, mn_aglsterms_case },
   { MN_AGLSTERMS_CATEGORY, mn_aglsterms_category },
   { MN_AGLSTERMS_DATELICENSED, mn_aglsterms_datelicensed },
   { MN_AGLSTERMS_DOCUMENTTYPE, mn_aglsterms_documenttype },
   { MN_AGLSTERMS_FUNCTION, mn_aglsterms_function },
   { MN_AGLSTERMS_ISBASEDON, mn_aglsterms_isbasedon },
   { MN_AGLSTERMS_ISBASISFOR, mn_aglsterms_isbasisfor },
   { MN_AGLSTERMS_JURISDICTION, mn_aglsterms_jurisdiction },
   { MN_AGLSTERMS_MANDATE, mn_aglsterms_mandate },
   { MN_AGLSTERMS_PROTECTIVEMARKING, mn_aglsterms_protectivemarking },
   { MN_AGLSTERMS_REGULATION, mn_aglsterms_regulation },
   { MN_AGLSTERMS_SERVICETYPE, mn_aglsterms_servicetype },
   { MN_DCS_DCSSTA, mn_dcs_dcssta },
   { MN_ESSAYDIRECTORY, mn_essaydirectory },
   { MN_FLBLOGAUTHOR, mn_flblogauthor },
   { MN_FSDATECREATION, mn_fsdatecreation },
   { MN_FSDATEPUBLISH, mn_fsdatepublish },
   { MN_FSFLCONTENT, mn_fsflcontent },
   { MN_FSLANGUAGE, mn_fslanguage },
   { MN_FSONSITEMAP, mn_fsonsitemap },
   { MN_FSPAGEDESCRIPTION, mn_fspagedescription },
   { MN_FSPAGENAME, mn_fspagename },
   { MN_FSSEARCHABLE, mn_fssearchable },
   { MN_FSSECTION, mn_fssection },
   { MN_FSWRITERTOOLPAGETYPE, mn_fswritertoolpagetype },
   { MN_IE_RM_OFF, mn_ie_rm_off },
   { MN_MSSMARTTAGSPREVENTPARSING, mn_mssmarttagspreventparsing },
   { MN_REPOSTUSAPIKEY, mn_repostusapikey },
   { MN_RESOURCELOADERDYNAMICSTYLES, mn_resourceloaderdynamicstyles },
   { MN_WT_SI_N, mn_wt_si_n },
   { MN_WT_SI_P, mn_wt_si_p },
   { MN_WT_SI_X, mn_wt_si_x },
   { MN_ZOOMCATEGORY, mn_zoomcategory },
   { MN_ZOOMDESCRIPTION, mn_zoomdescription },
   { MN_ZOOMIMAGE, mn_zoomimage },
   { MN_ZOOMPAGEBOOST, mn_zoompageboost },
   { MN_ZOOMTITLE, mn_zoomtitle },
   { MN_ZOOMWORDS, mn_zoomwords },
   { MN_ALEXAVERIFYID, mn_alexaverifyid },
   { MN_APPLE_ITUNES_APP, mn_apple_itunes_app },
   { MN_APPLE_MOBILE_WEB_APP_CAPABLE, mn_apple_mobile_web_app_capable },
   { MN_APPLE_MOBILE_WEB_APP_STATUS_BAR_STYLE, mn_apple_mobile_web_app_status_bar_style },
   { MN_APPLE_MOBILE_WEB_APP_TITLE, mn_apple_mobile_web_app_title },
   { MN_APPLE_TOUCH_FULLSCREEN, mn_apple_touch_fullscreen },
   { MN_APPLICATION_NAME, mn_application_name },
   { MN_APPLICATION_URL, mn_application_url },
   { MN_APPSTORE_BUNDLE_ID, mn_appstore_bundle_id },
   { MN_APPSTORE_DEVELOPER_URL, mn_appstore_developer_url },
   { MN_APPSTORE_STORE_ID, mn_appstore_store_id },
   { MN_AUDIENCE, mn_audience },
   { MN_BITCOIN, mn_bitcoin },
   { MN_BLAZERR_SECURE, mn_blazerr_secure },
   { MN_BLAZERR_SEO, mn_blazerr_seo },
   { MN_BLAZERR_SSL, mn_blazerr_ssl },
   { MN_BLAZERR_SUPPORT_ID_NONCOOKIES, mn_blazerr_support_id_noncookies },
   { MN_BLAZERR_SUPPORT_IDENTIFIER, mn_blazerr_support_identifier },
   { MN_BLOGCATALOG, mn_blogcatalog },
   { MN_BUG_BLOCKED, mn_bug_blocked },
   { MN_BUG_COMMENT, mn_bug_comment },
   { MN_BUG_COMPONENT, mn_bug_component },
   { MN_BUG_PRODUCT, mn_bug_product },
   { MN_BUG_SHORT_DESC, mn_bug_short_desc },
   { MN_CACHE, mn_cache },
   { MN_CFIA_GDR_ACTIVITY, mn_cfia_gdr_activity },
   { MN_CFIA_GDR_COMMODITY, mn_cfia_gdr_commodity },
   { MN_CFIA_GDR_INCLUDE, mn_cfia_gdr_include },
   { MN_CFIA_GDR_PROGRAM, mn_cfia_gdr_program },
   { MN_CITATION_AUTHOR, mn_citation_author },
   { MN_CITATION_AUTHOR_EMAIL, mn_citation_author_email },
   { MN_CITATION_AUTHOR_INSTITUTION, mn_citation_author_institution },
   { MN_CITATION_CONFERENCE_TITLE, mn_citation_conference_title },
   { MN_CITATION_DATE, mn_citation_date },
   { MN_CITATION_DISSERTATION_INSTITUTION, mn_citation_dissertation_institution },
   { MN_CITATION_DOI, mn_citation_doi },
   { MN_CITATION_FIRSTPAGE, mn_citation_firstpage },
   { MN_CITATION_FULLTEXT_HTML_URL, mn_citation_fulltext_html_url },
   { MN_CITATION_ISBN, mn_citation_isbn },
   { MN_CITATION_ISSN, mn_citation_issn },
   { MN_CITATION_ISSUE, mn_citation_issue },
   { MN_CITATION_JOURNAL_ABBREV, mn_citation_journal_abbrev },
   { MN_CITATION_JOURNAL_TITLE, mn_citation_journal_title },
   { MN_CITATION_KEYWORDS, mn_citation_keywords },
   { MN_CITATION_LANGUAGE, mn_citation_language },
   { MN_CITATION_LASTPAGE, mn_citation_lastpage },
   { MN_CITATION_PDF_URL, mn_citation_pdf_url },
   { MN_CITATION_PUBLICATION_DATE, mn_citation_publication_date },
   { MN_CITATION_PUBLISHER, mn_citation_publisher },
   { MN_CITATION_TECHNICAL_REPORT_INSTITUTION, mn_citation_technical_report_institution },
   { MN_CITATION_TECHNICAL_REPORT_NUMBER, mn_citation_technical_report_number },
   { MN_CITATION_TITLE, mn_citation_title },
   { MN_CITATION_VOLUME, mn_citation_volume },
   { MN_COLLECTION, mn_collection },
   { MN_CONTACT, mn_contact },
   { MN_CREATED, mn_created },
   { MN_CREATOR, mn_creator },
   { MN_CSRF_PARAM, mn_csrf_param },
   { MN_CSRF_TOKEN, mn_csrf_token },
   { MN_DA_ANONYMISEIP, mn_da_anonymiseip },
   { MN_DA_CONTACTCOMPANY, mn_da_contactcompany },
   { MN_DA_CONTACTEMAIL, mn_da_contactemail },
   { MN_DA_CONTACTFIRSTNAME, mn_da_contactfirstname },
   { MN_DA_CONTACTLASTNAME, mn_da_contactlastname },
   { MN_DA_CONTACTNAME, mn_da_contactname },
   { MN_DA_CONTACTTELEPHONE, mn_da_contacttelephone },
   { MN_DA_CONVERSIONCURRENCY, mn_da_conversioncurrency },
   { MN_DA_CONVERSIONID, mn_da_conversionid },
   { MN_DA_CONVERSIONVALUE, mn_da_conversionvalue },
   { MN_DA_GOALCURRENCY, mn_da_goalcurrency },
   { MN_DA_GOALID, mn_da_goalid },
   { MN_DA_GOALVALUE, mn_da_goalvalue },
   { MN_DA_INTERACTIONSELECTOR, mn_da_interactionselector },
   { MN_DA_PAGEROLE, mn_da_pagerole },
   { MN_DA_PAGETAXONOMY, mn_da_pagetaxonomy },
   { MN_DA_PAGETITLE, mn_da_pagetitle },
   { MN_DA_PAGEVERSION, mn_da_pageversion },
   { MN_DA_SESSIONID, mn_da_sessionid },
   { MN_DA_USERID, mn_da_userid },
   { MN_DC_CREATED, mn_dc_created },
   { MN_DC_CREATOR, mn_dc_creator },
   { MN_DC_DATE_ISSUED, mn_dc_date_issued },
   { MN_DC_DATECOPYRIGHTED, mn_dc_datecopyrighted },
   { MN_DC_DATESUBMITTED, mn_dc_datesubmitted },
   { MN_DC_DESCRIPTION, mn_dc_description },
   { MN_DC_LANGUAGE, mn_dc_language },
   { MN_DC_LICENSE, mn_dc_license },
   { MN_DC_MEDIATOR, mn_dc_mediator },
   { MN_DC_MEDIUM, mn_dc_medium },
   { MN_DC_MODIFIED, mn_dc_modified },
   { MN_DC_PROVENANCE, mn_dc_provenance },
   { MN_DC_PUBLISHER, mn_dc_publisher },
   { MN_DC_REFERENCES, mn_dc_references },
   { MN_DC_TEMPORAL, mn_dc_temporal },
   { MN_DC_TITLE, mn_dc_title },
   { MN_DC_TYPE, mn_dc_type },
   { MN_DC_VALID, mn_dc_valid },
   { MN_DCTERMS_ABSTRACT, mn_dcterms_abstract },
   { MN_DCTERMS_ACCESSRIGHTS, mn_dcterms_accessrights },
   { MN_DCTERMS_ACCRUALMETHOD, mn_dcterms_accrualmethod },
   { MN_DCTERMS_ACCRUALPERIODICITY, mn_dcterms_accrualperiodicity },
   { MN_DCTERMS_ACCRUALPOLICY, mn_dcterms_accrualpolicy },
   { MN_DCTERMS_ALTERNATIVE, mn_dcterms_alternative },
   { MN_DCTERMS_AUDIENCE, mn_dcterms_audience },
   { MN_DCTERMS_AVAILABLE, mn_dcterms_available },
   { MN_DCTERMS_BIBLIOGRAPHICCITATION, mn_dcterms_bibliographiccitation },
   { MN_DCTERMS_COLLECTION, mn_dcterms_collection },
   { MN_DCTERMS_CONFORMSTO, mn_dcterms_conformsto },
   { MN_DCTERMS_CONTRIBUTOR, mn_dcterms_contributor },
   { MN_DCTERMS_COVERAGE, mn_dcterms_coverage },
   { MN_DCTERMS_CREATED, mn_dcterms_created },
   { MN_DCTERMS_CREATOR, mn_dcterms_creator },
   { MN_DCTERMS_DATE, mn_dcterms_date },
   { MN_DCTERMS_DATEACCEPTED, mn_dcterms_dateaccepted },
   { MN_DCTERMS_DATECOPYRIGHTED, mn_dcterms_datecopyrighted },
   { MN_DCTERMS_DATESUBMITTED, mn_dcterms_datesubmitted },
   { MN_DCTERMS_DESCRIPTION, mn_dcterms_description },
   { MN_DCTERMS_EDUCATIONLEVEL, mn_dcterms_educationlevel },
   { MN_DCTERMS_EXTENT, mn_dcterms_extent },
   { MN_DCTERMS_FORMAT, mn_dcterms_format },
   { MN_DCTERMS_HASFORMAT, mn_dcterms_hasformat },
   { MN_DCTERMS_HASPART, mn_dcterms_haspart },
   { MN_DCTERMS_HASVERSION, mn_dcterms_hasversion },
   { MN_DCTERMS_IDENTIFIER, mn_dcterms_identifier },
   { MN_DCTERMS_INSTRUCTIONALMETHOD, mn_dcterms_instructionalmethod },
   { MN_DCTERMS_ISFORMATOF, mn_dcterms_isformatof },
   { MN_DCTERMS_ISPARTOF, mn_dcterms_ispartof },
   { MN_DCTERMS_ISREFERENCEDBY, mn_dcterms_isreferencedby },
   { MN_DCTERMS_ISREPLACEDBY, mn_dcterms_isreplacedby },
   { MN_DCTERMS_ISREQUIREDBY, mn_dcterms_isrequiredby },
   { MN_DCTERMS_ISVERSIONOF, mn_dcterms_isversionof },
   { MN_DCTERMS_ISSUED, mn_dcterms_issued },
   { MN_DCTERMS_LANGUAGE, mn_dcterms_language },
   { MN_DCTERMS_LICENSE, mn_dcterms_license },
   { MN_DCTERMS_MEDIATOR, mn_dcterms_mediator },
   { MN_DCTERMS_MEDIUM, mn_dcterms_medium },
   { MN_DCTERMS_MODIFIED, mn_dcterms_modified },
   { MN_DCTERMS_PROVENANCE, mn_dcterms_provenance },
   { MN_DCTERMS_PUBLISHER, mn_dcterms_publisher },
   { MN_DCTERMS_REFERENCES, mn_dcterms_references },
   { MN_DCTERMS_RELATION, mn_dcterms_relation },
   { MN_DCTERMS_REPLACES, mn_dcterms_replaces },
   { MN_DCTERMS_REQUIRES, mn_dcterms_requires },
   { MN_DCTERMS_RIGHTS, mn_dcterms_rights },
   { MN_DCTERMS_RIGHTSHOLDER, mn_dcterms_rightsholder },
   { MN_DCTERMS_SOURCE, mn_dcterms_source },
   { MN_DCTERMS_SPATIAL, mn_dcterms_spatial },
   { MN_DCTERMS_SUBJECT, mn_dcterms_subject },
   { MN_DCTERMS_TABLEOFCONTENTS, mn_dcterms_tableofcontents },
   { MN_DCTERMS_TEMPORAL, mn_dcterms_temporal },
   { MN_DCTERMS_TITLE, mn_dcterms_title },
   { MN_DCTERMS_TYPE, mn_dcterms_type },
   { MN_DCTERMS_VALID, mn_dcterms_valid },
   { MN_DESIGNER, mn_designer },
   { MN_DETECTIFY_VERIFICATION, mn_detectify_verification },
   { MN_DIR_CONTENT_POINTER, mn_dir_content_pointer },
   { MN_ENTITY, mn_entity },
   { MN_EXPIRES, mn_expires },
   { MN_FB_ADMINS, mn_fb_admins },
   { MN_FB_PAGE_ID, mn_fb_page_id },
   { MN_FDSE_DESCRIPTION, mn_fdse_description },
   { MN_FDSE_INDEX_AS, mn_fdse_index_as },
   { MN_FDSE_KEYWORDS, mn_fdse_keywords },
   { MN_FDSE_REFRESH, mn_fdse_refresh },
   { MN_FDSE_ROBOTS, mn_fdse_robots },
   { MN_FORMAT_DETECTION, mn_format_detection },
   { MN_FORMAT_PRINT, mn_format_print },
   { MN_FRAGMENT, mn_fragment },
   { MN_GCTERMS_TOPICTAXONOMY, mn_gcterms_topictaxonomy },
   { MN_GEO_A1, mn_geo_a1 },
   { MN_GEO_A2, mn_geo_a2 },
   { MN_GEO_A3, mn_geo_a3 },
   { MN_GEO_COUNTRY, mn_geo_country },
   { MN_GEO_LMK, mn_geo_lmk },
   { MN_GEO_PLACENAME, mn_geo_placename },
   { MN_GEO_POSITION, mn_geo_position },
   { MN_GEO_REGION, mn_geo_region },
   { MN_GLOBRIX_BATHROOMS, mn_globrix_bathrooms },
   { MN_GLOBRIX_BEDROOMS, mn_globrix_bedrooms },
   { MN_GLOBRIX_CONDITION, mn_globrix_condition },
   { MN_GLOBRIX_FEATURES, mn_globrix_features },
   { MN_GLOBRIX_INSTRUCTION, mn_globrix_instruction },
   { MN_GLOBRIX_LATITUDE, mn_globrix_latitude },
   { MN_GLOBRIX_LONGITUDE, mn_globrix_longitude },
   { MN_GLOBRIX_OUTSIDESPACE, mn_globrix_outsidespace },
   { MN_GLOBRIX_PARKING, mn_globrix_parking },
   { MN_GLOBRIX_PERIOD, mn_globrix_period },
   { MN_GLOBRIX_POA, mn_globrix_poa },
   { MN_GLOBRIX_POSTCODE, mn_globrix_postcode },
   { MN_GLOBRIX_PRICE, mn_globrix_price },
   { MN_GLOBRIX_PRICEPROXIMITY, mn_globrix_priceproximity },
   { MN_GLOBRIX_TENURE, mn_globrix_tenure },
   { MN_GLOBRIX_TYPE, mn_globrix_type },
   { MN_GLOBRIX_UNDEROFFER, mn_globrix_underoffer },
   { MN_GM_GPX_V, mn_gm_gpx_v },
   { MN_GO_IMPORT, mn_go_import },
   { MN_GOOGLE, mn_google },
   { MN_GOOGLE_PLAY_APP, mn_google_play_app },
   { MN_GOOGLE_SITE_VERIFICATION, mn_google_site_verification },
   { MN_GOOGLE_TRANSLATE_CUSTOMIZATION, mn_google_translate_customization },
   { MN_GWT_PROPERTY, mn_gwt_property },
   { MN_HANDHELDFRIENDLY, mn_handheldfriendly },
   { MN_ICAS_DATETIME, mn_icas_datetime },
   { MN_ICAS_DATETIME_ABBR, mn_icas_datetime_abbr },
   { MN_ICAS_DATETIME_DAY, mn_icas_datetime_day },
   { MN_ICAS_DATETIME_LONG, mn_icas_datetime_long },
   { MN_ICBM, mn_icbm },
   { MN_ITEMSPERPAGE, mn_itemsperpage },
   { MN_KEYWORDS_NOT, mn_keywords_not },
   { MN_META_DATE, mn_meta_date },
   { MN_MICROTIP, mn_microtip },
   { MN_MOBILE_AGENT, mn_mobile_agent },
   { MN_MOBILE_WEB_APP_CAPABLE, mn_mobile_web_app_capable },
   { MN_MOBILEOPTIMIZED, mn_mobileoptimized },
   { MN_MSAPPLICATION_TILECOLOR, mn_msapplication_tilecolor },
   { MN_MSAPPLICATION_TILEIMAGE, mn_msapplication_tileimage },
   { MN_MSAPPLICATION_CONFIG, mn_msapplication_config },
   { MN_MSAPPLICATION_NAVBUTTON_COLOR, mn_msapplication_navbutton_color },
   { MN_MSAPPLICATION_NOTIFICATION, mn_msapplication_notification },
   { MN_MSAPPLICATION_SQUARE150X150LOGO, mn_msapplication_square150x150logo },
   { MN_MSAPPLICATION_SQUARE310X310LOGO, mn_msapplication_square310x310logo },
   { MN_MSAPPLICATION_SQUARE70X70LOGO, mn_msapplication_square70x70logo },
   { MN_MSAPPLICATION_STARTURL, mn_msapplication_starturl },
   { MN_MSAPPLICATION_TAP_HIGHLIGHT, mn_msapplication_tap_highlight },
   { MN_MSAPPLICATION_TASK, mn_msapplication_task },
   { MN_MSAPPLICATION_TOOLTIP, mn_msapplication_tooltip },
   { MN_MSAPPLICATION_WIDE310X150LOGO, mn_msapplication_wide310x150logo },
   { MN_MSAPPLICATION_WINDOW, mn_msapplication_window },
   { MN_MSVALIDATE_01, mn_msvalidate_01 },
   { MN_NEXTGEN, mn_nextgen },
   { MN_NIBBLER_SITE_VERIFICATION, mn_nibbler_site_verification },
   { MN_NO_EMAIL_COLLECTION, mn_no_email_collection },
   { MN_NONFICTION, mn_nonfiction },
   { MN_NORTON_SAFEWEB_SITE_VERIFICATION, mn_norton_safeweb_site_verification },
   { MN_OG_DESCRIPTION, mn_og_description },
   { MN_OG_IMAGE, mn_og_image },
   { MN_OG_LOCALE, mn_og_locale },
   { MN_OG_SITE_NAME, mn_og_site_name },
   { MN_OG_TITLE, mn_og_title },
   { MN_OG_TYPE, mn_og_type },
   { MN_OG_URL, mn_og_url },
   { MN_ORIGIN, mn_origin },
   { MN_ORIGIN_TRIALS, mn_origin_trials },
   { MN_P_DOMAIN_VERIFY, mn_p_domain_verify },
   { MN_PAGE_VERSION, mn_page_version },
   { MN_PINGDOM, mn_pingdom },
   { MN_PINTEREST, mn_pinterest },
   { MN_PRISM_ALTERNATETITLE, mn_prism_alternatetitle },
   { MN_PRO, mn_pro },
   { MN_PRO_AUTH, mn_pro_auth },
   { MN_PRO_AUTH_FIELD, mn_pro_auth_field },
   { MN_PRO_AUTH_FRAGMENT, mn_pro_auth_fragment },
   { MN_RATING, mn_rating },
   { MN_REFERRER, mn_referrer },
   { MN_RESOLUTIONS, mn_resolutions },
   { MN_REVIEW_DATE, mn_review_date },
   { MN_REVISION, mn_revision },
   { MN_REVISIT_AFTER, mn_revisit_after },
   { MN_RIGHTS, mn_rights },
   { MN_RIGHTS_STANDARD, mn_rights_standard },
   { MN_ROBOTS, mn_robots },
   { MN_RPUPLUGIN, mn_rpuplugin },
   { MN_RQID, mn_rqid },
   { MN_SHAREAHOLIC_ANALYTICS, mn_shareaholic_analytics },
   { MN_SHAREAHOLIC_ARTICLE_AUTHOR, mn_shareaholic_article_author },
   { MN_SHAREAHOLIC_ARTICLE_AUTHOR_NAME, mn_shareaholic_article_author_name },
   { MN_SHAREAHOLIC_ARTICLE_MODIFIED_TIME, mn_shareaholic_article_modified_time },
   { MN_SHAREAHOLIC_ARTICLE_PUBLISHED_TIME, mn_shareaholic_article_published_time },
   { MN_SHAREAHOLIC_ARTICLE_VISIBILITY, mn_shareaholic_article_visibility },
   { MN_SHAREAHOLIC_DRUPAL_VERSION, mn_shareaholic_drupal_version },
   { MN_SHAREAHOLIC_IMAGE, mn_shareaholic_image },
   { MN_SHAREAHOLIC_KEYWORDS, mn_shareaholic_keywords },
   { MN_SHAREAHOLIC_LANGUAGE, mn_shareaholic_language },
   { MN_SHAREAHOLIC_OUTSTREAMADS, mn_shareaholic_outstreamads },
   { MN_SHAREAHOLIC_SHAREABLE_PAGE, mn_shareaholic_shareable_page },
   { MN_SHAREAHOLIC_SITE_ID, mn_shareaholic_site_id },
   { MN_SHAREAHOLIC_SITE_NAME, mn_shareaholic_site_name },
   { MN_SHAREAHOLIC_URL, mn_shareaholic_url },
   { MN_SHAREAHOLIC_WP_VERSION, mn_shareaholic_wp_version },
   { MN_SIGNET_AUTHORS, mn_signet_authors },
   { MN_SIGNET_LINKS, mn_signet_links },
   { MN_SKYPE_TOOLBAR, mn_skype_toolbar },
   { MN_STARTINDEX, mn_startindex },
   { MN_STARTVER, mn_startver },
   { MN_SUBJECT_DATETIME, mn_subject_datetime },
   { MN_SUBJECT_SYSTEM, mn_subject_system },
   { MN_THEME_COLOR, mn_theme_color },
   { MN_THUMBNAIL, mn_thumbnail },
   { MN_TOPPER, mn_topper },
   { MN_TOPPER_MAJOR, mn_topper_major },
   { MN_TOPPER_MINOR, mn_topper_minor },
   { MN_TOTALRESULTS, mn_totalresults },
   { MN_TRANSLATOR, mn_translator },
   { MN_TWITTER_APP_COUNTRY, mn_twitter_app_country },
   { MN_TWITTER_APP_ID_GOOGLEPLAY, mn_twitter_app_id_googleplay },
   { MN_TWITTER_APP_ID_IPAD, mn_twitter_app_id_ipad },
   { MN_TWITTER_APP_ID_IPHONE, mn_twitter_app_id_iphone },
   { MN_TWITTER_APP_NAME_GOOGLEPLAY, mn_twitter_app_name_googleplay },
   { MN_TWITTER_APP_NAME_IPAD, mn_twitter_app_name_ipad },
   { MN_TWITTER_APP_NAME_IPHONE, mn_twitter_app_name_iphone },
   { MN_TWITTER_APP_URL_GOOGLEPLAY, mn_twitter_app_url_googleplay },
   { MN_TWITTER_APP_URL_IPAD, mn_twitter_app_url_ipad },
   { MN_TWITTER_APP_URL_IPHONE, mn_twitter_app_url_iphone },
   { MN_TWITTER_CARD, mn_twitter_card },
   { MN_TWITTER_CREATOR, mn_twitter_creator },
   { MN_TWITTER_CREATOR_ID, mn_twitter_creator_id },
   { MN_TWITTER_DATA1, mn_twitter_data1 },
   { MN_TWITTER_DATA2, mn_twitter_data2 },
   { MN_TWITTER_DESCRIPTION, mn_twitter_description },
   { MN_TWITTER_DOMAIN, mn_twitter_domain },
   { MN_TWITTER_IMAGE, mn_twitter_image },
   { MN_TWITTER_IMAGE0, mn_twitter_image0 },
   { MN_TWITTER_IMAGE1, mn_twitter_image1 },
   { MN_TWITTER_IMAGE2, mn_twitter_image2 },
   { MN_TWITTER_IMAGE3, mn_twitter_image3 },
   { MN_TWITTER_IMAGE_HEIGHT, mn_twitter_image_height },
   { MN_TWITTER_IMAGE_SRC, mn_twitter_image_src },
   { MN_TWITTER_IMAGE_WIDTH, mn_twitter_image_width },
   { MN_TWITTER_LABEL1, mn_twitter_label1 },
   { MN_TWITTER_LABEL2, mn_twitter_label2 },
   { MN_TWITTER_PLAYER, mn_twitter_player },
   { MN_TWITTER_PLAYER_HEIGHT, mn_twitter_player_height },
   { MN_TWITTER_PLAYER_STREAM, mn_twitter_player_stream },
   { MN_TWITTER_PLAYER_STREAM_CONTENT_TYPE, mn_twitter_player_stream_content_type },
   { MN_TWITTER_PLAYER_WIDTH, mn_twitter_player_width },
   { MN_TWITTER_SITE, mn_twitter_site },
   { MN_TWITTER_SITE_ID, mn_twitter_site_id },
   { MN_TWITTER_TITLE, mn_twitter_title },
   { MN_TWITTER_URL, mn_twitter_url },
   { MN_TYPEMETAL_FORMATPREFS, mn_typemetal_formatprefs },
   { MN_VERIFY_V1, mn_verify_v1 },
   { MN_VERSION, mn_version },
   { MN_VFB_VERSION, mn_vfb_version },
   { MN_VIEWPORT, mn_viewport },
   { MN_WEB_AUTHOR, mn_web_author },
   { MN_WITGET, mn_witget },
   { MN_WOT_VERIFICATION, mn_wot_verification },
   { MN_WT_AC, mn_wt_ac },
   { MN_WT_AD, mn_wt_ad },
   { MN_WT_CG_N, mn_wt_cg_n },
   { MN_WT_CG_S, mn_wt_cg_s },
   { MN_WT_MC_ID, mn_wt_mc_id },
   { MN_WT_SV, mn_wt_sv },
   { MN_WT_TI, mn_wt_ti },
   { MN_Y_KEY, mn_y_key },
   { MN_YANDEX_VERIFICATION, mn_yandex_verification },

    { MN_IDENTIFIER_URL, mn_identifier_url },
    { MN_DISTRIBUTION, mn_distribution },
    { MN_NOTE, mn_note },
    { MN_SUBJECT, mn_subject },
    { MN_COPYRIGHT, mn_copyright },
    { MN_LANGUAGE, mn_language },
    { MN_ID, mn_id },
    { MN_PRESDATE, mn_presdate },
    { MN_TEMPLATE, mn_template },
    { MN_OPERATOR, mn_operator },
    { MN_CREATION, mn_creation },
    { MN_HOST, mn_host },
    { MN_HOST_ADMIN, mn_host_admin },
    { MN_CONTACTNAME, mn_contactName },
    { MN_CONTACTORGANIZATION, mn_contactOrganization },
    { MN_CONTACTSTREETADDRESS1, mn_contactStreetAddress1 },
    { MN_CONTACTZIPCODE, mn_contactZipcode },
    { MN_CONTACTCITY, mn_contactCity },
    { MN_CONTACTCOUNTRY, mn_contactCountry },
    { MN_CONTACTPHONENUMBER, mn_contactPhoneNumber },
    { MN_CONTACTFAXNUMBER, mn_contactFaxNumber },
    { MN_CONTACTNETWORKADDRESS, mn_contactNetworkAddress },
    { MN_LINKAGE, mn_linkage },

    { MN_ABSTRACT, mn_abstract },
    { MN_COVERAGE, mn_coverage },
    { MN_OG_EMAIL, mn_og_email },
    { MN_OG_PHONE_NUMBER, mn_og_phone_number },
    { MN_OG_FAX_NUMBER, mn_og_fax_number },
    { MN_OG_LATITUDE, mn_og_latitude },
    { MN_OG_LONGITUDE, mn_og_longitude },
    { MN_OG_STREET_ADDRESS, mn_og_street_address },
    { MN_OG_LOCALITY, mn_og_locality },
    { MN_OG_REGION, mn_og_region },
    { MN_OG_POSTAL_CODE, mn_og_postal_code },
    { MN_OG_COUNTRY_NAME, mn_og_country_name },
    { MN_MICROID, mn_microid },
    { MN_OWNER, mn_owner },
    { MN_REVISED, mn_revised },
    { MN_TOPIC, mn_topic },
    { MN_SUMMARY, mn_summary },
    { MN_TWEETMEME_TITLE, mn_tweetmeme_title } };

void metaname::init ()
{   symbol::init (metaname_symbol_table, sizeof (metaname_symbol_table) / sizeof (symbol_entry < e_metaname >)); };

struct symbol_entry < e_referrer > referrer_symbol_table [] =
{   {  "no-referrer", r_no },
    {  "no-referrer-when-downgrade", r_downgrade },
    {  "same-origin", r_same },
    {  "origin", r_origin },
    {  "strict-origin", r_strict },
    {  "origin-when-cross-origin", r_cross },
    {  "unsafe-url", r_unsafe } };

void referrer::init ()
{   symbol::init (referrer_symbol_table, sizeof (referrer_symbol_table) / sizeof (symbol_entry < e_referrer >)); };

struct symbol_entry < e_sandbox > sandbox_symbol_table [] =
{   {  "allow-forms", s_forms },
    {  "allow-pointer-lock", s_pointer },
    {  "allow-popups", s_popups },
    {  "allow-presentation", s_presentation },
    {  "allow-same-origin", s_origin },
    {  "allow-scripts", s_scripts },
    {  "allow-top-navigation", s_navigation } };

void sandbox::init ()
{   symbol::init (sandbox_symbol_table, sizeof (sandbox_symbol_table) / sizeof (symbol_entry < e_sandbox >)); };

void types_init ()
{   action::init ();
    currency::init ();
    httpequiv::init ();
    kind::init ();
    metaname::init ();
    referrer::init ();
    sandbox::init (); };
